/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PsiJavaElementPattern<T extends PsiElement, Self extends PsiJavaElementPattern<T, Self>>
extends PsiElementPattern<T, Self> {
    @NonNls
    private static final String VALUE = "value";

    public PsiJavaElementPattern(Class<T> aClass) {
        super(aClass);
    }

    public PsiJavaElementPattern(@NotNull InitialPatternCondition<T> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/patterns/PsiJavaElementPattern", "<init>"));
        }
        super(condition);
    }

    public Self annotationParam(@NonNls String annotationQualifiedName, @NonNls String parameterName) {
        return this.annotationParam((ElementPattern<String>)StandardPatterns.string().equalTo((Object)annotationQualifiedName), parameterName);
    }

    public Self annotationParam(@NonNls String annotationQualifiedName) {
        return this.annotationParam(annotationQualifiedName, VALUE);
    }

    public Self annotationParam(ElementPattern<String> annotationQualifiedName, @NonNls String parameterName) {
        return (Self)((Object)((PsiJavaElementPattern)this.withParent((ElementPattern)PsiJavaPatterns.psiNameValuePair().withName(parameterName).withParent((ElementPattern)PlatformPatterns.psiElement(PsiAnnotationParameterList.class).withParent((ElementPattern)PsiJavaPatterns.psiAnnotation().qName(annotationQualifiedName))))));
    }

    public Self insideAnnotationParam(ElementPattern<String> annotationQualifiedName, @NonNls String parameterName) {
        return (Self)((Object)((PsiJavaElementPattern)this.inside(true, (ElementPattern)PsiJavaPatterns.psiNameValuePair().withName(parameterName).withParent((ElementPattern)PlatformPatterns.psiElement(PsiAnnotationParameterList.class).withParent((ElementPattern)PsiJavaPatterns.psiAnnotation().qName(annotationQualifiedName))))));
    }

    public Self insideAnnotationParam(ElementPattern<String> annotationQualifiedName) {
        return this.insideAnnotationParam(annotationQualifiedName, VALUE);
    }

    public Self nameIdentifierOf(Class<? extends PsiMember> aClass) {
        return this.nameIdentifierOf((ElementPattern<PsiMember>)StandardPatterns.instanceOf(aClass));
    }

    public Self nameIdentifierOf(final ElementPattern<? extends PsiMember> pattern) {
        return (Self)((Object)((PsiJavaElementPattern)this.with(new PatternCondition<T>("nameIdentifierOf"){

            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/PsiJavaElementPattern$1", "accepts"));
                }
                if (!(t instanceof PsiIdentifier)) {
                    return false;
                }
                PsiElement parent = t.getParent();
                if (parent instanceof PsiClass && t != ((PsiClass)parent).getNameIdentifier()) {
                    return false;
                }
                if (parent instanceof PsiMethod && t != ((PsiMethod)parent).getNameIdentifier()) {
                    return false;
                }
                if (parent instanceof PsiVariable && t != ((PsiVariable)parent).getNameIdentifier()) {
                    return false;
                }
                return pattern.accepts((Object)parent, context);
            }
        })));
    }

    public Self methodCallParameter(final int index, final ElementPattern<? extends PsiMethod> methodPattern) {
        return (Self)((Object)((PsiJavaElementPattern)this.with(new PatternCondition<T>("methodCallParameter"){

            public boolean accepts(@NotNull T literal, ProcessingContext context) {
                if (literal == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/intellij/patterns/PsiJavaElementPattern$2", "accepts"));
                }
                PsiElement parent = literal.getParent();
                if (parent instanceof PsiExpressionList) {
                    PsiExpressionList psiExpressionList = (PsiExpressionList)parent;
                    PsiExpression[] psiExpressions = psiExpressionList.getExpressions();
                    if (psiExpressions.length <= index || psiExpressions[index] != literal) {
                        return false;
                    }
                    PsiElement element = psiExpressionList.getParent();
                    if (element instanceof PsiMethodCallExpression) {
                        JavaResolveResult[] results;
                        for (JavaResolveResult result : results = ((PsiMethodCallExpression)element).getMethodExpression().multiResolve(false)) {
                            PsiElement psiElement = result.getElement();
                            if (!methodPattern.accepts((Object)psiElement, context)) continue;
                            return true;
                        }
                    }
                }
                return false;
            }
        })));
    }

    public Self constructorParameter(final int index, final String ... fqns) {
        return (Self)((Object)((PsiJavaElementPattern)this.with(new PatternCondition<T>("methodCallParameter"){

            public boolean accepts(@NotNull T literal, ProcessingContext context) {
                if (literal == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/intellij/patterns/PsiJavaElementPattern$3", "accepts"));
                }
                PsiElement parent = literal.getParent();
                if (parent instanceof PsiExpressionList) {
                    PsiJavaCodeReferenceElement reference;
                    PsiExpressionList psiExpressionList = (PsiExpressionList)parent;
                    PsiExpression[] psiExpressions = psiExpressionList.getExpressions();
                    if (psiExpressions.length <= index || psiExpressions[index] != literal) {
                        return false;
                    }
                    PsiElement element = psiExpressionList.getParent();
                    if (element instanceof PsiNewExpression && (reference = ((PsiNewExpression)element).getClassOrAnonymousClassReference()) != null) {
                        String qualifiedName = reference.getQualifiedName();
                        for (String fqn : fqns) {
                            if (!fqn.equals(qualifiedName)) continue;
                            return true;
                        }
                    }
                }
                return false;
            }
        })));
    }

    public static class Capture<T extends PsiElement>
    extends PsiJavaElementPattern<T, Capture<T>> {
        public Capture(Class<T> aClass) {
            super(aClass);
        }

        public Capture(@NotNull InitialPatternCondition<T> condition) {
            if (condition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/patterns/PsiJavaElementPattern$Capture", "<init>"));
            }
            super(condition);
        }
    }
}

