/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PatternConditionPlus;
import com.intellij.patterns.PsiModifierListOwnerPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.util.PairProcessor;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class PsiParameterPattern
extends PsiModifierListOwnerPattern<PsiParameter, PsiParameterPattern> {
    protected PsiParameterPattern() {
        super(PsiParameter.class);
    }

    public PsiParameterPattern ofMethod(final int index, ElementPattern pattern) {
        return (PsiParameterPattern)this.with((PatternCondition)new PatternConditionPlus<PsiParameter, PsiMethod>("ofMethod", pattern){

            public boolean processValues(PsiParameter t, ProcessingContext context, PairProcessor<PsiMethod, ProcessingContext> processor) {
                PsiElement scope = t.getDeclarationScope();
                if (!(scope instanceof PsiMethod)) {
                    return true;
                }
                return processor.process((Object)((PsiMethod)scope), (Object)context);
            }

            public boolean accepts(@NotNull PsiParameter t, ProcessingContext context) {
                if (t == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/PsiParameterPattern$1", "accepts"));
                }
                if (!super.accepts((Object)t, context)) {
                    return false;
                }
                PsiMethod psiMethod = (PsiMethod)t.getDeclarationScope();
                PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
                return index >= 0 && index < parameters.length && t.equals(parameters[index]);
            }
        });
    }
}

