/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiWildcardType
extends PsiType.Stub {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.PsiWildcardType");
    private static final Key<PsiWildcardType> UNBOUNDED_WILDCARD = new Key("UNBOUNDED_WILDCARD");
    @NonNls
    private static final String EXTENDS_PREFIX = "? extends ";
    @NonNls
    private static final String SUPER_PREFIX = "? super ";
    @NotNull
    private final PsiManager myManager;
    private final boolean myIsExtending;
    private final PsiType myBound;

    private PsiWildcardType(@NotNull PsiManager manager, boolean isExtending, @Nullable PsiType bound) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/PsiWildcardType", "<init>"));
        }
        super(PsiAnnotation.EMPTY_ARRAY);
        this.myManager = manager;
        this.myIsExtending = isExtending;
        this.myBound = bound;
    }

    private PsiWildcardType(@NotNull PsiWildcardType type, @NotNull PsiAnnotation[] annotations) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/PsiWildcardType", "<init>"));
        }
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "com/intellij/psi/PsiWildcardType", "<init>"));
        }
        super(annotations);
        this.myManager = type.myManager;
        this.myIsExtending = type.myIsExtending;
        this.myBound = type.myBound;
    }

    @NotNull
    public static PsiWildcardType createUnbounded(@NotNull PsiManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/PsiWildcardType", "createUnbounded"));
        }
        PsiWildcardType unboundedWildcard = (PsiWildcardType)manager.getUserData(UNBOUNDED_WILDCARD);
        if (unboundedWildcard == null) {
            unboundedWildcard = (PsiWildcardType)manager.putUserDataIfAbsent(UNBOUNDED_WILDCARD, (Object)new PsiWildcardType(manager, false, null));
        }
        PsiWildcardType psiWildcardType = unboundedWildcard;
        if (psiWildcardType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiWildcardType", "createUnbounded"));
        }
        return psiWildcardType;
    }

    @NotNull
    public static PsiWildcardType createExtends(@NotNull PsiManager manager, @NotNull PsiType bound) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/PsiWildcardType", "createExtends"));
        }
        if (bound == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bound", "com/intellij/psi/PsiWildcardType", "createExtends"));
        }
        LOG.assertTrue(!(bound instanceof PsiWildcardType));
        LOG.assertTrue(bound != PsiType.NULL);
        PsiWildcardType psiWildcardType = new PsiWildcardType(manager, true, bound);
        if (psiWildcardType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiWildcardType", "createExtends"));
        }
        return psiWildcardType;
    }

    @NotNull
    public static PsiWildcardType createSuper(@NotNull PsiManager manager, @NotNull PsiType bound) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/PsiWildcardType", "createSuper"));
        }
        if (bound == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bound", "com/intellij/psi/PsiWildcardType", "createSuper"));
        }
        LOG.assertTrue(!(bound instanceof PsiWildcardType));
        LOG.assertTrue(bound != PsiType.NULL);
        PsiWildcardType psiWildcardType = new PsiWildcardType(manager, false, bound);
        if (psiWildcardType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiWildcardType", "createSuper"));
        }
        return psiWildcardType;
    }

    @NotNull
    public PsiWildcardType annotate(@NotNull PsiAnnotation[] annotations) {
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "com/intellij/psi/PsiWildcardType", "annotate"));
        }
        PsiWildcardType psiWildcardType = annotations.length == 0 ? this : new PsiWildcardType(this, annotations);
        if (psiWildcardType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiWildcardType", "annotate"));
        }
        return psiWildcardType;
    }

    @Override
    @NotNull
    public String getPresentableText() {
        String string = this.getText(false, true, this.myBound == null ? null : this.myBound.getPresentableText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiWildcardType", "getPresentableText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getCanonicalText(boolean annotated) {
        String string = this.getText(true, annotated, this.myBound == null ? null : this.myBound.getCanonicalText(annotated));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiWildcardType", "getCanonicalText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getInternalCanonicalText() {
        String string = this.getText(true, true, this.myBound == null ? null : this.myBound.getInternalCanonicalText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiWildcardType", "getInternalCanonicalText"));
        }
        return string;
    }

    private String getText(boolean qualified, boolean annotated, @Nullable String suffix) {
        PsiAnnotation[] annotations = this.getAnnotations();
        if (!(annotated && annotations.length != 0 || suffix != null)) {
            return "?";
        }
        StringBuilder sb = new StringBuilder();
        if (annotated) {
            PsiNameHelper.appendAnnotations(sb, annotations, qualified);
        }
        if (suffix == null) {
            sb.append('?');
        } else {
            sb.append(this.myIsExtending ? EXTENDS_PREFIX : SUPER_PREFIX);
            sb.append(suffix);
        }
        return sb.toString();
    }

    @Override
    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope scope;
        if (this.myBound != null && (scope = this.myBound.getResolveScope()) != null) {
            GlobalSearchScope globalSearchScope = scope;
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiWildcardType", "getResolveScope"));
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.myManager.getProject());
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiWildcardType", "getResolveScope"));
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public PsiType[] getSuperTypes() {
        PsiType[] psiTypeArray = new PsiType[]{this.getExtendsBound()};
        if (psiTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiWildcardType", "getSuperTypes"));
        }
        return psiTypeArray;
    }

    @Override
    public boolean equalsToText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/PsiWildcardType", "equalsToText"));
        }
        if (this.myBound == null) {
            return "?".equals(text);
        }
        if (this.myIsExtending) {
            return text.startsWith(EXTENDS_PREFIX) && this.myBound.equalsToText(text.substring(EXTENDS_PREFIX.length()));
        }
        return text.startsWith(SUPER_PREFIX) && this.myBound.equalsToText(text.substring(SUPER_PREFIX.length()));
    }

    @NotNull
    public PsiManager getManager() {
        PsiManager psiManager = this.myManager;
        if (psiManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiWildcardType", "getManager"));
        }
        return psiManager;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PsiWildcardType)) {
            return false;
        }
        PsiWildcardType that = (PsiWildcardType)o;
        if (this.myBound == null && that.myBound != null) {
            return that.isExtends() && that.myBound.equalsToText("java.lang.Object");
        }
        if (this.myBound != null && that.myBound == null) {
            return this.isExtends() && this.myBound.equalsToText("java.lang.Object");
        }
        return this.myIsExtending == that.myIsExtending && Comparing.equal((Object)this.myBound, (Object)that.myBound);
    }

    public int hashCode() {
        return (this.myIsExtending ? 1 : 0) + (this.myBound != null ? this.myBound.hashCode() : 0);
    }

    @Nullable
    public PsiType getBound() {
        return this.myBound;
    }

    @Override
    public <A> A accept(@NotNull PsiTypeVisitor<A> visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/PsiWildcardType", "accept"));
        }
        return visitor.visitWildcardType(this);
    }

    @Override
    public boolean isValid() {
        return this.myBound == null || this.myBound.isValid();
    }

    public boolean isExtends() {
        return this.myBound != null && this.myIsExtending;
    }

    public boolean isSuper() {
        return this.myBound != null && !this.myIsExtending;
    }

    public boolean isBounded() {
        return this.myBound != null;
    }

    @NotNull
    public PsiType getExtendsBound() {
        if (this.myBound == null || !this.myIsExtending) {
            PsiClassType psiClassType = PsiWildcardType.getJavaLangObject(this.myManager, this.getResolveScope());
            if (psiClassType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiWildcardType", "getExtendsBound"));
            }
            return psiClassType;
        }
        PsiType psiType = this.myBound;
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiWildcardType", "getExtendsBound"));
        }
        return psiType;
    }

    @NotNull
    public PsiType getSuperBound() {
        PsiType psiType = this.myBound == null || this.myIsExtending ? NULL : this.myBound;
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiWildcardType", "getSuperBound"));
        }
        return psiType;
    }
}

