/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassUtil {
    private ClassUtil() {
    }

    public static String extractPackageName(String className) {
        if (className != null) {
            int i = className.lastIndexOf(46);
            return i == -1 ? "" : className.substring(0, i);
        }
        return null;
    }

    @NotNull
    public static String extractClassName(@NotNull String fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "com/intellij/psi/util/ClassUtil", "extractClassName"));
        }
        int i = fqName.lastIndexOf(46);
        String string = i == -1 ? fqName : fqName.substring(i + 1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/ClassUtil", "extractClassName"));
        }
        return string;
    }

    public static String createNewClassQualifiedName(String qualifiedName, String className) {
        if (className == null) {
            return null;
        }
        if (qualifiedName == null || qualifiedName.isEmpty()) {
            return className;
        }
        return qualifiedName + "." + ClassUtil.extractClassName(className);
    }

    public static PsiDirectory sourceRoot(PsiDirectory containingDirectory) {
        while (containingDirectory != null) {
            if (JavaDirectoryService.getInstance().isSourceRoot(containingDirectory)) {
                return containingDirectory;
            }
            containingDirectory = containingDirectory.getParentDirectory();
        }
        return null;
    }

    public static void formatClassName(@NotNull PsiClass aClass, @NotNull StringBuilder buf) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/util/ClassUtil", "formatClassName"));
        }
        if (buf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buf", "com/intellij/psi/util/ClassUtil", "formatClassName"));
        }
        String qName = aClass.getQualifiedName();
        if (qName != null) {
            buf.append(qName);
        } else {
            PsiClass parentClass = ClassUtil.getContainerClass(aClass);
            if (parentClass != null) {
                ClassUtil.formatClassName(parentClass, buf);
                buf.append("$");
                buf.append(ClassUtil.getNonQualifiedClassIdx(aClass));
                String name = aClass.getName();
                if (name != null) {
                    buf.append(name);
                }
            }
        }
    }

    @Nullable
    private static PsiClass getContainerClass(@NotNull PsiClass aClass) {
        PsiElement parent;
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/util/ClassUtil", "getContainerClass"));
        }
        for (parent = aClass.getContext(); parent != null && !(parent instanceof PsiClass); parent = parent.getContext()) {
        }
        return (PsiClass)parent;
    }

    public static int getNonQualifiedClassIdx(final @NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/util/ClassUtil", "getNonQualifiedClassIdx"));
        }
        final int[] result = new int[]{-1};
        PsiClass containingClass = ClassUtil.getContainerClass(psiClass);
        if (containingClass != null) {
            containingClass.accept(new JavaRecursiveElementVisitor(){
                private int myCurrentIdx = 0;

                @Override
                public void visitElement(PsiElement element) {
                    if (result[0] == -1) {
                        super.visitElement(element);
                    }
                }

                @Override
                public void visitClass(PsiClass aClass) {
                    super.visitClass(aClass);
                    if (aClass.getQualifiedName() == null) {
                        ++this.myCurrentIdx;
                        if (psiClass == aClass) {
                            result[0] = this.myCurrentIdx;
                        }
                    }
                }
            });
        }
        return result[0];
    }

    public static PsiClass findNonQualifiedClassByIndex(@NotNull String indexName, @NotNull PsiClass containingClass) {
        if (indexName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexName", "com/intellij/psi/util/ClassUtil", "findNonQualifiedClassByIndex"));
        }
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "com/intellij/psi/util/ClassUtil", "findNonQualifiedClassByIndex"));
        }
        return ClassUtil.findNonQualifiedClassByIndex(indexName, containingClass, false);
    }

    public static PsiClass findNonQualifiedClassByIndex(@NotNull String indexName, final @NotNull PsiClass containingClass, final boolean jvmCompatible) {
        if (indexName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexName", "com/intellij/psi/util/ClassUtil", "findNonQualifiedClassByIndex"));
        }
        if (containingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "com/intellij/psi/util/ClassUtil", "findNonQualifiedClassByIndex"));
        }
        String prefix = ClassUtil.getDigitPrefix(indexName);
        final int idx = !prefix.isEmpty() ? Integer.parseInt(prefix) : -1;
        final String name = prefix.length() < indexName.length() ? indexName.substring(prefix.length()) : null;
        final PsiClass[] result = new PsiClass[1];
        containingClass.accept(new JavaRecursiveElementVisitor(){
            private int myCurrentIdx = 0;

            @Override
            public void visitElement(PsiElement element) {
                if (result[0] == null) {
                    super.visitElement(element);
                }
            }

            @Override
            public void visitClass(PsiClass aClass) {
                if (!jvmCompatible) {
                    super.visitClass(aClass);
                    if (aClass.getQualifiedName() == null) {
                        ++this.myCurrentIdx;
                        if (this.myCurrentIdx == idx && Comparing.strEqual((String)name, (String)aClass.getName())) {
                            result[0] = aClass;
                        }
                    }
                    return;
                }
                if (aClass == containingClass) {
                    super.visitClass(aClass);
                    return;
                }
                if (Comparing.strEqual((String)name, (String)aClass.getName())) {
                    ++this.myCurrentIdx;
                    if (this.myCurrentIdx == idx || idx == -1) {
                        result[0] = aClass;
                    }
                }
            }

            @Override
            public void visitTypeParameter(PsiTypeParameter classParameter) {
                if (!jvmCompatible) {
                    super.visitTypeParameter(classParameter);
                } else {
                    this.visitElement(classParameter);
                }
            }
        });
        return result[0];
    }

    @NotNull
    private static String getDigitPrefix(@NotNull String indexName) {
        char c;
        int i;
        if (indexName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexName", "com/intellij/psi/util/ClassUtil", "getDigitPrefix"));
        }
        for (i = 0; i < indexName.length() && Character.isDigit(c = indexName.charAt(i)); ++i) {
        }
        String string = i == 0 ? "" : indexName.substring(0, i);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/ClassUtil", "getDigitPrefix"));
        }
        return string;
    }

    @Nullable
    public static PsiClass findPsiClass(@NotNull PsiManager psiManager, @NotNull String externalName) {
        if (psiManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiManager", "com/intellij/psi/util/ClassUtil", "findPsiClass"));
        }
        if (externalName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalName", "com/intellij/psi/util/ClassUtil", "findPsiClass"));
        }
        return ClassUtil.findPsiClass(psiManager, externalName, null, false);
    }

    @Nullable
    public static PsiClass findPsiClass(@NotNull PsiManager psiManager, @NotNull String externalName, PsiClass psiClass, boolean jvmCompatible) {
        if (psiManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiManager", "com/intellij/psi/util/ClassUtil", "findPsiClass"));
        }
        if (externalName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalName", "com/intellij/psi/util/ClassUtil", "findPsiClass"));
        }
        return ClassUtil.findPsiClass(psiManager, externalName, psiClass, jvmCompatible, GlobalSearchScope.allScope((Project)psiManager.getProject()));
    }

    @Nullable
    public static PsiClass findPsiClass(@NotNull PsiManager psiManager, @NotNull String externalName, @Nullable PsiClass psiClass, boolean jvmCompatible, @NotNull GlobalSearchScope scope) {
        if (psiManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiManager", "com/intellij/psi/util/ClassUtil", "findPsiClass"));
        }
        if (externalName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalName", "com/intellij/psi/util/ClassUtil", "findPsiClass"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/util/ClassUtil", "findPsiClass"));
        }
        for (int pos = 0; pos < externalName.length(); ++pos) {
            PsiClass res;
            if (externalName.charAt(pos) != '$') continue;
            PsiClass parentClass = psiClass;
            if (parentClass == null) {
                parentClass = JavaPsiFacade.getInstance(psiManager.getProject()).findClass(externalName.substring(0, pos), scope);
            }
            if (parentClass == null || (res = ClassUtil.findSubclass(psiManager, externalName.substring(pos + 1), parentClass, jvmCompatible)) == null) continue;
            return res;
        }
        return JavaPsiFacade.getInstance(psiManager.getProject()).findClass(externalName, scope);
    }

    @Nullable
    private static PsiClass findSubclass(@NotNull PsiManager psiManager, @NotNull String externalName, PsiClass psiClass, boolean jvmCompatible) {
        if (psiManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiManager", "com/intellij/psi/util/ClassUtil", "findSubclass"));
        }
        if (externalName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalName", "com/intellij/psi/util/ClassUtil", "findSubclass"));
        }
        for (int pos = 0; pos < externalName.length(); ++pos) {
            if (externalName.charAt(pos) != '$') continue;
            PsiClass anonymousClass = ClassUtil.findNonQualifiedClassByIndex(externalName.substring(0, pos), psiClass, jvmCompatible);
            if (anonymousClass == null) {
                return null;
            }
            PsiClass res = ClassUtil.findPsiClass(psiManager, externalName.substring(pos), anonymousClass, jvmCompatible);
            if (res == null) continue;
            return res;
        }
        return ClassUtil.findNonQualifiedClassByIndex(externalName, psiClass, jvmCompatible);
    }

    @Nullable
    public static String getJVMClassName(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/util/ClassUtil", "getJVMClassName"));
        }
        PsiClass containingClass = aClass.getContainingClass();
        if (containingClass != null) {
            String parentName = ClassUtil.getJVMClassName(containingClass);
            if (parentName == null) {
                return null;
            }
            return parentName + "$" + aClass.getName();
        }
        return aClass.getQualifiedName();
    }

    @Nullable
    public static PsiClass findPsiClassByJVMName(@NotNull PsiManager manager, @NotNull String jvmClassName) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/util/ClassUtil", "findPsiClassByJVMName"));
        }
        if (jvmClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmClassName", "com/intellij/psi/util/ClassUtil", "findPsiClassByJVMName"));
        }
        return ClassUtil.findPsiClass(manager, jvmClassName.replace('/', '.'), null, true);
    }
}

