/*
 * Copyright 2000-2015 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* The following code was generated by JFlex 1.4.3 on 4/28/15 5:41 PM */
package com.intellij.lang.java.lexer;

import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.lexer.FlexLexer;

@SuppressWarnings({"ALL"})

/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.3
 * on 28.04.2015 17:41 from the specification file
 * <tt>[community/]java/java-psi-impl/src/com/intellij/lang/java/lexer/_JavaLexer.flex</tt>
 */
class _JavaLexer implements FlexLexer {
  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0, 0
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\3\1\1\1\6\1\0\1\1\1\6\16\3\4\0\1\1\1\60"+
    "\1\26\1\0\1\2\1\67\1\65\1\25\1\70\1\71\1\5\1\62"+
    "\1\77\1\22\1\20\1\4\1\13\11\7\1\102\1\76\1\63\1\57"+
    "\1\64\1\101\1\103\1\11\1\15\1\11\1\17\1\21\1\16\5\2"+
    "\1\12\3\2\1\23\7\2\1\14\2\2\1\74\1\24\1\75\1\66"+
    "\1\10\1\0\1\34\1\40\1\41\1\47\1\32\1\33\1\52\1\45"+
    "\1\46\1\2\1\43\1\35\1\50\1\37\1\42\1\53\1\2\1\30"+
    "\1\36\1\27\1\31\1\54\1\55\1\51\1\44\1\56\1\72\1\61"+
    "\1\73\1\100\41\3\2\0\4\2\4\0\1\2\2\0\1\3\7\0"+
    "\1\2\4\0\1\2\5\0\27\2\1\0\37\2\1\0\u01ca\2\4\0"+
    "\14\2\16\0\5\2\7\0\1\2\1\0\1\2\21\0\160\3\5\2"+
    "\1\0\2\2\2\0\4\2\10\0\1\2\1\0\3\2\1\0\1\2"+
    "\1\0\24\2\1\0\123\2\1\0\213\2\1\0\5\3\2\0\236\2"+
    "\11\0\46\2\2\0\1\2\7\0\47\2\7\0\1\2\1\0\55\3"+
    "\1\0\1\3\1\0\2\3\1\0\2\3\1\0\1\3\10\0\33\2"+
    "\5\0\3\2\15\0\5\3\6\0\1\2\4\0\13\3\5\0\53\2"+
    "\37\3\4\0\2\2\1\3\143\2\1\0\1\2\10\3\1\0\6\3"+
    "\2\2\2\3\1\0\4\3\2\2\12\3\3\2\2\0\1\2\17\0"+
    "\1\3\1\2\1\3\36\2\33\3\2\0\131\2\13\3\1\2\16\0"+
    "\12\3\41\2\11\3\2\2\4\0\1\2\5\0\26\2\4\3\1\2"+
    "\11\3\1\2\3\3\1\2\5\3\22\0\31\2\3\3\104\0\1\2"+
    "\1\0\13\2\67\0\33\3\1\0\4\3\66\2\3\3\1\2\22\3"+
    "\1\2\7\3\12\2\2\3\2\0\12\3\1\0\7\2\1\0\7\2"+
    "\1\0\3\3\1\0\10\2\2\0\2\2\2\0\26\2\1\0\7\2"+
    "\1\0\1\2\3\0\4\2\2\0\1\3\1\2\7\3\2\0\2\3"+
    "\2\0\3\3\1\2\10\0\1\3\4\0\2\2\1\0\3\2\2\3"+
    "\2\0\12\3\4\2\7\0\1\2\5\0\3\3\1\0\6\2\4\0"+
    "\2\2\2\0\26\2\1\0\7\2\1\0\2\2\1\0\2\2\1\0"+
    "\2\2\2\0\1\3\1\0\5\3\4\0\2\3\2\0\3\3\3\0"+
    "\1\3\7\0\4\2\1\0\1\2\7\0\14\3\3\2\1\3\13\0"+
    "\3\3\1\0\11\2\1\0\3\2\1\0\26\2\1\0\7\2\1\0"+
    "\2\2\1\0\5\2\2\0\1\3\1\2\10\3\1\0\3\3\1\0"+
    "\3\3\2\0\1\2\17\0\2\2\2\3\2\0\12\3\1\0\1\2"+
    "\17\0\3\3\1\0\10\2\2\0\2\2\2\0\26\2\1\0\7\2"+
    "\1\0\2\2\1\0\5\2\2\0\1\3\1\2\7\3\2\0\2\3"+
    "\2\0\3\3\10\0\2\3\4\0\2\2\1\0\3\2\2\3\2\0"+
    "\12\3\1\0\1\2\20\0\1\3\1\2\1\0\6\2\3\0\3\2"+
    "\1\0\4\2\3\0\2\2\1\0\1\2\1\0\2\2\3\0\2\2"+
    "\3\0\3\2\3\0\14\2\4\0\5\3\3\0\3\3\1\0\4\3"+
    "\2\0\1\2\6\0\1\3\16\0\12\3\11\0\1\2\7\0\3\3"+
    "\1\0\10\2\1\0\3\2\1\0\27\2\1\0\12\2\1\0\5\2"+
    "\3\0\1\2\7\3\1\0\3\3\1\0\4\3\7\0\2\3\1\0"+
    "\2\2\6\0\2\2\2\3\2\0\12\3\22\0\2\3\1\0\10\2"+
    "\1\0\3\2\1\0\27\2\1\0\12\2\1\0\5\2\2\0\1\3"+
    "\1\2\7\3\1\0\3\3\1\0\4\3\7\0\2\3\7\0\1\2"+
    "\1\0\2\2\2\3\2\0\12\3\1\0\2\2\17\0\2\3\1\0"+
    "\10\2\1\0\3\2\1\0\51\2\2\0\1\2\7\3\1\0\3\3"+
    "\1\0\4\3\1\2\10\0\1\3\10\0\2\2\2\3\2\0\12\3"+
    "\12\0\6\2\2\0\2\3\1\0\22\2\3\0\30\2\1\0\11\2"+
    "\1\0\1\2\2\0\7\2\3\0\1\3\4\0\6\3\1\0\1\3"+
    "\1\0\10\3\22\0\2\3\15\0\60\2\1\3\2\2\7\3\4\0"+
    "\10\2\10\3\1\0\12\3\47\0\2\2\1\0\1\2\2\0\2\2"+
    "\1\0\1\2\2\0\1\2\6\0\4\2\1\0\7\2\1\0\3\2"+
    "\1\0\1\2\1\0\1\2\2\0\2\2\1\0\4\2\1\3\2\2"+
    "\6\3\1\0\2\3\1\2\2\0\5\2\1\0\1\2\1\0\6\3"+
    "\2\0\12\3\2\0\4\2\40\0\1\2\27\0\2\3\6\0\12\3"+
    "\13\0\1\3\1\0\1\3\1\0\1\3\4\0\2\3\10\2\1\0"+
    "\44\2\4\0\24\3\1\0\2\3\5\2\13\3\1\0\44\3\11\0"+
    "\1\3\71\0\53\2\24\3\1\2\12\3\6\0\6\2\4\3\4\2"+
    "\3\3\1\2\3\3\2\2\7\3\3\2\4\3\15\2\14\3\1\2"+
    "\17\3\2\0\46\2\1\0\1\2\5\0\1\2\2\0\53\2\1\0"+
    "\u014d\2\1\0\4\2\2\0\7\2\1\0\1\2\1\0\4\2\2\0"+
    "\51\2\1\0\4\2\2\0\41\2\1\0\4\2\2\0\7\2\1\0"+
    "\1\2\1\0\4\2\2\0\17\2\1\0\71\2\1\0\4\2\2\0"+
    "\103\2\2\0\3\3\40\0\20\2\20\0\125\2\14\0\u026c\2\2\0"+
    "\21\2\1\0\32\2\5\0\113\2\3\0\3\2\17\0\15\2\1\0"+
    "\4\2\3\3\13\0\22\2\3\3\13\0\22\2\2\3\14\0\15\2"+
    "\1\0\3\2\1\0\2\3\14\0\64\2\40\3\3\0\1\2\3\0"+
    "\2\2\1\3\2\0\12\3\41\0\3\3\2\0\12\3\6\0\130\2"+
    "\10\0\51\2\1\3\1\2\5\0\106\2\12\0\35\2\3\0\14\3"+
    "\4\0\14\3\12\0\12\3\36\2\2\0\5\2\13\0\54\2\4\0"+
    "\21\3\7\2\2\3\6\0\12\3\46\0\27\2\5\3\4\0\65\2"+
    "\12\3\1\0\35\3\2\0\13\3\6\0\12\3\15\0\1\2\130\0"+
    "\5\3\57\2\21\3\7\2\4\0\12\3\21\0\11\3\14\0\3\3"+
    "\36\2\15\3\2\2\12\3\54\2\16\3\14\0\44\2\24\3\10\0"+
    "\12\3\3\0\3\2\12\3\44\2\122\0\3\3\1\0\25\3\4\2"+
    "\1\3\4\2\3\3\2\2\11\0\300\2\47\3\25\0\4\3\u0116\2"+
    "\2\0\6\2\2\0\46\2\2\0\6\2\2\0\10\2\1\0\1\2"+
    "\1\0\1\2\1\0\1\2\1\0\37\2\2\0\65\2\1\0\7\2"+
    "\1\0\1\2\3\0\3\2\1\0\7\2\3\0\4\2\2\0\6\2"+
    "\4\0\15\2\5\0\3\2\1\0\7\2\16\0\5\3\32\0\5\3"+
    "\20\0\2\2\23\0\1\2\13\0\5\3\5\0\6\3\1\0\1\2"+
    "\15\0\1\2\20\0\15\2\3\0\33\2\25\0\15\3\4\0\1\3"+
    "\3\0\14\3\21\0\1\2\4\0\1\2\2\0\12\2\1\0\1\2"+
    "\3\0\5\2\6\0\1\2\1\0\1\2\1\0\1\2\1\0\4\2"+
    "\1\0\13\2\2\0\4\2\5\0\5\2\4\0\1\2\21\0\51\2"+
    "\u0a77\0\57\2\1\0\57\2\1\0\205\2\6\0\4\2\3\3\2\2"+
    "\14\0\46\2\1\0\1\2\5\0\1\2\2\0\70\2\7\0\1\2"+
    "\17\0\1\3\27\2\11\0\7\2\1\0\7\2\1\0\7\2\1\0"+
    "\7\2\1\0\7\2\1\0\7\2\1\0\7\2\1\0\7\2\1\0"+
    "\40\3\57\0\1\2\u01d5\0\3\2\31\0\11\2\6\3\1\0\5\2"+
    "\2\0\5\2\4\0\126\2\2\0\2\3\2\0\3\2\1\0\132\2"+
    "\1\0\4\2\5\0\51\2\3\0\136\2\21\0\33\2\65\0\20\2"+
    "\u0200\0\u19b6\2\112\0\u51cd\2\63\0\u048d\2\103\0\56\2\2\0\u010d\2"+
    "\3\0\20\2\12\3\2\2\24\0\57\2\1\3\4\0\12\3\1\0"+
    "\31\2\7\0\1\3\120\2\2\3\45\0\11\2\2\0\147\2\2\0"+
    "\4\2\1\0\4\2\14\0\13\2\115\0\12\2\1\3\3\2\1\3"+
    "\4\2\1\3\27\2\5\3\20\0\1\2\7\0\64\2\14\0\2\3"+
    "\62\2\21\3\13\0\12\3\6\0\22\3\6\2\3\0\1\2\4\0"+
    "\12\3\34\2\10\3\2\0\27\2\15\3\14\0\35\2\3\0\4\3"+
    "\57\2\16\3\16\0\1\2\12\3\46\0\51\2\16\3\11\0\3\2"+
    "\1\3\10\2\2\3\2\0\12\3\6\0\27\2\3\0\1\2\1\3"+
    "\4\0\60\2\1\3\1\2\3\3\2\2\2\3\5\2\2\3\1\2"+
    "\1\3\1\2\30\0\3\2\2\0\13\2\5\3\2\0\3\2\2\3"+
    "\12\0\6\2\2\0\6\2\2\0\6\2\11\0\7\2\1\0\7\2"+
    "\221\0\43\2\10\3\1\0\2\3\2\0\12\3\6\0\u2ba4\2\14\0"+
    "\27\2\4\0\61\2\u2104\0\u016e\2\2\0\152\2\46\0\7\2\14\0"+
    "\5\2\5\0\1\2\1\3\12\2\1\0\15\2\1\0\5\2\1\0"+
    "\1\2\1\0\2\2\1\0\2\2\1\0\154\2\41\0\u016b\2\22\0"+
    "\100\2\2\0\66\2\50\0\15\2\3\0\20\3\20\0\7\3\14\0"+
    "\2\2\30\0\3\2\31\0\1\2\6\0\5\2\1\0\207\2\2\0"+
    "\1\3\4\0\1\2\13\0\12\3\7\0\32\2\4\0\1\2\1\0"+
    "\32\2\13\0\131\2\3\0\6\2\2\0\6\2\2\0\6\2\2\0"+
    "\3\2\3\0\2\2\3\0\2\2\22\0\3\3\4\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\0\1\1\1\2\1\3\1\4\1\5\2\6\1\7"+
    "\1\10\1\11\1\12\20\3\1\13\1\14\1\15\1\16"+
    "\1\17\1\20\1\21\1\22\1\23\1\24\1\25\1\26"+
    "\1\27\1\30\1\31\1\32\1\33\1\34\1\35\1\36"+
    "\1\37\1\40\1\41\1\42\1\43\1\44\1\45\3\46"+
    "\2\6\1\0\1\47\1\50\1\51\2\11\2\12\34\3"+
    "\1\52\3\3\1\53\6\3\1\54\1\55\1\56\1\57"+
    "\1\60\1\61\1\62\1\63\1\64\1\65\1\66\1\67"+
    "\1\70\1\41\1\71\1\46\1\6\1\0\1\72\2\3"+
    "\1\73\10\3\1\74\13\3\1\75\11\3\1\76\14\3"+
    "\1\77\1\0\2\71\1\0\1\100\2\3\1\101\1\3"+
    "\1\102\1\103\6\3\1\104\6\3\1\105\3\3\1\106"+
    "\1\3\1\107\3\3\1\110\6\3\1\111\5\3\1\112"+
    "\1\3\1\41\1\0\1\3\1\113\2\3\1\114\1\115"+
    "\1\116\4\3\1\117\1\3\1\120\2\3\1\121\1\3"+
    "\1\122\1\123\1\3\1\124\13\3\1\125\1\3\1\126"+
    "\1\127\2\3\1\130\2\3\1\131\1\3\1\132\1\133"+
    "\5\3\1\134\1\3\1\135\2\3\1\136\3\3\1\137"+
    "\1\140\3\3\1\141\4\3\1\142\1\3\1\143\1\144"+
    "\2\3\1\145\1\146\1\3\1\147\4\3\1\150\1\151"+
    "\1\3\1\152\2\3\1\153\1\3\1\154\1\155\1\3"+
    "\1\156";

  private static int [] zzUnpackAction() {
    int [] result = new int[320];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\104\0\210\0\314\0\u0110\0\u0154\0\u0198\0\u01dc"+
    "\0\u0220\0\u0264\0\u02a8\0\u02ec\0\u0330\0\u0374\0\u03b8\0\u03fc"+
    "\0\u0440\0\u0484\0\u04c8\0\u050c\0\u0550\0\u0594\0\u05d8\0\u061c"+
    "\0\u0660\0\u06a4\0\u06e8\0\u072c\0\u0770\0\u07b4\0\u07f8\0\u083c"+
    "\0\u0880\0\104\0\u08c4\0\u0908\0\u094c\0\104\0\104\0\104"+
    "\0\104\0\104\0\104\0\104\0\104\0\104\0\104\0\u0990"+
    "\0\104\0\u09d4\0\u0a18\0\104\0\104\0\104\0\104\0\104"+
    "\0\u0a5c\0\u0aa0\0\u0ae4\0\u0b28\0\u0b6c\0\104\0\104\0\104"+
    "\0\u0bb0\0\104\0\u0bf4\0\104\0\u0c38\0\u0c7c\0\u0cc0\0\u0d04"+
    "\0\u0d48\0\u0d8c\0\u0dd0\0\u0e14\0\u0e58\0\u0e9c\0\u0ee0\0\u0f24"+
    "\0\u0f68\0\u0fac\0\u0ff0\0\u1034\0\u1078\0\u10bc\0\u1100\0\u1144"+
    "\0\u1188\0\u11cc\0\u1210\0\u1254\0\u1298\0\u12dc\0\u1320\0\u1364"+
    "\0\314\0\u13a8\0\u13ec\0\u1430\0\u1474\0\u14b8\0\u14fc\0\u1540"+
    "\0\u1584\0\u15c8\0\u160c\0\104\0\104\0\104\0\104\0\104"+
    "\0\104\0\104\0\u1650\0\104\0\104\0\104\0\104\0\104"+
    "\0\u1694\0\u16d8\0\u171c\0\u1760\0\u17a4\0\104\0\u17e8\0\u182c"+
    "\0\314\0\u1870\0\u18b4\0\u18f8\0\u193c\0\u1980\0\u19c4\0\u1a08"+
    "\0\u1a4c\0\314\0\u1a90\0\u1ad4\0\u1b18\0\u1b5c\0\u1ba0\0\u1be4"+
    "\0\u1c28\0\u1c6c\0\u1cb0\0\u1cf4\0\u1d38\0\314\0\u1d7c\0\u1dc0"+
    "\0\u1e04\0\u1e48\0\u1e8c\0\u1ed0\0\u1f14\0\u1f58\0\u1f9c\0\u1fe0"+
    "\0\u2024\0\u2068\0\u20ac\0\u20f0\0\u2134\0\u2178\0\u21bc\0\u2200"+
    "\0\u2244\0\u2288\0\u22cc\0\u2310\0\104\0\u2354\0\u2398\0\104"+
    "\0\u23dc\0\314\0\u2420\0\u2464\0\314\0\u24a8\0\314\0\314"+
    "\0\u24ec\0\u2530\0\u2574\0\u25b8\0\u25fc\0\u2640\0\314\0\u2684"+
    "\0\u26c8\0\u270c\0\u2750\0\u2794\0\u27d8\0\314\0\u281c\0\u2860"+
    "\0\u28a4\0\314\0\u28e8\0\314\0\u292c\0\u2970\0\u29b4\0\314"+
    "\0\u29f8\0\u2a3c\0\u2a80\0\u2ac4\0\u2b08\0\u2b4c\0\314\0\u2b90"+
    "\0\u2bd4\0\u2c18\0\u2c5c\0\u2ca0\0\314\0\u2ce4\0\104\0\u2d28"+
    "\0\u2d6c\0\u2db0\0\u2df4\0\u2e38\0\314\0\314\0\u2e7c\0\u2ec0"+
    "\0\u2f04\0\u2f48\0\u2f8c\0\314\0\u2fd0\0\314\0\u3014\0\u3058"+
    "\0\314\0\u309c\0\314\0\314\0\u30e0\0\314\0\u3124\0\u3168"+
    "\0\u31ac\0\u31f0\0\u3234\0\u3278\0\u32bc\0\u3300\0\u3344\0\u3388"+
    "\0\u33cc\0\314\0\u3410\0\314\0\314\0\u3454\0\u3498\0\314"+
    "\0\u34dc\0\u3520\0\314\0\u3564\0\314\0\314\0\u35a8\0\u35ec"+
    "\0\u3630\0\u3674\0\u36b8\0\314\0\u36fc\0\314\0\u3740\0\u3784"+
    "\0\314\0\u37c8\0\u380c\0\u3850\0\314\0\314\0\u3894\0\u38d8"+
    "\0\u391c\0\314\0\u3960\0\u39a4\0\u39e8\0\u3a2c\0\314\0\u3a70"+
    "\0\314\0\314\0\u3ab4\0\u3af8\0\314\0\314\0\u3b3c\0\314"+
    "\0\u3b80\0\u3bc4\0\u3c08\0\u3c4c\0\314\0\314\0\u3c90\0\314"+
    "\0\u3cd4\0\u3d18\0\314\0\u3d5c\0\314\0\314\0\u3da0\0\314";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[320];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\2\1\3\1\4\1\2\1\5\1\6\1\3\1\7"+
    "\3\4\1\10\4\4\1\11\1\4\1\12\1\4\1\2"+
    "\1\13\1\14\1\15\1\16\1\4\1\17\1\20\1\21"+
    "\1\22\1\23\1\24\1\25\1\26\4\4\1\27\1\30"+
    "\2\4\1\31\1\32\1\33\1\34\1\4\1\35\1\36"+
    "\1\37\1\40\1\41\1\42\1\43\1\44\1\45\1\46"+
    "\1\47\1\50\1\51\1\52\1\53\1\54\1\55\1\56"+
    "\1\57\1\60\1\61\105\0\1\3\4\0\1\3\77\0"+
    "\2\4\3\0\11\4\1\0\1\4\1\0\1\4\3\0"+
    "\30\4\31\0\1\62\1\63\51\0\1\64\103\0\1\65"+
    "\33\0\2\7\1\0\1\66\1\7\2\0\1\67\1\70"+
    "\1\71\1\72\10\0\1\72\1\67\1\0\1\66\11\0"+
    "\1\70\43\0\2\7\1\0\1\66\1\7\1\73\1\74"+
    "\1\67\1\70\1\71\1\72\10\0\1\72\1\67\1\0"+
    "\1\66\2\0\1\74\6\0\1\70\1\0\1\73\41\0"+
    "\1\71\3\0\1\71\4\0\1\75\105\0\1\76\34\0"+
    "\1\77\4\0\1\100\17\0\6\13\1\0\15\13\1\101"+
    "\1\102\56\13\6\14\1\0\15\14\1\103\1\14\1\104"+
    "\55\14\2\0\2\4\3\0\11\4\1\0\1\4\1\0"+
    "\1\4\3\0\1\4\1\105\14\4\1\106\11\4\27\0"+
    "\2\4\3\0\11\4\1\0\1\4\1\0\1\4\3\0"+
    "\3\4\1\107\24\4\27\0\2\4\3\0\11\4\1\0"+
    "\1\4\1\0\1\4\3\0\6\4\1\110\1\4\1\111"+
    "\11\4\1\112\5\4\27\0\2\4\3\0\11\4\1\0"+
    "\1\4\1\0\1\4\3\0\5\4\1\113\1\114\4\4"+
    "\1\115\3\4\1\116\10\4\27\0\2\4\3\0\11\4"+
    "\1\0\1\4\1\0\1\4\3\0\7\4\1\117\1\4"+
    "\1\120\16\4\27\0\2\4\3\0\11\4\1\0\1\4"+
    "\1\0\1\4\3\0\13\4\1\121\14\4\27\0\2\4"+
    "\3\0\11\4\1\0\1\4\1\0\1\4\3\0\1\122"+
    "\1\4\1\123\12\4\1\124\1\125\7\4\1\126\1\4"+
    "\27\0\2\4\3\0\11\4\1\0\1\4\1\0\1\4"+
    "\3\0\2\4\1\127\1\130\1\4\1\131\22\4\27\0"+
    "\2\4\3\0\11\4\1\0\1\4\1\0\1\4\3\0"+
    "\1\4\1\132\11\4\1\133\1\4\1\134\12\4\27\0"+
    "\2\4\3\0\11\4\1\0\1\4\1\0\1\4\3\0"+
    "\5\4\1\135\1\136\4\4\1\137\2\4\1\140\11\4"+
    "\27\0\2\4\3\0\11\4\1\0\1\4\1\0\1\4"+
    "\3\0\4\4\1\141\3\4\1\142\10\4\1\143\6\4"+
    "\27\0\2\4\3\0\11\4\1\0\1\4\1\0\1\4"+
    "\3\0\3\4\1\144\7\4\1\145\14\4\27\0\2\4"+
    "\3\0\11\4\1\0\1\4\1\0\1\4\3\0\13\4"+
    "\1\146\14\4\27\0\2\4\3\0\11\4\1\0\1\4"+
    "\1\0\1\4\3\0\1\4\1\147\1\150\2\4\1\151"+
    "\22\4\27\0\2\4\3\0\11\4\1\0\1\4\1\0"+
    "\1\4\3\0\13\4\1\152\14\4\27\0\2\4\3\0"+
    "\11\4\1\0\1\4\1\0\1\4\3\0\16\4\1\153"+
    "\11\4\104\0\1\154\103\0\1\155\103\0\1\156\1\0"+
    "\1\157\101\0\1\160\2\0\1\161\100\0\1\162\3\0"+
    "\1\163\77\0\1\164\5\0\1\165\75\0\1\166\103\0"+
    "\1\167\126\0\1\170\1\0\6\62\1\0\75\62\5\171"+
    "\1\172\76\171\7\0\2\71\2\0\1\71\2\0\1\67"+
    "\1\70\1\0\1\72\10\0\1\72\1\67\13\0\1\70"+
    "\43\0\2\173\2\0\1\173\2\0\1\67\1\70\2\0"+
    "\1\173\10\0\1\67\13\0\1\70\12\0\1\173\30\0"+
    "\3\174\1\66\1\174\1\0\3\174\1\175\1\174\10\0"+
    "\3\174\1\66\2\0\2\174\5\0\1\174\43\0\2\74"+
    "\1\0\1\66\1\74\21\0\1\66\66\0\1\176\63\0"+
    "\6\13\1\0\75\13\6\14\1\0\75\14\2\0\2\4"+
    "\3\0\11\4\1\0\1\4\1\0\1\4\3\0\2\4"+
    "\1\177\2\4\1\200\7\4\1\201\12\4\27\0\2\4"+
    "\3\0\11\4\1\0\1\4\1\0\1\4\3\0\1\4"+
    "\1\202\15\4\1\203\10\4\27\0\2\4\3\0\11\4"+
    "\1\0\1\4\1\0\1\4\3\0\1\204\27\4\27\0"+
    "\2\4\3\0\11\4\1\0\1\4\1\0\1\4\3\0"+
    "\7\4\1\205\20\4\27\0\2\4\3\0\11\4\1\0"+
    "\1\4\1\0\1\4\3\0\2\4\1\206\25\4\27\0"+
    "\2\4\3\0\11\4\1\0\1\4\1\0\1\4\3\0"+
    "\1\207\27\4\27\0\2\4\3\0\11\4\1\0\1\4"+
    "\1\0\1\4\3\0\6\4\1\210\21\4\27\0\2\4"+
    "\3\0\11\4\1\0\1\4\1\0\1\4\3\0\13\4"+
    "\1\211\14\4\27\0\2\4\3\0\11\4\1\0\1\4"+
    "\1\0\1\4\3\0\1\4\1\212\26\4\27\0\2\4"+
    "\3\0\11\4\1\0\1\4\1\0\1\4\3\0\10\4"+
    "\1\213\17\4\27\0\2\4\3\0\11\4\1\0\1\4"+
    "\1\0\1\4\3\0\7\4\1\214\20\4\27\0\2\4"+
    "\3\0\11\4\1\0\1\4\1\0\1\4\3\0\7\4"+
    "\1\215\20\4\27\0\2\4\3\0\11\4\1\0\1\4"+
    "\1\0\1\4\3\0\10\4\1\216\17\4\27\0\2\4"+
    "\3\0\11\4\1\0\1\4\1\0\1\4\3\0\1\4"+
    "\1\217\3\4\1\220\22\4\27\0\2\4\3\0\11\4"+
    "\1\0\1\4\1\0\1\4\3\0\24\4\1\221\3\4"+
    "\27\0\2\4\3\0\11\4\1\0\1\4\1\0\1\4"+
    "\3\0\10\4\1\222\17\4\27\0\2\4\3\0\11\4"+
    "\1\0\1\4\1\0\1\4\3\0\13\4\1\223\14\4"+
    "\27\0\2\4\3\0\11\4\1\0\1\4\1\0\1\4"+
    "\3\0\17\4\1\224\10\4\27\0\2\4\3\0\11\4"+
    "\1\0\1\4\1\0\1\4\3\0\6\4\1\225\21\4"+
    "\27\0\2\4\3\0\11\4\1\0\1\4\1\0\1\4"+
    "\3\0\26\4\1\226\1\4\27\0\2\4\3\0\11\4"+
    "\1\0\1\4\1\0\1\4\3\0\1\227\27\4\27\0"+
    "\2\4\3\0\11\4\1\0\1\4\1\0\1\4\3\0"+
    "\3\4\1\230\24\4\27\0\2\4\3\0\11\4\1\0"+
    "\1\4\1\0\1\4\3\0\13\4\1\231\14\4\27\0"+
    "\2\4\3\0\11\4\1\0\1\4\1\0\1\4\3\0"+
    "\1\232\27\4\27\0\2\4\3\0\11\4\1\0\1\4"+
    "\1\0\1\4\3\0\1\233\6\4\1\234\20\4\27\0"+
    "\2\4\3\0\11\4\1\0\1\4\1\0\1\4\3\0"+
    "\5\4\1\235\22\4\27\0\2\4\3\0\11\4\1\0"+
    "\1\4\1\0\1\4\3\0\10\4\1\236\17\4\27\0"+
    "\2\4\3\0\11\4\1\0\1\4\1\0\1\4\3\0"+
    "\5\4\1\237\22\4\27\0\2\4\3\0\11\4\1\0"+
    "\1\4\1\0\1\4\3\0\1\240\6\4\1\241\20\4"+
    "\27\0\2\4\3\0\11\4\1\0\1\4\1\0\1\4"+
    "\3\0\24\4\1\242\3\4\27\0\2\4\3\0\11\4"+
    "\1\0\1\4\1\0\1\4\3\0\4\4\1\243\23\4"+
    "\27\0\2\4\3\0\11\4\1\0\1\4\1\0\1\4"+
    "\3\0\2\4\1\244\25\4\27\0\2\4\3\0\11\4"+
    "\1\0\1\4\1\0\1\4\3\0\1\245\27\4\27\0"+
    "\2\4\3\0\11\4\1\0\1\4\1\0\1\4\3\0"+
    "\13\4\1\246\3\4\1\247\10\4\27\0\2\4\3\0"+
    "\11\4\1\0\1\4\1\0\1\4\3\0\11\4\1\250"+
    "\16\4\27\0\2\4\3\0\11\4\1\0\1\4\1\0"+
    "\1\4\3\0\12\4\1\251\15\4\27\0\2\4\3\0"+
    "\11\4\1\0\1\4\1\0\1\4\3\0\6\4\1\252"+
    "\10\4\1\253\10\4\27\0\2\4\3\0\11\4\1\0"+
    "\1\4\1\0\1\4\3\0\17\4\1\254\10\4\104\0"+
    "\1\255\24\0\5\171\1\256\76\171\4\257\1\260\1\172"+
    "\76\257\7\0\2\173\2\0\1\173\2\0\1\67\1\70"+
    "\13\0\1\67\13\0\1\70\43\0\3\174\1\66\1\174"+
    "\1\0\3\174\1\261\1\174\1\0\1\72\6\0\3\174"+
    "\1\66\2\0\2\174\5\0\1\174\3\0\1\72\37\0"+
    "\3\261\1\0\1\261\1\0\3\261\1\0\1\261\10\0"+
    "\3\261\3\0\2\261\5\0\1\261\36\0\2\4\3\0"+
    "\11\4\1\0\1\4\1\0\1\4\3\0\3\4\1\262"+
    "\24\4\27\0\2\4\3\0\11\4\1\0\1\4\1\0"+
    "\1\4\3\0\10\4\1\263\17\4\27\0\2\4\3\0"+
    "\11\4\1\0\1\4\1\0\1\4\3\0\13\4\1\264"+
    "\14\4\27\0\2\4\3\0\11\4\1\0\1\4\1\0"+
    "\1\4\3\0\7\4\1\265\20\4\27\0\2\4\3\0"+
    "\11\4\1\0\1\4\1\0\1\4\3\0\2\4\1\266"+
    "\25\4\27\0\2\4\3\0\11\4\1\0\1\4\1\0"+
    "\1\4\3\0\3\4\1\267\24\4\27\0\2\4\3\0"+
    "\11\4\1\0\1\4\1\0\1\4\3\0\21\4\1\270"+
    "\6\4\27\0\2\4\3\0\11\4\1\0\1\4\1\0"+
    "\1\4\3\0\3\4\1\271\24\4\27\0\2\4\3\0"+
    "\11\4\1\0\1\4\1\0\1\4\3\0\7\4\1\272"+
    "\20\4\27\0\2\4\3\0\11\4\1\0\1\4\1\0"+
    "\1\4\3\0\5\4\1\273\22\4\27\0\2\4\3\0"+
    "\11\4\1\0\1\4\1\0\1\4\3\0\5\4\1\274"+
    "\22\4\27\0\2\4\3\0\11\4\1\0\1\4\1\0"+
    "\1\4\3\0\3\4\1\275\24\4\27\0\2\4\3\0"+
    "\11\4\1\0\1\4\1\0\1\4\3\0\1\276\27\4"+
    "\27\0\2\4\3\0\11\4\1\0\1\4\1\0\1\4"+
    "\3\0\23\4\1\277\4\4\27\0\2\4\3\0\11\4"+
    "\1\0\1\4\1\0\1\4\3\0\17\4\1\300\10\4"+
    "\27\0\2\4\3\0\11\4\1\0\1\4\1\0\1\4"+
    "\3\0\1\301\27\4\27\0\2\4\3\0\11\4\1\0"+
    "\1\4\1\0\1\4\3\0\3\4\1\302\24\4\27\0"+
    "\2\4\3\0\11\4\1\0\1\4\1\0\1\4\3\0"+
    "\12\4\1\303\15\4\27\0\2\4\3\0\11\4\1\0"+
    "\1\4\1\0\1\4\3\0\1\4\1\304\26\4\27\0"+
    "\2\4\3\0\11\4\1\0\1\4\1\0\1\4\3\0"+
    "\1\305\27\4\27\0\2\4\3\0\11\4\1\0\1\4"+
    "\1\0\1\4\3\0\6\4\1\306\21\4\27\0\2\4"+
    "\3\0\11\4\1\0\1\4\1\0\1\4\3\0\17\4"+
    "\1\307\10\4\27\0\2\4\3\0\11\4\1\0\1\4"+
    "\1\0\1\4\3\0\5\4\1\310\22\4\27\0\2\4"+
    "\3\0\11\4\1\0\1\4\1\0\1\4\3\0\6\4"+
    "\1\311\21\4\27\0\2\4\3\0\11\4\1\0\1\4"+
    "\1\0\1\4\3\0\3\4\1\312\24\4\27\0\2\4"+
    "\3\0\11\4\1\0\1\4\1\0\1\4\3\0\12\4"+
    "\1\313\15\4\27\0\2\4\3\0\11\4\1\0\1\4"+
    "\1\0\1\4\3\0\3\4\1\314\24\4\27\0\2\4"+
    "\3\0\11\4\1\0\1\4\1\0\1\4\3\0\7\4"+
    "\1\315\20\4\27\0\2\4\3\0\11\4\1\0\1\4"+
    "\1\0\1\4\3\0\1\316\6\4\1\317\20\4\27\0"+
    "\2\4\3\0\11\4\1\0\1\4\1\0\1\4\3\0"+
    "\1\4\1\320\26\4\27\0\2\4\3\0\11\4\1\0"+
    "\1\4\1\0\1\4\3\0\3\4\1\321\24\4\27\0"+
    "\2\4\3\0\11\4\1\0\1\4\1\0\1\4\3\0"+
    "\1\322\27\4\27\0\2\4\3\0\11\4\1\0\1\4"+
    "\1\0\1\4\3\0\6\4\1\323\4\4\1\324\14\4"+
    "\27\0\2\4\3\0\11\4\1\0\1\4\1\0\1\4"+
    "\3\0\5\4\1\325\22\4\27\0\2\4\3\0\11\4"+
    "\1\0\1\4\1\0\1\4\3\0\11\4\1\326\16\4"+
    "\27\0\2\4\3\0\11\4\1\0\1\4\1\0\1\4"+
    "\3\0\13\4\1\327\14\4\27\0\2\4\3\0\11\4"+
    "\1\0\1\4\1\0\1\4\3\0\1\330\27\4\27\0"+
    "\2\4\3\0\11\4\1\0\1\4\1\0\1\4\3\0"+
    "\25\4\1\331\2\4\27\0\2\4\3\0\11\4\1\0"+
    "\1\4\1\0\1\4\3\0\6\4\1\332\21\4\27\0"+
    "\2\4\3\0\11\4\1\0\1\4\1\0\1\4\3\0"+
    "\14\4\1\333\13\4\27\0\2\4\3\0\11\4\1\0"+
    "\1\4\1\0\1\4\3\0\5\4\1\334\22\4\27\0"+
    "\2\4\3\0\11\4\1\0\1\4\1\0\1\4\3\0"+
    "\20\4\1\335\7\4\27\0\2\4\3\0\11\4\1\0"+
    "\1\4\1\0\1\4\3\0\6\4\1\336\21\4\25\0"+
    "\4\171\1\337\1\256\76\171\5\257\1\340\76\257\7\0"+
    "\3\261\1\0\1\261\1\0\3\261\1\0\1\261\1\0"+
    "\1\72\6\0\3\261\3\0\2\261\5\0\1\261\3\0"+
    "\1\72\32\0\2\4\3\0\11\4\1\0\1\4\1\0"+
    "\1\4\3\0\7\4\1\341\20\4\27\0\2\4\3\0"+
    "\11\4\1\0\1\4\1\0\1\4\3\0\26\4\1\342"+
    "\1\4\27\0\2\4\3\0\11\4\1\0\1\4\1\0"+
    "\1\4\3\0\1\4\1\343\26\4\27\0\2\4\3\0"+
    "\11\4\1\0\1\4\1\0\1\4\3\0\10\4\1\344"+
    "\17\4\27\0\2\4\3\0\11\4\1\0\1\4\1\0"+
    "\1\4\3\0\3\4\1\345\24\4\27\0\2\4\3\0"+
    "\11\4\1\0\1\4\1\0\1\4\3\0\1\346\27\4"+
    "\27\0\2\4\3\0\11\4\1\0\1\4\1\0\1\4"+
    "\3\0\6\4\1\347\21\4\27\0\2\4\3\0\11\4"+
    "\1\0\1\4\1\0\1\4\3\0\1\4\1\350\26\4"+
    "\27\0\2\4\3\0\11\4\1\0\1\4\1\0\1\4"+
    "\3\0\1\4\1\351\26\4\27\0\2\4\3\0\11\4"+
    "\1\0\1\4\1\0\1\4\3\0\12\4\1\352\15\4"+
    "\27\0\2\4\3\0\11\4\1\0\1\4\1\0\1\4"+
    "\3\0\17\4\1\353\10\4\27\0\2\4\3\0\11\4"+
    "\1\0\1\4\1\0\1\4\3\0\1\4\1\354\26\4"+
    "\27\0\2\4\3\0\11\4\1\0\1\4\1\0\1\4"+
    "\3\0\16\4\1\355\11\4\27\0\2\4\3\0\11\4"+
    "\1\0\1\4\1\0\1\4\3\0\1\356\27\4\27\0"+
    "\2\4\3\0\11\4\1\0\1\4\1\0\1\4\3\0"+
    "\12\4\1\357\15\4\27\0\2\4\3\0\11\4\1\0"+
    "\1\4\1\0\1\4\3\0\25\4\1\360\2\4\27\0"+
    "\2\4\3\0\11\4\1\0\1\4\1\0\1\4\3\0"+
    "\14\4\1\361\13\4\27\0\2\4\3\0\11\4\1\0"+
    "\1\4\1\0\1\4\3\0\3\4\1\362\24\4\27\0"+
    "\2\4\3\0\11\4\1\0\1\4\1\0\1\4\3\0"+
    "\16\4\1\363\11\4\27\0\2\4\3\0\11\4\1\0"+
    "\1\4\1\0\1\4\3\0\7\4\1\364\20\4\27\0"+
    "\2\4\3\0\11\4\1\0\1\4\1\0\1\4\3\0"+
    "\17\4\1\365\10\4\27\0\2\4\3\0\11\4\1\0"+
    "\1\4\1\0\1\4\3\0\1\366\27\4\27\0\2\4"+
    "\3\0\11\4\1\0\1\4\1\0\1\4\3\0\1\4"+
    "\1\367\26\4\27\0\2\4\3\0\11\4\1\0\1\4"+
    "\1\0\1\4\3\0\5\4\1\370\22\4\27\0\2\4"+
    "\3\0\11\4\1\0\1\4\1\0\1\4\3\0\3\4"+
    "\1\371\24\4\27\0\2\4\3\0\11\4\1\0\1\4"+
    "\1\0\1\4\3\0\1\4\1\372\26\4\27\0\2\4"+
    "\3\0\11\4\1\0\1\4\1\0\1\4\3\0\2\4"+
    "\1\373\25\4\27\0\2\4\3\0\11\4\1\0\1\4"+
    "\1\0\1\4\3\0\6\4\1\374\21\4\27\0\2\4"+
    "\3\0\11\4\1\0\1\4\1\0\1\4\3\0\3\4"+
    "\1\375\24\4\27\0\2\4\3\0\11\4\1\0\1\4"+
    "\1\0\1\4\3\0\5\4\1\376\22\4\27\0\2\4"+
    "\3\0\11\4\1\0\1\4\1\0\1\4\3\0\17\4"+
    "\1\377\10\4\27\0\2\4\3\0\11\4\1\0\1\4"+
    "\1\0\1\4\3\0\5\4\1\u0100\22\4\27\0\2\4"+
    "\3\0\11\4\1\0\1\4\1\0\1\4\3\0\1\u0101"+
    "\27\4\27\0\2\4\3\0\11\4\1\0\1\4\1\0"+
    "\1\4\3\0\3\4\1\u0102\24\4\25\0\4\257\1\260"+
    "\1\340\76\257\2\0\2\4\3\0\11\4\1\0\1\4"+
    "\1\0\1\4\3\0\17\4\1\u0103\10\4\27\0\2\4"+
    "\3\0\11\4\1\0\1\4\1\0\1\4\3\0\7\4"+
    "\1\u0104\20\4\27\0\2\4\3\0\11\4\1\0\1\4"+
    "\1\0\1\4\3\0\10\4\1\u0105\17\4\27\0\2\4"+
    "\3\0\11\4\1\0\1\4\1\0\1\4\3\0\20\4"+
    "\1\u0106\7\4\27\0\2\4\3\0\11\4\1\0\1\4"+
    "\1\0\1\4\3\0\6\4\1\u0107\21\4\27\0\2\4"+
    "\3\0\11\4\1\0\1\4\1\0\1\4\3\0\1\u0108"+
    "\27\4\27\0\2\4\3\0\11\4\1\0\1\4\1\0"+
    "\1\4\3\0\5\4\1\u0109\22\4\27\0\2\4\3\0"+
    "\11\4\1\0\1\4\1\0\1\4\3\0\1\u010a\27\4"+
    "\27\0\2\4\3\0\11\4\1\0\1\4\1\0\1\4"+
    "\3\0\12\4\1\u010b\15\4\27\0\2\4\3\0\11\4"+
    "\1\0\1\4\1\0\1\4\3\0\1\4\1\u010c\26\4"+
    "\27\0\2\4\3\0\11\4\1\0\1\4\1\0\1\4"+
    "\3\0\16\4\1\u010d\11\4\27\0\2\4\3\0\11\4"+
    "\1\0\1\4\1\0\1\4\3\0\3\4\1\u010e\24\4"+
    "\27\0\2\4\3\0\11\4\1\0\1\4\1\0\1\4"+
    "\3\0\5\4\1\u010f\22\4\27\0\2\4\3\0\11\4"+
    "\1\0\1\4\1\0\1\4\3\0\10\4\1\u0110\17\4"+
    "\27\0\2\4\3\0\11\4\1\0\1\4\1\0\1\4"+
    "\3\0\4\4\1\u0111\23\4\27\0\2\4\3\0\11\4"+
    "\1\0\1\4\1\0\1\4\3\0\10\4\1\u0112\17\4"+
    "\27\0\2\4\3\0\11\4\1\0\1\4\1\0\1\4"+
    "\3\0\21\4\1\u0113\6\4\27\0\2\4\3\0\11\4"+
    "\1\0\1\4\1\0\1\4\3\0\1\u0114\27\4\27\0"+
    "\2\4\3\0\11\4\1\0\1\4\1\0\1\4\3\0"+
    "\6\4\1\u0115\21\4\27\0\2\4\3\0\11\4\1\0"+
    "\1\4\1\0\1\4\3\0\3\4\1\u0116\24\4\27\0"+
    "\2\4\3\0\11\4\1\0\1\4\1\0\1\4\3\0"+
    "\12\4\1\u0117\15\4\27\0\2\4\3\0\11\4\1\0"+
    "\1\4\1\0\1\4\3\0\1\u0118\27\4\27\0\2\4"+
    "\3\0\11\4\1\0\1\4\1\0\1\4\3\0\12\4"+
    "\1\u0119\15\4\27\0\2\4\3\0\11\4\1\0\1\4"+
    "\1\0\1\4\3\0\23\4\1\u011a\4\4\27\0\2\4"+
    "\3\0\11\4\1\0\1\4\1\0\1\4\3\0\17\4"+
    "\1\u011b\10\4\27\0\2\4\3\0\11\4\1\0\1\4"+
    "\1\0\1\4\3\0\3\4\1\u011c\24\4\27\0\2\4"+
    "\3\0\11\4\1\0\1\4\1\0\1\4\3\0\7\4"+
    "\1\u011d\20\4\27\0\2\4\3\0\11\4\1\0\1\4"+
    "\1\0\1\4\3\0\15\4\1\u011e\12\4\27\0\2\4"+
    "\3\0\11\4\1\0\1\4\1\0\1\4\3\0\12\4"+
    "\1\u011f\15\4\27\0\2\4\3\0\11\4\1\0\1\4"+
    "\1\0\1\4\3\0\4\4\1\u0120\23\4\27\0\2\4"+
    "\3\0\11\4\1\0\1\4\1\0\1\4\3\0\13\4"+
    "\1\u0121\14\4\27\0\2\4\3\0\11\4\1\0\1\4"+
    "\1\0\1\4\3\0\10\4\1\u0122\17\4\27\0\2\4"+
    "\3\0\11\4\1\0\1\4\1\0\1\4\3\0\2\4"+
    "\1\u0123\25\4\27\0\2\4\3\0\11\4\1\0\1\4"+
    "\1\0\1\4\3\0\5\4\1\u0124\22\4\27\0\2\4"+
    "\3\0\11\4\1\0\1\4\1\0\1\4\3\0\12\4"+
    "\1\u0125\15\4\27\0\2\4\3\0\11\4\1\0\1\4"+
    "\1\0\1\4\3\0\3\4\1\u0126\24\4\27\0\2\4"+
    "\3\0\11\4\1\0\1\4\1\0\1\4\3\0\1\u0127"+
    "\27\4\27\0\2\4\3\0\11\4\1\0\1\4\1\0"+
    "\1\4\3\0\1\u0128\27\4\27\0\2\4\3\0\11\4"+
    "\1\0\1\4\1\0\1\4\3\0\3\4\1\u0129\24\4"+
    "\27\0\2\4\3\0\11\4\1\0\1\4\1\0\1\4"+
    "\3\0\3\4\1\u012a\24\4\27\0\2\4\3\0\11\4"+
    "\1\0\1\4\1\0\1\4\3\0\6\4\1\u012b\21\4"+
    "\27\0\2\4\3\0\11\4\1\0\1\4\1\0\1\4"+
    "\3\0\10\4\1\u012c\17\4\27\0\2\4\3\0\11\4"+
    "\1\0\1\4\1\0\1\4\3\0\1\u012d\27\4\27\0"+
    "\2\4\3\0\11\4\1\0\1\4\1\0\1\4\3\0"+
    "\24\4\1\u012e\3\4\27\0\2\4\3\0\11\4\1\0"+
    "\1\4\1\0\1\4\3\0\10\4\1\u012f\17\4\27\0"+
    "\2\4\3\0\11\4\1\0\1\4\1\0\1\4\3\0"+
    "\3\4\1\u0130\24\4\27\0\2\4\3\0\11\4\1\0"+
    "\1\4\1\0\1\4\3\0\12\4\1\u0131\15\4\27\0"+
    "\2\4\3\0\11\4\1\0\1\4\1\0\1\4\3\0"+
    "\3\4\1\u0132\24\4\27\0\2\4\3\0\11\4\1\0"+
    "\1\4\1\0\1\4\3\0\10\4\1\u0133\17\4\27\0"+
    "\2\4\3\0\11\4\1\0\1\4\1\0\1\4\3\0"+
    "\3\4\1\u0134\24\4\27\0\2\4\3\0\11\4\1\0"+
    "\1\4\1\0\1\4\3\0\3\4\1\u0135\24\4\27\0"+
    "\2\4\3\0\11\4\1\0\1\4\1\0\1\4\3\0"+
    "\1\u0136\27\4\27\0\2\4\3\0\11\4\1\0\1\4"+
    "\1\0\1\4\3\0\17\4\1\u0137\10\4\27\0\2\4"+
    "\3\0\11\4\1\0\1\4\1\0\1\4\3\0\3\4"+
    "\1\u0138\24\4\27\0\2\4\3\0\11\4\1\0\1\4"+
    "\1\0\1\4\3\0\13\4\1\u0139\14\4\27\0\2\4"+
    "\3\0\11\4\1\0\1\4\1\0\1\4\3\0\1\u013a"+
    "\27\4\27\0\2\4\3\0\11\4\1\0\1\4\1\0"+
    "\1\4\3\0\20\4\1\u013b\7\4\27\0\2\4\3\0"+
    "\11\4\1\0\1\4\1\0\1\4\3\0\27\4\1\u013c"+
    "\27\0\2\4\3\0\11\4\1\0\1\4\1\0\1\4"+
    "\3\0\4\4\1\u013d\23\4\27\0\2\4\3\0\11\4"+
    "\1\0\1\4\1\0\1\4\3\0\7\4\1\u013e\20\4"+
    "\27\0\2\4\3\0\11\4\1\0\1\4\1\0\1\4"+
    "\3\0\3\4\1\u013f\24\4\27\0\2\4\3\0\11\4"+
    "\1\0\1\4\1\0\1\4\3\0\20\4\1\u0140\7\4"+
    "\25\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[15844];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;
  private static final char[] EMPTY_BUFFER = new char[0];
  private static final int YYEOF = -1;
  private static java.io.Reader zzReader = null; // Fake

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\0\1\11\37\1\1\11\3\1\12\11\1\1\1\11"+
    "\2\1\5\11\4\1\1\0\3\11\1\1\1\11\1\1"+
    "\1\11\47\1\7\11\1\1\5\11\4\1\1\0\1\11"+
    "\56\1\1\11\1\0\1\1\1\11\1\0\55\1\1\11"+
    "\1\0\140\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[320];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private CharSequence zzBuffer = "";

  /** this buffer may contains the current text array to be matched when it is cheap to acquire it */
  private char[] zzBufferArray;

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the textposition at the last state to be included in yytext */
  private int zzPushbackPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /**
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
  private boolean myAssertKeyword;
  private boolean myEnumKeyword;

  public _JavaLexer(LanguageLevel level) {
    this((java.io.Reader)null);
    myAssertKeyword = level.isAtLeast(LanguageLevel.JDK_1_4);
    myEnumKeyword = level.isAtLeast(LanguageLevel.JDK_1_5);
  }

  public void goTo(int offset) {
    zzCurrentPos = zzMarkedPos = zzStartRead = offset;
    zzPushbackPos = 0;
    zzAtEOF = offset < zzEndRead;
  }


  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  _JavaLexer(java.io.Reader in) {
    this.zzReader = in;
  }


  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 2276) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }

  public final int getTokenStart(){
    return zzStartRead;
  }

  public final int getTokenEnd(){
    return getTokenStart() + yylength();
  }

  public void reset(CharSequence buffer, int start, int end,int initialState){
    zzBuffer = buffer;
    zzBufferArray = com.intellij.util.text.CharArrayUtil.fromSequenceWithoutCopying(buffer);
    zzCurrentPos = zzMarkedPos = zzStartRead = start;
    zzPushbackPos = 0;
    zzAtEOF  = false;
    zzAtBOL = true;
    zzEndRead = end;
    yybegin(initialState);
  }

  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   *
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {
    return true;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final CharSequence yytext() {
    return zzBuffer.subSequence(zzStartRead, zzMarkedPos);
  }


  /**
   * Returns the character at position <tt>pos</tt> from the
   * matched text.
   *
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch.
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBufferArray != null ? zzBufferArray[zzStartRead+pos]:zzBuffer.charAt(zzStartRead+pos);
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of
   * yypushback(int) and a match-all fallback rule) this method
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() {
    if (!zzEOFDone) {
      zzEOFDone = true;
      return;

    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public IElementType advance() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    CharSequence zzBufferL = zzBuffer;
    char[] zzBufferArrayL = zzBufferArray;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = ZZ_LEXSTATE[zzLexicalState];


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL)
            zzInput = (zzBufferArrayL != null ? zzBufferArrayL[zzCurrentPosL++] : zzBufferL.charAt(zzCurrentPosL++));
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = (zzBufferArrayL != null ? zzBufferArrayL[zzCurrentPosL++] : zzBufferL.charAt(zzCurrentPosL++));
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 68: 
          { return JavaTokenType.LONG_KEYWORD;
          }
        case 111: break;
        case 99: 
          { return JavaTokenType.PRIVATE_KEYWORD;
          }
        case 112: break;
        case 27: 
          { return JavaTokenType.COMMA;
          }
        case 113: break;
        case 23: 
          { return JavaTokenType.RBRACE;
          }
        case 114: break;
        case 22: 
          { return JavaTokenType.LBRACE;
          }
        case 115: break;
        case 65: 
          { return JavaTokenType.THIS_KEYWORD;
          }
        case 116: break;
        case 83: 
          { return JavaTokenType.CLASS_KEYWORD;
          }
        case 117: break;
        case 14: 
          { return JavaTokenType.PLUS;
          }
        case 118: break;
        case 54: 
          { return JavaTokenType.XOREQ;
          }
        case 119: break;
        case 62: 
          { return JavaTokenType.INT_KEYWORD;
          }
        case 120: break;
        case 80: 
          { return JavaTokenType.SHORT_KEYWORD;
          }
        case 121: break;
        case 44: 
          { return JavaTokenType.EQEQ;
          }
        case 122: break;
        case 67: 
          { return myEnumKeyword ? JavaTokenType.ENUM_KEYWORD : JavaTokenType.IDENTIFIER;
          }
        case 123: break;
        case 101: 
          { return JavaTokenType.ABSTRACT_KEYWORD;
          }
        case 124: break;
        case 69: 
          { return JavaTokenType.NULL_KEYWORD;
          }
        case 125: break;
        case 95: 
          { return JavaTokenType.EXTENDS_KEYWORD;
          }
        case 126: break;
        case 51: 
          { return JavaTokenType.LTLT;
          }
        case 127: break;
        case 20: 
          { return JavaTokenType.LPARENTH;
          }
        case 128: break;
        case 12: 
          { return JavaTokenType.EXCL;
          }
        case 129: break;
        case 102: 
          { return JavaTokenType.STRICTFP_KEYWORD;
          }
        case 130: break;
        case 34: 
          { return JavaTokenType.DIVEQ;
          }
        case 131: break;
        case 89: 
          { return JavaTokenType.STATIC_KEYWORD;
          }
        case 132: break;
        case 39: 
          { return JavaTokenType.MINUSMINUS;
          }
        case 133: break;
        case 76: 
          { return JavaTokenType.FALSE_KEYWORD;
          }
        case 134: break;
        case 1: 
          { return JavaTokenType.BAD_CHARACTER;
          }
        case 135: break;
        case 90: 
          { return JavaTokenType.SWITCH_KEYWORD;
          }
        case 136: break;
        case 26: 
          { return JavaTokenType.SEMICOLON;
          }
        case 137: break;
        case 18: 
          { return JavaTokenType.XOR;
          }
        case 138: break;
        case 38: 
          { return JavaTokenType.DOUBLE_LITERAL;
          }
        case 139: break;
        case 46: 
          { return JavaTokenType.OREQ;
          }
        case 140: break;
        case 11: 
          { return JavaTokenType.EQ;
          }
        case 141: break;
        case 4: 
          { return JavaTokenType.DIV;
          }
        case 142: break;
        case 66: 
          { return JavaTokenType.ELSE_KEYWORD;
          }
        case 143: break;
        case 61: 
          { return JavaTokenType.NEW_KEYWORD;
          }
        case 144: break;
        case 58: 
          { return JavaTokenType.ELLIPSIS;
          }
        case 145: break;
        case 53: 
          { return JavaTokenType.ANDAND;
          }
        case 146: break;
        case 81: 
          { return JavaTokenType.BREAK_KEYWORD;
          }
        case 147: break;
        case 9: 
          { return JavaTokenType.CHARACTER_LITERAL;
          }
        case 148: break;
        case 52: 
          { return JavaTokenType.ANDEQ;
          }
        case 149: break;
        case 6: 
          { return JavaTokenType.INTEGER_LITERAL;
          }
        case 150: break;
        case 77: 
          { return JavaTokenType.FLOAT_KEYWORD;
          }
        case 151: break;
        case 10: 
          { return JavaTokenType.STRING_LITERAL;
          }
        case 152: break;
        case 72: 
          { return JavaTokenType.CHAR_KEYWORD;
          }
        case 153: break;
        case 91: 
          { return JavaTokenType.NATIVE_KEYWORD;
          }
        case 154: break;
        case 43: 
          { return JavaTokenType.DO_KEYWORD;
          }
        case 155: break;
        case 7: 
          { return JavaTokenType.DOT;
          }
        case 156: break;
        case 28: 
          { return JavaTokenType.TILDE;
          }
        case 157: break;
        case 110: 
          { return JavaTokenType.SYNCHRONIZED_KEYWORD;
          }
        case 158: break;
        case 32: 
          { return JavaTokenType.END_OF_LINE_COMMENT;
          }
        case 159: break;
        case 35: 
          { return JavaTokenType.ASTERISKEQ;
          }
        case 160: break;
        case 79: 
          { return JavaTokenType.SUPER_KEYWORD;
          }
        case 161: break;
        case 40: 
          { return JavaTokenType.MINUSEQ;
          }
        case 162: break;
        case 63: 
          { return JavaTokenType.LTLTEQ;
          }
        case 163: break;
        case 73: 
          { return JavaTokenType.GOTO_KEYWORD;
          }
        case 164: break;
        case 25: 
          { return JavaTokenType.RBRACKET;
          }
        case 165: break;
        case 33: 
          { return JavaTokenType.C_STYLE_COMMENT;
          }
        case 166: break;
        case 15: 
          { return JavaTokenType.LT;
          }
        case 167: break;
        case 42: 
          { return JavaTokenType.IF_KEYWORD;
          }
        case 168: break;
        case 8: 
          { return JavaTokenType.MINUS;
          }
        case 169: break;
        case 85: 
          { return JavaTokenType.WHILE_KEYWORD;
          }
        case 170: break;
        case 70: 
          { return JavaTokenType.BYTE_KEYWORD;
          }
        case 171: break;
        case 96: 
          { return JavaTokenType.FINALLY_KEYWORD;
          }
        case 172: break;
        case 74: 
          { return JavaTokenType.VOID_KEYWORD;
          }
        case 173: break;
        case 29: 
          { return JavaTokenType.QUEST;
          }
        case 174: break;
        case 19: 
          { return JavaTokenType.PERC;
          }
        case 175: break;
        case 109: 
          { return JavaTokenType.IMPLEMENTS_KEYWORD;
          }
        case 176: break;
        case 86: 
          { return JavaTokenType.THROWS_KEYWORD;
          }
        case 177: break;
        case 41: 
          { return JavaTokenType.ARROW;
          }
        case 178: break;
        case 78: 
          { return JavaTokenType.FINAL_KEYWORD;
          }
        case 179: break;
        case 93: 
          { return JavaTokenType.DOUBLE_KEYWORD;
          }
        case 180: break;
        case 88: 
          { return myAssertKeyword ? JavaTokenType.ASSERT_KEYWORD : JavaTokenType.IDENTIFIER;
          }
        case 181: break;
        case 107: 
          { return JavaTokenType.PROTECTED_KEYWORD;
          }
        case 182: break;
        case 103: 
          { return JavaTokenType.CONTINUE_KEYWORD;
          }
        case 183: break;
        case 100: 
          { return JavaTokenType.PACKAGE_KEYWORD;
          }
        case 184: break;
        case 16: 
          { return JavaTokenType.GT;
          }
        case 185: break;
        case 24: 
          { return JavaTokenType.LBRACKET;
          }
        case 186: break;
        case 36: 
          { return JavaTokenType.LONG_LITERAL;
          }
        case 187: break;
        case 60: 
          { return JavaTokenType.FOR_KEYWORD;
          }
        case 188: break;
        case 98: 
          { return JavaTokenType.DEFAULT_KEYWORD;
          }
        case 189: break;
        case 48: 
          { return JavaTokenType.PLUSEQ;
          }
        case 190: break;
        case 87: 
          { return JavaTokenType.RETURN_KEYWORD;
          }
        case 191: break;
        case 64: 
          { return JavaTokenType.TRUE_KEYWORD;
          }
        case 192: break;
        case 49: 
          { return JavaTokenType.PLUSPLUS;
          }
        case 193: break;
        case 47: 
          { return JavaTokenType.OROR;
          }
        case 194: break;
        case 13: 
          { return JavaTokenType.OR;
          }
        case 195: break;
        case 3: 
          { return JavaTokenType.IDENTIFIER;
          }
        case 196: break;
        case 55: 
          { return JavaTokenType.PERCEQ;
          }
        case 197: break;
        case 30: 
          { return JavaTokenType.COLON;
          }
        case 198: break;
        case 104: 
          { return JavaTokenType.VOLATILE_KEYWORD;
          }
        case 199: break;
        case 106: 
          { return JavaTokenType.INTERFACE_KEYWORD;
          }
        case 200: break;
        case 108: 
          { return JavaTokenType.INSTANCEOF_KEYWORD;
          }
        case 201: break;
        case 105: 
          { return JavaTokenType.TRANSIENT_KEYWORD;
          }
        case 202: break;
        case 97: 
          { return JavaTokenType.BOOLEAN_KEYWORD;
          }
        case 203: break;
        case 71: 
          { return JavaTokenType.CASE_KEYWORD;
          }
        case 204: break;
        case 5: 
          { return JavaTokenType.ASTERISK;
          }
        case 205: break;
        case 92: 
          { return JavaTokenType.IMPORT_KEYWORD;
          }
        case 206: break;
        case 31: 
          { return JavaTokenType.AT;
          }
        case 207: break;
        case 45: 
          { return JavaTokenType.NE;
          }
        case 208: break;
        case 59: 
          { return JavaTokenType.TRY_KEYWORD;
          }
        case 209: break;
        case 82: 
          { return JavaTokenType.CATCH_KEYWORD;
          }
        case 210: break;
        case 37: 
          { return JavaTokenType.FLOAT_LITERAL;
          }
        case 211: break;
        case 17: 
          { return JavaTokenType.AND;
          }
        case 212: break;
        case 75: 
          { return JavaTokenType.THROW_KEYWORD;
          }
        case 213: break;
        case 57: 
          { return JavaDocElementType.DOC_COMMENT;
          }
        case 214: break;
        case 56: 
          { return JavaTokenType.DOUBLE_COLON;
          }
        case 215: break;
        case 21: 
          { return JavaTokenType.RPARENTH;
          }
        case 216: break;
        case 2: 
          { return JavaTokenType.WHITE_SPACE;
          }
        case 217: break;
        case 94: 
          { return JavaTokenType.PUBLIC_KEYWORD;
          }
        case 218: break;
        case 50: 
          { return JavaTokenType.LE;
          }
        case 219: break;
        case 84: 
          { return JavaTokenType.CONST_KEYWORD;
          }
        case 220: break;
        default:
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            zzDoEOF();
            return null;
          }
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
