/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.THash;
import gnu.trove.THashMap;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectHash;
import java.util.Arrays;
import java.util.HashSet;

public class MapTest {
    public static void main(String[] args) {
        MapTest.testTIntObjectHashMap();
        MapTest.testTHashMap();
        MapTest.testClone();
    }

    private static void testTIntObjectHashMap() {
        TIntObjectHashMap<String> map = new TIntObjectHashMap<String>();
        MapTest.assertTrue(map._deadkeys == 0);
        MapTest.assertTrue(map._hashingStrategy == map);
        MapTest.assertTrue(map.capacity() == 7);
        MapTest.assertTrue(map._free == map.capacity());
        MapTest.assertTrue(map._size == 0);
        MapTest.assertTrue(map._loadFactor == 0.8f);
        MapTest.assertTrue(map._maxSize == (int)((float)map.capacity() * map._loadFactor));
        int key = 1;
        MapTest.assertTrue(map._hashingStrategy.computeHashCode(key) == 1);
        String value = "1";
        String prev = map.put(key, value);
        MapTest.assertTrue(prev == null);
        MapTest.assertTrue(map._deadkeys == 0);
        MapTest.assertTrue(map._hashingStrategy == map);
        MapTest.assertTrue(map.capacity() == 7);
        MapTest.assertTrue(map._free == map.capacity() - 1);
        MapTest.assertTrue(map._size == 1);
        MapTest.assertTrue(map._loadFactor == 0.8f);
        MapTest.assertTrue(map._maxSize == (int)((float)map.capacity() * map._loadFactor));
        int index = map.index(key);
        MapTest.assertTrue(index == 1);
        MapTest.assertTrue(map.size() == 1);
        MapTest.assertTrue(map._values[index] == value);
        String remove = (String)map.remove(key);
        MapTest.assertTrue(remove == value);
        MapTest.assertTrue(map.size() == 0);
        MapTest.assertTrue(map.capacity() == 7);
        MapTest.assertTrue(map._values[index] == TObjectHash.REMOVED);
        MapTest.assertTrue(map._deadkeys == 1);
        MapTest.assertTrue(map._hashingStrategy == map);
        MapTest.assertTrue(map.capacity() == 7);
        MapTest.assertTrue(map._free == map.capacity() - 1);
        MapTest.assertTrue(map._size == 0);
        MapTest.assertTrue(map._loadFactor == 0.8f);
        MapTest.assertTrue(map._maxSize == (int)((float)map.capacity() * map._loadFactor));
        prev = map.put(key, value);
        MapTest.assertTrue(prev == null);
        index = map.index(key);
        MapTest.assertTrue(index == 1);
        MapTest.assertTrue(map.size() == 1);
        MapTest.assertTrue(map._values[index] == value);
        MapTest.assertTrue(map._deadkeys == 0);
        MapTest.assertTrue(map._hashingStrategy == map);
        MapTest.assertTrue(map.capacity() == 7);
        MapTest.assertTrue(map._free == map.capacity() - 1);
        MapTest.assertTrue(map._size == 1);
        MapTest.assertTrue(map._loadFactor == 0.8f);
        MapTest.assertTrue(map._maxSize == (int)((float)map.capacity() * map._loadFactor));
        int key2 = 8;
        MapTest.assertTrue(map._hashingStrategy.computeHashCode(key2) == 8);
        prev = map.put(key2, value);
        MapTest.assertTrue(prev == null);
        index = map.index(key2);
        MapTest.assertTrue(index == 4);
        MapTest.assertTrue(map.size() == 2);
        MapTest.assertTrue(map._values[index] == value);
        MapTest.assertTrue(map._deadkeys == 0);
        MapTest.assertTrue(map._hashingStrategy == map);
        MapTest.assertTrue(map.capacity() == 7);
        MapTest.assertTrue(map._free == map.capacity() - 2);
        MapTest.assertTrue(map._size == 2);
        MapTest.assertTrue(map._loadFactor == 0.8f);
        MapTest.assertTrue(map._maxSize == (int)((float)map.capacity() * map._loadFactor));
        index = map.index(key);
        remove = (String)map.remove(key);
        MapTest.assertTrue(remove == value);
        MapTest.assertTrue(map.size() == 1);
        MapTest.assertTrue(map._values[index] == TObjectHash.REMOVED);
        MapTest.assertTrue(map._deadkeys == 1);
        MapTest.assertTrue(map._hashingStrategy == map);
        MapTest.assertTrue(map.capacity() == 7);
        MapTest.assertTrue(map._free == map.capacity() - 2);
        MapTest.assertTrue(map._size == 1);
        MapTest.assertTrue(map._loadFactor == 0.8f);
        MapTest.assertTrue(map._maxSize == (int)((float)map.capacity() * map._loadFactor));
        String v = (String)map.get(key2);
        MapTest.assertTrue(v == value);
        index = map.index(key2);
        MapTest.assertTrue(index == 4);
        remove = (String)map.remove(key2);
        MapTest.assertTrue(remove == value);
        MapTest.assertTrue(map.size() == 0);
        MapTest.assertTrue(map.capacity() == 7);
        MapTest.assertTrue(map._values[index] == TObjectHash.REMOVED);
        MapTest.assertTrue(map._deadkeys == 2);
        MapTest.assertTrue(map._hashingStrategy == map);
        MapTest.assertTrue(map.capacity() == 7);
        MapTest.assertTrue(map._free == map.capacity() - 2);
        MapTest.assertTrue(map._size == 0);
        MapTest.assertTrue(map._loadFactor == 0.8f);
        MapTest.assertTrue(map._maxSize == (int)((float)map.capacity() * map._loadFactor));
        map.clear();
        MapTest.assertTrue(map._deadkeys == 0);
        MapTest.assertTrue(map._hashingStrategy == map);
        MapTest.assertTrue(map.capacity() == 7);
        MapTest.assertTrue(map._free == map.capacity());
        MapTest.assertTrue(map._size == 0);
        MapTest.assertTrue(map._loadFactor == 0.8f);
        MapTest.assertTrue(map._maxSize == (int)((float)map.capacity() * map._loadFactor));
        map.put(1, value);
        map.put(2, value);
        map.put(3, value);
        map.put(4, value);
        map.put(5, value);
        MapTest.assertTrue(map._deadkeys == 0);
        MapTest.assertTrue(map._hashingStrategy == map);
        MapTest.assertTrue(map.capacity() == 7);
        MapTest.assertTrue(map._free == map.capacity() - 5);
        MapTest.assertTrue(map._size == 5);
        MapTest.assertTrue(map._loadFactor == 0.8f);
        MapTest.assertTrue(map._maxSize == (int)((float)map.capacity() * map._loadFactor));
        map.put(5, value);
        MapTest.assertTrue(map._deadkeys == 0);
        MapTest.assertTrue(map._hashingStrategy == map);
        MapTest.assertTrue(map.capacity() == 7);
        MapTest.assertTrue(map._free == map.capacity() - 5);
        MapTest.assertTrue(map._size == 5);
        MapTest.assertTrue(map._loadFactor == 0.8f);
        MapTest.assertTrue(map._maxSize == (int)((float)map.capacity() * map._loadFactor));
        map.put(6, value);
        MapTest.assertTrue(map._deadkeys == 0);
        MapTest.assertTrue(map._hashingStrategy == map);
        MapTest.assertTrue(map.capacity() == 17);
        MapTest.assertTrue(map._free == map.capacity() - 6);
        MapTest.assertTrue(map._size == 6);
        MapTest.assertTrue(map._loadFactor == 0.8f);
        MapTest.assertTrue(map._maxSize == (int)((float)map.capacity() * map._loadFactor));
    }

    private static void testTHashMap() {
        THashMap<Integer, String> map = new THashMap<Integer, String>();
        MapTest.assertTrue(map._deadkeys == 0);
        MapTest.assertTrue(map._hashingStrategy == map);
        MapTest.assertTrue(map.capacity() == 7);
        MapTest.assertTrue(map._free == map.capacity());
        MapTest.assertTrue(map._size == 0);
        MapTest.assertTrue(map._loadFactor == 0.8f);
        MapTest.assertTrue(map._maxSize == (int)((float)map.capacity() * map._loadFactor));
        int key = 1;
        MapTest.assertTrue(map._hashingStrategy.computeHashCode(key) == 1);
        String value = "1";
        String prev = map.put(key, value);
        MapTest.assertTrue(prev == null);
        MapTest.assertTrue(map._deadkeys == 0);
        MapTest.assertTrue(map._hashingStrategy == map);
        MapTest.assertTrue(map.capacity() == 7);
        MapTest.assertTrue(map._free == map.capacity() - 1);
        MapTest.assertTrue(map._size == 1);
        MapTest.assertTrue(map._loadFactor == 0.8f);
        MapTest.assertTrue(map._maxSize == (int)((float)map.capacity() * map._loadFactor));
        int index = map.index(key);
        MapTest.assertTrue(index == 1);
        MapTest.assertTrue(map.size() == 1);
        MapTest.assertTrue(map._values[index] == value);
        String remove = (String)map.remove(key);
        MapTest.assertTrue(remove == value);
        MapTest.assertTrue(map.size() == 0);
        MapTest.assertTrue(map.capacity() == 7);
        MapTest.assertTrue(map._set[index] == TObjectHash.REMOVED);
        MapTest.assertTrue(map._deadkeys == 1);
        MapTest.assertTrue(map._hashingStrategy == map);
        MapTest.assertTrue(map.capacity() == 7);
        MapTest.assertTrue(map._free == map.capacity() - 1);
        MapTest.assertTrue(map._size == 0);
        MapTest.assertTrue(map._loadFactor == 0.8f);
        MapTest.assertTrue(map._maxSize == (int)((float)map.capacity() * map._loadFactor));
        prev = map.put(key, value);
        MapTest.assertTrue(prev == null);
        index = map.index(key);
        MapTest.assertTrue(index == 1);
        MapTest.assertTrue(map.size() == 1);
        MapTest.assertTrue(map._values[index] == value);
        MapTest.assertTrue(map._deadkeys == 0);
        MapTest.assertTrue(map._hashingStrategy == map);
        MapTest.assertTrue(map.capacity() == 7);
        MapTest.assertTrue(map._free == map.capacity() - 1);
        MapTest.assertTrue(map._size == 1);
        MapTest.assertTrue(map._loadFactor == 0.8f);
        MapTest.assertTrue(map._maxSize == (int)((float)map.capacity() * map._loadFactor));
        int key2 = 8;
        MapTest.assertTrue(map._hashingStrategy.computeHashCode(key2) == 8);
        prev = map.put(key2, value);
        MapTest.assertTrue(prev == null);
        index = map.index(key2);
        MapTest.assertTrue(index == 4);
        MapTest.assertTrue(map.size() == 2);
        MapTest.assertTrue(map._values[index] == value);
        MapTest.assertTrue(map._deadkeys == 0);
        MapTest.assertTrue(map._hashingStrategy == map);
        MapTest.assertTrue(map.capacity() == 7);
        MapTest.assertTrue(map._free == map.capacity() - 2);
        MapTest.assertTrue(map._size == 2);
        MapTest.assertTrue(map._loadFactor == 0.8f);
        MapTest.assertTrue(map._maxSize == (int)((float)map.capacity() * map._loadFactor));
        index = map.index(key);
        remove = (String)map.remove(key);
        MapTest.assertTrue(remove == value);
        MapTest.assertTrue(map.size() == 1);
        MapTest.assertTrue(map._set[index] == TObjectHash.REMOVED);
        MapTest.assertTrue(map._deadkeys == 1);
        MapTest.assertTrue(map._hashingStrategy == map);
        MapTest.assertTrue(map.capacity() == 7);
        MapTest.assertTrue(map._free == map.capacity() - 2);
        MapTest.assertTrue(map._size == 1);
        MapTest.assertTrue(map._loadFactor == 0.8f);
        MapTest.assertTrue(map._maxSize == (int)((float)map.capacity() * map._loadFactor));
        String v = (String)map.get(key2);
        MapTest.assertTrue(v == value);
        index = map.index(key2);
        MapTest.assertTrue(index == 4);
        remove = (String)map.remove(key2);
        MapTest.assertTrue(remove == value);
        MapTest.assertTrue(map.size() == 0);
        MapTest.assertTrue(map.capacity() == 7);
        MapTest.assertTrue(map._set[index] == TObjectHash.REMOVED);
        MapTest.assertTrue(map._deadkeys == 2);
        MapTest.assertTrue(map._hashingStrategy == map);
        MapTest.assertTrue(map.capacity() == 7);
        MapTest.assertTrue(map._free == map.capacity() - 2);
        MapTest.assertTrue(map._size == 0);
        MapTest.assertTrue(map._loadFactor == 0.8f);
        MapTest.assertTrue(map._maxSize == (int)((float)map.capacity() * map._loadFactor));
        map.clear();
        MapTest.assertTrue(map._deadkeys == 2);
        MapTest.assertTrue(map._hashingStrategy == map);
        MapTest.assertTrue(map.capacity() == 7);
        MapTest.assertTrue(map._free == map.capacity() - 2);
        MapTest.assertTrue(map._size == 0);
        MapTest.assertTrue(map._loadFactor == 0.8f);
        MapTest.assertTrue(map._maxSize == (int)((float)map.capacity() * map._loadFactor));
        map.put(1, value);
        map.put(2, value);
        map.put(3, value);
        map.put(4, value);
        map.put(5, value);
        MapTest.assertTrue(map._deadkeys == 0);
        MapTest.assertTrue(map._hashingStrategy == map);
        MapTest.assertTrue(map.capacity() == 7);
        MapTest.assertTrue(map._free == map.capacity() - 5);
        MapTest.assertTrue(map._size == 5);
        MapTest.assertTrue(map._loadFactor == 0.8f);
        MapTest.assertTrue(map._maxSize == (int)((float)map.capacity() * map._loadFactor));
        map.put(5, "xxx");
        MapTest.assertTrue(map._deadkeys == 0);
        MapTest.assertTrue(map._hashingStrategy == map);
        MapTest.assertTrue(map.capacity() == 7);
        MapTest.assertTrue(map._free == map.capacity() - 5);
        MapTest.assertTrue(map._size == 5);
        MapTest.assertTrue(map._loadFactor == 0.8f);
        MapTest.assertTrue(map._maxSize == (int)((float)map.capacity() * map._loadFactor));
        map.put(6, value);
        MapTest.assertTrue(map._deadkeys == 0);
        MapTest.assertTrue(map._hashingStrategy == map);
        MapTest.assertTrue(map.capacity() == 17);
        MapTest.assertTrue(map._free == map.capacity() - 6);
        MapTest.assertTrue(map._size == 6);
        MapTest.assertTrue(map._loadFactor == 0.8f);
        MapTest.assertTrue(map._maxSize == (int)((float)map.capacity() * map._loadFactor));
    }

    public static void testClone() {
        TIntObjectHashMap<int[]> map = new TIntObjectHashMap<int[]>();
        map.put(0, new int[2]);
        map.put(1, new int[2]);
        Object clone = map.clone();
        MapTest.assertEquals(((THash)clone).size(), 2);
        int[] keys = ((TIntObjectHashMap)clone).keys();
        MapTest.assertEquals(keys.length, 2);
        HashSet<Integer> set01 = new HashSet<Integer>(Arrays.asList(0, 1));
        HashSet<Integer> keySet = new HashSet<Integer>(Arrays.asList(keys[0], keys[1]));
        MapTest.assertEquals(set01, keySet);
        map.clear();
        MapTest.assertEquals(((THash)clone).size(), 2);
        keys = ((TIntObjectHashMap)clone).keys();
        MapTest.assertEquals(keys.length, 2);
        keySet = new HashSet<Integer>(Arrays.asList(keys[0], keys[1]));
        MapTest.assertEquals(set01, keySet);
    }

    private static void assertEquals(int a, int b) {
        MapTest.assertTrue(a == b);
    }

    private static void assertEquals(Object a, Object b) {
        MapTest.assertTrue(a.equals(b));
    }

    private static void assertTrue(boolean b) {
        if (!b) {
            throw new AssertionError();
        }
    }
}

