/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.generate;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.regex.Pattern;

public class Generate {
    private static final String[] WRAPPERS = new String[]{"double", "Double", "float", "Float", "int", "Integer", "long", "Long", "byte", "Byte"};

    public static void main(String[] args) throws IOException {
        Generate.generate("TPObjectHashMap.template", "src/gnu/trove/T", "ObjectHashMap.java");
        Generate.generate("TObjectPHashMap.template", "src/gnu/trove/TObject", "HashMap.java");
        Generate.generate("TArrayList.template", "src/gnu/trove/T", "ArrayList.java");
        Generate.generate("THashingStrategy.template", "src/gnu/trove/T", "HashingStrategy.java");
        Generate.generate("TPHash.template", "src/gnu/trove/T", "Hash.java");
        Generate.generate("TPHashSet.template", "src/gnu/trove/T", "HashSet.java");
        Generate.generate("TPIterator.template", "src/gnu/trove/T", "Iterator.java");
        Generate.generate("TPFunction.template", "src/gnu/trove/T", "Function.java");
        Generate.generate("TPProcedure.template", "src/gnu/trove/T", "Procedure.java");
        Generate.generate("TObjectPIterator.template", "src/gnu/trove/TObject", "Iterator.java");
        Generate.generate("TPObjectIterator.template", "src/gnu/trove/T", "ObjectIterator.java");
        Generate.generate("TPObjectProcedure.template", "src/gnu/trove/T", "ObjectProcedure.java");
        Generate.generate("TObjectPProcedure.template", "src/gnu/trove/TObject", "Procedure.java");
        Generate.generateKV("TKVIterator.template", "src/gnu/trove/T", "Iterator.java");
        Generate.generateKV("TKVProcedure.template", "src/gnu/trove/T", "Procedure.java");
        Generate.generateKV("TKVHashMap.template", "src/gnu/trove/T", "HashMap.java");
        Generate.generateKV("TPPMapDecorator.template", "src/gnu/trove/decorator/T", "HashMapDecorator.java");
        Generate.generate("TPObjectMapDecorator.template", "src/gnu/trove/decorator/T", "ObjectHashMapDecorator.java");
        Generate.generate("TObjectPMapDecorator.template", "src/gnu/trove/decorator/TObject", "HashMapDecorator.java");
        Generate.generate("TPHashSetDecorator.template", "src/gnu/trove/decorator/T", "HashSetDecorator.java");
    }

    private static void generate(String templateName, String pathPrefix, String pathSuffix) throws IOException {
        String template = Generate.readFile(templateName);
        for (int i = 0; i < WRAPPERS.length; i += 2) {
            String e = WRAPPERS[i];
            String ET = WRAPPERS[i + 1];
            String E = Generate.shortenInt(ET);
            String out = template;
            out = Pattern.compile("#e#").matcher(out).replaceAll(e);
            out = Pattern.compile("#E#").matcher(out).replaceAll(E);
            out = Pattern.compile("#ET#").matcher(out).replaceAll(ET);
            String outFile = pathPrefix + E + pathSuffix;
            Generate.writeFile(outFile, out);
        }
    }

    private static void generateKV(String templateName, String pathPrefix, String pathSuffix) throws IOException {
        String template = Generate.readFile(templateName);
        for (int i = 0; i < WRAPPERS.length; i += 2) {
            for (int j = 0; j < WRAPPERS.length; j += 2) {
                String k = WRAPPERS[i];
                String KT = WRAPPERS[i + 1];
                String v = WRAPPERS[j];
                String VT = WRAPPERS[j + 1];
                String K = Generate.shortenInt(KT);
                String V = Generate.shortenInt(VT);
                String out = template;
                out = Pattern.compile("#v#").matcher(out).replaceAll(v);
                out = Pattern.compile("#V#").matcher(out).replaceAll(V);
                out = Pattern.compile("#k#").matcher(out).replaceAll(k);
                out = Pattern.compile("#K#").matcher(out).replaceAll(K);
                out = Pattern.compile("#KT#").matcher(out).replaceAll(KT);
                out = Pattern.compile("#VT#").matcher(out).replaceAll(VT);
                String outFile = pathPrefix + K + V + pathSuffix;
                Generate.writeFile(outFile, out);
            }
        }
    }

    private static void writeFile(String file, String out) throws IOException {
        File path = new File("generated/" + file).getAbsoluteFile();
        FileWriter writer = new FileWriter(path);
        writer.write(out);
        writer.close();
        System.out.println("File written: " + path);
    }

    private static String shortenInt(String type) {
        return type.equals("Integer") ? "Int" : type;
    }

    private static String readFile(String name) throws IOException {
        String line;
        String packageName = Generate.class.getPackage().getName();
        URL resource = Generate.class.getClassLoader().getResource(packageName.replace('.', '/') + "/" + name);
        InputStream inputStream = resource.openConnection().getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuffer out = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            out.append(line);
            out.append("\n");
        }
        return out.toString();
    }
}

