/*
 * Decompiled with CFR 0.152.
 */
package com.github.adejanovski.cassandra.jdbc;

import com.github.adejanovski.cassandra.jdbc.CassandraConnection;
import com.github.adejanovski.cassandra.jdbc.SessionHolder;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLNonTransientConnectionException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraDriver
implements Driver {
    public static final int DVR_MAJOR_VERSION = 2;
    public static final int DVR_MINOR_VERSION = 1;
    public static final int DVR_PATCH_VERSION = 6;
    public static final String DVR_NAME = "Datastax JDBC Driver";
    private static final Logger logger = LoggerFactory.getLogger(CassandraDriver.class);
    private final LoadingCache<Map<String, String>, SessionHolder> sessionsCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Map<String, String>, SessionHolder>(){

        public SessionHolder load(Map<String, String> params) throws Exception {
            return new SessionHolder(params, (LoadingCache<Map<String, String>, SessionHolder>)CassandraDriver.this.sessionsCache);
        }
    });

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith("jdbc:cassandra:");
    }

    @Override
    public Connection connect(String url, Properties props) throws SQLException {
        if (this.acceptsURL(url)) {
            ImmutableMap.Builder params = ImmutableMap.builder();
            Enumeration<Object> keys = props.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                params.put((Object)key, (Object)props.getProperty(key));
            }
            params.put((Object)"jdbcUrl", (Object)url);
            ImmutableMap cacheKey = params.build();
            try {
                SessionHolder sessionHolder;
                while (!(sessionHolder = (SessionHolder)this.sessionsCache.get((Object)cacheKey)).acquire()) {
                }
                return new CassandraConnection(sessionHolder);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof SQLException) {
                    throw (SQLException)cause;
                }
                throw new SQLNonTransientConnectionException("Unexpected error while creating connection", e);
            }
        }
        return null;
    }

    @Override
    public int getMajorVersion() {
        return 2;
    }

    @Override
    public int getMinorVersion() {
        return 1;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties props) throws SQLException {
        if (props == null) {
            props = new Properties();
        }
        DriverPropertyInfo[] info = new DriverPropertyInfo[2];
        info[0] = new DriverPropertyInfo("user", props.getProperty("user"));
        info[0].description = "The 'user' property";
        info[1] = new DriverPropertyInfo("password", props.getProperty("password"));
        info[1].description = "The 'password' property";
        return info;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException(String.format("the Cassandra implementation does not support this method", new Object[0]));
    }

    static {
        try {
            CassandraDriver driverInst = new CassandraDriver();
            DriverManager.registerDriver(driverInst);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

