/*
 * Decompiled with CFR 0.152.
 */
package com.github.adejanovski.cassandra.jdbc;

import com.github.adejanovski.cassandra.jdbc.AbstractJdbcType;
import com.github.adejanovski.cassandra.jdbc.MarshalException;
import java.nio.ByteBuffer;

public class JdbcBoolean
extends AbstractJdbcType<Boolean> {
    public static final JdbcBoolean instance = new JdbcBoolean();

    JdbcBoolean() {
    }

    @Override
    public boolean isCaseSensitive() {
        return false;
    }

    @Override
    public int getScale(Boolean obj) {
        return -1;
    }

    @Override
    public int getPrecision(Boolean obj) {
        return -1;
    }

    @Override
    public boolean isCurrency() {
        return false;
    }

    @Override
    public boolean isSigned() {
        return false;
    }

    @Override
    public String toString(Boolean obj) {
        return obj.toString();
    }

    @Override
    public boolean needsQuotes() {
        return false;
    }

    public String getString(ByteBuffer bytes) {
        if (bytes.remaining() == 0) {
            return Boolean.FALSE.toString();
        }
        if (bytes.remaining() != 1) {
            throw new MarshalException("A boolean is stored in exactly 1 byte: " + bytes.remaining());
        }
        byte value = bytes.get(bytes.position());
        return value == 0 ? Boolean.FALSE.toString() : Boolean.TRUE.toString();
    }

    @Override
    public Class<Boolean> getType() {
        return Boolean.class;
    }

    @Override
    public int getJdbcType() {
        return 16;
    }

    @Override
    public Boolean compose(Object value) {
        return (Boolean)value;
    }

    @Override
    public Object decompose(Boolean value) {
        return value == null ? null : value;
    }
}

