/*
 * Decompiled with CFR 0.152.
 */
package com.github.adejanovski.cassandra.jdbc.codec;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import java.nio.ByteBuffer;
import org.apache.cassandra.utils.ByteBufferUtil;

public class LongToIntCodec
extends TypeCodec<Integer> {
    public LongToIntCodec(Class<Integer> javaClass) {
        super(DataType.bigint(), javaClass);
    }

    public ByteBuffer serialize(Integer paramT, ProtocolVersion paramProtocolVersion) throws InvalidTypeException {
        if (paramT == null) {
            return null;
        }
        return ByteBufferUtil.bytes((int)paramT);
    }

    public Integer deserialize(ByteBuffer paramByteBuffer, ProtocolVersion paramProtocolVersion) throws InvalidTypeException {
        if (paramByteBuffer == null) {
            return null;
        }
        Long value = ByteBufferUtil.toLong((ByteBuffer)paramByteBuffer.duplicate());
        return value.intValue();
    }

    public Integer parse(String paramString) throws InvalidTypeException {
        return Integer.valueOf(paramString);
    }

    public String format(Integer paramT) throws InvalidTypeException {
        return String.valueOf(paramT);
    }
}

