/*
 * Decompiled with CFR 0.152.
 */
package com.github.internal;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.IResultMap;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.collections.Sets;
import org.testng.reporters.Files;

public class Utils {
    public static ExecutionResults computeOverResults(List<ISuite> suites) {
        ExecutionResults results = new ExecutionResults();
        for (ISuite s : suites) {
            Map suiteResults = s.getResults();
            for (ISuiteResult sr : suiteResults.values()) {
                ITestContext testContext = sr.getTestContext();
                ExecutionResults executionResults = results;
                executionResults.passed = executionResults.passed + testContext.getPassedTests().size();
                executionResults = results;
                executionResults.failed = executionResults.failed + testContext.getFailedTests().size();
                int retriedPerTest = 0;
                int skippedPerTest = 0;
                for (ITestResult result : testContext.getSkippedTests().getAllResults()) {
                    if (result.getAttribute("retried") != null) {
                        ++retriedPerTest;
                        continue;
                    }
                    ++skippedPerTest;
                }
                Object object = results;
                ((ExecutionResults)object).skipped = ((ExecutionResults)object).skipped + skippedPerTest;
                object = results;
                ((ExecutionResults)object).retried = ((ExecutionResults)object).retried + retriedPerTest;
                object = results;
                ((ExecutionResults)object).ignored = ((ExecutionResults)object).ignored + testContext.getExcludedMethods().size();
            }
        }
        return results;
    }

    public static void writeToFile(String outputDirectory, String fileContent) throws IOException {
        String fileName = "Metrics-" + new SimpleDateFormat("yyyyMMMdd-HHmm'.html'").format(new Date());
        String tempFile = outputDirectory + File.separator + fileName;
        File file = new File(tempFile);
        Files.writeFile((String)fileContent, (File)file);
        System.out.println("TestNG Metrics " + fileName + " is created successfully");
    }

    static Map<String, List<ITestResult>> asMap(Set<ITestResult> testResults) {
        Map map = Maps.newHashMap();
        for (ITestResult result : testResults) {
            String className = result.getTestClass().getName();
            List list = map.computeIfAbsent(className, k -> Lists.newArrayList());
            list.add(result);
        }
        return map;
    }

    static Set<ITestResult> extractResults(ISuiteResult suiteResult) {
        Set testResults = Sets.newHashSet();
        ITestContext testContext = suiteResult.getTestContext();
        testResults.addAll(Utils.addAllTestResults(testContext.getPassedTests()));
        testResults.addAll(Utils.addAllTestResults(testContext.getFailedTests()));
        testResults.addAll(Utils.addAllTestResults(testContext.getSkippedTests()));
        testResults.addAll(Utils.addAllTestResults(testContext.getPassedConfigurations()));
        testResults.addAll(Utils.addAllTestResults(testContext.getSkippedConfigurations()));
        testResults.addAll(Utils.addAllTestResults(testContext.getFailedConfigurations()));
        testResults.addAll(Utils.addAllTestResults(testContext.getFailedButWithinSuccessPercentageTests()));
        return testResults;
    }

    static String getStatusString(ITestResult result) {
        int testResultStatus = result.getStatus();
        switch (testResultStatus) {
            case 1: {
                return "PASS";
            }
            case 2: {
                return "FAIL";
            }
            case 3: {
                return "SKIP";
            }
            case 4: {
                return "SUCCESS_PERCENTAGE_FAILURE";
            }
        }
        throw new AssertionError((Object)("Unexpected value: " + testResultStatus));
    }

    private static Set<ITestResult> addAllTestResults(IResultMap resultMap) {
        if (resultMap == null) {
            return Sets.newHashSet();
        }
        ArrayList temp = new ArrayList(resultMap.getAllResults());
        temp.sort((o1, o2) -> (int)(o1.getStartMillis() - o2.getStartMillis()));
        return new HashSet<ITestResult>(temp);
    }

    public static class ExecutionResults {
        private int passed = 0;
        private int failed = 0;
        private int skipped = 0;
        private int ignored = 0;
        private int retried = 0;

        int getTotal() {
            return this.getPassed() + this.getFailed() + this.getSkipped() + this.getRetried();
        }

        int getPassed() {
            return this.passed;
        }

        int getFailed() {
            return this.failed;
        }

        int getSkipped() {
            return this.skipped;
        }

        int getIgnored() {
            return this.ignored;
        }

        int getRetried() {
            return this.retried;
        }
    }
}

