/*
 * Decompiled with CFR 0.152.
 */
package com.github.testng;

import com.github.exception.ReportConfigException;
import com.github.internal.HtmlBuilder;
import com.github.internal.Utils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.testng.IReporter;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestResult;
import org.testng.TestNG;
import org.testng.xml.XmlSuite;

public class MetricsListener
implements IReporter,
ITestListener {
    private StringBuilder builder = new StringBuilder();
    private static String outdir;

    public void generateReport(List<XmlSuite> xmlSuites, List<ISuite> suites, String outputDirectory) {
        String logo = System.getProperty("testng.metrics.logo", "https://i.ibb.co/0j28fBG/tmetricslogo.png");
        Utils.ExecutionResults results = Utils.computeOverResults(suites);
        this.builder.append((CharSequence)HtmlBuilder.buildHeaderAndTitle());
        this.builder.append((CharSequence)HtmlBuilder.buildDashBoard(results, logo));
        suites.forEach(this::generateReport);
        this.builder.append((CharSequence)HtmlBuilder.buildLogsTab());
        this.builder.append((CharSequence)HtmlBuilder.buildEmailTab(results));
        this.builder.append((CharSequence)HtmlBuilder.buildScriptContent());
        try {
            Utils.writeToFile(outputDirectory, this.builder.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void generateReport(ISuite suite) {
        this.generateClassMetrics(suite);
        this.generateTestMetrics(suite);
        this.generateMethodMetrics(suite);
    }

    private void generateClassMetrics(ISuite suite) {
        Collection suiteResults = suite.getResults().values();
        int index = 0;
        int size = suiteResults.size();
        for (ISuiteResult suiteResult : suiteResults) {
            if (index == 0) {
                this.builder.append((CharSequence)HtmlBuilder.appendClassMetricsHeader());
            }
            this.builder.append((CharSequence)HtmlBuilder.buildClassMetrics(suiteResult));
            if (index == size - 1) {
                this.builder.append((CharSequence)HtmlBuilder.appendClassMetricsFooter());
            }
            ++index;
        }
    }

    private void generateTestMetrics(ISuite suite) {
        Collection suiteResults = suite.getResults().values();
        int index = 0;
        int size = suiteResults.size();
        long totalTime = 0L;
        for (ISuiteResult eachRslt : suite.getResults().values()) {
            ITestContext ctx = eachRslt.getTestContext();
            Date start = ctx.getStartDate();
            Date end = ctx.getEndDate();
            long ms = end.getTime() - start.getTime();
            totalTime += ms;
        }
        long secs = totalTime / 1000L;
        String executionTimeFormat = String.format("%02d:%02d:%02d", secs / 3600L, secs % 3600L / 60L, secs % 60L);
        for (ISuiteResult suiteResult : suiteResults) {
            if (index == 0) {
                this.builder.append((CharSequence)HtmlBuilder.appendTestMetricsHeader(executionTimeFormat));
            }
            this.builder.append((CharSequence)HtmlBuilder.buildTestMetricsTab(suiteResult));
            if (index == size - 1) {
                this.builder.append((CharSequence)HtmlBuilder.appendTestMetricsFooter());
            }
            ++index;
        }
    }

    private void generateMethodMetrics(ISuite suite) {
        Collection suiteResults = suite.getResults().values();
        int index = 0;
        int size = suiteResults.size();
        for (ISuiteResult suiteResult : suiteResults) {
            if (index == 0) {
                this.builder.append((CharSequence)HtmlBuilder.appendMethodMetricsHeader());
            }
            this.builder.append((CharSequence)HtmlBuilder.buildMethodMetricsTab(suiteResult));
            if (index == size - 1) {
                this.builder.append((CharSequence)HtmlBuilder.appendMethodMetricsFooter());
            }
            ++index;
        }
    }

    public void onStart(ITestContext context) {
        String archive_report = context.getCurrentXmlTest().getParameter("archive.testng.metrics.report");
        if (archive_report == null) {
            archive_report = "false";
        }
        outdir = "";
        if (archive_report.equalsIgnoreCase("yes") || archive_report.equalsIgnoreCase("true")) {
            String archivePath = "";
            try {
                Method customMethod = TestNG.class.getMethod("setOutputDirectory", String.class);
                archivePath = System.getProperty("user.dir") + File.separator + "TestNg_Metrics_Reports" + File.separator;
                archivePath = archivePath + "Results_" + new SimpleDateFormat("dd_MMM_yy_hh_mm_ss").format(new Date());
                try {
                    if (!new File(archivePath).mkdirs()) {
                        throw new ReportConfigException("Failed to create the archive report directory");
                    }
                }
                catch (Exception exception) {
                    throw new ReportConfigException(exception.getMessage(), exception);
                }
                outdir = archivePath;
                Object[] customObject = new Object[]{outdir};
                customMethod.invoke((Object)TestNG.getDefault(), customObject);
                System.out.println("Custom output folder created at: " + outdir);
            }
            catch (Exception exception) {
                throw new ReportConfigException("Unable to set archive report directory", exception);
            }
        }
        try {
            Method customMethod = TestNG.class.getMethod("getOutputDirectory", new Class[0]);
            Object[] customObject = new Object[]{};
            outdir = (String)customMethod.invoke((Object)TestNG.getDefault(), customObject);
        }
        catch (Exception exception) {
            throw new ReportConfigException("Unable to read report directory", exception);
        }
    }

    public void onFinish(ITestContext context) {
        try {
            Method customizedFinish = TestNG.class.getMethod("getOutputDirectory", new Class[0]);
            Object[] customObject = new Object[]{};
            outdir = (String)customizedFinish.invoke((Object)TestNG.getDefault(), customObject);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void onTestStart(ITestResult result) {
    }

    public void onTestSuccess(ITestResult result) {
    }

    public void onTestFailure(ITestResult result) {
    }

    public void onTestSkipped(ITestResult result) {
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
    }

    public void onTestFailedWithTimeout(ITestResult result) {
        this.onTestFailure(result);
    }

    public static String getOutdir() {
        return outdir;
    }
}

