/*
 * Decompiled with CFR 0.152.
 */
package com.github.admincaofuqiang.HttpUtil;

import com.alibaba.fastjson.JSON;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class HttpUrlUtil {
    public static String doGet(String url) {
        String string;
        URL requestUrl = null;
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new RuntimeException("reuqest url is null");
        }
        try {
            requestUrl = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("reuqest url format is error");
        }
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = (HttpURLConnection)requestUrl.openConnection();
            httpURLConnection.setRequestMethod("GET");
        }
        catch (IOException e) {
            throw new RuntimeException("request error");
        }
        InputStream inputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            int responseCode = httpURLConnection.getResponseCode();
            if (responseCode == 200) {
                inputStream = httpURLConnection.getInputStream();
                inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
                bufferedReader = new BufferedReader(inputStreamReader);
                String string2 = bufferedReader.readLine();
                return string2;
            }
            String responseMessage = httpURLConnection.getResponseMessage();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("code", responseCode);
            map.put("message", responseMessage);
            string = JSON.toJSONString(map);
        }
        catch (IOException e) {
            throw new RuntimeException("request error");
        }
        finally {
            try {
                bufferedReader.close();
                inputStreamReader.close();
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return string;
    }

    public static String doPostJson(String url, String param) {
        return HttpUrlUtil.doPostJsonWhitHeader(url, param, null);
    }

    public static String doPostJsonWhitHeader(String url, String param, Map<String, String> header) {
        String string;
        URL requestUrl = null;
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new RuntimeException("request url is null");
        }
        try {
            requestUrl = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("request url format error");
        }
        HttpURLConnection httpURLConnection = null;
        InputStream inputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            int responseCode;
            httpURLConnection = (HttpURLConnection)requestUrl.openConnection();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setRequestProperty("Connection", "Keep-Alive");
            httpURLConnection.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
            httpURLConnection.setRequestProperty("accept", "*/*");
            httpURLConnection.setRequestProperty("Charset", "UT-8");
            if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{param}) || !JSON.isValid((String)param)) {
                throw new RuntimeException("request error");
            }
            byte[] bytes = param.getBytes(StandardCharsets.UTF_8);
            httpURLConnection.setRequestProperty("Content-Length", String.valueOf(bytes.length));
            Object outputStream = httpURLConnection.getOutputStream();
            ((OutputStream)outputStream).write(param.getBytes(StandardCharsets.UTF_8));
            ((OutputStream)outputStream).flush();
            ((OutputStream)outputStream).close();
            if (ObjectUtils.isNotEmpty(header)) {
                Set<String> key = header.keySet();
                for (String s : key) {
                    httpURLConnection.setRequestProperty(s, header.get(s));
                }
            }
            if ((responseCode = httpURLConnection.getResponseCode()) == 200) {
                inputStream = httpURLConnection.getInputStream();
                inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
                bufferedReader = new BufferedReader(inputStreamReader);
                outputStream = bufferedReader.readLine();
                return outputStream;
            }
            String responseMessage = httpURLConnection.getResponseMessage();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("code", responseCode);
            map.put("message", responseMessage);
            string = JSON.toJSONString(map);
        }
        catch (IOException e) {
            throw new RuntimeException("request errorcls");
        }
        finally {
            try {
                bufferedReader.close();
                inputStreamReader.close();
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return string;
    }
}

