/*
 * Decompiled with CFR 0.152.
 */
package com.github.admincaofuqiang.ImageUtil;

import cn.hutool.core.codec.Base64;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.ObjectUtils;

public class Image {
    public static BufferedImage makeImageStream(BufferedImage bufferedImage, int outputWidth, int qrcodeWidth, Integer marginBottom, String description, Color backgroundColor, Font font, Color foregroundColor) {
        if (outputWidth <= 0) {
            throw new RuntimeException("\u8f93\u51fa\u56fe\u7247\u5c3a\u5bf8\u8fc7\u5c0f");
        }
        if (qrcodeWidth <= 0) {
            throw new RuntimeException("\u5185\u5d4c\u56fe\u7247\u5c3a\u5bf8\u8fc7\u5c0f");
        }
        if (outputWidth < qrcodeWidth) {
            throw new RuntimeException("\u8f93\u51fa\u6587\u4ef6\u5c3a\u5bf8\u5927\u4e8e\u5185\u5d4c\u56fe\u7247\u5c3a\u5bf8");
        }
        BufferedImage outBufferedImage = new BufferedImage(outputWidth, outputWidth, 1);
        Graphics2D graphics = outBufferedImage.createGraphics();
        if (ObjectUtils.isEmpty((Object)backgroundColor)) {
            graphics.setBackground(Color.white);
        } else {
            graphics.setBackground(backgroundColor);
        }
        graphics.clearRect(0, 0, outputWidth, outputWidth);
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics.setPaint(new Color(0, 0, 0, 64));
        if (ObjectUtils.isEmpty((Object)font)) {
            font = new Font("\u5b8b\u4f53", 1, 20);
        }
        graphics.setFont(font);
        if (ObjectUtils.isEmpty((Object)foregroundColor)) {
            graphics.setColor(Color.BLACK);
        } else {
            graphics.setColor(foregroundColor);
        }
        FontMetrics fm = graphics.getFontMetrics(font);
        int textWidth = fm.stringWidth(description);
        int widthX = (outputWidth - textWidth) / 2;
        graphics.drawString(description, widthX, outputWidth - marginBottom);
        graphics.drawImage(bufferedImage, (outputWidth - qrcodeWidth) / 2, (outputWidth - qrcodeWidth) / 2, qrcodeWidth, qrcodeWidth, null);
        graphics.dispose();
        return outBufferedImage;
    }

    public static String makeImageBase64(BufferedImage bufferedImage, int outputWidth, int qrcodeWidth, Integer marginBottom, String description, Color backgroundColor, Font font, Color foregroundColor) {
        BufferedImage out = Image.makeImageStream(bufferedImage, outputWidth, qrcodeWidth, marginBottom, description, backgroundColor, font, foregroundColor);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)out, "png", stream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String base64 = Base64.encode((byte[])stream.toByteArray());
        return "data:image/png;base64," + base64;
    }
}

