CREATE TABLE if not exists jacg_method_catch_{appName} (
  record_id int NOT NULL COMMENT '记录id，从1开始',
  method_hash varchar(32) NOT NULL COMMENT '方法hash+字节数',
  simple_class_name varchar(255) NOT NULL COMMENT '唯一类名',
  method_name varchar(300) NOT NULL COMMENT '方法名称',
  simple_catch_exception_type varchar(255) NOT NULL COMMENT 'catch捕获的异常类型唯一类名',
  catch_exception_type varchar(255) NOT NULL COMMENT 'catch捕获的异常类型',
  catch_flag varchar(20) NOT NULL COMMENT 'catch标志，switch: 编译器为switch生成的catch代码块，try-with-resource: 编译器为try-with-resource生成的catch代码块',
  try_start_line_number int NOT NULL COMMENT 'try代码块开始代码行号',
  try_end_line_number int NOT NULL COMMENT 'try代码块结束代码行号',
  try_min_call_id int NOT NULL COMMENT 'try代码块最小方法调用ID',
  try_max_call_id int NOT NULL COMMENT 'try代码块最大方法调用ID',
  catch_start_offset int NOT NULL COMMENT 'catch代码块开始指令偏移量',
  catch_end_offset int NOT NULL COMMENT 'catch代码块结束指令偏移量',
  catch_start_line_number int NOT NULL COMMENT 'catch代码块开始代码行号',
  catch_end_line_number int NOT NULL COMMENT 'catch代码块结束代码行号',
  catch_min_call_id int NOT NULL COMMENT 'catch代码块最小方法调用ID',
  catch_max_call_id int NOT NULL COMMENT 'catch代码块最大方法调用ID',
  full_method text NOT NULL COMMENT '完整方法（类名+方法名+参数）',
  return_type varchar(255) NOT NULL COMMENT '方法返回类型，包含数组标志',
  PRIMARY KEY (record_id),
  INDEX idx_mcth_mh_{appName}(method_hash),
  INDEX idx_mcth_scn_{appName}(simple_class_name),
  INDEX idx_mcth_sct_{appName}(simple_catch_exception_type)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='方法的catch信息';