/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.mybatis_mysql_table_parser.dto;

import com.adrninistrator.mybatis_mysql_table_parser.common.enums.MySqlStatementEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class MySqlTableInfo {
    private final Map<String, Set<String>> storedTableMap = new HashMap<String, Set<String>>();
    private final List<String> selectTableList = new ArrayList<String>();
    private final List<String> select4UpdateTableList = new ArrayList<String>();
    private final List<String> insertTableList = new ArrayList<String>();
    private final List<String> insertIgnoreTableList = new ArrayList<String>();
    private final List<String> insertOrUpdateTableList = new ArrayList<String>();
    private final List<String> replaceTableList = new ArrayList<String>();
    private List<String> updateTableList = new ArrayList<String>();
    private List<String> deleteTableList = new ArrayList<String>();
    private final List<String> alterTableList = new ArrayList<String>();
    private final List<String> truncateTableList = new ArrayList<String>();
    private final List<String> createTableList = new ArrayList<String>();
    private final List<String> dropTableList = new ArrayList<String>();
    private boolean parseFail = false;

    public static void copyUpdateTableList(MySqlTableInfo src, MySqlTableInfo dest) {
        dest.updateTableList = src.updateTableList;
    }

    public static void copyDeleteTableList(MySqlTableInfo src, MySqlTableInfo dest) {
        dest.deleteTableList = src.deleteTableList;
    }

    public static void addAllTables(MySqlTableInfo src, MySqlTableInfo dest) {
        Map<String, Set<String>> usedStoredTableMap = dest.storedTableMap;
        MySqlTableInfo.addAllTableList(MySqlStatementEnum.DSE_SELECT, src.selectTableList, dest.selectTableList, usedStoredTableMap);
        MySqlTableInfo.addAllTableList(MySqlStatementEnum.DSE_SELECT_4_UPDATE, src.select4UpdateTableList, dest.select4UpdateTableList, usedStoredTableMap);
        MySqlTableInfo.addAllTableList(MySqlStatementEnum.DSE_INSERT, src.insertTableList, dest.insertTableList, usedStoredTableMap);
        MySqlTableInfo.addAllTableList(MySqlStatementEnum.DSE_INSERT_IGNORE, src.insertIgnoreTableList, dest.insertIgnoreTableList, usedStoredTableMap);
        MySqlTableInfo.addAllTableList(MySqlStatementEnum.DSE_INSERT_OR_UPDATE, src.insertOrUpdateTableList, dest.insertOrUpdateTableList, usedStoredTableMap);
        MySqlTableInfo.addAllTableList(MySqlStatementEnum.DSE_REPLACE, src.replaceTableList, dest.replaceTableList, usedStoredTableMap);
        MySqlTableInfo.addAllTableList(MySqlStatementEnum.DSE_UPDATE, src.updateTableList, dest.updateTableList, usedStoredTableMap);
        MySqlTableInfo.addAllTableList(MySqlStatementEnum.DSE_DELETE, src.deleteTableList, dest.deleteTableList, usedStoredTableMap);
        MySqlTableInfo.addAllTableList(MySqlStatementEnum.DSE_ALTER, src.alterTableList, dest.alterTableList, usedStoredTableMap);
        MySqlTableInfo.addAllTableList(MySqlStatementEnum.DSE_TRUNCATE, src.truncateTableList, dest.truncateTableList, usedStoredTableMap);
        MySqlTableInfo.addAllTableList(MySqlStatementEnum.DSE_CREATE, src.createTableList, dest.createTableList, usedStoredTableMap);
        MySqlTableInfo.addAllTableList(MySqlStatementEnum.DSE_DROP, src.dropTableList, dest.dropTableList, usedStoredTableMap);
    }

    private static void addAllTableList(MySqlStatementEnum mySqlStatementEnum, List<String> srcTableList, List<String> destTableList, Map<String, Set<String>> usedStoredTableMap) {
        for (String srcTable : srcTableList) {
            MySqlTableInfo.addTable(mySqlStatementEnum, srcTable, destTableList, usedStoredTableMap);
        }
    }

    private static void addTable(MySqlStatementEnum mySqlStatementEnum, String tableName, List<String> tableList, Map<String, Set<String>> usedStoredTableMap) {
        Set storedTableSet = usedStoredTableMap.computeIfAbsent(mySqlStatementEnum.getStatement(), k -> new HashSet());
        if (storedTableSet.add(tableName)) {
            tableList.add(tableName);
        }
    }

    public boolean isParseFail() {
        return this.parseFail;
    }

    public void setParseFail(boolean parseFail) {
        this.parseFail = parseFail;
    }

    public void addSelectTable(String tableName) {
        MySqlTableInfo.addTable(MySqlStatementEnum.DSE_SELECT, tableName, this.selectTableList, this.storedTableMap);
    }

    public void addSelect4UpdateTable(String tableName) {
        MySqlTableInfo.addTable(MySqlStatementEnum.DSE_SELECT_4_UPDATE, tableName, this.select4UpdateTableList, this.storedTableMap);
    }

    public void addInsertTable(String tableName) {
        MySqlTableInfo.addTable(MySqlStatementEnum.DSE_INSERT, tableName, this.insertTableList, this.storedTableMap);
    }

    public void addInsertIgnoreTable(String tableName) {
        MySqlTableInfo.addTable(MySqlStatementEnum.DSE_INSERT_IGNORE, tableName, this.insertIgnoreTableList, this.storedTableMap);
    }

    public void addInsertOrUpdateTable(String tableName) {
        MySqlTableInfo.addTable(MySqlStatementEnum.DSE_INSERT_OR_UPDATE, tableName, this.insertOrUpdateTableList, this.storedTableMap);
    }

    public void addReplaceIntoTable(String tableName) {
        MySqlTableInfo.addTable(MySqlStatementEnum.DSE_REPLACE, tableName, this.replaceTableList, this.storedTableMap);
    }

    public void addUpdateTable(String tableName) {
        MySqlTableInfo.addTable(MySqlStatementEnum.DSE_UPDATE, tableName, this.updateTableList, this.storedTableMap);
    }

    public void addDeleteTable(String tableName) {
        MySqlTableInfo.addTable(MySqlStatementEnum.DSE_DELETE, tableName, this.deleteTableList, this.storedTableMap);
    }

    public void addAlterTable(String tableName) {
        MySqlTableInfo.addTable(MySqlStatementEnum.DSE_ALTER, tableName, this.alterTableList, this.storedTableMap);
    }

    public void addTruncateTable(String tableName) {
        MySqlTableInfo.addTable(MySqlStatementEnum.DSE_TRUNCATE, tableName, this.truncateTableList, this.storedTableMap);
    }

    public void addCreateTable(String tableName) {
        MySqlTableInfo.addTable(MySqlStatementEnum.DSE_CREATE, tableName, this.createTableList, this.storedTableMap);
    }

    public void addDropTable(String tableName) {
        MySqlTableInfo.addTable(MySqlStatementEnum.DSE_DROP, tableName, this.dropTableList, this.storedTableMap);
    }

    private void addTableList4ToString(StringBuilder stringBuilder, String listName, List<String> list) {
        if (list.isEmpty()) {
            return;
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append(" ");
        }
        stringBuilder.append(listName).append(": ").append(StringUtils.join(list, (String)", "));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.addTableList4ToString(stringBuilder, "select", this.selectTableList);
        this.addTableList4ToString(stringBuilder, "select4Update", this.select4UpdateTableList);
        this.addTableList4ToString(stringBuilder, "insert", this.insertTableList);
        this.addTableList4ToString(stringBuilder, "insertIgnore", this.insertIgnoreTableList);
        this.addTableList4ToString(stringBuilder, "insertOrUpdate", this.insertOrUpdateTableList);
        this.addTableList4ToString(stringBuilder, "replaceInto", this.replaceTableList);
        this.addTableList4ToString(stringBuilder, "update", this.updateTableList);
        this.addTableList4ToString(stringBuilder, "delete", this.deleteTableList);
        this.addTableList4ToString(stringBuilder, "alter", this.alterTableList);
        this.addTableList4ToString(stringBuilder, "truncate", this.truncateTableList);
        this.addTableList4ToString(stringBuilder, "create", this.createTableList);
        this.addTableList4ToString(stringBuilder, "drop", this.dropTableList);
        return stringBuilder.toString();
    }

    public List<String> getSelectTableList() {
        return this.selectTableList;
    }

    public List<String> getSelect4UpdateTableList() {
        return this.select4UpdateTableList;
    }

    public List<String> getInsertTableList() {
        return this.insertTableList;
    }

    public List<String> getInsertIgnoreTableList() {
        return this.insertIgnoreTableList;
    }

    public List<String> getInsertOrUpdateTableList() {
        return this.insertOrUpdateTableList;
    }

    public List<String> getReplaceTableList() {
        return this.replaceTableList;
    }

    public List<String> getUpdateTableList() {
        return this.updateTableList;
    }

    public List<String> getDeleteTableList() {
        return this.deleteTableList;
    }

    public List<String> getAlterTableList() {
        return this.alterTableList;
    }

    public List<String> getTruncateTableList() {
        return this.truncateTableList;
    }

    public List<String> getCreateTableList() {
        return this.createTableList;
    }

    public List<String> getDropTableList() {
        return this.dropTableList;
    }
}

