/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.mybatis_mysql_table_parser.entry;

import com.adrninistrator.mybatis_mysql_table_parser.dto.MyBatisSqlInfo;
import com.adrninistrator.mybatis_mysql_table_parser.dto.MySqlTableInfo;
import com.adrninistrator.mybatis_mysql_table_parser.parser.MyBatisXmlSqlParser;
import com.adrninistrator.mybatis_mysql_table_parser.parser.MySqlTableParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEntry {
    private static final Logger logger = LoggerFactory.getLogger(AbstractEntry.class);
    protected final MyBatisXmlSqlParser myBatisXmlSqlParser = new MyBatisXmlSqlParser();
    protected final MySqlTableParser mySqlTableParser = new MySqlTableParser();
    protected final Map<String, MyBatisSqlInfo> myBatisSqlInfoMap = new HashMap<String, MyBatisSqlInfo>();

    protected AbstractEntry() {
    }

    protected void handleDirectory(String dirPath) {
        logger.debug("\u5904\u7406\u76ee\u5f55 {}", (Object)dirPath);
        File dir = new File(dirPath);
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                this.handleDirectory(file.getPath());
                continue;
            }
            String filePath = file.getPath();
            if (!StringUtils.endsWithIgnoreCase((CharSequence)filePath, (CharSequence)".xml")) continue;
            this.handleXmlFile(filePath);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected MyBatisSqlInfo handleXmlFile(String filePath) {
        try (FileInputStream inputStream = new FileInputStream(filePath);){
            MyBatisSqlInfo myBatisSqlInfo = this.handleXmlFile(inputStream, filePath);
            return myBatisSqlInfo;
        }
        catch (Exception e) {
            logger.error("error ", (Throwable)e);
            return null;
        }
    }

    protected MyBatisSqlInfo handleXmlFile(InputStream inputStream, String filePath) {
        logger.debug("\u5904\u7406xml\u6587\u4ef6 {}", (Object)filePath);
        try {
            MyBatisSqlInfo myBatisSqlInfo = this.myBatisXmlSqlParser.parseMybatisXmlSql(inputStream, filePath);
            if (myBatisSqlInfo == null) {
                return null;
            }
            HashMap<String, MySqlTableInfo> mySqlTableInfoMap = new HashMap<String, MySqlTableInfo>();
            for (Map.Entry<String, List<String>> entry : myBatisSqlInfo.getFullSqlMap().entrySet()) {
                String sqlId = entry.getKey();
                List<String> fullSqlList = entry.getValue();
                for (String fullSql : fullSqlList) {
                    MySqlTableInfo mySqlTableInfo = this.mySqlTableParser.parseTablesInSql(fullSql);
                    mySqlTableInfoMap.put(sqlId, mySqlTableInfo);
                    if (!mySqlTableInfo.isParseFail()) continue;
                    logger.error("\u89e3\u6790\u5931\u8d25\t{}\t{}\t{}", new Object[]{filePath, sqlId, fullSql});
                }
            }
            myBatisSqlInfo.setMySqlTableInfoMap(mySqlTableInfoMap);
            this.myBatisSqlInfoMap.put(myBatisSqlInfo.getMapperInterfaceName(), myBatisSqlInfo);
            return myBatisSqlInfo;
        }
        catch (Exception e) {
            logger.error("error ", (Throwable)e);
            return null;
        }
    }
}

