/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.mybatis_mysql_table_parser.entry;

import com.adrninistrator.mybatis_mysql_table_parser.common.enums.MySqlStatementEnum;
import com.adrninistrator.mybatis_mysql_table_parser.dto.MyBatisSqlInfo;
import com.adrninistrator.mybatis_mysql_table_parser.dto.MySqlTableInfo;
import com.adrninistrator.mybatis_mysql_table_parser.entry.AbstractEntry;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Entry4GetMyBatisMySqlTableInfo
extends AbstractEntry {
    private static final Logger logger = LoggerFactory.getLogger(Entry4GetMyBatisMySqlTableInfo.class);

    public void getTableInfo(String dirPath, String outputFilePath) {
        if (StringUtils.isBlank((CharSequence)dirPath) || StringUtils.isBlank((CharSequence)outputFilePath)) {
            logger.error("\u4f20\u5165\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            return;
        }
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFilePath), StandardCharsets.UTF_8));){
            String fileHeader = "# sql\u8bed\u53e5\u7c7b\u578b\t\u8868\u540d\n";
            writer.write(fileHeader);
            this.handleDirectory(dirPath);
            MySqlTableInfo allMySqlTableInfo = new MySqlTableInfo();
            for (Map.Entry entry : this.myBatisSqlInfoMap.entrySet()) {
                MyBatisSqlInfo myBatisSqlInfo = (MyBatisSqlInfo)entry.getValue();
                Map<String, MySqlTableInfo> mySqlTableInfoMap = myBatisSqlInfo.getMySqlTableInfoMap();
                for (Map.Entry<String, MySqlTableInfo> entry1 : mySqlTableInfoMap.entrySet()) {
                    MySqlTableInfo mySqlTableInfo = entry1.getValue();
                    MySqlTableInfo.addAllTables(mySqlTableInfo, allMySqlTableInfo);
                }
            }
            this.recordTableInfo(writer, MySqlStatementEnum.DSE_SELECT, allMySqlTableInfo.getSelectTableList());
            this.recordTableInfo(writer, MySqlStatementEnum.DSE_SELECT_4_UPDATE, allMySqlTableInfo.getSelect4UpdateTableList());
            this.recordTableInfo(writer, MySqlStatementEnum.DSE_INSERT, allMySqlTableInfo.getInsertTableList());
            this.recordTableInfo(writer, MySqlStatementEnum.DSE_INSERT_IGNORE, allMySqlTableInfo.getInsertIgnoreTableList());
            this.recordTableInfo(writer, MySqlStatementEnum.DSE_INSERT_OR_UPDATE, allMySqlTableInfo.getInsertOrUpdateTableList());
            this.recordTableInfo(writer, MySqlStatementEnum.DSE_REPLACE, allMySqlTableInfo.getReplaceTableList());
            this.recordTableInfo(writer, MySqlStatementEnum.DSE_UPDATE, allMySqlTableInfo.getUpdateTableList());
            this.recordTableInfo(writer, MySqlStatementEnum.DSE_DELETE, allMySqlTableInfo.getDeleteTableList());
            this.recordTableInfo(writer, MySqlStatementEnum.DSE_ALTER, allMySqlTableInfo.getAlterTableList());
            this.recordTableInfo(writer, MySqlStatementEnum.DSE_TRUNCATE, allMySqlTableInfo.getTruncateTableList());
            this.recordTableInfo(writer, MySqlStatementEnum.DSE_CREATE, allMySqlTableInfo.getCreateTableList());
            this.recordTableInfo(writer, MySqlStatementEnum.DSE_DROP, allMySqlTableInfo.getDropTableList());
        }
        catch (Exception e) {
            logger.error("error ", (Throwable)e);
        }
    }

    private void recordTableInfo(BufferedWriter writer, MySqlStatementEnum mySqlStatementEnum, List<String> tableList) throws IOException {
        if (tableList.isEmpty()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Collections.sort(tableList);
        for (String table : tableList) {
            stringBuilder.append(mySqlStatementEnum.getStatement()).append("\t").append(table).append("\n");
        }
        writer.write(stringBuilder.toString());
    }
}

