/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.mybatis_mysql_table_parser.parser;

import com.adrninistrator.mybatis_mysql_table_parser.dto.MyBatisSqlInfo;
import com.adrninistrator.mybatis_mysql_table_parser.token_handler.EmptyTokenHandler;
import com.adrninistrator.mybatis_mysql_table_parser.token_handler.QuestionMarkTokenHandler;
import com.adrninistrator.mybatis_mysql_table_parser.xml.NoOpEntityResolver;
import copy.org.apache.ibatis.parsing.GenericTokenParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Comment;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Text;
import org.jdom2.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;

public class MyBatisXmlSqlParser {
    private static final Logger logger = LoggerFactory.getLogger(MyBatisXmlSqlParser.class);
    private static final String[] MYSQL_DML_SINGLE_STATEMENT = new String[]{"select ", "update ", "delete "};
    private static final String[] MYSQL_DML_DDL_MULTI_STATEMENT = new String[]{"insert into ", "insert ignore into ", "replace insert ", "alter table ", "truncate table ", "create table ", "drop table "};
    private static final String[] SQL_COLUMN_OPERATE_STATEMENT = new String[]{"=", "<", ">", "!", "not ", "in (", "in(", "like ", "like'", ","};
    private static final String[] SQL_AND_OR = new String[]{"and ", "or "};
    private final SAXBuilder saxBuilder = new SAXBuilder();
    private final GenericTokenParser hashtagValueParser;
    private final GenericTokenParser dollarValueParser;
    private final GenericTokenParser commentMultiLineParser;
    private final GenericTokenParser commentSingleLine1Parser;
    private final GenericTokenParser commentSingleLine2Parser;

    public MyBatisXmlSqlParser() {
        this.saxBuilder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", false);
        this.saxBuilder.setFeature("http://xml.org/sax/features/external-general-entities", false);
        this.saxBuilder.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        this.saxBuilder.setEntityResolver((EntityResolver)new NoOpEntityResolver());
        this.hashtagValueParser = new GenericTokenParser("#{", "}", QuestionMarkTokenHandler.getInstance());
        this.dollarValueParser = new GenericTokenParser("${", "}", QuestionMarkTokenHandler.getInstance());
        this.commentMultiLineParser = new GenericTokenParser("/*", "*/", EmptyTokenHandler.getInstance());
        this.commentSingleLine1Parser = new GenericTokenParser("-- ", "\r", EmptyTokenHandler.getInstance());
        this.commentSingleLine2Parser = new GenericTokenParser("-- ", "\n", EmptyTokenHandler.getInstance());
    }

    public MyBatisSqlInfo parseMybatisXmlSql(InputStream inputStream, String filePath) throws IOException, JDOMException {
        Document document = this.saxBuilder.build(inputStream);
        Element root = document.getRootElement();
        if (!"mapper".equals(root.getName())) {
            logger.info("\u8df3\u8fc7\u975eMybatis XML 1: {}", (Object)filePath);
            return null;
        }
        String namespace = root.getAttributeValue("namespace");
        if (StringUtils.isBlank((CharSequence)namespace)) {
            logger.info("\u8df3\u8fc7\u975eMybatis XML 2: {}", (Object)filePath);
            return null;
        }
        logger.info("\u5f00\u59cb\u5904\u7406Mybatis XML: {}", (Object)filePath);
        HashMap<String, String> sqlElementMap = new HashMap<String, String>();
        this.preHandleMybatisXml(root, sqlElementMap);
        return this.handleMybatisXml(root, namespace, sqlElementMap);
    }

    private void preHandleMybatisXml(Element root, Map<String, String> sqlElementMap) {
        for (Element element : root.getChildren()) {
            try {
                if (!"sql".equals(element.getName())) continue;
                String id = element.getAttributeValue("id");
                ArrayList<String> sqlFragmentList = new ArrayList<String>();
                this.getSqlFromElementContent(element, sqlFragmentList, sqlElementMap);
                List<String> fullSqlList = this.appendSqlFragment(sqlFragmentList, true);
                if (fullSqlList.isEmpty()) {
                    logger.error("\u672a\u83b7\u53d6sql\u5143\u7d20\u7684sql\u8bed\u53e5 {}", (Object)id);
                    continue;
                }
                sqlElementMap.put(id, fullSqlList.get(0));
            }
            catch (Exception e) {
                logger.error("error ", (Throwable)e);
            }
        }
    }

    private MyBatisSqlInfo handleMybatisXml(Element root, String namespace, Map<String, String> sqlElementMap) {
        HashMap<String, List<String>> sqlMap = new HashMap<String, List<String>>();
        MyBatisSqlInfo myBatisSqlInfo = new MyBatisSqlInfo();
        myBatisSqlInfo.setMapperInterfaceName(namespace);
        myBatisSqlInfo.setFullSqlMap(sqlMap);
        for (Element element : root.getChildren()) {
            if (!StringUtils.equalsAny((CharSequence)element.getName(), (CharSequence[])new CharSequence[]{"select", "insert", "update", "delete"})) continue;
            try {
                String sqlId = element.getAttributeValue("id");
                ArrayList<String> sqlFragmentList = new ArrayList<String>();
                boolean existsSelectKey = this.handleSelectKeyElement(element, sqlFragmentList, sqlElementMap, true);
                this.getSqlFromElementContent(element, sqlFragmentList, sqlElementMap);
                if (existsSelectKey) {
                    this.handleSelectKeyElement(element, sqlFragmentList, sqlElementMap, false);
                }
                List<String> fullSqlList = this.appendSqlFragment(sqlFragmentList, false);
                sqlMap.put(sqlId, fullSqlList);
            }
            catch (Exception e) {
                logger.error("error ", (Throwable)e);
            }
        }
        return myBatisSqlInfo;
    }

    private void getSqlFromElementContent(Element currentElement, List<String> sqlFragmentList, Map<String, String> sqlElementMap) {
        for (Content content : currentElement.getContent()) {
            if (content instanceof Text) {
                Text text = (Text)content;
                this.addSqlStatement(sqlFragmentList, text.getText());
                continue;
            }
            if (content instanceof Element) {
                Element element = (Element)content;
                String elementName = element.getName();
                if (StringUtils.equalsAny((CharSequence)elementName, (CharSequence[])new CharSequence[]{"foreach"})) {
                    this.handleForeachElement(sqlFragmentList, element, sqlElementMap);
                    continue;
                }
                if (StringUtils.equalsAny((CharSequence)elementName, (CharSequence[])new CharSequence[]{"if", "choose", "when", "otherwise"})) {
                    this.getSqlFromElementContent(element, sqlFragmentList, sqlElementMap);
                    continue;
                }
                if (StringUtils.equals((CharSequence)elementName, (CharSequence)"where")) {
                    this.handleWhereElement(sqlFragmentList, elementName, element, sqlElementMap);
                    continue;
                }
                if (StringUtils.equals((CharSequence)elementName, (CharSequence)"set")) {
                    this.addSqlStatement(sqlFragmentList, elementName);
                    this.getSqlFromElementContent(element, sqlFragmentList, sqlElementMap);
                    this.handleLastComma4SetElement(sqlFragmentList);
                    continue;
                }
                if (StringUtils.equals((CharSequence)elementName, (CharSequence)"include")) {
                    this.handleIncludeElement(sqlFragmentList, element, sqlElementMap);
                    continue;
                }
                if (StringUtils.equals((CharSequence)elementName, (CharSequence)"trim")) {
                    this.handleTrimElement(element, sqlFragmentList, sqlElementMap);
                    continue;
                }
                if (StringUtils.equalsAny((CharSequence)elementName, (CharSequence[])new CharSequence[]{"selectKey", "bind"})) continue;
                logger.error("\u6682\u672a\u5904\u7406\u7684MyBatis\u7c7b\u578b {}", (Object)elementName);
                continue;
            }
            if (content instanceof Comment) continue;
            logger.error("\u6682\u672a\u5904\u7406\u7684XML\u7c7b\u578b {}", (Object)content.getClass().getName());
        }
    }

    private boolean handleSelectKeyElement(Element currentElement, List<String> sqlFragmentList, Map<String, String> sqlElementMap, boolean before) {
        int selectKeyNum = 0;
        for (Content content : currentElement.getContent()) {
            Element element;
            String elementName;
            if (!(content instanceof Element) || !"selectKey".equals(elementName = (element = (Element)content).getName())) continue;
            ++selectKeyNum;
            String order = element.getAttributeValue("order");
            if (before && !"BEFORE".equals(order) || !before && !"AFTER".equals(order)) continue;
            ArrayList<String> selectKeySqlFragmentList = new ArrayList<String>();
            this.handleTrimElement(element, selectKeySqlFragmentList, sqlElementMap);
            if (selectKeySqlFragmentList.isEmpty()) continue;
            if (before) {
                sqlFragmentList.addAll(0, selectKeySqlFragmentList);
                continue;
            }
            sqlFragmentList.addAll(selectKeySqlFragmentList);
        }
        return selectKeyNum > 0;
    }

    private void handleTrimElement(Element element, List<String> sqlFragmentList, Map<String, String> sqlElementMap) {
        String prefix = element.getAttributeValue("prefix");
        if (prefix != null) {
            this.addSqlStatement(sqlFragmentList, prefix);
        }
        String prefixOverrides = element.getAttributeValue("prefixOverrides");
        String suffixOverrides = element.getAttributeValue("suffixOverrides");
        ArrayList<String> trimSqlFragmentList = new ArrayList<String>();
        this.getSqlFromElementContent(element, trimSqlFragmentList, sqlElementMap);
        if (!trimSqlFragmentList.isEmpty()) {
            if (StringUtils.isNotEmpty((CharSequence)prefixOverrides)) {
                List<String> prefixOverrideList = this.parseOverrides(prefixOverrides);
                for (String currentPrefixOverride : prefixOverrideList) {
                    String firstSql = this.formatSql((String)trimSqlFragmentList.get(0));
                    if (!StringUtils.startsWithIgnoreCase((CharSequence)firstSql, (CharSequence)currentPrefixOverride)) continue;
                    trimSqlFragmentList.set(0, firstSql.substring(currentPrefixOverride.length()));
                    break;
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)suffixOverrides)) {
                int lastIndex = trimSqlFragmentList.size() - 1;
                List<String> suffixOverrideList = this.parseOverrides(suffixOverrides);
                for (String currentSuffixOverride : suffixOverrideList) {
                    String lastSql = this.formatSql((String)trimSqlFragmentList.get(lastIndex));
                    if (!StringUtils.endsWithIgnoreCase((CharSequence)lastSql, (CharSequence)currentSuffixOverride)) continue;
                    trimSqlFragmentList.set(lastIndex, lastSql.substring(0, lastSql.length() - currentSuffixOverride.length()));
                    break;
                }
            }
        }
        sqlFragmentList.addAll(trimSqlFragmentList);
        String suffix = element.getAttributeValue("suffix");
        if (suffix != null) {
            this.addSqlStatement(sqlFragmentList, suffix);
        }
    }

    private List<String> parseOverrides(String overrides) {
        if (overrides != null) {
            StringTokenizer parser = new StringTokenizer(overrides, "|", false);
            ArrayList<String> list = new ArrayList<String>(parser.countTokens());
            while (parser.hasMoreTokens()) {
                list.add(parser.nextToken());
            }
            return list;
        }
        return Collections.emptyList();
    }

    private void handleLastComma4SetElement(List<String> sqlFragmentList) {
        if (sqlFragmentList.isEmpty()) {
            return;
        }
        int lastIndex = sqlFragmentList.size() - 1;
        String lastSql = this.replaceFlagInSql(sqlFragmentList.get(lastIndex));
        if (lastSql.endsWith(",")) {
            sqlFragmentList.set(lastIndex, lastSql.substring(0, lastSql.length() - 1));
        }
    }

    private void handleForeachElement(List<String> sqlFragmentList, Element element, Map<String, String> sqlElementMap) {
        String open = element.getAttributeValue("open");
        if (open != null) {
            this.addSqlStatement(sqlFragmentList, open);
        }
        this.getSqlFromElementContent(element, sqlFragmentList, sqlElementMap);
        String close = element.getAttributeValue("close");
        if (close != null) {
            this.addSqlStatement(sqlFragmentList, close);
        }
    }

    private void handleWhereElement(List<String> sqlFragmentList, String elementName, Element element, Map<String, String> sqlElementMap) {
        this.addSqlStatement(sqlFragmentList, elementName);
        ArrayList<String> whereSqlFragmentList = new ArrayList<String>();
        this.getSqlFromElementContent(element, whereSqlFragmentList, sqlElementMap);
        if (!whereSqlFragmentList.isEmpty()) {
            String firstSqlFragment = this.replaceFlagInSql((String)whereSqlFragmentList.get(0));
            for (String andOrOr : SQL_AND_OR) {
                if (!StringUtils.startsWithIgnoreCase((CharSequence)firstSqlFragment, (CharSequence)andOrOr)) continue;
                whereSqlFragmentList.set(0, firstSqlFragment.substring(andOrOr.length()));
            }
            sqlFragmentList.addAll(whereSqlFragmentList);
        }
    }

    private void handleIncludeElement(List<String> sqlFragmentList, Element element, Map<String, String> sqlElementMap) {
        String sqlValue = sqlElementMap.get(element.getAttributeValue("refid"));
        if (sqlValue != null) {
            sqlFragmentList.add(sqlValue);
        }
    }

    private void addSqlStatement(List<String> sqlFragmentList, String sqlStatement) {
        if (sqlStatement.trim().isEmpty()) {
            return;
        }
        sqlFragmentList.add(sqlStatement);
    }

    private List<String> appendSqlFragment(List<String> sqlFragmentList, boolean oneSql) {
        ArrayList<String> fullSqlList = new ArrayList<String>();
        boolean first = true;
        StringBuilder fullSql = new StringBuilder();
        String lastSqlFragment = "";
        for (int i = 0; i < sqlFragmentList.size(); ++i) {
            String formattedSqlFragment = this.formatSql(sqlFragmentList.get(i));
            if (!oneSql && fullSql.length() > 0 && this.isAnotherSql(formattedSqlFragment)) {
                fullSqlList.add(fullSql.toString());
                first = true;
                fullSql = new StringBuilder();
                lastSqlFragment = "";
            }
            if (!(first || lastSqlFragment.endsWith(" ") || formattedSqlFragment.startsWith(" "))) {
                formattedSqlFragment = " " + formattedSqlFragment;
            }
            fullSql.append(formattedSqlFragment);
            lastSqlFragment = formattedSqlFragment;
            first = false;
        }
        if (fullSql.length() > 0) {
            fullSqlList.add(fullSql.toString());
        }
        return fullSqlList;
    }

    private String formatSql(String sql) {
        String sql1 = this.hashtagValueParser.parse(sql);
        String sql2 = this.dollarValueParser.parse(sql1);
        String sql3 = this.commentMultiLineParser.parse(sql2);
        String sql4 = this.commentSingleLine1Parser.parse(sql3);
        String sql5 = this.commentSingleLine2Parser.parse(sql4);
        return this.replaceFlagInSql(sql5);
    }

    private String replaceFlagInSql(String sql) {
        return sql.replaceAll("[\r\n\t]", " ").replaceAll("[ ][ ]*", " ").trim();
    }

    private boolean isAnotherSql(String formattedSqlFragment) {
        String lowerFormattedSql = formattedSqlFragment.toLowerCase(Locale.ROOT);
        for (String mysqlDmlStatement : MYSQL_DML_SINGLE_STATEMENT) {
            if (!lowerFormattedSql.startsWith(mysqlDmlStatement)) continue;
            boolean ignore = false;
            for (String sqlColumnOperateStatement : SQL_COLUMN_OPERATE_STATEMENT) {
                if (!lowerFormattedSql.startsWith(mysqlDmlStatement + sqlColumnOperateStatement)) continue;
                ignore = true;
                break;
            }
            if (ignore) continue;
            return true;
        }
        for (String mysqlDmlStatement : MYSQL_DML_DDL_MULTI_STATEMENT) {
            if (!lowerFormattedSql.startsWith(mysqlDmlStatement)) continue;
            return true;
        }
        return false;
    }
}

