/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.mybatis_mysql_table_parser.entry;

import com.adrninistrator.mybatis_mysql_table_parser.dto.MyBatisMySqlInfo;
import com.adrninistrator.mybatis_mysql_table_parser.dto.MySqlTableInfo;
import com.adrninistrator.mybatis_mysql_table_parser.entry.AbstractEntry;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Entry4GetMyBatisMySqlTableName
extends AbstractEntry {
    private static final Logger logger = LoggerFactory.getLogger(Entry4GetMyBatisMySqlTableName.class);

    public void getTableName(String dirPath, String outputFilePath) {
        if (StringUtils.isBlank((CharSequence)dirPath) || StringUtils.isBlank((CharSequence)outputFilePath)) {
            logger.error("\u4f20\u5165\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            return;
        }
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFilePath), StandardCharsets.UTF_8));){
            this.handleDirectory(dirPath);
            HashSet<String> allTableSet = new HashSet<String>();
            for (Map.Entry entry : this.myBatisSqlInfoMap.entrySet()) {
                MyBatisMySqlInfo myBatisSqlInfo = (MyBatisMySqlInfo)entry.getValue();
                Map<String, MySqlTableInfo> mySqlTableInfoMap = myBatisSqlInfo.getMySqlTableInfoMap();
                for (Map.Entry<String, MySqlTableInfo> entry1 : mySqlTableInfoMap.entrySet()) {
                    MySqlTableInfo mySqlTableInfo = entry1.getValue();
                    allTableSet.addAll(mySqlTableInfo.getSelectTableList());
                    allTableSet.addAll(mySqlTableInfo.getSelect4UpdateTableList());
                    allTableSet.addAll(mySqlTableInfo.getInsertTableList());
                    allTableSet.addAll(mySqlTableInfo.getInsertIgnoreTableList());
                    allTableSet.addAll(mySqlTableInfo.getInsertOrUpdateTableList());
                    allTableSet.addAll(mySqlTableInfo.getReplaceTableList());
                    allTableSet.addAll(mySqlTableInfo.getUpdateTableList());
                    allTableSet.addAll(mySqlTableInfo.getDeleteTableList());
                    allTableSet.addAll(mySqlTableInfo.getAlterTableList());
                    allTableSet.addAll(mySqlTableInfo.getTruncateTableList());
                    allTableSet.addAll(mySqlTableInfo.getCreateTableList());
                    allTableSet.addAll(mySqlTableInfo.getDropTableList());
                }
            }
            this.recordTableInfo(writer, allTableSet);
        }
        catch (Exception e) {
            logger.error("error ", (Throwable)e);
        }
    }

    private void recordTableInfo(BufferedWriter writer, Set<String> allTableSet) throws IOException {
        if (allTableSet.isEmpty()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> tableList = new ArrayList<String>(allTableSet);
        Collections.sort(tableList);
        for (String table : tableList) {
            stringBuilder.append(table).append("\n");
        }
        writer.write(stringBuilder.toString());
    }
}

