/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.mybatis_mysql_table_parser.parser;

import com.adrninistrator.mybatis_mysql_table_parser.common.enums.MySqlStatementEnum;
import com.adrninistrator.mybatis_mysql_table_parser.dto.MySqlTableInfo;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLAllExpr;
import com.alibaba.druid.sql.ast.expr.SQLAnyExpr;
import com.alibaba.druid.sql.ast.expr.SQLBetweenExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLExistsExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLInSubQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLListExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLSomeExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLBlockStatement;
import com.alibaba.druid.sql.ast.statement.SQLCallStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLMergeStatement;
import com.alibaba.druid.sql.ast.statement.SQLReplaceStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSetStatement;
import com.alibaba.druid.sql.ast.statement.SQLShowTablesStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTruncateStatement;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.ast.statement.SQLUnionQueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.ast.statement.SQLValuesTableSource;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.MySqlDeclareStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlCreateTableStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlInsertStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSetTransactionStatement;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlStatementParser;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlTableParser {
    private static final Logger logger = LoggerFactory.getLogger(MySqlTableParser.class);

    public MySqlTableInfo parseTablesInSql(String fullSql) {
        MySqlTableInfo mySqlTableInfo = new MySqlTableInfo();
        try {
            MySqlStatementParser parser = new MySqlStatementParser(fullSql);
            SQLStatement sqlStatement = parser.parseStatement();
            if (sqlStatement instanceof SQLSelectStatement) {
                this.parseSelectStatement((SQLSelectStatement)sqlStatement, mySqlTableInfo);
            } else if (sqlStatement instanceof MySqlInsertStatement) {
                this.parseInsertStatement((MySqlInsertStatement)sqlStatement, mySqlTableInfo);
            } else if (sqlStatement instanceof SQLReplaceStatement) {
                this.parseReplaceStatement((SQLReplaceStatement)sqlStatement, mySqlTableInfo);
            } else if (sqlStatement instanceof SQLUpdateStatement) {
                this.parseUpdateStatement((SQLUpdateStatement)sqlStatement, mySqlTableInfo);
            } else if (sqlStatement instanceof SQLDeleteStatement) {
                this.parseDeleteStatement((SQLDeleteStatement)sqlStatement, mySqlTableInfo);
            } else if (sqlStatement instanceof SQLAlterTableStatement) {
                this.parseAlterStatement((SQLAlterTableStatement)sqlStatement, mySqlTableInfo);
            } else if (sqlStatement instanceof SQLTruncateStatement) {
                this.parseTruncateStatement((SQLTruncateStatement)sqlStatement, mySqlTableInfo);
            } else if (sqlStatement instanceof MySqlCreateTableStatement) {
                this.parseCreateStatement((MySqlCreateTableStatement)sqlStatement, mySqlTableInfo);
            } else if (sqlStatement instanceof SQLDropTableStatement) {
                this.parseDropStatement((SQLDropTableStatement)sqlStatement, mySqlTableInfo);
            } else if (!(sqlStatement instanceof SQLSetStatement || sqlStatement instanceof MySqlSetTransactionStatement || sqlStatement instanceof SQLCallStatement || sqlStatement instanceof SQLMergeStatement || sqlStatement instanceof SQLBlockStatement || sqlStatement instanceof MySqlDeclareStatement || sqlStatement instanceof SQLShowTablesStatement)) {
                logger.error("\u6682\u672a\u5904\u7406\u7684SQLStatement\u7c7b\u578b {}", (Object)sqlStatement.getClass().getName());
            }
        }
        catch (Exception e) {
            logger.error("error {} ", (Object)fullSql, (Object)e);
            mySqlTableInfo.setParseFail(true);
        }
        return mySqlTableInfo;
    }

    private void parseSelectStatement(SQLSelectStatement sqlSelectStatement, MySqlTableInfo mySqlTableInfo) {
        SQLSelect sqlSelect = sqlSelectStatement.getSelect();
        if (sqlSelect.getQuery() != null) {
            this.handleSQLSelectQuery(sqlSelect.getQuery(), mySqlTableInfo);
        }
    }

    private void handleSQLSelectQuery(SQLSelectQuery sqlSelectQuery, MySqlTableInfo mySqlTableInfo) {
        if (sqlSelectQuery instanceof SQLSelectQueryBlock) {
            SQLExpr whereSQLExpr;
            SQLSelectQueryBlock sqlSelectQueryBlock;
            SQLTableSource sqlTableSource;
            MySqlSelectQueryBlock mySqlSelectQueryBlock = null;
            if (sqlSelectQuery instanceof MySqlSelectQueryBlock) {
                mySqlSelectQueryBlock = (MySqlSelectQueryBlock)sqlSelectQuery;
            }
            if ((sqlTableSource = (sqlSelectQueryBlock = (SQLSelectQueryBlock)sqlSelectQuery).getFrom()) != null) {
                MySqlStatementEnum mySqlStatementEnum = MySqlStatementEnum.DSSE_SELECT;
                if (mySqlSelectQueryBlock != null && mySqlSelectQueryBlock.isForUpdate()) {
                    mySqlStatementEnum = MySqlStatementEnum.DSSE_SELECT_4_UPDATE;
                }
                this.handleSQLTableSource(sqlTableSource, mySqlTableInfo, mySqlStatementEnum);
            }
            if ((whereSQLExpr = sqlSelectQueryBlock.getWhere()) != null) {
                this.handleWhereSqlExpr(whereSQLExpr, mySqlTableInfo);
            }
            return;
        }
        if (sqlSelectQuery instanceof SQLUnionQuery) {
            SQLUnionQuery sqlUnionQuery = (SQLUnionQuery)sqlSelectQuery;
            for (SQLSelectQuery childSqlSelectQuery : sqlUnionQuery.getChildren()) {
                this.handleSQLSelectQuery(childSqlSelectQuery, mySqlTableInfo);
            }
            return;
        }
        if (!(sqlSelectQuery instanceof SQLValuesTableSource)) {
            logger.error("\u6682\u672a\u5904\u7406\u7684SQLSelectQuery\u7c7b\u578b {}", (Object)sqlSelectQuery.getClass().getName());
        }
    }

    private void handleWhereSqlExpr(SQLExpr whereSqlExpr, MySqlTableInfo mySqlTableInfo) {
        if (whereSqlExpr == null) {
            return;
        }
        if (whereSqlExpr instanceof SQLInSubQueryExpr) {
            SQLInSubQueryExpr sqlInSubQueryExpr = (SQLInSubQueryExpr)whereSqlExpr;
            if (sqlInSubQueryExpr.getSubQuery() != null) {
                this.handleSQLSelectQuery(sqlInSubQueryExpr.getSubQuery().getQuery(), mySqlTableInfo);
            }
            return;
        }
        if (whereSqlExpr instanceof SQLExistsExpr) {
            SQLExistsExpr sqlExistsExpr = (SQLExistsExpr)whereSqlExpr;
            if (sqlExistsExpr.getSubQuery() != null) {
                this.handleSQLSelectQuery(sqlExistsExpr.getSubQuery().getQuery(), mySqlTableInfo);
            }
            return;
        }
        if (whereSqlExpr instanceof SQLAllExpr) {
            SQLAllExpr sqlAllExpr = (SQLAllExpr)whereSqlExpr;
            if (sqlAllExpr.getSubQuery() != null) {
                this.handleSQLSelectQuery(sqlAllExpr.getSubQuery().getQuery(), mySqlTableInfo);
            }
            return;
        }
        if (whereSqlExpr instanceof SQLAnyExpr) {
            SQLAnyExpr sqlAnyExpr = (SQLAnyExpr)whereSqlExpr;
            if (sqlAnyExpr.getSubQuery() != null) {
                this.handleSQLSelectQuery(sqlAnyExpr.getSubQuery().getQuery(), mySqlTableInfo);
            }
            return;
        }
        if (whereSqlExpr instanceof SQLSomeExpr) {
            SQLSomeExpr sqlSomeExpr = (SQLSomeExpr)whereSqlExpr;
            if (sqlSomeExpr.getSubQuery() != null) {
                this.handleSQLSelectQuery(sqlSomeExpr.getSubQuery().getQuery(), mySqlTableInfo);
            }
            return;
        }
        if (!(whereSqlExpr instanceof SQLBinaryOpExpr || whereSqlExpr instanceof SQLInListExpr || whereSqlExpr instanceof SQLBetweenExpr || whereSqlExpr instanceof SQLIdentifierExpr || whereSqlExpr instanceof SQLMethodInvokeExpr || whereSqlExpr instanceof SQLVariantRefExpr)) {
            logger.error("\u6682\u672a\u5904\u7406\u7684SQLExpr\u7c7b\u578b {}", (Object)whereSqlExpr.getClass().getName());
        }
    }

    private void parseInsertStatement(MySqlInsertStatement mySqlInsertStatement, MySqlTableInfo mySqlTableInfo) {
        MySqlStatementEnum mySqlStatementEnum = MySqlStatementEnum.DSSE_INSERT;
        if (mySqlInsertStatement.isIgnore()) {
            mySqlStatementEnum = MySqlStatementEnum.DSSE_INSERT_IGNORE;
        }
        if (mySqlInsertStatement.getDuplicateKeyUpdate() != null && !mySqlInsertStatement.getDuplicateKeyUpdate().isEmpty()) {
            mySqlStatementEnum = MySqlStatementEnum.DSSE_INSERT_OR_UPDATE;
        }
        SQLExprTableSource sqlExprTableSource = mySqlInsertStatement.getTableSource();
        String tableName = sqlExprTableSource.getTableName();
        this.recordTableName(tableName, mySqlTableInfo, mySqlStatementEnum);
        if (mySqlInsertStatement.getQuery() != null) {
            this.handleSQLSelectQuery(mySqlInsertStatement.getQuery().getQuery(), mySqlTableInfo);
        }
    }

    private void parseReplaceStatement(SQLReplaceStatement sqlReplaceStatement, MySqlTableInfo mySqlTableInfo) {
        SQLExprTableSource sqlExprTableSource = sqlReplaceStatement.getTableSource();
        String tableName = sqlExprTableSource.getTableName();
        this.recordTableName(tableName, mySqlTableInfo, MySqlStatementEnum.DSSE_REPLACE);
        SQLQueryExpr sqlQueryExpr = sqlReplaceStatement.getQuery();
        if (sqlQueryExpr != null && sqlQueryExpr.getSubQuery() != null) {
            this.handleSQLSelectQuery(sqlQueryExpr.getSubQuery().getQuery(), mySqlTableInfo);
        }
    }

    private void parseUpdateStatement(SQLUpdateStatement sqlUpdateStatement, MySqlTableInfo mySqlTableInfo) {
        MySqlTableInfo updateMySqlTableInfo = new MySqlTableInfo();
        MySqlTableInfo updateUseAliasMySqlTableInfo = new MySqlTableInfo();
        SQLTableSource sqlTableSource = sqlUpdateStatement.getTableSource();
        this.handleSQLTableSource(sqlTableSource, updateMySqlTableInfo, MySqlStatementEnum.DSSE_UPDATE);
        for (Object sqlUpdateSetItem : sqlUpdateStatement.getItems()) {
            SQLExpr columnExpr = sqlUpdateSetItem.getColumn();
            if (columnExpr instanceof SQLPropertyExpr) {
                SQLPropertyExpr columnPropertyExpr = (SQLPropertyExpr)columnExpr;
                String tableAlias = columnPropertyExpr.getOwnerName();
                SQLTableSource setSqlTableSource = sqlTableSource.findTableSource(tableAlias);
                this.handleSQLTableSource(setSqlTableSource, updateUseAliasMySqlTableInfo, MySqlStatementEnum.DSSE_UPDATE);
                continue;
            }
            if (columnExpr instanceof SQLIdentifierExpr || columnExpr instanceof SQLListExpr) continue;
            logger.error("\u6682\u672a\u5904\u7406\u7684SQLExpr\u7c7b\u578b {}", (Object)columnExpr.getClass().getName());
        }
        List<String> updateUseAliasTableList = updateUseAliasMySqlTableInfo.getUpdateTableList();
        if (updateUseAliasMySqlTableInfo.getUpdateTableList().isEmpty()) {
            MySqlTableInfo.copyUpdateTableList(updateMySqlTableInfo, mySqlTableInfo);
        } else {
            for (String updateTableList : updateMySqlTableInfo.getUpdateTableList()) {
                if (updateUseAliasTableList.contains(updateTableList)) {
                    mySqlTableInfo.addUpdateTable(updateTableList);
                    continue;
                }
                mySqlTableInfo.addSelectTable(updateTableList);
            }
        }
        SQLExpr whereSQLExpr = sqlUpdateStatement.getWhere();
        if (whereSQLExpr != null) {
            this.handleWhereSqlExpr(whereSQLExpr, mySqlTableInfo);
        }
    }

    private void parseDeleteStatement(SQLDeleteStatement sqlDeleteStatement, MySqlTableInfo mySqlTableInfo) {
        SQLTableSource sqlTableSourceFrom;
        MySqlTableInfo deleteMySqlTableInfo = new MySqlTableInfo();
        MySqlTableInfo fromMySqlTableInfo = new MySqlTableInfo();
        SQLTableSource sqlTableSource = sqlDeleteStatement.getTableSource();
        if (sqlTableSource instanceof SQLExprTableSource) {
            String tableNameOrAlias;
            SQLExprTableSource sqlExprTableSource = (SQLExprTableSource)sqlTableSource;
            SQLExpr tableSourceExpr = sqlExprTableSource.getExpr();
            if (tableSourceExpr instanceof SQLIdentifierExpr) {
                SQLIdentifierExpr sqlIdentifierExpr = (SQLIdentifierExpr)tableSourceExpr;
                tableNameOrAlias = sqlIdentifierExpr.getName();
                this.recordTableName(tableNameOrAlias, deleteMySqlTableInfo, MySqlStatementEnum.DSSE_DELETE);
            } else if (tableSourceExpr instanceof SQLPropertyExpr) {
                SQLPropertyExpr sqlPropertyExpr = (SQLPropertyExpr)tableSourceExpr;
                tableNameOrAlias = sqlPropertyExpr.getOwnerName();
                this.recordTableName(tableNameOrAlias, deleteMySqlTableInfo, MySqlStatementEnum.DSSE_DELETE);
            } else if (!(tableSourceExpr instanceof SQLVariantRefExpr)) {
                logger.error("\u6682\u672a\u652f\u6301\u7684SQLExpr\u7c7b\u578b {}", (Object)tableSourceExpr.getClass().getName());
            }
        } else {
            logger.error("\u6682\u672a\u652f\u6301\u7684SQLTableSource\u7c7b\u578b {}", (Object)sqlTableSource.getClass().getName());
        }
        SQLExpr whereSQLExpr = sqlDeleteStatement.getWhere();
        if (whereSQLExpr != null) {
            this.handleWhereSqlExpr(whereSQLExpr, mySqlTableInfo);
        }
        if ((sqlTableSourceFrom = sqlDeleteStatement.getFrom()) == null) {
            MySqlTableInfo.copyDeleteTableList(deleteMySqlTableInfo, mySqlTableInfo);
            return;
        }
        this.handleSQLTableSource(sqlTableSourceFrom, fromMySqlTableInfo, MySqlStatementEnum.DSSE_SELECT);
        for (String deleteTableNameOrAlias : deleteMySqlTableInfo.getDeleteTableList()) {
            SQLTableSource deleteSqlTableSource = sqlTableSourceFrom.findTableSource(deleteTableNameOrAlias);
            if (deleteSqlTableSource == null) continue;
            this.handleSQLTableSource(deleteSqlTableSource, mySqlTableInfo, MySqlStatementEnum.DSSE_DELETE);
        }
        for (String selectTableName : fromMySqlTableInfo.getSelectTableList()) {
            if (mySqlTableInfo.getDeleteTableList().contains(selectTableName)) continue;
            mySqlTableInfo.addSelectTable(selectTableName);
        }
    }

    private void parseAlterStatement(SQLAlterTableStatement sqlAlterTableStatement, MySqlTableInfo mySqlTableInfo) {
        this.handleSQLTableSource((SQLTableSource)sqlAlterTableStatement.getTableSource(), mySqlTableInfo, MySqlStatementEnum.DSSE_ALTER);
    }

    private void parseTruncateStatement(SQLTruncateStatement sqlTruncateStatement, MySqlTableInfo mySqlTableInfo) {
        for (SQLExprTableSource sqlExprTableSource : sqlTruncateStatement.getTableSources()) {
            this.handleSQLTableSource((SQLTableSource)sqlExprTableSource, mySqlTableInfo, MySqlStatementEnum.DSSE_TRUNCATE);
        }
    }

    private void parseCreateStatement(MySqlCreateTableStatement mySqlCreateTableStatement, MySqlTableInfo mySqlTableInfo) {
        this.handleSQLTableSource((SQLTableSource)mySqlCreateTableStatement.getTableSource(), mySqlTableInfo, MySqlStatementEnum.DSSE_CREATE);
    }

    private void parseDropStatement(SQLDropTableStatement sqlDropTableStatement, MySqlTableInfo mySqlTableInfo) {
        for (SQLExprTableSource sqlExprTableSource : sqlDropTableStatement.getTableSources()) {
            this.handleSQLTableSource((SQLTableSource)sqlExprTableSource, mySqlTableInfo, MySqlStatementEnum.DSSE_DROP);
        }
    }

    private void handleSQLTableSource(SQLTableSource sqlTableSource, MySqlTableInfo mySqlTableInfo, MySqlStatementEnum mySqlStatementEnum) {
        if (sqlTableSource == null) {
            return;
        }
        if (sqlTableSource instanceof SQLExprTableSource) {
            SQLExprTableSource sqlExprTableSource = (SQLExprTableSource)sqlTableSource;
            String tableName = sqlExprTableSource.getTableName();
            this.recordTableName(tableName, mySqlTableInfo, mySqlStatementEnum);
            return;
        }
        if (sqlTableSource instanceof SQLJoinTableSource) {
            SQLTableSource rightSQLTableSource;
            SQLJoinTableSource sqlJoinTableSource = (SQLJoinTableSource)sqlTableSource;
            SQLTableSource leftSQLTableSource = sqlJoinTableSource.getLeft();
            if (leftSQLTableSource != null) {
                this.handleSQLTableSource(leftSQLTableSource, mySqlTableInfo, mySqlStatementEnum);
            }
            if ((rightSQLTableSource = sqlJoinTableSource.getRight()) != null) {
                this.handleSQLTableSource(rightSQLTableSource, mySqlTableInfo, mySqlStatementEnum);
            }
            return;
        }
        if (sqlTableSource instanceof SQLSubqueryTableSource) {
            SQLSubqueryTableSource sqlSubqueryTableSource = (SQLSubqueryTableSource)sqlTableSource;
            if (sqlSubqueryTableSource.getSelect() != null) {
                this.handleSQLSelectQuery(sqlSubqueryTableSource.getSelect().getQuery(), mySqlTableInfo);
            }
            return;
        }
        if (sqlTableSource instanceof SQLUnionQueryTableSource) {
            SQLUnionQueryTableSource sqlUnionQueryTableSource = (SQLUnionQueryTableSource)sqlTableSource;
            if (sqlUnionQueryTableSource.getUnion() != null && sqlUnionQueryTableSource.getUnion().getChildren() != null) {
                for (SQLSelectQuery sqlSelectQuery : sqlUnionQueryTableSource.getUnion().getChildren()) {
                    this.handleSQLSelectQuery(sqlSelectQuery, mySqlTableInfo);
                }
            }
            return;
        }
        logger.error("\u6682\u672a\u5904\u7406\u7684SQLTableSource\u7c7b\u578b {}", (Object)sqlTableSource.getClass().getName());
    }

    private void recordTableName(String tableName, MySqlTableInfo mySqlTableInfo, MySqlStatementEnum mySqlStatementEnum) {
        switch (mySqlStatementEnum) {
            case DSSE_SELECT: {
                mySqlTableInfo.addSelectTable(tableName);
                break;
            }
            case DSSE_SELECT_4_UPDATE: {
                mySqlTableInfo.addSelect4UpdateTable(tableName);
                break;
            }
            case DSSE_INSERT: {
                mySqlTableInfo.addInsertTable(tableName);
                break;
            }
            case DSSE_INSERT_IGNORE: {
                mySqlTableInfo.addInsertIgnoreTable(tableName);
                break;
            }
            case DSSE_INSERT_OR_UPDATE: {
                mySqlTableInfo.addInsertOrUpdateTable(tableName);
                break;
            }
            case DSSE_REPLACE: {
                mySqlTableInfo.addReplaceIntoTable(tableName);
                break;
            }
            case DSSE_UPDATE: {
                mySqlTableInfo.addUpdateTable(tableName);
                break;
            }
            case DSSE_DELETE: {
                mySqlTableInfo.addDeleteTable(tableName);
                break;
            }
            case DSSE_ALTER: {
                mySqlTableInfo.addAlterTable(tableName);
                break;
            }
            case DSSE_TRUNCATE: {
                mySqlTableInfo.addTruncateTable(tableName);
                break;
            }
            case DSSE_CREATE: {
                mySqlTableInfo.addCreateTable(tableName);
                break;
            }
            case DSSE_DROP: {
                mySqlTableInfo.addDropTable(tableName);
                break;
            }
            default: {
                logger.error("\u975e\u6cd5\u7684\u8bed\u53e5 {}", (Object)mySqlStatementEnum);
            }
        }
    }
}

