/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.mybatis_mysql_table_parser.dto;

import com.adrninistrator.mybatis_mysql_table_parser.common.enums.MySqlStatementEnum;
import com.adrninistrator.mybatis_mysql_table_parser.dto.MySQLWriteTableInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class MySqlTableInfo {
    private final Map<String, Set<String>> storedTableMap = new HashMap<String, Set<String>>();
    private final Set<String> allTableSet = new HashSet<String>();
    private final List<String> selectTableList = new ArrayList<String>();
    private final List<String> select4UpdateTableList = new ArrayList<String>();
    private final List<String> insertTableList = new ArrayList<String>();
    private final List<String> insertIgnoreTableList = new ArrayList<String>();
    private final List<String> insertOrUpdateTableList = new ArrayList<String>();
    private final List<String> replaceTableList = new ArrayList<String>();
    private List<String> updateTableList = new ArrayList<String>();
    private List<String> deleteTableList = new ArrayList<String>();
    private final List<String> alterTableList = new ArrayList<String>();
    private final List<String> truncateTableList = new ArrayList<String>();
    private final List<String> createTableList = new ArrayList<String>();
    private final List<String> dropTableList = new ArrayList<String>();
    private MySQLWriteTableInfo mySQLWriteTableInfo;
    private boolean parseFail = false;

    public static void copyUpdateTableList(MySqlTableInfo src, MySqlTableInfo dest) {
        dest.updateTableList = src.updateTableList;
        dest.mySQLWriteTableInfo = src.mySQLWriteTableInfo;
    }

    public static void copyDeleteTableList(MySqlTableInfo src, MySqlTableInfo dest) {
        dest.deleteTableList = src.deleteTableList;
        dest.mySQLWriteTableInfo = src.mySQLWriteTableInfo;
    }

    public void addAllTables(MySqlTableInfo dest) {
        Map<String, Set<String>> usedStoredTableMap = dest.storedTableMap;
        this.addAllTableList(MySqlStatementEnum.DSSE_SELECT, this.selectTableList, dest.selectTableList, usedStoredTableMap);
        this.addAllTableList(MySqlStatementEnum.DSSE_SELECT_4_UPDATE, this.select4UpdateTableList, dest.select4UpdateTableList, usedStoredTableMap);
        this.addAllTableList(MySqlStatementEnum.DSSE_INSERT, this.insertTableList, dest.insertTableList, usedStoredTableMap);
        this.addAllTableList(MySqlStatementEnum.DSSE_INSERT_IGNORE, this.insertIgnoreTableList, dest.insertIgnoreTableList, usedStoredTableMap);
        this.addAllTableList(MySqlStatementEnum.DSSE_INSERT_OR_UPDATE, this.insertOrUpdateTableList, dest.insertOrUpdateTableList, usedStoredTableMap);
        this.addAllTableList(MySqlStatementEnum.DSSE_REPLACE, this.replaceTableList, dest.replaceTableList, usedStoredTableMap);
        this.addAllTableList(MySqlStatementEnum.DSSE_UPDATE, this.updateTableList, dest.updateTableList, usedStoredTableMap);
        this.addAllTableList(MySqlStatementEnum.DSSE_DELETE, this.deleteTableList, dest.deleteTableList, usedStoredTableMap);
        this.addAllTableList(MySqlStatementEnum.DSSE_ALTER, this.alterTableList, dest.alterTableList, usedStoredTableMap);
        this.addAllTableList(MySqlStatementEnum.DSSE_TRUNCATE, this.truncateTableList, dest.truncateTableList, usedStoredTableMap);
        this.addAllTableList(MySqlStatementEnum.DSSE_CREATE, this.createTableList, dest.createTableList, usedStoredTableMap);
        this.addAllTableList(MySqlStatementEnum.DSSE_DROP, this.dropTableList, dest.dropTableList, usedStoredTableMap);
    }

    private void addAllTableList(MySqlStatementEnum mySqlStatementEnum, List<String> srcTableList, List<String> destTableList, Map<String, Set<String>> usedStoredTableMap) {
        for (String srcTable : srcTableList) {
            this.addTable(mySqlStatementEnum, srcTable, destTableList, usedStoredTableMap);
        }
    }

    private void addTable(MySqlStatementEnum mySqlStatementEnum, String tableName, List<String> tableList, Map<String, Set<String>> usedStoredTableMap) {
        Set storedTableSet = usedStoredTableMap.computeIfAbsent(mySqlStatementEnum.getType(), k -> new HashSet());
        if (storedTableSet.add(tableName)) {
            tableList.add(tableName);
        }
        this.allTableSet.add(tableName);
        if (mySqlStatementEnum.isWriteDml()) {
            this.mySQLWriteTableInfo = new MySQLWriteTableInfo(mySqlStatementEnum, tableName);
        }
    }

    public boolean isParseFail() {
        return this.parseFail;
    }

    public void setParseFail(boolean parseFail) {
        this.parseFail = parseFail;
    }

    public void addSelectTable(String tableName) {
        this.addTable(MySqlStatementEnum.DSSE_SELECT, tableName, this.selectTableList, this.storedTableMap);
    }

    public void addSelect4UpdateTable(String tableName) {
        this.addTable(MySqlStatementEnum.DSSE_SELECT_4_UPDATE, tableName, this.select4UpdateTableList, this.storedTableMap);
    }

    public void addInsertTable(String tableName) {
        this.addTable(MySqlStatementEnum.DSSE_INSERT, tableName, this.insertTableList, this.storedTableMap);
    }

    public void addInsertIgnoreTable(String tableName) {
        this.addTable(MySqlStatementEnum.DSSE_INSERT_IGNORE, tableName, this.insertIgnoreTableList, this.storedTableMap);
    }

    public void addInsertOrUpdateTable(String tableName) {
        this.addTable(MySqlStatementEnum.DSSE_INSERT_OR_UPDATE, tableName, this.insertOrUpdateTableList, this.storedTableMap);
    }

    public void addReplaceIntoTable(String tableName) {
        this.addTable(MySqlStatementEnum.DSSE_REPLACE, tableName, this.replaceTableList, this.storedTableMap);
    }

    public void addUpdateTable(String tableName) {
        this.addTable(MySqlStatementEnum.DSSE_UPDATE, tableName, this.updateTableList, this.storedTableMap);
    }

    public void addDeleteTable(String tableName) {
        this.addTable(MySqlStatementEnum.DSSE_DELETE, tableName, this.deleteTableList, this.storedTableMap);
    }

    public void addAlterTable(String tableName) {
        this.addTable(MySqlStatementEnum.DSSE_ALTER, tableName, this.alterTableList, this.storedTableMap);
    }

    public void addTruncateTable(String tableName) {
        this.addTable(MySqlStatementEnum.DSSE_TRUNCATE, tableName, this.truncateTableList, this.storedTableMap);
    }

    public void addCreateTable(String tableName) {
        this.addTable(MySqlStatementEnum.DSSE_CREATE, tableName, this.createTableList, this.storedTableMap);
    }

    public void addDropTable(String tableName) {
        this.addTable(MySqlStatementEnum.DSSE_DROP, tableName, this.dropTableList, this.storedTableMap);
    }

    private void addTableList4ToString(StringBuilder stringBuilder, String listName, List<String> list) {
        if (list.isEmpty()) {
            return;
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append(" ");
        }
        stringBuilder.append(listName).append(": ").append(StringUtils.join(list, (String)", "));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.addTableList4ToString(stringBuilder, "select", this.selectTableList);
        this.addTableList4ToString(stringBuilder, "select4Update", this.select4UpdateTableList);
        this.addTableList4ToString(stringBuilder, "insert", this.insertTableList);
        this.addTableList4ToString(stringBuilder, "insertIgnore", this.insertIgnoreTableList);
        this.addTableList4ToString(stringBuilder, "insertOrUpdate", this.insertOrUpdateTableList);
        this.addTableList4ToString(stringBuilder, "replaceInto", this.replaceTableList);
        this.addTableList4ToString(stringBuilder, "update", this.updateTableList);
        this.addTableList4ToString(stringBuilder, "delete", this.deleteTableList);
        this.addTableList4ToString(stringBuilder, "alter", this.alterTableList);
        this.addTableList4ToString(stringBuilder, "truncate", this.truncateTableList);
        this.addTableList4ToString(stringBuilder, "create", this.createTableList);
        this.addTableList4ToString(stringBuilder, "drop", this.dropTableList);
        if (this.mySQLWriteTableInfo != null) {
            stringBuilder.append(" write: ").append(this.mySQLWriteTableInfo);
        }
        return stringBuilder.toString();
    }

    public Set<String> getAllTableSet() {
        return this.allTableSet;
    }

    public List<String> getSelectTableList() {
        return this.selectTableList;
    }

    public List<String> getSelect4UpdateTableList() {
        return this.select4UpdateTableList;
    }

    public List<String> getInsertTableList() {
        return this.insertTableList;
    }

    public List<String> getInsertIgnoreTableList() {
        return this.insertIgnoreTableList;
    }

    public List<String> getInsertOrUpdateTableList() {
        return this.insertOrUpdateTableList;
    }

    public List<String> getReplaceTableList() {
        return this.replaceTableList;
    }

    public List<String> getUpdateTableList() {
        return this.updateTableList;
    }

    public List<String> getDeleteTableList() {
        return this.deleteTableList;
    }

    public List<String> getAlterTableList() {
        return this.alterTableList;
    }

    public List<String> getTruncateTableList() {
        return this.truncateTableList;
    }

    public List<String> getCreateTableList() {
        return this.createTableList;
    }

    public List<String> getDropTableList() {
        return this.dropTableList;
    }

    public MySQLWriteTableInfo getMySQLWriteTableInfo() {
        return this.mySQLWriteTableInfo;
    }
}

