/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.mybatis_mysql_table_parser.entry;

import com.adrninistrator.mybatis_mysql_table_parser.dto.MyBatisMySqlInfo;
import com.adrninistrator.mybatis_mysql_table_parser.dto.MySqlTableInfo;
import com.adrninistrator.mybatis_mysql_table_parser.parser.MyBatisXmlSqlParser;
import com.adrninistrator.mybatis_mysql_table_parser.parser.MySqlTableParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEntry {
    private static final Logger logger = LoggerFactory.getLogger(AbstractEntry.class);
    protected final MyBatisXmlSqlParser myBatisXmlSqlParser = new MyBatisXmlSqlParser();
    protected final MySqlTableParser mySqlTableParser = new MySqlTableParser();

    protected AbstractEntry() {
    }

    protected Map<String, MyBatisMySqlInfo> handleDirectory(String dirPath) {
        HashMap<String, MyBatisMySqlInfo> myBatisSqlInfoMap = new HashMap<String, MyBatisMySqlInfo>();
        this.doHandleDirectory(dirPath, myBatisSqlInfoMap);
        return myBatisSqlInfoMap;
    }

    private void doHandleDirectory(String dirPath, Map<String, MyBatisMySqlInfo> myBatisSqlInfoMap) {
        logger.debug("\u5904\u7406\u76ee\u5f55 {}", (Object)dirPath);
        File dir = new File(dirPath);
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                this.doHandleDirectory(file.getPath(), myBatisSqlInfoMap);
                continue;
            }
            String filePath = file.getPath();
            if (!StringUtils.endsWithIgnoreCase((CharSequence)filePath, (CharSequence)".xml")) continue;
            this.handleXmlFile(filePath, myBatisSqlInfoMap);
        }
    }

    protected MyBatisMySqlInfo handleXmlFile(String filePath) {
        return this.handleXmlFile(filePath, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected MyBatisMySqlInfo handleXmlFile(String filePath, Map<String, MyBatisMySqlInfo> myBatisSqlInfoMap) {
        try (FileInputStream inputStream = new FileInputStream(filePath);){
            MyBatisMySqlInfo myBatisMySqlInfo = this.handleXmlFile(inputStream, filePath, myBatisSqlInfoMap);
            return myBatisMySqlInfo;
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790sql\u8bed\u53e5\u51fa\u73b0\u5f02\u5e38 ", (Throwable)e);
            return null;
        }
    }

    protected MyBatisMySqlInfo handleXmlFile(InputStream inputStream, String filePath) {
        return this.handleXmlFile(inputStream, filePath, null);
    }

    protected MyBatisMySqlInfo handleXmlFile(InputStream inputStream, String filePath, Map<String, MyBatisMySqlInfo> myBatisSqlInfoMap) {
        logger.debug("\u5904\u7406xml\u6587\u4ef6 {}", (Object)filePath);
        try {
            MyBatisMySqlInfo myBatisSqlInfo = this.myBatisXmlSqlParser.parseMybatisXmlSql(inputStream, filePath);
            if (myBatisSqlInfo == null) {
                return null;
            }
            HashMap<String, MySqlTableInfo> mySqlTableInfoMap = new HashMap<String, MySqlTableInfo>();
            for (Map.Entry<String, List<String>> entry : myBatisSqlInfo.getFullSqlMap().entrySet()) {
                String sqlId = entry.getKey();
                List<String> fullSqlList = entry.getValue();
                for (String fullSql : fullSqlList) {
                    MySqlTableInfo mySqlTableInfo = this.mySqlTableParser.parseTablesInSql(fullSql);
                    mySqlTableInfoMap.put(sqlId, mySqlTableInfo);
                    if (!mySqlTableInfo.isParseFail()) continue;
                    logger.error("\u89e3\u6790\u5931\u8d25\t{}\t{}\t{}", new Object[]{filePath, sqlId, fullSql});
                }
            }
            myBatisSqlInfo.setMySqlTableInfoMap(mySqlTableInfoMap);
            String insertTableName = this.getPossibleTableName4MySqlTableInfo(filePath, mySqlTableInfoMap);
            myBatisSqlInfo.setPossibleTableName(insertTableName);
            if (myBatisSqlInfoMap != null) {
                myBatisSqlInfoMap.put(myBatisSqlInfo.getMapperInterfaceName(), myBatisSqlInfo);
            }
            return myBatisSqlInfo;
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790sql\u8bed\u53e5\u51fa\u73b0\u5f02\u5e38 ", (Throwable)e);
            return null;
        }
    }

    protected String getPossibleTableName4MySqlTableInfo(String filePath, Map<String, MySqlTableInfo> mySqlTableInfoMap) {
        String insertTableName;
        MySqlTableInfo insertMySqlTableInfo = mySqlTableInfoMap.get("insert");
        if (insertMySqlTableInfo != null && (insertTableName = this.getInsertTableName4List(filePath, insertMySqlTableInfo.getInsertTableList())) != null) {
            return insertTableName;
        }
        HashSet<String> allTableNameSet = new HashSet<String>();
        Iterator<Map.Entry<String, MySqlTableInfo>> iterator = mySqlTableInfoMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, MySqlTableInfo> entry = iterator.next();
            String methodName = entry.getKey();
            MySqlTableInfo mySqlTableInfo = entry.getValue();
            allTableNameSet.addAll(mySqlTableInfo.getAllTableSet());
            if (!methodName.startsWith("insert")) continue;
            String insertTableName2 = this.getInsertTableName4List(filePath, mySqlTableInfo.getInsertTableList());
            if (insertTableName2 != null) {
                return insertTableName2;
            }
            insertTableName2 = this.getInsertTableName4List(filePath, mySqlTableInfo.getInsertIgnoreTableList());
            if (insertTableName2 != null) {
                return insertTableName2;
            }
            insertTableName2 = this.getInsertTableName4List(filePath, mySqlTableInfo.getInsertOrUpdateTableList());
            if (insertTableName2 == null) continue;
            return insertTableName2;
        }
        if (allTableNameSet.size() == 1 && (iterator = allTableNameSet.iterator()).hasNext()) {
            String tableName = (String)((Object)iterator.next());
            return tableName;
        }
        return "";
    }

    private String getInsertTableName4List(String filePath, List<String> insertTableList) {
        if (insertTableList.size() == 1) {
            return insertTableList.get(0);
        }
        if (insertTableList.size() > 1) {
            logger.error("ihsert\u8bed\u53e5\u4e2d\u63d2\u5165\u4e86\u591a\u4e2a\u6570\u636e\u5e93\u8868 {} {} {}", new Object[]{filePath, "insert", StringUtils.join(insertTableList, (String)" ")});
        }
        return null;
    }
}

