/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.mybatismysqltableparser.dto;

import com.adrninistrator.mybatismysqltableparser.common.enums.MySqlStatementEnum;
import com.adrninistrator.mybatismysqltableparser.dto.MySqlSelectColumnInfo;
import com.adrninistrator.mybatismysqltableparser.dto.MySqlSetColumnInfo;
import com.adrninistrator.mybatismysqltableparser.dto.MySqlWhereColumnInfo;
import com.adrninistrator.mybatismysqltableparser.dto.MySqlWriteTableInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class MySqlTableColumnInfo {
    private final String xmlElementName;
    private final Map<String, Set<String>> storedTableMap = new HashMap<String, Set<String>>();
    private final Set<String> allTableSet = new HashSet<String>();
    private final Set<String> deleteTableAliasSet = new HashSet<String>();
    private final List<String> selectTableList = new ArrayList<String>();
    private final List<String> select4UpdateTableList = new ArrayList<String>();
    private final List<String> insertTableList = new ArrayList<String>();
    private final List<String> insertIgnoreTableList = new ArrayList<String>();
    private final List<String> insertOrUpdateTableList = new ArrayList<String>();
    private final List<String> replaceTableList = new ArrayList<String>();
    private final List<String> updateTableList = new ArrayList<String>();
    private final List<String> deleteTableList = new ArrayList<String>();
    private final List<String> alterTableList = new ArrayList<String>();
    private final List<String> truncateTableList = new ArrayList<String>();
    private final List<String> createTableList = new ArrayList<String>();
    private final List<String> dropTableList = new ArrayList<String>();
    private final List<MySqlSetColumnInfo> mySqlSetColumnInfoList = new ArrayList<MySqlSetColumnInfo>();
    private final List<MySqlWhereColumnInfo> mySqlWhereColumnInfoList = new ArrayList<MySqlWhereColumnInfo>();
    private final List<MySqlSelectColumnInfo> mySqlSelectColumnInfoList = new ArrayList<MySqlSelectColumnInfo>();
    private MySqlWriteTableInfo mySqlWriteTableInfo;
    private boolean parseFail = false;

    public MySqlTableColumnInfo() {
        this.xmlElementName = "";
    }

    public MySqlTableColumnInfo(String xmlElementName) {
        this.xmlElementName = xmlElementName;
    }

    public void copyWhereColumnList(MySqlTableColumnInfo src) {
        this.mySqlWhereColumnInfoList.addAll(src.mySqlWhereColumnInfoList);
    }

    public void copySelectColumnList(MySqlTableColumnInfo src) {
        this.mySqlSelectColumnInfoList.addAll(src.mySqlSelectColumnInfoList);
    }

    public void copySelectColumnListWithAlias(MySqlTableColumnInfo src, String dbColumnAlias) {
        for (MySqlSelectColumnInfo srcMySqlSelectColumnInfo : src.mySqlSelectColumnInfoList) {
            MySqlSelectColumnInfo destMySqlSelectColumnInfo = new MySqlSelectColumnInfo(srcMySqlSelectColumnInfo.getDbTableName(), srcMySqlSelectColumnInfo.getDbColumnName(), dbColumnAlias);
            this.mySqlSelectColumnInfoList.add(destMySqlSelectColumnInfo);
        }
    }

    public void copySelectTableList(MySqlTableColumnInfo src) {
        this.addAllTableList(MySqlStatementEnum.DSSE_SELECT, src.selectTableList, this.selectTableList);
    }

    public void copyUpdateTableList(MySqlTableColumnInfo src) {
        this.addAllTableList(MySqlStatementEnum.DSSE_UPDATE, src.updateTableList, this.updateTableList);
        this.mySqlWriteTableInfo = src.mySqlWriteTableInfo;
    }

    public void copyDeleteTableList(MySqlTableColumnInfo src) {
        this.addAllTableList(MySqlStatementEnum.DSSE_DELETE, src.deleteTableList, this.deleteTableList);
        this.mySqlWriteTableInfo = src.mySqlWriteTableInfo;
    }

    public void addAllTables(MySqlTableColumnInfo src) {
        this.addAllTableList(MySqlStatementEnum.DSSE_SELECT, src.selectTableList, this.selectTableList);
        this.addAllTableList(MySqlStatementEnum.DSSE_SELECT_4_UPDATE, src.select4UpdateTableList, this.select4UpdateTableList);
        this.addAllTableList(MySqlStatementEnum.DSSE_INSERT, src.insertTableList, this.insertTableList);
        this.addAllTableList(MySqlStatementEnum.DSSE_INSERT_IGNORE, src.insertIgnoreTableList, this.insertIgnoreTableList);
        this.addAllTableList(MySqlStatementEnum.DSSE_INSERT_OR_UPDATE, src.insertOrUpdateTableList, this.insertOrUpdateTableList);
        this.addAllTableList(MySqlStatementEnum.DSSE_REPLACE, src.replaceTableList, this.replaceTableList);
        this.addAllTableList(MySqlStatementEnum.DSSE_UPDATE, src.updateTableList, this.updateTableList);
        this.addAllTableList(MySqlStatementEnum.DSSE_DELETE, src.deleteTableList, this.deleteTableList);
        this.addAllTableList(MySqlStatementEnum.DSSE_ALTER, src.alterTableList, this.alterTableList);
        this.addAllTableList(MySqlStatementEnum.DSSE_TRUNCATE, src.truncateTableList, this.truncateTableList);
        this.addAllTableList(MySqlStatementEnum.DSSE_CREATE, src.createTableList, this.createTableList);
        this.addAllTableList(MySqlStatementEnum.DSSE_DROP, src.dropTableList, this.dropTableList);
    }

    public void addDeleteTableAliasSet(String deleteTableAlias) {
        this.deleteTableAliasSet.add(deleteTableAlias);
    }

    private void addAllTableList(MySqlStatementEnum mySqlStatementEnum, List<String> srcTableList, List<String> destTableList) {
        for (String srcTable : srcTableList) {
            this.addTable(mySqlStatementEnum, srcTable, destTableList);
        }
    }

    private void addTable(MySqlStatementEnum mySqlStatementEnum, String tableName, List<String> tableList) {
        if (tableName == null) {
            return;
        }
        Set storedTableSet = this.storedTableMap.computeIfAbsent(mySqlStatementEnum.getType(), k -> new HashSet());
        if (storedTableSet.add(tableName)) {
            tableList.add(tableName);
        }
        this.allTableSet.add(tableName);
        if (mySqlStatementEnum.isWriteDml()) {
            this.mySqlWriteTableInfo = new MySqlWriteTableInfo(mySqlStatementEnum, tableName);
        }
    }

    public boolean isParseFail() {
        return this.parseFail;
    }

    public void setParseFail(boolean parseFail) {
        this.parseFail = parseFail;
    }

    public void addSelectTable(String tableName) {
        this.addTable(MySqlStatementEnum.DSSE_SELECT, tableName, this.selectTableList);
    }

    public void addSelect4UpdateTable(String tableName) {
        this.addTable(MySqlStatementEnum.DSSE_SELECT_4_UPDATE, tableName, this.select4UpdateTableList);
    }

    public void addInsertTable(String tableName) {
        this.addTable(MySqlStatementEnum.DSSE_INSERT, tableName, this.insertTableList);
    }

    public void addInsertIgnoreTable(String tableName) {
        this.addTable(MySqlStatementEnum.DSSE_INSERT_IGNORE, tableName, this.insertIgnoreTableList);
    }

    public void addInsertOrUpdateTable(String tableName) {
        this.addTable(MySqlStatementEnum.DSSE_INSERT_OR_UPDATE, tableName, this.insertOrUpdateTableList);
    }

    public void addReplaceIntoTable(String tableName) {
        this.addTable(MySqlStatementEnum.DSSE_REPLACE, tableName, this.replaceTableList);
    }

    public void addUpdateTable(String tableName) {
        this.addTable(MySqlStatementEnum.DSSE_UPDATE, tableName, this.updateTableList);
    }

    public void addDeleteTable(String tableName) {
        this.addTable(MySqlStatementEnum.DSSE_DELETE, tableName, this.deleteTableList);
    }

    public void addAlterTable(String tableName) {
        this.addTable(MySqlStatementEnum.DSSE_ALTER, tableName, this.alterTableList);
    }

    public void addTruncateTable(String tableName) {
        this.addTable(MySqlStatementEnum.DSSE_TRUNCATE, tableName, this.truncateTableList);
    }

    public void addCreateTable(String tableName) {
        this.addTable(MySqlStatementEnum.DSSE_CREATE, tableName, this.createTableList);
    }

    public void addDropTable(String tableName) {
        this.addTable(MySqlStatementEnum.DSSE_DROP, tableName, this.dropTableList);
    }

    public void addMySqlSetColumnInfo(MySqlSetColumnInfo mySqlSetColumnInfo) {
        if (!this.mySqlSetColumnInfoList.contains(mySqlSetColumnInfo)) {
            this.mySqlSetColumnInfoList.add(mySqlSetColumnInfo);
        }
    }

    public void addMySqlWhereColumnInfo(MySqlWhereColumnInfo mySqlWhereColumnInfo) {
        if (!this.mySqlWhereColumnInfoList.contains(mySqlWhereColumnInfo)) {
            this.mySqlWhereColumnInfoList.add(mySqlWhereColumnInfo);
        }
    }

    public boolean addMySqlSelectColumnInfo(MySqlSelectColumnInfo mySqlSelectColumnInfo) {
        if (!this.mySqlSelectColumnInfoList.contains(mySqlSelectColumnInfo)) {
            this.mySqlSelectColumnInfoList.add(mySqlSelectColumnInfo);
            return true;
        }
        return false;
    }

    private void addTableList4ToString(StringBuilder stringBuilder, String listName, List<String> list) {
        if (list.isEmpty()) {
            return;
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append(" ");
        }
        stringBuilder.append(listName).append(": ").append(StringUtils.join(list, (String)", "));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.addTableList4ToString(stringBuilder, MySqlStatementEnum.DSSE_SELECT.getInitials(), this.selectTableList);
        this.addTableList4ToString(stringBuilder, MySqlStatementEnum.DSSE_SELECT_4_UPDATE.getInitials(), this.select4UpdateTableList);
        this.addTableList4ToString(stringBuilder, MySqlStatementEnum.DSSE_INSERT.getInitials(), this.insertTableList);
        this.addTableList4ToString(stringBuilder, MySqlStatementEnum.DSSE_INSERT_IGNORE.getInitials(), this.insertIgnoreTableList);
        this.addTableList4ToString(stringBuilder, MySqlStatementEnum.DSSE_INSERT_OR_UPDATE.getInitials(), this.insertOrUpdateTableList);
        this.addTableList4ToString(stringBuilder, MySqlStatementEnum.DSSE_REPLACE.getInitials(), this.replaceTableList);
        this.addTableList4ToString(stringBuilder, MySqlStatementEnum.DSSE_UPDATE.getInitials(), this.updateTableList);
        this.addTableList4ToString(stringBuilder, MySqlStatementEnum.DSSE_DELETE.getInitials(), this.deleteTableList);
        this.addTableList4ToString(stringBuilder, MySqlStatementEnum.DSSE_ALTER.getInitials(), this.alterTableList);
        this.addTableList4ToString(stringBuilder, MySqlStatementEnum.DSSE_TRUNCATE.getInitials(), this.truncateTableList);
        this.addTableList4ToString(stringBuilder, MySqlStatementEnum.DSSE_CREATE.getInitials(), this.createTableList);
        this.addTableList4ToString(stringBuilder, MySqlStatementEnum.DSSE_DROP.getInitials(), this.dropTableList);
        if (this.mySqlWriteTableInfo != null) {
            stringBuilder.append(" write: ").append(this.mySqlWriteTableInfo);
        }
        return stringBuilder.toString();
    }

    public String getXmlElementName() {
        return this.xmlElementName;
    }

    public Set<String> getAllTableSet() {
        return this.allTableSet;
    }

    public Set<String> getDeleteTableAliasSet() {
        return this.deleteTableAliasSet;
    }

    public List<String> getSelectTableList() {
        return this.selectTableList;
    }

    public List<String> getSelect4UpdateTableList() {
        return this.select4UpdateTableList;
    }

    public List<String> getInsertTableList() {
        return this.insertTableList;
    }

    public List<String> getInsertIgnoreTableList() {
        return this.insertIgnoreTableList;
    }

    public List<String> getInsertOrUpdateTableList() {
        return this.insertOrUpdateTableList;
    }

    public List<String> getReplaceTableList() {
        return this.replaceTableList;
    }

    public List<String> getUpdateTableList() {
        return this.updateTableList;
    }

    public List<String> getDeleteTableList() {
        return this.deleteTableList;
    }

    public List<String> getAlterTableList() {
        return this.alterTableList;
    }

    public List<String> getTruncateTableList() {
        return this.truncateTableList;
    }

    public List<String> getCreateTableList() {
        return this.createTableList;
    }

    public List<String> getDropTableList() {
        return this.dropTableList;
    }

    public List<MySqlSetColumnInfo> getMySqlSetColumnInfoList() {
        return this.mySqlSetColumnInfoList;
    }

    public List<MySqlWhereColumnInfo> getMySqlWhereColumnInfoList() {
        return this.mySqlWhereColumnInfoList;
    }

    public List<MySqlSelectColumnInfo> getMySqlSelectColumnInfoList() {
        return this.mySqlSelectColumnInfoList;
    }

    public MySqlWriteTableInfo getMySqlWriteTableInfo() {
        return this.mySqlWriteTableInfo;
    }
}

