/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.mybatismysqltableparser.entry;

import com.adrninistrator.mybatismysqltableparser.common.MyBatisTableParserConstants;
import com.adrninistrator.mybatismysqltableparser.dto.MyBatisMySqlInfo;
import com.adrninistrator.mybatismysqltableparser.dto.MyBatisXmlElement4Statement;
import com.adrninistrator.mybatismysqltableparser.dto.MySqlTableColumnInfo;
import com.adrninistrator.mybatismysqltableparser.parser.MyBatisXmlSqlParser;
import com.adrninistrator.mybatismysqltableparser.parser.MySqlTableColumnParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEntry {
    private static final Logger logger = LoggerFactory.getLogger(AbstractEntry.class);
    protected final MyBatisXmlSqlParser myBatisXmlSqlParser = new MyBatisXmlSqlParser();
    protected final MySqlTableColumnParser mySqlTableColumnParser = new MySqlTableColumnParser();

    protected AbstractEntry() {
    }

    protected Map<String, MyBatisMySqlInfo> handleDirectory(String dirPath) {
        HashMap<String, MyBatisMySqlInfo> myBatisSqlInfoMap = new HashMap<String, MyBatisMySqlInfo>();
        this.doHandleDirectory(dirPath, myBatisSqlInfoMap);
        return myBatisSqlInfoMap;
    }

    private void doHandleDirectory(String dirPath, Map<String, MyBatisMySqlInfo> myBatisSqlInfoMap) {
        logger.debug("\u5904\u7406\u76ee\u5f55 {}", (Object)dirPath);
        File dir = new File(dirPath);
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                this.doHandleDirectory(file.getPath(), myBatisSqlInfoMap);
                continue;
            }
            String filePath = file.getPath();
            if (!StringUtils.endsWithIgnoreCase((CharSequence)filePath, (CharSequence)".xml")) continue;
            this.handleXmlFile(filePath, myBatisSqlInfoMap);
        }
    }

    protected MyBatisMySqlInfo handleXmlFile(String xmlFilePath) {
        return this.handleXmlFile(xmlFilePath, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected MyBatisMySqlInfo handleXmlFile(String xmlFilePath, Map<String, MyBatisMySqlInfo> myBatisSqlInfoMap) {
        try (FileInputStream inputStream = new FileInputStream(xmlFilePath);){
            MyBatisMySqlInfo myBatisMySqlInfo = this.handleXmlFile(inputStream, xmlFilePath, myBatisSqlInfoMap);
            return myBatisMySqlInfo;
        }
        catch (Exception e) {
            logger.error("\u5904\u7406xml\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38 {} ", (Object)xmlFilePath, (Object)e);
            return null;
        }
    }

    protected MyBatisMySqlInfo handleXmlFile(InputStream inputStream, String xmlFilePath) {
        return this.handleXmlFile(inputStream, xmlFilePath, null);
    }

    protected MyBatisMySqlInfo handleXmlFile(InputStream inputStream, String xmlFilePath, Map<String, MyBatisMySqlInfo> myBatisSqlInfoMap) {
        logger.debug("\u5904\u7406xml\u6587\u4ef6 {}", (Object)xmlFilePath);
        try {
            MyBatisMySqlInfo myBatisSqlInfo = this.myBatisXmlSqlParser.parseMybatisXmlSql(inputStream, xmlFilePath);
            if (myBatisSqlInfo == null) {
                return null;
            }
            HashMap<String, MySqlTableColumnInfo> mySqlTableColumnInfoMap = new HashMap<String, MySqlTableColumnInfo>();
            Map<String, MyBatisXmlElement4Statement> statementMap = myBatisSqlInfo.getStatementMap();
            ArrayList<String> sqlIdList = new ArrayList<String>(statementMap.keySet());
            Collections.sort(sqlIdList);
            for (String sqlId : sqlIdList) {
                MyBatisXmlElement4Statement statement = statementMap.get(sqlId);
                List<String> fullSqlList = statement.getFullSqlList();
                for (String fullSql : fullSqlList) {
                    MySqlTableColumnInfo mySqlTableColumnInfo = this.mySqlTableColumnParser.parseTablesInSql(xmlFilePath, statement.getXmlElementName(), sqlId, fullSql);
                    mySqlTableColumnInfoMap.put(sqlId, mySqlTableColumnInfo);
                    if (!mySqlTableColumnInfo.isParseFail()) continue;
                    logger.error("\u89e3\u6790\u5931\u8d25 {} {} [{}]", new Object[]{xmlFilePath, sqlId, fullSql});
                }
            }
            myBatisSqlInfo.setMySqlTableColumnInfoMap(mySqlTableColumnInfoMap);
            String possibleTableName = this.getPossibleTableName4MySqlTableColumnInfo(xmlFilePath, mySqlTableColumnInfoMap);
            myBatisSqlInfo.setPossibleTableName(possibleTableName);
            if (myBatisSqlInfoMap != null) {
                myBatisSqlInfoMap.put(myBatisSqlInfo.getMapperInterfaceName(), myBatisSqlInfo);
            }
            return myBatisSqlInfo;
        }
        catch (Exception e) {
            String flag = e.getClass().getName().startsWith("org.jdom2.") ? "" : "\u9884\u671f\u5916\u7684\u5f02\u5e38";
            logger.error("\u5904\u7406xml\u6587\u4ef6\u51fa\u73b0\u5f02\u5e382 {} {} ", new Object[]{flag, xmlFilePath, e});
            return null;
        }
    }

    protected String getPossibleTableName4MySqlTableColumnInfo(String xmlFilePath, Map<String, MySqlTableColumnInfo> mySqlTableColumnInfoMap) {
        String insertTableName;
        MySqlTableColumnInfo mySqlTableColumnInfo;
        for (String mybatisMapperDefaultId : MyBatisTableParserConstants.MYBATIS_MAPPER_DEFAULT_ID) {
            Iterator<String> iterator;
            Set<String> allTableSet;
            mySqlTableColumnInfo = mySqlTableColumnInfoMap.get(mybatisMapperDefaultId);
            if (mySqlTableColumnInfo == null || (allTableSet = mySqlTableColumnInfo.getAllTableSet()).size() != 1 || !(iterator = allTableSet.iterator()).hasNext()) continue;
            String tableName = iterator.next();
            return tableName;
        }
        MySqlTableColumnInfo insertMySqlTableColumnInfo = mySqlTableColumnInfoMap.get("insert");
        if (insertMySqlTableColumnInfo != null && (insertTableName = this.getWriteTableName4List(xmlFilePath, insertMySqlTableColumnInfo.getInsertTableList())) != null) {
            return insertTableName;
        }
        HashSet<String> allTableSet = new HashSet<String>();
        Iterator<Map.Entry<String, MySqlTableColumnInfo>> iterator = mySqlTableColumnInfoMap.entrySet().iterator();
        while (iterator.hasNext()) {
            String updateTableName;
            Map.Entry<String, MySqlTableColumnInfo> entry = iterator.next();
            logger.debug("\u5f53\u524d\u5904\u7406\u7684sql\u8bed\u53e5\u7684id {}", (Object)entry.getKey());
            mySqlTableColumnInfo = entry.getValue();
            String xmlElementName = mySqlTableColumnInfo.getXmlElementName();
            allTableSet.addAll(mySqlTableColumnInfo.getAllTableSet());
            if (StringUtils.equalsAny((CharSequence)xmlElementName, (CharSequence[])new CharSequence[]{"insert", "update"})) {
                String insertTableName2 = this.getWriteTableName4List(xmlFilePath, mySqlTableColumnInfo.getInsertTableList());
                if (insertTableName2 != null) {
                    return insertTableName2;
                }
                insertTableName2 = this.getWriteTableName4List(xmlFilePath, mySqlTableColumnInfo.getInsertIgnoreTableList());
                if (insertTableName2 != null) {
                    return insertTableName2;
                }
                insertTableName2 = this.getWriteTableName4List(xmlFilePath, mySqlTableColumnInfo.getInsertOrUpdateTableList());
                if (insertTableName2 == null) continue;
                return insertTableName2;
            }
            if (StringUtils.equalsAny((CharSequence)xmlElementName, (CharSequence[])new CharSequence[]{"delete", "update"})) {
                String deleteTableName = this.getWriteTableName4List(xmlFilePath, mySqlTableColumnInfo.getDeleteTableList());
                if (deleteTableName == null) continue;
                return deleteTableName;
            }
            if (!"update".equals(xmlElementName) || (updateTableName = this.getWriteTableName4List(xmlFilePath, mySqlTableColumnInfo.getUpdateTableList())) == null) continue;
            return updateTableName;
        }
        if (allTableSet.size() == 1 && (iterator = allTableSet.iterator()).hasNext()) {
            String tableName = (String)((Object)iterator.next());
            return tableName;
        }
        return "";
    }

    private String getWriteTableName4List(String xmlFilePath, List<String> tableList) {
        if (tableList.size() == 1) {
            return tableList.get(0);
        }
        if (tableList.size() > 1) {
            logger.error("\u4fee\u6539\u64cd\u4f5c\u8bed\u53e5\u4e2d\u4fee\u6539\u4e86\u591a\u4e2a\u6570\u636e\u5e93\u8868 {} {}", (Object)xmlFilePath, (Object)StringUtils.join(tableList, (String)" "));
        }
        return null;
    }
}

