/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.mybatismysqltableparser.entry;

import com.adrninistrator.mybatismysqltableparser.common.enums.MySqlStatementEnum;
import com.adrninistrator.mybatismysqltableparser.dto.MyBatisMySqlInfo;
import com.adrninistrator.mybatismysqltableparser.dto.MySqlSelectColumnInfo;
import com.adrninistrator.mybatismysqltableparser.dto.MySqlSetColumnInfo;
import com.adrninistrator.mybatismysqltableparser.dto.MySqlTableColumnInfo;
import com.adrninistrator.mybatismysqltableparser.dto.MySqlWhereColumnInfo;
import com.adrninistrator.mybatismysqltableparser.entry.AbstractEntry;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Entry4GetMyBatisMySqlTableColumnDetailInfo
extends AbstractEntry {
    private static final Logger logger = LoggerFactory.getLogger(Entry4GetMyBatisMySqlTableColumnDetailInfo.class);
    public static final String FILE_NAME_TABLE_INFO = "result_table_info.md";
    public static final String FILE_NAME_WHERE_COLUMN = "result_where_column.md";
    public static final String FILE_NAME_SET_COLUMN = "result_set_column.md";
    public static final String FILE_NAME_SELECT_COLUMN = "result_select_column.md";

    public void getDetailInfo(String dirPath, String outputDirPath) {
        if (StringUtils.isBlank((CharSequence)dirPath) || StringUtils.isBlank((CharSequence)outputDirPath)) {
            logger.error("\u4f20\u5165\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            return;
        }
        File dir = new File(outputDirPath);
        if (!dir.exists() || !dir.isDirectory()) {
            logger.error("\u6307\u5b9a\u7684\u76ee\u5f55\u4e0d\u5b58\u5728\uff0c\u9700\u8981\u5148\u521b\u5efa {}", (Object)outputDirPath);
            return;
        }
        String filePath4TableInfo = outputDirPath + File.separator + FILE_NAME_TABLE_INFO;
        String filePath4WhereColumn = outputDirPath + File.separator + FILE_NAME_WHERE_COLUMN;
        String filePath4SetColumn = outputDirPath + File.separator + FILE_NAME_SET_COLUMN;
        String filePath4SelectColumn = outputDirPath + File.separator + FILE_NAME_SELECT_COLUMN;
        try (BufferedWriter writer4TableInfo = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath4TableInfo), StandardCharsets.UTF_8));
             BufferedWriter writer4WhereColumn = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath4WhereColumn), StandardCharsets.UTF_8));
             BufferedWriter writer4SetColumn = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath4SetColumn), StandardCharsets.UTF_8));
             BufferedWriter writer4SelectColumn = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath4SelectColumn), StandardCharsets.UTF_8));){
            String fileHeader4TableInfo = StringUtils.joinWith((String)"\t", (Object[])new Object[]{"# MyBatis-Mapper\u7c7b\u540d", "MyBatis-Mapper\u65b9\u6cd5\u540d", "sql\u8bed\u53e5\u7c7b\u578b", "\u6570\u636e\u5e93\u8868\u540d", "XML\u6587\u4ef6\u8def\u5f84"}) + "\n";
            writer4TableInfo.write(fileHeader4TableInfo);
            String fileHeader4WhereColumn = StringUtils.joinWith((String)"\t", (Object[])new Object[]{"# MyBatis-Mapper\u7c7b\u540d", "MyBatis-Mapper\u65b9\u6cd5\u540d", "\u6570\u636e\u5e93\u8868\u540d", "\u6570\u636e\u5e93\u5b57\u6bb5\u540d", "\u6570\u636e\u5e93\u5b57\u6bb5\u8fdb\u884c\u6bd4\u8f83\u7684\u65b9\u5f0f", "\u6570\u636e\u5e93\u5b57\u6bb5\u7528\u4e8e\u6bd4\u8f83\u7684\u53d8\u91cf\u540d", "\u6570\u636e\u5e93\u5b57\u6bb5\u7528\u4e8e\u6bd4\u8f83\u7684\u53d8\u91cf\u7684\u4f7f\u7528\u65b9\u5f0f", "XML\u6587\u4ef6\u8def\u5f84"}) + "\n";
            writer4WhereColumn.write(fileHeader4WhereColumn);
            String fileHeader4SetColumn = StringUtils.joinWith((String)"\t", (Object[])new Object[]{"# MyBatis-Mapper\u7c7b\u540d", "MyBatis-Mapper\u65b9\u6cd5\u540d", "\u6570\u636e\u5e93\u8868\u540d", "\u6570\u636e\u5e93\u5b57\u6bb5\u540d", "\u6570\u636e\u5e93\u5b57\u6bb5\u8d4b\u503c\u7684\u53d8\u91cf\u540d", "XML\u6587\u4ef6\u8def\u5f84"}) + "\n";
            writer4SetColumn.write(fileHeader4SetColumn);
            String fileHeader4SelectColumn = StringUtils.joinWith((String)"\t", (Object[])new Object[]{"# MyBatis-Mapper\u7c7b\u540d", "MyBatis-Mapper\u65b9\u6cd5\u540d", "\u6570\u636e\u5e93\u8868\u540d", "\u6570\u636e\u5e93\u5b57\u6bb5\u540d", "\u6570\u636e\u5e93\u5b57\u6bb5\u522b\u540d", "XML\u6587\u4ef6\u8def\u5f84"}) + "\n";
            writer4SelectColumn.write(fileHeader4SelectColumn);
            Map<String, MyBatisMySqlInfo> myBatisSqlInfoMap = this.handleDirectory(dirPath);
            ArrayList<String> mapperClassNameList = new ArrayList<String>(myBatisSqlInfoMap.keySet());
            Collections.sort(mapperClassNameList);
            for (String mapperClassName : mapperClassNameList) {
                MyBatisMySqlInfo myBatisSqlInfo = myBatisSqlInfoMap.get(mapperClassName);
                String xmlFilePath = myBatisSqlInfo.getXmlFilePath();
                Map<String, MySqlTableColumnInfo> mySqlTableColumnInfoMap = myBatisSqlInfo.getMySqlTableColumnInfoMap();
                ArrayList<String> mapperMethodNameList = new ArrayList<String>(mySqlTableColumnInfoMap.keySet());
                Collections.sort(mapperMethodNameList);
                for (String mapperMethodName : mapperMethodNameList) {
                    MySqlTableColumnInfo mySqlTableColumnInfo = mySqlTableColumnInfoMap.get(mapperMethodName);
                    this.recordTableInfo(writer4TableInfo, mapperClassName, mapperMethodName, MySqlStatementEnum.DSSE_SELECT, mySqlTableColumnInfo.getSelectTableList(), xmlFilePath);
                    this.recordTableInfo(writer4TableInfo, mapperClassName, mapperMethodName, MySqlStatementEnum.DSSE_SELECT_4_UPDATE, mySqlTableColumnInfo.getSelect4UpdateTableList(), xmlFilePath);
                    this.recordTableInfo(writer4TableInfo, mapperClassName, mapperMethodName, MySqlStatementEnum.DSSE_INSERT, mySqlTableColumnInfo.getInsertTableList(), xmlFilePath);
                    this.recordTableInfo(writer4TableInfo, mapperClassName, mapperMethodName, MySqlStatementEnum.DSSE_INSERT_IGNORE, mySqlTableColumnInfo.getInsertIgnoreTableList(), xmlFilePath);
                    this.recordTableInfo(writer4TableInfo, mapperClassName, mapperMethodName, MySqlStatementEnum.DSSE_INSERT_OR_UPDATE, mySqlTableColumnInfo.getInsertOrUpdateTableList(), xmlFilePath);
                    this.recordTableInfo(writer4TableInfo, mapperClassName, mapperMethodName, MySqlStatementEnum.DSSE_REPLACE, mySqlTableColumnInfo.getReplaceTableList(), xmlFilePath);
                    this.recordTableInfo(writer4TableInfo, mapperClassName, mapperMethodName, MySqlStatementEnum.DSSE_UPDATE, mySqlTableColumnInfo.getUpdateTableList(), xmlFilePath);
                    this.recordTableInfo(writer4TableInfo, mapperClassName, mapperMethodName, MySqlStatementEnum.DSSE_DELETE, mySqlTableColumnInfo.getDeleteTableList(), xmlFilePath);
                    this.recordTableInfo(writer4TableInfo, mapperClassName, mapperMethodName, MySqlStatementEnum.DSSE_ALTER, mySqlTableColumnInfo.getAlterTableList(), xmlFilePath);
                    this.recordTableInfo(writer4TableInfo, mapperClassName, mapperMethodName, MySqlStatementEnum.DSSE_TRUNCATE, mySqlTableColumnInfo.getTruncateTableList(), xmlFilePath);
                    this.recordTableInfo(writer4TableInfo, mapperClassName, mapperMethodName, MySqlStatementEnum.DSSE_CREATE, mySqlTableColumnInfo.getCreateTableList(), xmlFilePath);
                    this.recordTableInfo(writer4TableInfo, mapperClassName, mapperMethodName, MySqlStatementEnum.DSSE_DROP, mySqlTableColumnInfo.getDropTableList(), xmlFilePath);
                    this.recordColumnInfo(writer4WhereColumn, mapperClassName, mapperMethodName, mySqlTableColumnInfo.getMySqlWhereColumnInfoList(), xmlFilePath);
                    this.recordSetInfo(writer4SetColumn, mapperClassName, mapperMethodName, mySqlTableColumnInfo.getMySqlSetColumnInfoList(), xmlFilePath);
                    this.recordSelectInfo(writer4SelectColumn, mapperClassName, mapperMethodName, mySqlTableColumnInfo.getMySqlSelectColumnInfoList(), xmlFilePath);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6307\u5b9a\u76ee\u5f55\u4e2dMyBatis XML\u4e2d\u6d89\u53ca\u7684\u8868\u540d\u8be6\u7ec6\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38 ", (Throwable)e);
        }
    }

    private void recordTableInfo(BufferedWriter writer, String mapperClassName, String mapperMethodName, MySqlStatementEnum mySqlStatementEnum, List<String> tableList, String xmlFilePath) throws IOException {
        if (tableList == null || tableList.isEmpty()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Collections.sort(tableList);
        for (String table : tableList) {
            stringBuilder.append(mapperClassName).append("\t").append(mapperMethodName).append("\t").append(mySqlStatementEnum.getType()).append("\t").append(table).append("\t").append(xmlFilePath).append("\n");
        }
        writer.write(stringBuilder.toString());
    }

    private void recordColumnInfo(BufferedWriter writer, String mapperClassName, String mapperMethodName, List<MySqlWhereColumnInfo> whereColumnInfoList, String xmlFilePath) throws IOException {
        if (whereColumnInfoList.isEmpty()) {
            return;
        }
        whereColumnInfoList.sort(Comparator.comparing(MySqlWhereColumnInfo::getDbTableName).thenComparing(MySqlWhereColumnInfo::getDbColumnName));
        StringBuilder stringBuilder = new StringBuilder();
        for (MySqlWhereColumnInfo whereColumnInfo : whereColumnInfoList) {
            stringBuilder.append(mapperClassName).append("\t").append(mapperMethodName).append("\t").append(whereColumnInfo.getDbTableName()).append("\t").append(whereColumnInfo.getDbColumnName()).append("\t").append(whereColumnInfo.getOperation()).append("\t").append(whereColumnInfo.getParameterName()).append("\t").append(whereColumnInfo.getParameterType()).append("\t").append(xmlFilePath).append("\n");
        }
        writer.write(stringBuilder.toString());
    }

    private void recordSetInfo(BufferedWriter writer, String mapperClassName, String mapperMethodName, List<MySqlSetColumnInfo> setColumnInfoList, String xmlFilePath) throws IOException {
        if (setColumnInfoList.isEmpty()) {
            return;
        }
        setColumnInfoList.sort(Comparator.comparing(MySqlSetColumnInfo::getDbTableName).thenComparing(MySqlSetColumnInfo::getDbColumnName));
        StringBuilder stringBuilder = new StringBuilder();
        for (MySqlSetColumnInfo mySqlSetColumnInfo : setColumnInfoList) {
            stringBuilder.append(mapperClassName).append("\t").append(mapperMethodName).append("\t").append(mySqlSetColumnInfo.getDbTableName()).append("\t").append(mySqlSetColumnInfo.getDbColumnName()).append("\t").append(mySqlSetColumnInfo.getParameterName()).append("\t").append(xmlFilePath).append("\n");
        }
        writer.write(stringBuilder.toString());
    }

    private void recordSelectInfo(BufferedWriter writer, String mapperClassName, String mapperMethodName, List<MySqlSelectColumnInfo> mySqlSelectColumnInfoList, String xmlFilePath) throws IOException {
        if (mySqlSelectColumnInfoList.isEmpty()) {
            return;
        }
        mySqlSelectColumnInfoList.sort(Comparator.comparing(MySqlSelectColumnInfo::getDbTableName).thenComparing(MySqlSelectColumnInfo::getDbColumnName));
        StringBuilder stringBuilder = new StringBuilder();
        for (MySqlSelectColumnInfo mySqlSelectColumnInfo : mySqlSelectColumnInfoList) {
            stringBuilder.append(mapperClassName).append("\t").append(mapperMethodName).append("\t").append(mySqlSelectColumnInfo.getDbTableName()).append("\t").append(mySqlSelectColumnInfo.getDbColumnName()).append("\t").append(mySqlSelectColumnInfo.getDbColumnAlias()).append("\t").append(xmlFilePath).append("\n");
        }
        writer.write(stringBuilder.toString());
    }
}

