/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.mybatismysqltableparser.entry;

import com.adrninistrator.mybatismysqltableparser.common.enums.MySqlStatementEnum;
import com.adrninistrator.mybatismysqltableparser.dto.MyBatisMySqlInfo;
import com.adrninistrator.mybatismysqltableparser.dto.MySqlTableColumnInfo;
import com.adrninistrator.mybatismysqltableparser.entry.AbstractEntry;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Entry4GetMyBatisMySqlTableInfo
extends AbstractEntry {
    private static final Logger logger = LoggerFactory.getLogger(Entry4GetMyBatisMySqlTableInfo.class);

    public void getTableInfo(String dirPath, String outputFilePath) {
        if (StringUtils.isBlank((CharSequence)dirPath) || StringUtils.isBlank((CharSequence)outputFilePath)) {
            logger.error("\u4f20\u5165\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            return;
        }
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFilePath), StandardCharsets.UTF_8));){
            String fileHeader = "# sql\u8bed\u53e5\u7c7b\u578b\t\u6570\u636e\u5e93\u8868\u540d\n";
            writer.write(fileHeader);
            Map<String, MyBatisMySqlInfo> myBatisSqlInfoMap = this.handleDirectory(dirPath);
            MySqlTableColumnInfo allMySqlTableColumnInfo = new MySqlTableColumnInfo();
            for (Map.Entry<String, MyBatisMySqlInfo> entry : myBatisSqlInfoMap.entrySet()) {
                MyBatisMySqlInfo myBatisSqlInfo = entry.getValue();
                Map<String, MySqlTableColumnInfo> mySqlTableColumnInfoMap = myBatisSqlInfo.getMySqlTableColumnInfoMap();
                for (Map.Entry<String, MySqlTableColumnInfo> entry1 : mySqlTableColumnInfoMap.entrySet()) {
                    MySqlTableColumnInfo mySqlTableColumnInfo = entry1.getValue();
                    allMySqlTableColumnInfo.addAllTables(mySqlTableColumnInfo);
                }
            }
            this.recordTableInfo(writer, MySqlStatementEnum.DSSE_SELECT, allMySqlTableColumnInfo.getSelectTableList());
            this.recordTableInfo(writer, MySqlStatementEnum.DSSE_SELECT_4_UPDATE, allMySqlTableColumnInfo.getSelect4UpdateTableList());
            this.recordTableInfo(writer, MySqlStatementEnum.DSSE_INSERT, allMySqlTableColumnInfo.getInsertTableList());
            this.recordTableInfo(writer, MySqlStatementEnum.DSSE_INSERT_IGNORE, allMySqlTableColumnInfo.getInsertIgnoreTableList());
            this.recordTableInfo(writer, MySqlStatementEnum.DSSE_INSERT_OR_UPDATE, allMySqlTableColumnInfo.getInsertOrUpdateTableList());
            this.recordTableInfo(writer, MySqlStatementEnum.DSSE_REPLACE, allMySqlTableColumnInfo.getReplaceTableList());
            this.recordTableInfo(writer, MySqlStatementEnum.DSSE_UPDATE, allMySqlTableColumnInfo.getUpdateTableList());
            this.recordTableInfo(writer, MySqlStatementEnum.DSSE_DELETE, allMySqlTableColumnInfo.getDeleteTableList());
            this.recordTableInfo(writer, MySqlStatementEnum.DSSE_ALTER, allMySqlTableColumnInfo.getAlterTableList());
            this.recordTableInfo(writer, MySqlStatementEnum.DSSE_TRUNCATE, allMySqlTableColumnInfo.getTruncateTableList());
            this.recordTableInfo(writer, MySqlStatementEnum.DSSE_CREATE, allMySqlTableColumnInfo.getCreateTableList());
            this.recordTableInfo(writer, MySqlStatementEnum.DSSE_DROP, allMySqlTableColumnInfo.getDropTableList());
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6307\u5b9a\u76ee\u5f55\u4e2dMyBatis XML\u4e2d\u6d89\u53ca\u7684\u5168\u90e8MySQL\u8868\u540d\u53ca\u5bf9\u5e94\u7684sql\u8bed\u53e5\u51fa\u73b0\u5f02\u5e38 ", (Throwable)e);
        }
    }

    private void recordTableInfo(BufferedWriter writer, MySqlStatementEnum mySqlStatementEnum, List<String> tableList) throws IOException {
        if (tableList.isEmpty()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Collections.sort(tableList);
        for (String table : tableList) {
            stringBuilder.append(mySqlStatementEnum.getType()).append("\t").append(table).append("\n");
        }
        writer.write(stringBuilder.toString());
    }
}

