/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.mybatismysqltableparser.entry;

import com.adrninistrator.mybatismysqltableparser.dto.MyBatisMySqlInfo;
import com.adrninistrator.mybatismysqltableparser.dto.MySqlTableColumnInfo;
import com.adrninistrator.mybatismysqltableparser.entry.AbstractEntry;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Entry4GetMyBatisMySqlTableName
extends AbstractEntry {
    private static final Logger logger = LoggerFactory.getLogger(Entry4GetMyBatisMySqlTableName.class);

    public void getTableName(String dirPath, String outputFilePath) {
        if (StringUtils.isBlank((CharSequence)dirPath) || StringUtils.isBlank((CharSequence)outputFilePath)) {
            logger.error("\u4f20\u5165\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            return;
        }
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFilePath), StandardCharsets.UTF_8));){
            Map<String, MyBatisMySqlInfo> myBatisSqlInfoMap = this.handleDirectory(dirPath);
            HashSet<String> allTableSet = new HashSet<String>();
            for (Map.Entry<String, MyBatisMySqlInfo> entry : myBatisSqlInfoMap.entrySet()) {
                MyBatisMySqlInfo myBatisSqlInfo = entry.getValue();
                Map<String, MySqlTableColumnInfo> mySqlTableColumnInfoMap = myBatisSqlInfo.getMySqlTableColumnInfoMap();
                for (Map.Entry<String, MySqlTableColumnInfo> entry1 : mySqlTableColumnInfoMap.entrySet()) {
                    MySqlTableColumnInfo mySqlTableColumnInfo = entry1.getValue();
                    allTableSet.addAll(mySqlTableColumnInfo.getSelectTableList());
                    allTableSet.addAll(mySqlTableColumnInfo.getSelect4UpdateTableList());
                    allTableSet.addAll(mySqlTableColumnInfo.getInsertTableList());
                    allTableSet.addAll(mySqlTableColumnInfo.getInsertIgnoreTableList());
                    allTableSet.addAll(mySqlTableColumnInfo.getInsertOrUpdateTableList());
                    allTableSet.addAll(mySqlTableColumnInfo.getReplaceTableList());
                    allTableSet.addAll(mySqlTableColumnInfo.getUpdateTableList());
                    allTableSet.addAll(mySqlTableColumnInfo.getDeleteTableList());
                    allTableSet.addAll(mySqlTableColumnInfo.getAlterTableList());
                    allTableSet.addAll(mySqlTableColumnInfo.getTruncateTableList());
                    allTableSet.addAll(mySqlTableColumnInfo.getCreateTableList());
                    allTableSet.addAll(mySqlTableColumnInfo.getDropTableList());
                }
            }
            this.recordTableInfo(writer, allTableSet);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6307\u5b9a\u76ee\u5f55\u4e2dMyBatis XML\u4e2d\u6d89\u53ca\u7684\u5168\u90e8MySQL\u8868\u540d\u51fa\u73b0\u5f02\u5e38 ", (Throwable)e);
        }
    }

    private void recordTableInfo(BufferedWriter writer, Set<String> allTableSet) throws IOException {
        if (allTableSet.isEmpty()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> tableList = new ArrayList<String>(allTableSet);
        Collections.sort(tableList);
        for (String table : tableList) {
            stringBuilder.append(table).append("\n");
        }
        writer.write(stringBuilder.toString());
    }
}

