/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.mybatismysqltableparser.parser;

import com.adrninistrator.mybatismysqltableparser.common.enums.MySqlStatementEnum;
import com.adrninistrator.mybatismysqltableparser.dto.MySqlSelectColumnInfo;
import com.adrninistrator.mybatismysqltableparser.dto.MySqlSetColumnInfo;
import com.adrninistrator.mybatismysqltableparser.dto.MySqlTableColumnInfo;
import com.adrninistrator.mybatismysqltableparser.dto.ParameterNameAndType;
import com.adrninistrator.mybatismysqltableparser.dto.TableAndColumnName;
import com.adrninistrator.mybatismysqltableparser.util.MyBatisTableParserUtil;
import com.adrninistrator.mybatismysqltableparser.visitor.SQLBinaryOpExprVisitor;
import com.adrninistrator.mybatismysqltableparser.visitor.SQLExprTableSourceMultiVisitor;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.expr.SQLAllExpr;
import com.alibaba.druid.sql.ast.expr.SQLAnyExpr;
import com.alibaba.druid.sql.ast.expr.SQLBetweenExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLCaseExpr;
import com.alibaba.druid.sql.ast.expr.SQLCastExpr;
import com.alibaba.druid.sql.ast.expr.SQLExistsExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLInSubQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLListExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLSomeExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLBlockStatement;
import com.alibaba.druid.sql.ast.statement.SQLCallStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLMergeStatement;
import com.alibaba.druid.sql.ast.statement.SQLReplaceStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSetStatement;
import com.alibaba.druid.sql.ast.statement.SQLShowTablesStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTruncateStatement;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.ast.statement.SQLUnionQueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.ast.statement.SQLValuesTableSource;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.MySqlDeclareStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlCreateTableStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlInsertStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlOptimizeStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSetTransactionStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowProfilesStatement;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlStatementParser;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlTableColumnParser {
    private static final Logger logger = LoggerFactory.getLogger(MySqlTableColumnParser.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MySqlTableColumnInfo parseTablesInSql(String xmlFilePath, String xmlElementName, String sqlId, String fullSql) {
        String xmlFileName = MyBatisTableParserUtil.getFileNameFromPath(xmlFilePath);
        MyBatisTableParserUtil.recordCurrentXmlFileName(xmlFileName);
        MyBatisTableParserUtil.recordCurrentSqlID(sqlId);
        MyBatisTableParserUtil.recordCurrentSql(fullSql);
        MySqlTableColumnInfo mySqlTableColumnInfo = new MySqlTableColumnInfo(xmlElementName);
        try {
            MySqlStatementParser parser = new MySqlStatementParser(fullSql);
            SQLStatement sqlStatement = parser.parseStatement();
            if (sqlStatement instanceof SQLSelectStatement) {
                this.parseSelectStatement((SQLSelectStatement)sqlStatement, mySqlTableColumnInfo);
                this.addOtherSelectTable((SQLObject)sqlStatement, mySqlTableColumnInfo);
            } else if (sqlStatement instanceof MySqlInsertStatement) {
                this.parseInsertStatement((MySqlInsertStatement)sqlStatement, mySqlTableColumnInfo);
                this.addOtherSelectTable((SQLObject)sqlStatement, mySqlTableColumnInfo);
            } else if (sqlStatement instanceof SQLReplaceStatement) {
                this.parseReplaceStatement((SQLReplaceStatement)sqlStatement, mySqlTableColumnInfo);
                this.addOtherSelectTable((SQLObject)sqlStatement, mySqlTableColumnInfo);
            } else if (sqlStatement instanceof SQLUpdateStatement) {
                this.parseUpdateStatement((SQLUpdateStatement)sqlStatement, mySqlTableColumnInfo);
                this.addOtherSelectTable((SQLObject)sqlStatement, mySqlTableColumnInfo);
            } else if (sqlStatement instanceof SQLDeleteStatement) {
                SQLDeleteStatement sqlDeleteStatement = (SQLDeleteStatement)sqlStatement;
                this.parseDeleteStatement(sqlDeleteStatement, mySqlTableColumnInfo);
                this.addOtherSelectTable((SQLObject)sqlDeleteStatement, mySqlTableColumnInfo);
                SQLTableSource deleteFromSQLTableSource = sqlDeleteStatement.getFrom();
                if (deleteFromSQLTableSource != null) {
                    this.addOtherSelectTable((SQLObject)deleteFromSQLTableSource, mySqlTableColumnInfo);
                }
            } else if (sqlStatement instanceof SQLAlterTableStatement) {
                this.parseAlterStatement((SQLAlterTableStatement)sqlStatement, mySqlTableColumnInfo);
            } else if (sqlStatement instanceof SQLTruncateStatement) {
                this.parseTruncateStatement((SQLTruncateStatement)sqlStatement, mySqlTableColumnInfo);
            } else if (sqlStatement instanceof MySqlCreateTableStatement) {
                this.parseCreateStatement((MySqlCreateTableStatement)sqlStatement, mySqlTableColumnInfo);
            } else if (sqlStatement instanceof SQLDropTableStatement) {
                this.parseDropStatement((SQLDropTableStatement)sqlStatement, mySqlTableColumnInfo);
            } else if (sqlStatement instanceof MySqlOptimizeStatement) {
                this.parseOptimizeStatement((MySqlOptimizeStatement)sqlStatement, mySqlTableColumnInfo);
            } else if (!(sqlStatement instanceof SQLSetStatement || sqlStatement instanceof MySqlSetTransactionStatement || sqlStatement instanceof SQLCallStatement || sqlStatement instanceof SQLMergeStatement || sqlStatement instanceof SQLBlockStatement || sqlStatement instanceof MySqlDeclareStatement || sqlStatement instanceof SQLShowTablesStatement || sqlStatement instanceof MySqlShowProfilesStatement)) {
                logger.error("\u6682\u672a\u5904\u7406\u7684SQLStatement\u7c7b\u578b {}  [{}] [{}] [{}] [{}]", new Object[]{sqlStatement.getClass().getName(), sqlStatement, MyBatisTableParserUtil.getCurrentXmlFileName(), MyBatisTableParserUtil.getCurrentSqlID(), MyBatisTableParserUtil.getCurrentSql()});
            }
        }
        catch (ParserException e) {
            logger.error("\u89e3\u6790sql\u8bed\u53e5\u51fa\u73b0\u5f02\u5e38 [{}] [{}] [{}] {}", new Object[]{xmlFilePath, sqlId, fullSql, e.getMessage()});
            mySqlTableColumnInfo.setParseFail(true);
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790sql\u8bed\u53e5\u51fa\u73b0\u5f02\u5e382 [{}] [{}] [{}] ", new Object[]{xmlFilePath, sqlId, fullSql, e});
            mySqlTableColumnInfo.setParseFail(true);
        }
        finally {
            MyBatisTableParserUtil.clearThreadLocal();
        }
        return mySqlTableColumnInfo;
    }

    private void parseSelectStatement(SQLSelectStatement sqlSelectStatement, MySqlTableColumnInfo mySqlTableColumnInfo) {
        SQLSelect sqlSelect = sqlSelectStatement.getSelect();
        if (sqlSelect.getQuery() != null) {
            this.handleSQLSelectQuery(sqlSelect.getQuery(), mySqlTableColumnInfo);
        }
    }

    public void handleSQLSelectQuery(SQLSelectQuery sqlSelectQuery, MySqlTableColumnInfo mySqlTableColumnInfo) {
        if (sqlSelectQuery instanceof SQLSelectQueryBlock) {
            SQLExpr whereSQLExpr;
            MySqlSelectQueryBlock mySqlSelectQueryBlock = null;
            if (sqlSelectQuery instanceof MySqlSelectQueryBlock) {
                mySqlSelectQueryBlock = (MySqlSelectQueryBlock)sqlSelectQuery;
            }
            SQLSelectQueryBlock sqlSelectQueryBlock = (SQLSelectQueryBlock)sqlSelectQuery;
            this.handleSelectColumn(sqlSelectQueryBlock, mySqlTableColumnInfo);
            SQLTableSource sqlTableSource = sqlSelectQueryBlock.getFrom();
            if (sqlTableSource != null) {
                MySqlStatementEnum mySqlStatementEnum = MySqlStatementEnum.DSSE_SELECT;
                if (mySqlSelectQueryBlock != null && mySqlSelectQueryBlock.isForUpdate()) {
                    mySqlStatementEnum = MySqlStatementEnum.DSSE_SELECT_4_UPDATE;
                }
                this.handleSQLTableSource(sqlTableSource, mySqlTableColumnInfo, mySqlStatementEnum);
            }
            if ((whereSQLExpr = sqlSelectQueryBlock.getWhere()) != null) {
                this.handleWhereSqlExpr(whereSQLExpr, mySqlTableColumnInfo);
            }
            return;
        }
        if (sqlSelectQuery instanceof SQLUnionQuery) {
            SQLUnionQuery sqlUnionQuery = (SQLUnionQuery)sqlSelectQuery;
            for (SQLSelectQuery childSqlSelectQuery : sqlUnionQuery.getChildren()) {
                this.handleSQLSelectQuery(childSqlSelectQuery, mySqlTableColumnInfo);
            }
            return;
        }
        if (!(sqlSelectQuery instanceof SQLValuesTableSource)) {
            logger.error("\u6682\u672a\u5904\u7406\u7684SQLSelectQuery\u7c7b\u578b {} [{}] [{}] [{}] [{}]", new Object[]{sqlSelectQuery.getClass().getName(), sqlSelectQuery, MyBatisTableParserUtil.getCurrentXmlFileName(), MyBatisTableParserUtil.getCurrentSqlID(), MyBatisTableParserUtil.getCurrentSql()});
        }
    }

    private void handleSelectColumn(SQLSelectQueryBlock sqlSelectQueryBlock, MySqlTableColumnInfo mySqlTableColumnInfo) {
        for (SQLSelectItem sqlSelectItem : sqlSelectQueryBlock.getSelectList()) {
            Object sqlQueryMySqlTableColumnInfo;
            String dbColumnAlias = StringUtils.defaultString((String)sqlSelectItem.getAlias(), (String)"");
            SQLExpr sqlExpr = sqlSelectItem.getExpr();
            if (sqlExpr instanceof SQLIdentifierExpr || sqlExpr instanceof SQLPropertyExpr) {
                this.handleSelectTableColumnExpr(sqlExpr, sqlSelectQueryBlock, dbColumnAlias, mySqlTableColumnInfo);
                continue;
            }
            if (sqlExpr instanceof SQLAllColumnExpr) {
                this.recordSelectAllSelectColumn(sqlSelectQueryBlock.getFrom(), mySqlTableColumnInfo);
                continue;
            }
            if (sqlExpr instanceof SQLQueryExpr) {
                SQLQueryExpr sqlQueryExpr = (SQLQueryExpr)sqlExpr;
                sqlQueryMySqlTableColumnInfo = new MySqlTableColumnInfo();
                this.handleSQLSelectQuery(sqlQueryExpr.getSubQuery().getQuery(), (MySqlTableColumnInfo)sqlQueryMySqlTableColumnInfo);
                mySqlTableColumnInfo.copySelectTableList((MySqlTableColumnInfo)sqlQueryMySqlTableColumnInfo);
                mySqlTableColumnInfo.copyWhereColumnList((MySqlTableColumnInfo)sqlQueryMySqlTableColumnInfo);
                mySqlTableColumnInfo.copySelectColumnListWithAlias((MySqlTableColumnInfo)sqlQueryMySqlTableColumnInfo, dbColumnAlias);
                continue;
            }
            if (sqlExpr instanceof SQLCaseExpr) {
                SQLCaseExpr sqlCaseExpr = (SQLCaseExpr)sqlExpr;
                for (SQLCaseExpr.Item item : sqlCaseExpr.getItems()) {
                    this.handleSelectTableColumnExpr(item.getValueExpr(), sqlSelectQueryBlock, dbColumnAlias, mySqlTableColumnInfo);
                }
                SQLExpr caseElseExpr = sqlCaseExpr.getElseExpr();
                if (caseElseExpr == null) continue;
                this.handleSelectTableColumnExpr(caseElseExpr, sqlSelectQueryBlock, dbColumnAlias, mySqlTableColumnInfo);
                continue;
            }
            if (sqlExpr instanceof SQLCastExpr) {
                SQLExpr sqlExpr2 = ((SQLCastExpr)sqlExpr).getExpr();
                this.handleSelectTableColumnExpr(sqlExpr2, sqlSelectQueryBlock, dbColumnAlias, mySqlTableColumnInfo);
                continue;
            }
            if (sqlExpr instanceof SQLExistsExpr) {
                SQLExistsExpr sqlExistsExpr = (SQLExistsExpr)sqlExpr;
                sqlQueryMySqlTableColumnInfo = new MySqlTableColumnInfo();
                this.handleSQLSelectQuery(sqlExistsExpr.getSubQuery().getQuery(), (MySqlTableColumnInfo)sqlQueryMySqlTableColumnInfo);
                mySqlTableColumnInfo.copySelectTableList((MySqlTableColumnInfo)sqlQueryMySqlTableColumnInfo);
                mySqlTableColumnInfo.copyWhereColumnList((MySqlTableColumnInfo)sqlQueryMySqlTableColumnInfo);
                continue;
            }
            if (MyBatisTableParserUtil.checkIgnoreSelectColumnExprType(sqlExpr)) continue;
            logger.error("\u6682\u672a\u5904\u7406\u7684SQLExpr\u7c7b\u578b {} [{}] [{}] [{}] [{}]", new Object[]{sqlExpr.getClass().getName(), sqlExpr, MyBatisTableParserUtil.getCurrentXmlFileName(), MyBatisTableParserUtil.getCurrentSqlID(), MyBatisTableParserUtil.getCurrentSql()});
        }
    }

    private void handleSelectTableColumnExpr(SQLExpr sqlExpr, SQLSelectQueryBlock sqlSelectQueryBlock, String dbColumnAlias, MySqlTableColumnInfo mySqlTableColumnInfo) {
        if (sqlExpr instanceof SQLIdentifierExpr) {
            SQLIdentifierExpr sqlIdentifierExpr = (SQLIdentifierExpr)sqlExpr;
            String dbColumnName = sqlIdentifierExpr.getName();
            String dbTableName = MyBatisTableParserUtil.getTableNameFromTableSource(sqlSelectQueryBlock.getFrom(), "");
            MySqlSelectColumnInfo mySqlSelectColumnInfo = new MySqlSelectColumnInfo(dbTableName, dbColumnName, dbColumnAlias);
            mySqlTableColumnInfo.addMySqlSelectColumnInfo(mySqlSelectColumnInfo);
            return;
        }
        if (sqlExpr instanceof SQLPropertyExpr) {
            SQLPropertyExpr sqlPropertyExpr = (SQLPropertyExpr)sqlExpr;
            String dbColumnName = sqlPropertyExpr.getName();
            if ("*".equals(dbColumnName)) {
                this.recordSelectAllSelectColumn(sqlSelectQueryBlock.getFrom(), mySqlTableColumnInfo);
                return;
            }
            String dbTableAlias = sqlPropertyExpr.getOwnerName();
            String dbTableName = MyBatisTableParserUtil.getTableNameFromTableSource(sqlSelectQueryBlock.getFrom(), dbTableAlias);
            MySqlSelectColumnInfo mySqlSelectColumnInfo = new MySqlSelectColumnInfo(dbTableName, dbColumnName, dbColumnAlias);
            mySqlTableColumnInfo.addMySqlSelectColumnInfo(mySqlSelectColumnInfo);
            return;
        }
        if (sqlExpr instanceof SQLQueryExpr) {
            SQLQueryExpr sqlQueryExpr = (SQLQueryExpr)sqlExpr;
            this.handleSQLSelectQuery(sqlQueryExpr.getSubQuery().getQuery(), mySqlTableColumnInfo);
            return;
        }
        if (sqlExpr instanceof SQLCaseExpr) {
            SQLCaseExpr sqlCaseExpr = (SQLCaseExpr)sqlExpr;
            for (SQLCaseExpr.Item item : sqlCaseExpr.getItems()) {
                this.handleSelectTableColumnExpr(item.getValueExpr(), sqlSelectQueryBlock, dbColumnAlias, mySqlTableColumnInfo);
            }
            SQLExpr caseElseExpr = sqlCaseExpr.getElseExpr();
            if (caseElseExpr != null) {
                this.handleSelectTableColumnExpr(caseElseExpr, sqlSelectQueryBlock, dbColumnAlias, mySqlTableColumnInfo);
            }
            return;
        }
        if (sqlExpr instanceof SQLCastExpr) {
            SQLExpr sqlExpr2 = ((SQLCastExpr)sqlExpr).getExpr();
            this.handleSelectTableColumnExpr(sqlExpr2, sqlSelectQueryBlock, dbColumnAlias, mySqlTableColumnInfo);
            return;
        }
        if (!MyBatisTableParserUtil.checkIgnoreSelectColumnExprType(sqlExpr)) {
            logger.error("\u6682\u672a\u5904\u7406\u7684SQLExpr\u7c7b\u578b {} [{}] [{}] [{}] [{}]", new Object[]{sqlExpr.getClass().getName(), sqlExpr, MyBatisTableParserUtil.getCurrentXmlFileName(), MyBatisTableParserUtil.getCurrentSqlID(), MyBatisTableParserUtil.getCurrentSql()});
        }
    }

    private void recordSelectAllSelectColumn(SQLTableSource fromAllTableSource, MySqlTableColumnInfo mySqlTableColumnInfo) {
        MySqlTableColumnInfo selectAllMySqlTableColumnInfo = new MySqlTableColumnInfo();
        this.handleSelectAllTableSource(fromAllTableSource, selectAllMySqlTableColumnInfo, null);
        for (MySqlSelectColumnInfo mySqlSelectColumnInfo : selectAllMySqlTableColumnInfo.getMySqlSelectColumnInfoList()) {
            if (!mySqlTableColumnInfo.addMySqlSelectColumnInfo(mySqlSelectColumnInfo)) continue;
        }
    }

    private void handleSelectAllTableSource(SQLTableSource fromAllTableSource, MySqlTableColumnInfo mySqlTableColumnInfo, Set<String> expectedTableAliasSet) {
        if (fromAllTableSource instanceof SQLSubqueryTableSource) {
            SQLSubqueryTableSource fromAllSubQuery = (SQLSubqueryTableSource)fromAllTableSource;
            SQLSelectQuery fromAllSubQuerySQLSelectQuery = fromAllSubQuery.getSelect().getQuery();
            this.handleSQLSelectQuery(fromAllSubQuerySQLSelectQuery, mySqlTableColumnInfo);
        } else if (fromAllTableSource instanceof SQLJoinTableSource) {
            SQLJoinTableSource fromAllSQLJoinTableSource = (SQLJoinTableSource)fromAllTableSource;
            HashSet<String> usedSelectTableAliasSet = new HashSet<String>();
            SQLObject parent = fromAllTableSource.getParent();
            if (parent instanceof MySqlSelectQueryBlock) {
                Set<String> selectTableAliasSet = MyBatisTableParserUtil.getSelectAllTableAliasSet((MySqlSelectQueryBlock)parent);
                usedSelectTableAliasSet.addAll(selectTableAliasSet);
            }
            this.handleSelectAllTableSource(fromAllSQLJoinTableSource.getLeft(), mySqlTableColumnInfo, usedSelectTableAliasSet);
            this.handleSelectAllTableSource(fromAllSQLJoinTableSource.getRight(), mySqlTableColumnInfo, usedSelectTableAliasSet);
        } else if (fromAllTableSource instanceof SQLUnionQueryTableSource) {
            SQLUnionQueryTableSource fromAllSQLUnionQueryTableSource = (SQLUnionQueryTableSource)fromAllTableSource;
            SQLUnionQuery sqlUnionQuery = fromAllSQLUnionQueryTableSource.getUnion();
            this.handleSQLSelectQuery((SQLSelectQuery)sqlUnionQuery, mySqlTableColumnInfo);
        } else if (fromAllTableSource instanceof SQLExprTableSource) {
            SQLExprTableSource fromAllSQLExprTableSource = (SQLExprTableSource)fromAllTableSource;
            if (expectedTableAliasSet == null || expectedTableAliasSet.isEmpty() || expectedTableAliasSet.contains(fromAllSQLExprTableSource.getAlias())) {
                String dbTableName = MyBatisTableParserUtil.getTableNameFromTableSource((SQLTableSource)fromAllSQLExprTableSource, "");
                MySqlSelectColumnInfo mySqlSelectColumnInfo = new MySqlSelectColumnInfo(dbTableName, "*", "");
                mySqlTableColumnInfo.addMySqlSelectColumnInfo(mySqlSelectColumnInfo);
            } else {
                ArrayList<String> expectedTableAliasList = new ArrayList<String>(expectedTableAliasSet);
                Collections.sort(expectedTableAliasList);
                logger.info("select * \u9884\u671f\u7684\u8868\u522b\u540d\u4e0e\u5b9e\u9645\u7684\u4e0d\u76f8\u540c\uff0c\u4e0d\u8bb0\u5f55 [{}] [{}] [{}] [{}] [{}] ", new Object[]{StringUtils.join(expectedTableAliasList, (String)" "), fromAllSQLExprTableSource.getAlias(), MyBatisTableParserUtil.getCurrentXmlFileName(), MyBatisTableParserUtil.getCurrentSqlID(), MyBatisTableParserUtil.getCurrentSql()});
            }
        } else {
            logger.error("\u6682\u672a\u5904\u7406\u7684SQLTableSource\u7c7b\u578b {} [{}] [{}] [{}] [{}]", new Object[]{fromAllTableSource.getClass().getName(), fromAllTableSource, MyBatisTableParserUtil.getCurrentXmlFileName(), MyBatisTableParserUtil.getCurrentSqlID(), MyBatisTableParserUtil.getCurrentSql()});
        }
    }

    private void handleWhereSqlExpr(SQLExpr whereSqlExpr, MySqlTableColumnInfo mySqlTableColumnInfo) {
        if (whereSqlExpr == null) {
            return;
        }
        if (whereSqlExpr instanceof SQLBinaryOpExpr) {
            SQLBinaryOpExprVisitor sqlBinaryOpExprVisitor = new SQLBinaryOpExprVisitor(mySqlTableColumnInfo);
            whereSqlExpr.accept((SQLASTVisitor)sqlBinaryOpExprVisitor);
            return;
        }
        if (whereSqlExpr instanceof SQLInSubQueryExpr) {
            SQLInSubQueryExpr sqlInSubQueryExpr = (SQLInSubQueryExpr)whereSqlExpr;
            if (sqlInSubQueryExpr.getSubQuery() != null) {
                this.handleSQLSelectQuery(sqlInSubQueryExpr.getSubQuery().getQuery(), mySqlTableColumnInfo);
            }
            return;
        }
        if (whereSqlExpr instanceof SQLExistsExpr) {
            SQLExistsExpr sqlExistsExpr = (SQLExistsExpr)whereSqlExpr;
            if (sqlExistsExpr.getSubQuery() != null) {
                this.handleSQLSelectQuery(sqlExistsExpr.getSubQuery().getQuery(), mySqlTableColumnInfo);
            }
            return;
        }
        if (whereSqlExpr instanceof SQLAllExpr) {
            SQLAllExpr sqlAllExpr = (SQLAllExpr)whereSqlExpr;
            if (sqlAllExpr.getSubQuery() != null) {
                this.handleSQLSelectQuery(sqlAllExpr.getSubQuery().getQuery(), mySqlTableColumnInfo);
            }
            return;
        }
        if (whereSqlExpr instanceof SQLAnyExpr) {
            SQLAnyExpr sqlAnyExpr = (SQLAnyExpr)whereSqlExpr;
            if (sqlAnyExpr.getSubQuery() != null) {
                this.handleSQLSelectQuery(sqlAnyExpr.getSubQuery().getQuery(), mySqlTableColumnInfo);
            }
            return;
        }
        if (whereSqlExpr instanceof SQLSomeExpr) {
            SQLSomeExpr sqlSomeExpr = (SQLSomeExpr)whereSqlExpr;
            if (sqlSomeExpr.getSubQuery() != null) {
                this.handleSQLSelectQuery(sqlSomeExpr.getSubQuery().getQuery(), mySqlTableColumnInfo);
            }
            return;
        }
        if (!(whereSqlExpr instanceof SQLInListExpr || whereSqlExpr instanceof SQLBetweenExpr || whereSqlExpr instanceof SQLIdentifierExpr || whereSqlExpr instanceof SQLMethodInvokeExpr || whereSqlExpr instanceof SQLVariantRefExpr)) {
            logger.error("\u6682\u672a\u5904\u7406\u7684SQLExpr\u7c7b\u578b {} [{}] [{}] [{}] [{}]", new Object[]{whereSqlExpr.getClass().getName(), whereSqlExpr, MyBatisTableParserUtil.getCurrentXmlFileName(), MyBatisTableParserUtil.getCurrentSqlID(), MyBatisTableParserUtil.getCurrentSql()});
        }
    }

    private void parseInsertStatement(MySqlInsertStatement mySqlInsertStatement, MySqlTableColumnInfo mySqlTableColumnInfo) {
        MySqlStatementEnum mySqlStatementEnum = MySqlStatementEnum.DSSE_INSERT;
        if (mySqlInsertStatement.isIgnore()) {
            mySqlStatementEnum = MySqlStatementEnum.DSSE_INSERT_IGNORE;
        }
        if (mySqlInsertStatement.getDuplicateKeyUpdate() != null && !mySqlInsertStatement.getDuplicateKeyUpdate().isEmpty()) {
            mySqlStatementEnum = MySqlStatementEnum.DSSE_INSERT_OR_UPDATE;
        }
        SQLExprTableSource sqlExprTableSource = mySqlInsertStatement.getTableSource();
        String tableName = MyBatisTableParserUtil.getTableNameFromTableSource((SQLTableSource)sqlExprTableSource);
        this.recordTableName(tableName, mySqlTableColumnInfo, mySqlStatementEnum);
        if (mySqlInsertStatement.getQuery() != null) {
            this.handleSQLSelectQuery(mySqlInsertStatement.getQuery().getQuery(), mySqlTableColumnInfo);
        }
    }

    private void parseReplaceStatement(SQLReplaceStatement sqlReplaceStatement, MySqlTableColumnInfo mySqlTableColumnInfo) {
        SQLExprTableSource sqlExprTableSource = sqlReplaceStatement.getTableSource();
        String tableName = MyBatisTableParserUtil.getTableNameFromTableSource((SQLTableSource)sqlExprTableSource);
        this.recordTableName(tableName, mySqlTableColumnInfo, MySqlStatementEnum.DSSE_REPLACE);
        SQLQueryExpr sqlQueryExpr = sqlReplaceStatement.getQuery();
        if (sqlQueryExpr != null && sqlQueryExpr.getSubQuery() != null) {
            this.handleSQLSelectQuery(sqlQueryExpr.getSubQuery().getQuery(), mySqlTableColumnInfo);
        }
    }

    private void parseUpdateStatement(SQLUpdateStatement sqlUpdateStatement, MySqlTableColumnInfo mySqlTableColumnInfo) {
        MySqlTableColumnInfo updateMySqlTableColumnInfo = new MySqlTableColumnInfo();
        MySqlTableColumnInfo updateUseAliasMySqlTableColumnInfo = new MySqlTableColumnInfo();
        SQLTableSource sqlTableSource = sqlUpdateStatement.getTableSource();
        this.handleSQLTableSource(sqlTableSource, updateMySqlTableColumnInfo, MySqlStatementEnum.DSSE_UPDATE);
        for (Object sqlUpdateSetItem : sqlUpdateStatement.getItems()) {
            SQLExpr updateSetColumnExpr;
            SQLExpr updateSetValueExpr = sqlUpdateSetItem.getValue();
            if (updateSetValueExpr instanceof SQLVariantRefExpr) {
                this.handleUpdateSetColumn(sqlUpdateSetItem.getColumn(), (SQLVariantRefExpr)updateSetValueExpr, mySqlTableColumnInfo, sqlTableSource);
            }
            if ((updateSetColumnExpr = sqlUpdateSetItem.getColumn()) instanceof SQLPropertyExpr) {
                SQLPropertyExpr columnPropertyExpr = (SQLPropertyExpr)updateSetColumnExpr;
                String tableAlias = columnPropertyExpr.getOwnerName();
                SQLTableSource setSqlTableSource = sqlTableSource.findTableSource(tableAlias);
                this.handleSQLTableSource(setSqlTableSource, updateUseAliasMySqlTableColumnInfo, MySqlStatementEnum.DSSE_UPDATE);
                continue;
            }
            if (updateSetColumnExpr instanceof SQLIdentifierExpr || updateSetColumnExpr instanceof SQLListExpr) continue;
            logger.error("\u6682\u672a\u5904\u7406\u7684SQLExpr\u7c7b\u578b {} [{}] [{}] [{}] [{}]", new Object[]{updateSetColumnExpr.getClass().getName(), updateSetColumnExpr, MyBatisTableParserUtil.getCurrentXmlFileName(), MyBatisTableParserUtil.getCurrentSqlID(), MyBatisTableParserUtil.getCurrentSql()});
        }
        List<String> updateUseAliasTableList = updateUseAliasMySqlTableColumnInfo.getUpdateTableList();
        if (updateUseAliasMySqlTableColumnInfo.getUpdateTableList().isEmpty()) {
            mySqlTableColumnInfo.copyUpdateTableList(updateMySqlTableColumnInfo);
        } else {
            for (String updateTableList : updateMySqlTableColumnInfo.getUpdateTableList()) {
                if (updateUseAliasTableList.contains(updateTableList)) {
                    mySqlTableColumnInfo.addUpdateTable(updateTableList);
                    continue;
                }
                mySqlTableColumnInfo.addSelectTable(updateTableList);
            }
        }
        SQLExpr whereSQLExpr = sqlUpdateStatement.getWhere();
        if (whereSQLExpr != null) {
            this.handleWhereSqlExpr(whereSQLExpr, mySqlTableColumnInfo);
        }
    }

    private void parseDeleteStatement(SQLDeleteStatement sqlDeleteStatement, MySqlTableColumnInfo mySqlTableColumnInfo) {
        SQLExpr whereSQLExpr = sqlDeleteStatement.getWhere();
        if (whereSQLExpr != null) {
            this.handleWhereSqlExpr(whereSQLExpr, mySqlTableColumnInfo);
        }
        SQLTableSource sqlTableSource = sqlDeleteStatement.getTableSource();
        SQLTableSource fromSQLTableSource = sqlDeleteStatement.getFrom();
        if (sqlTableSource instanceof SQLExprTableSource) {
            SQLExprTableSource sqlExprTableSource = (SQLExprTableSource)sqlTableSource;
            SQLExpr tableSourceExpr = sqlExprTableSource.getExpr();
            if (tableSourceExpr instanceof SQLIdentifierExpr) {
                SQLIdentifierExpr sqlIdentifierExpr = (SQLIdentifierExpr)tableSourceExpr;
                this.recordDeleteTableName(sqlIdentifierExpr.getName(), fromSQLTableSource, mySqlTableColumnInfo);
            } else if (tableSourceExpr instanceof SQLPropertyExpr) {
                SQLPropertyExpr sqlPropertyExpr = (SQLPropertyExpr)tableSourceExpr;
                this.recordDeleteTableName(sqlPropertyExpr.getOwnerName(), fromSQLTableSource, mySqlTableColumnInfo);
            } else if (tableSourceExpr instanceof SQLVariantRefExpr) {
                SQLVariantRefExpr sqlVariantRefExpr = (SQLVariantRefExpr)tableSourceExpr;
                this.recordTableName(sqlVariantRefExpr.getName(), mySqlTableColumnInfo, MySqlStatementEnum.DSSE_DELETE);
            } else {
                logger.error("\u6682\u672a\u5904\u7406\u7684SQLExpr\u7c7b\u578b {} [{}] [{}] [{}] [{}]", new Object[]{tableSourceExpr.getClass().getName(), tableSourceExpr, MyBatisTableParserUtil.getCurrentXmlFileName(), MyBatisTableParserUtil.getCurrentSqlID(), MyBatisTableParserUtil.getCurrentSql()});
            }
            return;
        }
        if (!(sqlTableSource instanceof SQLJoinTableSource)) {
            logger.error("\u6682\u672a\u5904\u7406\u7684SQLTableSource\u7c7b\u578b {} [{}] [{}] [{}] [{}]", new Object[]{sqlTableSource.getClass().getName(), sqlTableSource, MyBatisTableParserUtil.getCurrentXmlFileName(), MyBatisTableParserUtil.getCurrentSqlID(), MyBatisTableParserUtil.getCurrentSql()});
        }
    }

    private void recordDeleteTableName(String tableNameOrAlias, SQLTableSource fromSQLTableSource, MySqlTableColumnInfo mySqlTableColumnInfo) {
        String tableName;
        if (fromSQLTableSource != null && !tableNameOrAlias.equals(tableName = MyBatisTableParserUtil.getTableNameFromTableSource(fromSQLTableSource, tableNameOrAlias))) {
            mySqlTableColumnInfo.addDeleteTableAliasSet(tableNameOrAlias);
            tableNameOrAlias = tableName;
        }
        this.recordTableName(tableNameOrAlias, mySqlTableColumnInfo, MySqlStatementEnum.DSSE_DELETE);
    }

    private void parseAlterStatement(SQLAlterTableStatement sqlAlterTableStatement, MySqlTableColumnInfo mySqlTableColumnInfo) {
        this.handleSQLTableSource((SQLTableSource)sqlAlterTableStatement.getTableSource(), mySqlTableColumnInfo, MySqlStatementEnum.DSSE_ALTER);
    }

    private void parseTruncateStatement(SQLTruncateStatement sqlTruncateStatement, MySqlTableColumnInfo mySqlTableColumnInfo) {
        for (SQLExprTableSource sqlExprTableSource : sqlTruncateStatement.getTableSources()) {
            this.handleSQLTableSource((SQLTableSource)sqlExprTableSource, mySqlTableColumnInfo, MySqlStatementEnum.DSSE_TRUNCATE);
        }
    }

    private void parseCreateStatement(MySqlCreateTableStatement mySqlCreateTableStatement, MySqlTableColumnInfo mySqlTableColumnInfo) {
        this.handleSQLTableSource((SQLTableSource)mySqlCreateTableStatement.getTableSource(), mySqlTableColumnInfo, MySqlStatementEnum.DSSE_CREATE);
    }

    private void parseDropStatement(SQLDropTableStatement sqlDropTableStatement, MySqlTableColumnInfo mySqlTableColumnInfo) {
        for (SQLExprTableSource sqlExprTableSource : sqlDropTableStatement.getTableSources()) {
            this.handleSQLTableSource((SQLTableSource)sqlExprTableSource, mySqlTableColumnInfo, MySqlStatementEnum.DSSE_DROP);
        }
    }

    private void parseOptimizeStatement(MySqlOptimizeStatement mySqlOptimizeStatement, MySqlTableColumnInfo mySqlTableColumnInfo) {
        for (SQLExprTableSource sqlExprTableSource : mySqlOptimizeStatement.getTableSources()) {
            this.handleSQLTableSource((SQLTableSource)sqlExprTableSource, mySqlTableColumnInfo, MySqlStatementEnum.DSSE_OPTIMIZE);
        }
    }

    private void handleSQLTableSource(SQLTableSource sqlTableSource, MySqlTableColumnInfo mySqlTableColumnInfo, MySqlStatementEnum mySqlStatementEnum) {
        if (sqlTableSource == null) {
            return;
        }
        if (sqlTableSource instanceof SQLExprTableSource) {
            SQLExprTableSource sqlExprTableSource = (SQLExprTableSource)sqlTableSource;
            String tableName = MyBatisTableParserUtil.getTableNameFromTableSource((SQLTableSource)sqlExprTableSource);
            this.recordTableName(tableName, mySqlTableColumnInfo, mySqlStatementEnum);
            return;
        }
        if (sqlTableSource instanceof SQLJoinTableSource) {
            SQLTableSource rightSQLTableSource;
            SQLJoinTableSource sqlJoinTableSource = (SQLJoinTableSource)sqlTableSource;
            SQLTableSource leftSQLTableSource = sqlJoinTableSource.getLeft();
            if (leftSQLTableSource != null) {
                this.handleSQLTableSource(leftSQLTableSource, mySqlTableColumnInfo, mySqlStatementEnum);
            }
            if ((rightSQLTableSource = sqlJoinTableSource.getRight()) != null) {
                this.handleSQLTableSource(rightSQLTableSource, mySqlTableColumnInfo, mySqlStatementEnum);
            }
            return;
        }
        if (sqlTableSource instanceof SQLSubqueryTableSource) {
            SQLSubqueryTableSource sqlSubqueryTableSource = (SQLSubqueryTableSource)sqlTableSource;
            if (sqlSubqueryTableSource.getSelect() != null) {
                this.handleSQLSelectQuery(sqlSubqueryTableSource.getSelect().getQuery(), mySqlTableColumnInfo);
            }
            return;
        }
        if (sqlTableSource instanceof SQLUnionQueryTableSource) {
            SQLUnionQueryTableSource sqlUnionQueryTableSource = (SQLUnionQueryTableSource)sqlTableSource;
            if (sqlUnionQueryTableSource.getUnion() != null && sqlUnionQueryTableSource.getUnion().getChildren() != null) {
                for (SQLSelectQuery sqlSelectQuery : sqlUnionQueryTableSource.getUnion().getChildren()) {
                    this.handleSQLSelectQuery(sqlSelectQuery, mySqlTableColumnInfo);
                }
            }
            return;
        }
        logger.error("\u6682\u672a\u5904\u7406\u7684SQLTableSource\u7c7b\u578b {} [{}] [{}] [{}] [{}]", new Object[]{sqlTableSource.getClass().getName(), sqlTableSource, MyBatisTableParserUtil.getCurrentXmlFileName(), MyBatisTableParserUtil.getCurrentSqlID(), MyBatisTableParserUtil.getCurrentSql()});
    }

    private void handleUpdateSetColumn(SQLExpr updateSetColumnExpr, SQLVariantRefExpr updateSetValueExpr, MySqlTableColumnInfo mySqlTableColumnInfo, SQLTableSource sqlTableSource) {
        List<TableAndColumnName> tableAndColumnNameList = MyBatisTableParserUtil.genTableAndColumnName(updateSetColumnExpr, sqlTableSource);
        ParameterNameAndType parameterNameAndType = MyBatisTableParserUtil.genParameterNameAndType(updateSetValueExpr);
        for (TableAndColumnName tableAndColumnName : tableAndColumnNameList) {
            mySqlTableColumnInfo.addMySqlSetColumnInfo(new MySqlSetColumnInfo(tableAndColumnName.getTableName(), tableAndColumnName.getColumnName(), parameterNameAndType.getParameterName()));
        }
    }

    private void addOtherSelectTable(SQLObject sqlObject, MySqlTableColumnInfo mySqlTableColumnInfo) {
        SQLExprTableSourceMultiVisitor sqlExprTableSourceMultiVisitor = new SQLExprTableSourceMultiVisitor();
        sqlObject.accept((SQLASTVisitor)sqlExprTableSourceMultiVisitor);
        List<String> tableNameList = sqlExprTableSourceMultiVisitor.getTableNameList();
        for (String tableName : tableNameList) {
            if (mySqlTableColumnInfo.getAllTableSet().contains(tableName) || mySqlTableColumnInfo.getDeleteTableAliasSet().contains(tableName)) continue;
            mySqlTableColumnInfo.addSelectTable(tableName);
        }
    }

    private void recordTableName(String tableName, MySqlTableColumnInfo mySqlTableColumnInfo, MySqlStatementEnum mySqlStatementEnum) {
        switch (mySqlStatementEnum) {
            case DSSE_SELECT: {
                mySqlTableColumnInfo.addSelectTable(tableName);
                break;
            }
            case DSSE_SELECT_4_UPDATE: {
                mySqlTableColumnInfo.addSelect4UpdateTable(tableName);
                break;
            }
            case DSSE_INSERT: {
                mySqlTableColumnInfo.addInsertTable(tableName);
                break;
            }
            case DSSE_INSERT_IGNORE: {
                mySqlTableColumnInfo.addInsertIgnoreTable(tableName);
                break;
            }
            case DSSE_INSERT_OR_UPDATE: {
                mySqlTableColumnInfo.addInsertOrUpdateTable(tableName);
                break;
            }
            case DSSE_REPLACE: {
                mySqlTableColumnInfo.addReplaceIntoTable(tableName);
                break;
            }
            case DSSE_UPDATE: {
                mySqlTableColumnInfo.addUpdateTable(tableName);
                break;
            }
            case DSSE_DELETE: {
                mySqlTableColumnInfo.addDeleteTable(tableName);
                break;
            }
            case DSSE_ALTER: {
                mySqlTableColumnInfo.addAlterTable(tableName);
                break;
            }
            case DSSE_TRUNCATE: {
                mySqlTableColumnInfo.addTruncateTable(tableName);
                break;
            }
            case DSSE_CREATE: {
                mySqlTableColumnInfo.addCreateTable(tableName);
                break;
            }
            case DSSE_DROP: {
                mySqlTableColumnInfo.addDropTable(tableName);
                break;
            }
            default: {
                logger.error("\u975e\u6cd5\u7684\u8bed\u53e5 {}", (Object)mySqlStatementEnum);
            }
        }
    }
}

