/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.mybatismysqltableparser.util;

import com.adrninistrator.mybatismysqltableparser.dto.ParameterName;
import com.adrninistrator.mybatismysqltableparser.dto.ParameterNameAndType;
import com.adrninistrator.mybatismysqltableparser.dto.TableAndColumnName;
import com.adrninistrator.mybatismysqltableparser.visitor.SQLExprTableSourceVisitor;
import com.alibaba.druid.sql.ast.SQLCurrentTimeExpr;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLCaseExpr;
import com.alibaba.druid.sql.ast.expr.SQLCastExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumericLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLSequenceExpr;
import com.alibaba.druid.sql.ast.expr.SQLTextLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLUnaryExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlDeleteStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlUpdateStatement;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyBatisTableParserUtil {
    private static final Logger logger = LoggerFactory.getLogger(MyBatisTableParserUtil.class);
    private static final ThreadLocal<String> THREAD_LOCAL_CURRENT_XML_FILE_NAME = new ThreadLocal();
    private static final ThreadLocal<String> THREAD_LOCAL_CURRENT_SQL_ID = new ThreadLocal();
    private static final ThreadLocal<String> THREAD_LOCAL_CURRENT_SQL = new ThreadLocal();

    public static void recordCurrentXmlFileName(String sql) {
        THREAD_LOCAL_CURRENT_XML_FILE_NAME.set(sql);
    }

    public static String getCurrentXmlFileName() {
        return StringUtils.defaultString((String)THREAD_LOCAL_CURRENT_XML_FILE_NAME.get(), (String)"");
    }

    public static void recordCurrentSqlID(String sql) {
        THREAD_LOCAL_CURRENT_SQL_ID.set(sql);
    }

    public static String getCurrentSqlID() {
        return StringUtils.defaultString((String)THREAD_LOCAL_CURRENT_SQL_ID.get(), (String)"");
    }

    public static void recordCurrentSql(String sql) {
        THREAD_LOCAL_CURRENT_SQL.set(sql);
    }

    public static String getCurrentSql() {
        return StringUtils.defaultString((String)THREAD_LOCAL_CURRENT_SQL.get(), (String)"");
    }

    public static void clearThreadLocal() {
        THREAD_LOCAL_CURRENT_XML_FILE_NAME.remove();
        THREAD_LOCAL_CURRENT_SQL_ID.remove();
        THREAD_LOCAL_CURRENT_SQL.remove();
    }

    public static String getFileNameFromPath(String filePath) {
        String fileName = StringUtils.substringAfterLast((String)filePath, (String)"/");
        if (StringUtils.isNotBlank((CharSequence)fileName)) {
            return fileName;
        }
        fileName = StringUtils.substringAfterLast((String)filePath, (String)"\\");
        if (StringUtils.isNotBlank((CharSequence)fileName)) {
            return fileName;
        }
        return filePath;
    }

    public static String getTableNameFromTableSource(SQLTableSource sqlTableSource) {
        SQLExprTableSourceVisitor sqlExprTableSourceVisitor = new SQLExprTableSourceVisitor();
        sqlTableSource.accept((SQLASTVisitor)sqlExprTableSourceVisitor);
        return sqlExprTableSourceVisitor.getTableName();
    }

    public static String getTableNameFromTableSource(SQLTableSource sqlTableSource, String tableAlias) {
        if (sqlTableSource == null) {
            logger.error("\u4f20\u5165\u7684SQLTableSource\u4e3a\u7a7a [{}] [{}] [{}] [{}]", new Object[]{tableAlias, MyBatisTableParserUtil.getCurrentXmlFileName(), MyBatisTableParserUtil.getCurrentSqlID(), MyBatisTableParserUtil.getCurrentSql()});
            return "";
        }
        if (StringUtils.isBlank((CharSequence)tableAlias)) {
            return MyBatisTableParserUtil.getTableNameFromTableSource(sqlTableSource);
        }
        SQLTableSource sqlTableSourceUseAlias = sqlTableSource.findTableSource(tableAlias);
        if (sqlTableSourceUseAlias == null) {
            logger.error("\u4eceSQLTableSource\u4e2d\u6839\u636e\u8868\u522b\u540d\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u8868 [{}] [{}] [{}] [{}] [{}]", new Object[]{sqlTableSource, tableAlias, MyBatisTableParserUtil.getCurrentXmlFileName(), MyBatisTableParserUtil.getCurrentSqlID(), MyBatisTableParserUtil.getCurrentSql()});
            return "";
        }
        return MyBatisTableParserUtil.getTableNameFromTableSource(sqlTableSourceUseAlias);
    }

    public static List<TableAndColumnName> genTableAndColumnName(SQLExpr columnExpr, SQLTableSource sqlTableSource) {
        if (columnExpr instanceof SQLIdentifierExpr) {
            String tableName = MyBatisTableParserUtil.getTableNameFromTableSource(sqlTableSource);
            String columnName = ((SQLIdentifierExpr)columnExpr).getName();
            return Collections.singletonList(new TableAndColumnName(tableName, columnName));
        }
        if (columnExpr instanceof SQLPropertyExpr) {
            SQLPropertyExpr sqlPropertyExprLeft = (SQLPropertyExpr)columnExpr;
            String tableName = MyBatisTableParserUtil.getTableNameFromTableSource(sqlTableSource, sqlPropertyExprLeft.getOwnerName());
            String columnName = sqlPropertyExprLeft.getName();
            return Collections.singletonList(new TableAndColumnName(tableName, columnName));
        }
        if (columnExpr instanceof SQLVariantRefExpr) {
            SQLVariantRefExpr sqlVariantRefExpr = (SQLVariantRefExpr)columnExpr;
            String tableName = MyBatisTableParserUtil.getTableNameFromTableSource(sqlTableSource, null);
            String columnName = sqlVariantRefExpr.getName();
            return Collections.singletonList(new TableAndColumnName(tableName, columnName));
        }
        if (columnExpr instanceof SQLCastExpr) {
            SQLCastExpr sqlCastExpr = (SQLCastExpr)columnExpr;
            return MyBatisTableParserUtil.genTableAndColumnName(sqlCastExpr.getExpr(), sqlTableSource);
        }
        if (columnExpr instanceof SQLCaseExpr) {
            ArrayList<TableAndColumnName> tableAndColumnNameList = new ArrayList<TableAndColumnName>();
            SQLCaseExpr sqlCaseExpr = (SQLCaseExpr)columnExpr;
            for (SQLCaseExpr.Item item : sqlCaseExpr.getItems()) {
                List<TableAndColumnName> tableAndColumnNameListTmp = MyBatisTableParserUtil.genTableAndColumnName(item.getValueExpr(), sqlTableSource);
                for (TableAndColumnName tableAndColumnName : tableAndColumnNameListTmp) {
                    if (tableAndColumnNameList.contains(tableAndColumnName)) continue;
                    tableAndColumnNameList.add(tableAndColumnName);
                }
            }
            SQLExpr caseElseExpr = sqlCaseExpr.getElseExpr();
            if (caseElseExpr != null) {
                List<TableAndColumnName> tableAndColumnNameListTmp = MyBatisTableParserUtil.genTableAndColumnName(caseElseExpr, sqlTableSource);
                for (TableAndColumnName tableAndColumnName : tableAndColumnNameListTmp) {
                    if (tableAndColumnNameList.contains(tableAndColumnName)) continue;
                    tableAndColumnNameList.add(tableAndColumnName);
                }
            }
            return tableAndColumnNameList;
        }
        if (!(columnExpr instanceof SQLTextLiteralExpr || columnExpr instanceof SQLBinaryOpExpr || columnExpr instanceof SQLMethodInvokeExpr || columnExpr instanceof SQLCurrentTimeExpr)) {
            logger.error("\u6682\u672a\u5904\u7406\u7684\u5b57\u6bb5\u7c7b\u578b {} [{}] [{}] [{}] [{}]", new Object[]{columnExpr.getClass().getName(), columnExpr, MyBatisTableParserUtil.getCurrentXmlFileName(), MyBatisTableParserUtil.getCurrentSqlID(), MyBatisTableParserUtil.getCurrentSql()});
        }
        return Collections.emptyList();
    }

    public static ParameterNameAndType genParameterNameAndType(SQLVariantRefExpr valueExpr) {
        String parameterType;
        String parameterName;
        String rightName = valueExpr.getName();
        if (rightName.startsWith("${")) {
            parameterName = StringUtils.substringBetween((String)rightName, (String)"${", (String)"}");
            parameterType = "$";
        } else if (rightName.startsWith("#{")) {
            parameterName = StringUtils.substringBetween((String)rightName, (String)"#{", (String)"}");
            parameterType = "#";
        } else if (rightName.startsWith("@")) {
            parameterName = rightName;
            parameterType = "@";
        } else {
            logger.error("\u6682\u672a\u5904\u7406\u7684\u53d8\u91cf\u5f62\u5f0f {} [{}] [{}] [{}]", new Object[]{rightName, MyBatisTableParserUtil.getCurrentXmlFileName(), MyBatisTableParserUtil.getCurrentSqlID(), MyBatisTableParserUtil.getCurrentSql()});
            parameterName = "";
            parameterType = "";
        }
        return new ParameterNameAndType(parameterName, parameterType);
    }

    public static <T> T findSuperSQLObject(SQLObject sqlObject, Class<T> clazz) {
        for (SQLObject currentSQLObject = sqlObject.getParent(); currentSQLObject != null; currentSQLObject = currentSQLObject.getParent()) {
            if (!clazz.equals(currentSQLObject.getClass())) continue;
            return (T)currentSQLObject;
        }
        return null;
    }

    public static SQLTableSource findSQLTableSourceInSuper(SQLObject sqlObject) {
        MySqlSelectQueryBlock mySqlSelectQueryBlock = MyBatisTableParserUtil.findSuperSQLObject(sqlObject, MySqlSelectQueryBlock.class);
        if (mySqlSelectQueryBlock != null) {
            return mySqlSelectQueryBlock.getFrom();
        }
        MySqlUpdateStatement mySqlUpdateStatement = MyBatisTableParserUtil.findSuperSQLObject(sqlObject, MySqlUpdateStatement.class);
        if (mySqlUpdateStatement != null) {
            return mySqlUpdateStatement.getTableSource();
        }
        MySqlDeleteStatement mySqlDeleteStatement = MyBatisTableParserUtil.findSuperSQLObject(sqlObject, MySqlDeleteStatement.class);
        if (mySqlDeleteStatement != null) {
            return mySqlDeleteStatement.getTableSource();
        }
        return null;
    }

    public static String genMyBatisMapperArgNameUseArg(int argSeq) {
        return "arg" + argSeq;
    }

    public static String genMyBatisMapperArgNameUseParam(int argSeq) {
        return "param" + (argSeq + 1);
    }

    public static List<String> genMyBatisMapperPossibleArgNameList(String argNameInSql, int argSeq) {
        ArrayList<String> myBatisMapperPossibleArgNameList = new ArrayList<String>(2);
        if (StringUtils.isNotBlank((CharSequence)argNameInSql)) {
            myBatisMapperPossibleArgNameList.add(argNameInSql);
        } else {
            myBatisMapperPossibleArgNameList.add(MyBatisTableParserUtil.genMyBatisMapperArgNameUseArg(argSeq));
        }
        myBatisMapperPossibleArgNameList.add(MyBatisTableParserUtil.genMyBatisMapperArgNameUseParam(argSeq));
        return myBatisMapperPossibleArgNameList;
    }

    public static ParameterName genParameterName(String paramRawName) {
        int lastIndex = paramRawName.lastIndexOf(".");
        if (lastIndex == -1) {
            return new ParameterName("", paramRawName);
        }
        String paramObjName = paramRawName.substring(0, lastIndex);
        String paramName = paramRawName.substring(lastIndex + ".".length());
        return new ParameterName(paramObjName, paramName);
    }

    public static Set<String> getSelectAllTableAliasSet(MySqlSelectQueryBlock mySqlSelectQueryBlock) {
        HashSet<String> tableAliasSet = new HashSet<String>();
        for (SQLSelectItem sqlSelectItem : mySqlSelectQueryBlock.getSelectList()) {
            SQLPropertyExpr sqlPropertyExpr;
            SQLExpr sqlExpr = sqlSelectItem.getExpr();
            if (!(sqlExpr instanceof SQLPropertyExpr) || !"*".equals((sqlPropertyExpr = (SQLPropertyExpr)sqlExpr).getName())) continue;
            tableAliasSet.add(sqlPropertyExpr.getOwnerName());
        }
        return tableAliasSet;
    }

    public static boolean checkIgnoreSelectColumnExprType(SQLExpr sqlExpr) {
        return sqlExpr instanceof SQLCharExpr || sqlExpr instanceof SQLNCharExpr || sqlExpr instanceof SQLNumericLiteralExpr || sqlExpr instanceof SQLMethodInvokeExpr || sqlExpr instanceof SQLVariantRefExpr || sqlExpr instanceof SQLBinaryOpExpr || sqlExpr instanceof SQLCurrentTimeExpr || sqlExpr instanceof SQLNullExpr || sqlExpr instanceof SQLSequenceExpr || sqlExpr instanceof SQLUnaryExpr;
    }

    private MyBatisTableParserUtil() {
        throw new IllegalStateException("illegal");
    }
}

