/*
 * Decompiled with CFR 0.152.
 */
package com.adrninistrator.mybatismysqltableparser.visitor;

import com.adrninistrator.mybatismysqltableparser.dto.MySqlSelectColumnInfo;
import com.adrninistrator.mybatismysqltableparser.dto.MySqlTableColumnInfo;
import com.adrninistrator.mybatismysqltableparser.dto.MySqlWhereColumnInfo;
import com.adrninistrator.mybatismysqltableparser.dto.ParameterNameAndType;
import com.adrninistrator.mybatismysqltableparser.dto.TableAndColumnName;
import com.adrninistrator.mybatismysqltableparser.parser.MySqlTableColumnParser;
import com.adrninistrator.mybatismysqltableparser.util.MyBatisTableParserUtil;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitor;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLBinaryOpExprVisitor
implements MySqlASTVisitor {
    private static final Logger logger = LoggerFactory.getLogger(SQLBinaryOpExprVisitor.class);
    private final MySqlTableColumnInfo mySqlTableColumnInfo;

    public SQLBinaryOpExprVisitor(MySqlTableColumnInfo mySqlTableColumnInfo) {
        this.mySqlTableColumnInfo = mySqlTableColumnInfo;
    }

    public boolean visit(SQLBinaryOpExpr x) {
        SQLExpr sqlExprAnother;
        SQLVariantRefExpr sqlExprVariant;
        SQLBinaryOperator sqlBinaryOperator = x.getOperator();
        if (!sqlBinaryOperator.isRelational()) {
            return true;
        }
        SQLTableSource sqlTableSource = MyBatisTableParserUtil.findSQLTableSourceInSuper((SQLObject)x);
        if (sqlTableSource == null) {
            logger.error("\u672a\u83b7\u53d6\u5230\u8868\u6765\u6e90 {}", (Object)x);
            return true;
        }
        SQLExpr sqlExprLeft = x.getLeft();
        SQLExpr sqlExprRight = x.getRight();
        if (sqlExprLeft instanceof SQLVariantRefExpr && (sqlExprRight instanceof SQLIdentifierExpr || sqlExprRight instanceof SQLPropertyExpr)) {
            sqlExprVariant = (SQLVariantRefExpr)sqlExprLeft;
            sqlExprAnother = sqlExprRight;
        } else if (sqlExprRight instanceof SQLVariantRefExpr) {
            sqlExprVariant = (SQLVariantRefExpr)sqlExprRight;
            sqlExprAnother = sqlExprLeft;
        } else {
            return true;
        }
        if (sqlExprAnother instanceof SQLQueryExpr) {
            SQLQueryExpr sqlQueryExpr = (SQLQueryExpr)sqlExprAnother;
            MySqlTableColumnParser mySqlTableColumnParser = new MySqlTableColumnParser();
            MySqlTableColumnInfo tmpMySqlTableColumnInfo = new MySqlTableColumnInfo();
            mySqlTableColumnParser.handleSQLSelectQuery(sqlQueryExpr.getSubQuery().getQuery(), tmpMySqlTableColumnInfo);
            ParameterNameAndType parameterNameAndType = MyBatisTableParserUtil.genParameterNameAndType(sqlExprVariant);
            for (MySqlSelectColumnInfo mySqlSelectColumnInfo : tmpMySqlTableColumnInfo.getMySqlSelectColumnInfoList()) {
                this.mySqlTableColumnInfo.addMySqlWhereColumnInfo(new MySqlWhereColumnInfo(mySqlSelectColumnInfo.getDbTableName(), mySqlSelectColumnInfo.getDbColumnName(), x.getOperator().getName(), parameterNameAndType.getParameterName(), parameterNameAndType.getParameterType()));
            }
            return true;
        }
        List<TableAndColumnName> tableAndColumnNameList = MyBatisTableParserUtil.genTableAndColumnName(sqlExprAnother, sqlTableSource);
        ParameterNameAndType parameterNameAndType = MyBatisTableParserUtil.genParameterNameAndType(sqlExprVariant);
        for (TableAndColumnName tableAndColumnName : tableAndColumnNameList) {
            this.mySqlTableColumnInfo.addMySqlWhereColumnInfo(new MySqlWhereColumnInfo(tableAndColumnName.getTableName(), tableAndColumnName.getColumnName(), x.getOperator().getName(), parameterNameAndType.getParameterName(), parameterNameAndType.getParameterType()));
        }
        return true;
    }
}

