/*
 * Decompiled with CFR 0.152.
 */
package com.github.advisedtesting.context.internal;

import com.github.advisedtesting.core.ObjectFactory;
import java.util.List;
import java.util.Map;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class SpringContextObjectFactory
implements ObjectFactory {
    private final ApplicationContext context;

    public SpringContextObjectFactory(Class<?> ... classes) {
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext();
        context.register((Class[])classes);
        context.setClassLoader(Thread.currentThread().getContextClassLoader());
        context.refresh();
        this.context = context;
    }

    public SpringContextObjectFactory(List<Class<?>> classes) {
        this(classes.toArray(new Class[0]));
    }

    public <T> T getObject(Class<T> type) {
        if (ApplicationContext.class.isAssignableFrom(type)) {
            return (T)this.context;
        }
        if (ObjectFactory.class.isAssignableFrom(type)) {
            return (T)this;
        }
        return (T)this.context.getBean(type);
    }

    public <T> T getObject(String name, Class<T> type) {
        return (T)this.context.getBean(name, type);
    }

    public <T> Map<String, T> getAllObjects(Class<T> type) {
        return this.context.getBeansOfType(type);
    }
}

