/*
 * Decompiled with CFR 0.152.
 */
package com.github.advisedtesting.context.internal;

import com.github.advisedtesting.context.IoCContext;
import com.github.advisedtesting.context.internal.SpringContextObjectFactory;
import com.github.advisedtesting.core.ContextAwareMethodInvocation;
import com.github.advisedtesting.core.ObjectFactory;
import java.util.ArrayList;
import java.util.List;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class IoCContextAdvice
implements MethodInterceptor {
    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (ContextAwareMethodInvocation.class.isAssignableFrom(invocation.getClass())) {
            ContextAwareMethodInvocation cinvocation = (ContextAwareMethodInvocation)invocation;
            SpringContextObjectFactory objectFactory = new SpringContextObjectFactory(this.sanitize(((IoCContext)cinvocation.getTargetAnnotation()).classes()));
            cinvocation.registerObjectFactory((ObjectFactory)objectFactory);
            return invocation.proceed();
        }
        throw new IllegalStateException("This MethodInterceptor must be passed an instance of " + ContextAwareMethodInvocation.class.getName());
    }

    private List<Class<?>> sanitize(Class<?> ... classes) throws ClassNotFoundException {
        ArrayList output = new ArrayList();
        for (Class<?> clazz : classes) {
            output.add(Thread.currentThread().getContextClassLoader().loadClass(clazz.getName()));
        }
        return output;
    }
}

