/*
 * Decompiled with CFR 0.152.
 */
package com.github.zkclient;

import com.github.zkclient.exception.ZkInterruptedException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ZkEventThread
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(ZkEventThread.class);
    private final BlockingQueue<ZkEvent> _events = new LinkedBlockingQueue<ZkEvent>();
    private static final AtomicInteger _eventId = new AtomicInteger(0);
    private volatile boolean shutdown = false;

    ZkEventThread(String name) {
        this.setDaemon(true);
        this.setName("ZkClient-EventThread-" + this.getId() + "-" + name);
    }

    @Override
    public void run() {
        LOG.info("Starting ZkClient event thread.");
        try {
            while (!this.isShutdown()) {
                ZkEvent zkEvent = this._events.take();
                int eventId = _eventId.incrementAndGet();
                LOG.debug("Delivering event #" + eventId + " " + zkEvent);
                try {
                    zkEvent.run();
                }
                catch (InterruptedException e) {
                    this.shutdown();
                }
                catch (ZkInterruptedException e) {
                    this.shutdown();
                }
                catch (Throwable e) {
                    LOG.error("Error handling event " + zkEvent, e);
                }
                LOG.debug("Delivering event #" + eventId + " done");
            }
        }
        catch (InterruptedException e) {
            LOG.info("Terminate ZkClient event thread.");
        }
    }

    public boolean isShutdown() {
        return this.shutdown || this.isInterrupted();
    }

    public void shutdown() {
        this.shutdown = true;
        this.interrupt();
    }

    public void send(ZkEvent event) {
        if (!this.isShutdown()) {
            LOG.debug("New event: " + event);
            this._events.add(event);
        }
    }

    static abstract class ZkEvent {
        private final String _description;

        public ZkEvent(String description) {
            this._description = description;
        }

        public abstract void run() throws Exception;

        public String toString() {
            return "ZkEvent[" + this._description + "]";
        }
    }
}

