/*
 * Decompiled with CFR 0.152.
 */
package com.github.zkclient;

import com.github.zkclient.ServerCnxnFactory;
import com.github.zkclient.ZkClient;
import com.github.zkclient.ZkClientUtils;
import com.github.zkclient.exception.ZkException;
import com.github.zkclient.exception.ZkInterruptedException;
import java.io.File;
import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkServer {
    private static final Logger LOG = LoggerFactory.getLogger(ZkServer.class);
    public static final int DEFAULT_PORT = 2181;
    public static final int DEFAULT_TICK_TIME = 5000;
    public static final int DEFAULT_MIN_SESSION_TIMEOUT = 10000;
    private final String _dataDir;
    private final String _logDir;
    private ZooKeeperServer _zk;
    private ServerCnxnFactory _nioFactory;
    private ZkClient _zkClient;
    private final int _port;
    private final int _tickTime;
    private final int _minSessionTimeout;

    public ZkServer(String dataDir, String logDir) {
        this(dataDir, logDir, 2181);
    }

    public ZkServer(String dataDir, String logDir, int port) {
        this(dataDir, logDir, port, 5000);
    }

    public ZkServer(String dataDir, String logDir, int port, int tickTime) {
        this(dataDir, logDir, port, tickTime, 10000);
    }

    public ZkServer(String dataDir, String logDir, int port, int tickTime, int minSessionTimeout) {
        this._dataDir = dataDir;
        this._logDir = logDir;
        this._port = port;
        this._tickTime = tickTime;
        this._minSessionTimeout = minSessionTimeout;
    }

    public int getPort() {
        return this._port;
    }

    @PostConstruct
    public void start() {
        this.startZkServer();
        this._zkClient = new ZkClient("localhost:" + this._port, 10000);
    }

    private void startZkServer() {
        int port = this._port;
        if (!ZkClientUtils.isPortFree(port)) {
            throw new IllegalStateException("Zookeeper port " + port + " was already in use. Running in single machine mode?");
        }
        File dataDir = new File(this._dataDir);
        File dataLogDir = new File(this._logDir);
        dataDir.mkdirs();
        dataLogDir.mkdirs();
        LOG.info("Start single zookeeper server...");
        LOG.info("data dir: " + dataDir.getAbsolutePath());
        LOG.info("data log dir: " + dataLogDir.getAbsolutePath());
        this.startSingleZkServer(this._tickTime, dataDir, dataLogDir, port);
    }

    private void startSingleZkServer(int tickTime, File dataDir, File dataLogDir, int port) {
        try {
            this._zk = new ZooKeeperServer(dataDir, dataLogDir, tickTime);
            this._zk.setMinSessionTimeout(this._minSessionTimeout);
            this._nioFactory = ServerCnxnFactory.createFactory(port, 60);
            this._nioFactory.startup(this._zk);
        }
        catch (IOException e) {
            throw new ZkException("Unable to start single ZooKeeper server.", e);
        }
        catch (InterruptedException e) {
            throw new ZkInterruptedException(e);
        }
    }

    @PreDestroy
    public void shutdown() {
        ZooKeeperServer zk = this._zk;
        if (zk == null) {
            LOG.warn("shutdown duplication");
            return;
        }
        this._zk = null;
        LOG.info("Shutting down ZkServer...");
        try {
            this._zkClient.close();
        }
        catch (ZkException e) {
            LOG.warn("Error on closing zkclient: " + e.getClass().getName());
        }
        if (this._nioFactory != null) {
            this._nioFactory.shutdown();
            try {
                this._nioFactory.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this._nioFactory = null;
        }
        zk.shutdown();
        if (zk.getZKDatabase() != null) {
            try {
                zk.getZKDatabase().close();
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        LOG.info("Shutting down ZkServer...done");
    }

    public ZkClient getZkClient() {
        return this._zkClient;
    }
}

