/*
 * Decompiled with CFR 0.152.
 */
package com.github.zkclient;

import com.github.zkclient.ZkClient;
import com.github.zkclient.ZkClientUtils;
import com.github.zkclient.exception.ZkException;
import java.io.File;
import java.net.ConnectException;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.zookeeper.client.FourLetterWordMain;
import org.apache.zookeeper.server.ServerConfig;
import org.apache.zookeeper.server.ZooKeeperServerMain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkServer
extends ZooKeeperServerMain {
    private static final Logger LOG = LoggerFactory.getLogger(ZkServer.class);
    public static final int DEFAULT_PORT = 2181;
    public static final int DEFAULT_TICK_TIME = 5000;
    public static final int DEFAULT_MIN_SESSION_TIMEOUT = 10000;
    private final String _dataDir;
    private final String _logDir;
    private ZkClient _zkClient;
    private final int _port;
    private final int _tickTime;
    private final int _minSessionTimeout;
    private volatile boolean shutdown = false;
    private boolean daemon = true;

    public ZkServer(String dataDir, String logDir) {
        this(dataDir, logDir, 2181);
    }

    public ZkServer(String dataDir, String logDir, int port) {
        this(dataDir, logDir, port, 5000);
    }

    public ZkServer(String dataDir, String logDir, int port, int tickTime) {
        this(dataDir, logDir, port, tickTime, 10000);
    }

    public ZkServer(String dataDir, String logDir, int port, int tickTime, int minSessionTimeout) {
        this._dataDir = dataDir;
        this._logDir = logDir;
        this._port = port;
        this._tickTime = tickTime;
        this._minSessionTimeout = minSessionTimeout;
    }

    public int getPort() {
        return this._port;
    }

    @PostConstruct
    public void start() {
        this.shutdown = false;
        this.startZkServer();
        this._zkClient = new ZkClient("localhost:" + this._port, 10000);
    }

    private void startZkServer() {
        int port = this._port;
        if (!ZkClientUtils.isPortFree(port)) {
            throw new IllegalStateException("Zookeeper port " + port + " was already in use. Running in single machine mode?");
        }
        File dataDir = new File(this._dataDir);
        File dataLogDir = new File(this._logDir);
        dataDir.mkdirs();
        LOG.info("Start single zookeeper server, port={} data={} ", (Object)port, (Object)dataDir.getAbsolutePath());
        final ZkServer serverMain = this;
        final InnerServerConfig config = new InnerServerConfig();
        config.parse(new String[]{"" + port, dataDir.getAbsolutePath(), "" + this._tickTime, "60"});
        config.setMinSessionTimeout(this._minSessionTimeout);
        String threadName = "inner-zkserver-" + port;
        Thread innerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    serverMain.runFromConfig((ServerConfig)config);
                }
                catch (Exception e) {
                    throw new ZkException("Unable to start single ZooKeeper server.", e);
                }
            }
        }, threadName);
        innerThread.setDaemon(this.daemon);
        innerThread.start();
        ZkServer.waitForServerUp(port, 30000L, false);
    }

    @PreDestroy
    public void shutdown() {
        if (!this.shutdown) {
            this.shutdown = true;
            LOG.info("Shutting down ZkServer port={}...", (Object)this._port);
            if (this._zkClient != null) {
                try {
                    this._zkClient.close();
                }
                catch (ZkException e) {
                    LOG.warn("Error on closing zkclient: " + e.getClass().getName());
                }
                this._zkClient = null;
            }
            super.shutdown();
            ZkServer.waitForServerDown(this._port, 30000L, false);
            LOG.info("Shutting down ZkServer port={}...done", (Object)this._port);
        }
    }

    public ZkClient getZkClient() {
        return this._zkClient;
    }

    public static boolean waitForServerUp(int port, long timeout, boolean secure) {
        long start = System.currentTimeMillis();
        while (true) {
            try {
                String result = FourLetterWordMain.send4LetterWord((String)"127.0.0.1", (int)port, (String)"stat");
                if (result.startsWith("Zookeeper version:") && !result.contains("READ-ONLY")) {
                    return true;
                }
            }
            catch (ConnectException e) {
                LOG.debug("server {} not up: {}", (Object)port, (Object)e.toString());
            }
            catch (Exception e) {
                LOG.info("server {} not up", (Object)port, (Object)e);
            }
            if (System.currentTimeMillis() > start + timeout) break;
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return false;
    }

    public static boolean waitForServerDown(int port, long timeout, boolean secure) {
        long start = System.currentTimeMillis();
        while (true) {
            try {
                FourLetterWordMain.send4LetterWord((String)"127.0.0.1", (int)port, (String)"stat");
            }
            catch (Exception e) {
                return true;
            }
            if (System.currentTimeMillis() > start + timeout) break;
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return false;
    }

    class InnerServerConfig
    extends ServerConfig {
        InnerServerConfig() {
        }

        public void setMinSessionTimeout(int minSessionTimeout) {
            this.minSessionTimeout = minSessionTimeout;
        }
    }
}

