/*
 * Decompiled with CFR 0.152.
 */
package com.github.zkclient.exception;

import com.github.zkclient.exception.ZkBadVersionException;
import com.github.zkclient.exception.ZkNoNodeException;
import com.github.zkclient.exception.ZkNodeExistsException;
import org.apache.zookeeper.KeeperException;

public class ZkException
extends RuntimeException {
    private static final long serialVersionUID = 1L;

    public ZkException() {
    }

    public ZkException(String message, Throwable cause) {
        super(message, cause);
    }

    public ZkException(String message) {
        super(message);
    }

    public ZkException(Throwable cause) {
        super(cause);
    }

    public static ZkException create(KeeperException e) {
        switch (e.code()) {
            case NONODE: {
                return new ZkNoNodeException(e);
            }
            case BADVERSION: {
                return new ZkBadVersionException(e);
            }
            case NODEEXISTS: {
                return new ZkNodeExistsException(e);
            }
        }
        return new ZkException(e);
    }
}

