/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.base;

import com.mgz.afp.base.StructuredFieldIntroducer;
import com.mgz.afp.base.annotations.AFPField;
import com.mgz.afp.base.annotations.AFPType;
import com.mgz.afp.enums.SFFlag;
import com.mgz.afp.enums.SFType;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.exceptions.IAFPDecodeableWriteable;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.util.Constants;
import com.mgz.util.UtilBinaryDecoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

@AFPType
public abstract class StructuredField
implements IAFPDecodeableWriteable {
    @AFPField
    StructuredFieldIntroducer structuredFieldIntroducer;
    @AFPField(isOptional=true, maxSize=32759)
    byte[] padding;

    public static void checkDataLength(byte[] sfData, int offset, int length, int minLength) throws AFPParserException {
        if (length == -1) {
            length = sfData.length - offset;
        }
        if (sfData == null || sfData.length == 0 || offset >= sfData.length) {
            throw new AFPParserException("Offset is greater than the size of the given data.");
        }
        if (length > 0 && offset + length > sfData.length) {
            throw new AFPParserException("The specified range is greater than the size of the given data.");
        }
        if (minLength > 0 && offset + minLength > sfData.length) {
            throw new AFPParserException("The given data array is to small to contain enough data for decoding.");
        }
        if (length >= 0 && minLength >= 0 && length < minLength) {
            throw new AFPParserException("The specified length of used data array is to small to contain enough data for decoding.");
        }
    }

    public static int getActualLength(byte[] sfData, int offset, int length) {
        return length != -1 ? length : sfData.length - offset;
    }

    @Override
    public abstract void decodeAFP(byte[] var1, int var2, int var3, AFPParserConfiguration var4) throws AFPParserException;

    @Override
    public abstract void writeAFP(OutputStream var1, AFPParserConfiguration var2) throws IOException;

    public StructuredFieldIntroducer getStructuredFieldIntroducer() {
        return this.structuredFieldIntroducer;
    }

    public void setStructuredFieldIntroducer(StructuredFieldIntroducer structuredFieldIntroducer) {
        this.structuredFieldIntroducer = structuredFieldIntroducer;
    }

    public byte[] getPadding() {
        return this.padding;
    }

    public void setPadding(byte[] padding) {
        this.padding = padding;
        if (padding != null && padding.length == 0) {
            padding = null;
        }
        if (padding != null) {
            this.structuredFieldIntroducer.setFlag(SFFlag.isPadded);
        } else {
            this.structuredFieldIntroducer.removeFlag(SFFlag.isPadded);
        }
    }

    protected void writeFullStructuredField(OutputStream os, byte[] netPayloadWithoutSFIandPadding) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(this.structuredFieldIntroducer.toBytes());
        if (netPayloadWithoutSFIandPadding != null && netPayloadWithoutSFIandPadding.length > 0) {
            baos.write(netPayloadWithoutSFIandPadding);
        }
        if (this.padding != null) {
            baos.write(this.padding);
        }
        byte[] sfData = baos.toByteArray();
        byte[] lenBytes = UtilBinaryDecoding.intToByteArray(sfData.length, 2);
        for (int i = 0; i < lenBytes.length; ++i) {
            sfData[i] = lenBytes[i];
        }
        this.structuredFieldIntroducer.setSFLength(sfData.length);
        os.write(Constants.AFPBeginByte_0xA5);
        os.write(sfData);
    }

    public boolean isBeginSF() {
        if (this.structuredFieldIntroducer == null || this.structuredFieldIntroducer.getSFTypeID() == null || this.structuredFieldIntroducer.getSFTypeID().getSfType() == null) {
            return false;
        }
        return this.structuredFieldIntroducer.getSFTypeID().getSfType() == SFType.Begin;
    }

    public boolean isEndSF() {
        if (this.structuredFieldIntroducer == null || this.structuredFieldIntroducer.getSFTypeID() == null || this.structuredFieldIntroducer.getSFTypeID().getSfType() == null) {
            return false;
        }
        return this.structuredFieldIntroducer.getSFTypeID().getSfType() == SFType.End;
    }

    public boolean isShallow() {
        if (this.structuredFieldIntroducer == null || this.structuredFieldIntroducer.actualConfig == null) {
            return false;
        }
        return this.structuredFieldIntroducer.actualConfig.isBuildShallow();
    }

    public String toString() {
        return "StructuredField{" + this.structuredFieldIntroducer + '}';
    }
}

