/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.base;

import com.mgz.afp.base.IHasTriplets;
import com.mgz.afp.base.StructuredField;
import com.mgz.afp.base.annotations.AFPField;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.afp.parser.TripletParser;
import com.mgz.afp.triplets.Triplet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public abstract class StructuredFieldBaseTriplets
extends StructuredField
implements IHasTriplets {
    @AFPField
    protected List<Triplet> triplets;

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        int actualLength = StructuredFieldBaseTriplets.getActualLength(sfData, offset, length);
        this.triplets = null;
        if (actualLength > 0) {
            this.triplets = TripletParser.parseTriplets(sfData, offset, actualLength, config);
        }
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (this.triplets != null) {
            for (Triplet triplet : this.triplets) {
                triplet.writeAFP(baos, config);
            }
        }
        this.writeFullStructuredField(os, baos.toByteArray());
    }

    @Override
    public final List<Triplet> getTriplets() {
        return this.triplets;
    }

    @Override
    public final void setTriplets(List<Triplet> triplets) {
        this.triplets = triplets;
    }

    @Override
    public final void addTriplet(Triplet triplet) {
        if (triplet != null) {
            if (this.triplets == null) {
                this.triplets = new ArrayList<Triplet>();
            }
            this.triplets.add(triplet);
        }
    }

    @Override
    public final void removeTriplet(Triplet triplet) {
        if (this.triplets != null) {
            this.triplets.remove(triplet);
        }
    }
}

