/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.bcoca;

import com.mgz.afp.base.StructuredField;
import com.mgz.afp.base.annotations.AFPField;
import com.mgz.afp.bcoca.BDD_BarCodeDataDescriptor;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.util.UtilBinaryDecoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.EnumSet;

public class BDA_BarCodeData
extends StructuredField {
    @AFPField
    EnumSet<BarCodeFlag> barCodeFlags;
    @AFPField
    int xOffset;
    @AFPField
    int yOffset;
    @AFPField(isOptional=true)
    ParametersData parametersData;
    @AFPField(isOptional=true, maxSize=32754)
    byte[] barCodeData;

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        BDD_BarCodeDataDescriptor associatedBarCodeDataDescriptor = config.getCurrentBarCodeDataDescriptor();
        BDA_BarCodeData.checkDataLength(sfData, offset, length, 5);
        this.barCodeFlags = BarCodeFlag.valueOf(sfData[0]);
        this.xOffset = UtilBinaryDecoding.parseInt(sfData, 1, 2);
        this.yOffset = UtilBinaryDecoding.parseInt(sfData, 3, 2);
        int actualLength = length != -1 ? length : sfData.length - offset;
        int parameterDataLength = 0;
        if (actualLength > 5) {
            this.parametersData = associatedBarCodeDataDescriptor.barcodeType == BDD_BarCodeDataDescriptor.BarCodeType.DataMatrix_GS1DataMatrix_2D ? new ParametersDataMatrixBarcode() : (associatedBarCodeDataDescriptor.barcodeType == BDD_BarCodeDataDescriptor.BarCodeType.MaxiCode_2D ? new ParametersDataMaxiCode_2D() : (associatedBarCodeDataDescriptor.barcodeType == BDD_BarCodeDataDescriptor.BarCodeType.PDF417_2D ? new ParametersDataPDF417_2D() : (associatedBarCodeDataDescriptor.barcodeType == BDD_BarCodeDataDescriptor.BarCodeType.QRCode_2D ? new ParametersDataQRCode_2D() : null)));
            if (this.parametersData != null) {
                parameterDataLength = this.parametersData.decodeAFP(sfData, 5, -1);
            }
        }
        if (actualLength > 5 + parameterDataLength) {
            this.barCodeData = new byte[actualLength - (5 + parameterDataLength)];
            System.arraycopy(sfData, offset + (5 + parameterDataLength), this.barCodeData, 0, this.barCodeData.length);
        } else {
            this.barCodeData = new byte[0];
        }
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(BarCodeFlag.toByte(this.barCodeFlags));
        baos.write(UtilBinaryDecoding.intToByteArray(this.xOffset, 2));
        baos.write(UtilBinaryDecoding.intToByteArray(this.yOffset, 2));
        this.parametersData.writeAFP(baos, config);
        baos.write(this.barCodeData);
        this.writeFullStructuredField(os, baos.toByteArray());
    }

    public EnumSet<BarCodeFlag> getBarCodeFlags() {
        return this.barCodeFlags;
    }

    public void setBarCodeFlags(EnumSet<BarCodeFlag> barCodeFlags) {
        this.barCodeFlags = barCodeFlags;
    }

    public void addBarCodeFlag(BarCodeFlag barCodeFlag) {
        if (this.barCodeFlags == null) {
            this.barCodeFlags = EnumSet.noneOf(BarCodeFlag.class);
        }
        if (barCodeFlag == BarCodeFlag.PositionHRIBelow) {
            this.barCodeFlags.remove((Object)BarCodeFlag.PositionHRIAbove);
        } else if (barCodeFlag == BarCodeFlag.PositionHRIAbove) {
            this.barCodeFlags.remove((Object)BarCodeFlag.PositionHRIBelow);
        }
        this.barCodeFlags.add(barCodeFlag);
    }

    public int getxOffset() {
        return this.xOffset;
    }

    public void setxOffset(int xOffset) {
        this.xOffset = xOffset;
    }

    public int getyOffset() {
        return this.yOffset;
    }

    public void setyOffset(int yOffset) {
        this.yOffset = yOffset;
    }

    public static class ParametersDataQRCode_2D
    extends ParametersData {
        Conversion conversion;
        byte versionOfSymbol;
        ErrorCorrectionLevel errorCorrectionLevel;
        short parityData;
        SpecialFunctionFlag specialFunctionFlag;
        short applicationIndicator;

        @Override
        public int decodeAFP(byte[] sfData, int offset, int length) throws AFPParserException {
            StructuredField.checkDataLength(sfData, offset, length, 9);
            this.controlFlags = ParametersData.ControlFlag.valueOf(UtilBinaryDecoding.parseInt(sfData, offset, 1));
            this.conversion = Conversion.valueOf(sfData[offset + 1]);
            this.versionOfSymbol = sfData[offset + 2];
            this.errorCorrectionLevel = ErrorCorrectionLevel.valueOf(sfData[offset + 3]);
            this.sequenceIndicator = sfData[offset + 4];
            this.totalNumberOfSymbols = sfData[offset + 5];
            this.parityData = UtilBinaryDecoding.parseShort(sfData, offset + 6, 1);
            this.specialFunctionFlag = SpecialFunctionFlag.valueOf(UtilBinaryDecoding.parseShort(sfData, offset + 7, 1));
            this.applicationIndicator = UtilBinaryDecoding.parseShort(sfData, offset + 8, 1);
            return 9;
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(ParametersData.ControlFlag.toByte(this.controlFlags));
            os.write(this.conversion.toByte());
            os.write(this.versionOfSymbol);
            os.write(this.errorCorrectionLevel.toByte());
            os.write(this.sequenceIndicator);
            os.write(this.totalNumberOfSymbols);
            os.write(this.parityData);
            os.write(this.specialFunctionFlag.toByte());
            os.write(this.applicationIndicator);
        }

        public static enum SpecialFunctionFlag {
            symbolConformsToUCC_EANCode,
            symbolConformsToIndustriyStandard;


            public static SpecialFunctionFlag valueOf(short code) {
                if (code == 128) {
                    return symbolConformsToUCC_EANCode;
                }
                return symbolConformsToIndustriyStandard;
            }

            public int toByte() {
                if (this == symbolConformsToUCC_EANCode) {
                    return 128;
                }
                return 64;
            }
        }

        public static enum ErrorCorrectionLevel {
            LevelL,
            LevelM,
            LevelQ,
            LevelH;


            public static ErrorCorrectionLevel valueOf(byte leveCode) {
                for (ErrorCorrectionLevel level : ErrorCorrectionLevel.values()) {
                    if (level.ordinal() != leveCode) continue;
                    return level;
                }
                return null;
            }

            public int toByte() {
                return this.ordinal();
            }
        }

        public static enum Conversion {
            NoConversion(0),
            SBCS_EBCDIC_CodePage500(1),
            SBCS_EBCDIC_CodePage290(2),
            SBCS_EBCDIC_CodePage1027(3),
            AFPLineDataSOSIData_CCSID1390_CCSID943(4),
            AFPLineDataSOSIData_CCSID1399_CCSID943(5),
            AFPLineDataSOSIData_CCSID1390_CCSID932(6),
            AFPLineDataSOSIData_CCSID1399_CCSID932(7),
            AFPLineDataSOSIData_CCSID1390_CCSID942(8),
            AFPLineDataSOSIData_CCSID1399_CCSID942(9);

            int code;

            private Conversion(int conversionCode) {
                this.code = conversionCode;
            }

            public static Conversion valueOf(byte conversionCode) {
                for (Conversion conversion : Conversion.values()) {
                    if (conversion.code != conversionCode) continue;
                    return conversion;
                }
                return NoConversion;
            }

            public int toByte() {
                return this.code;
            }
        }
    }

    public static class ParametersDataPDF417_2D
    extends ParametersData {
        byte numberOfDataSymbolCharactersPerRow;
        byte desiredNumberOfRows;
        byte securityLevel;
        short lengthOfMacroPDF417ControlBlock;
        byte[] macroPDF417ControlBlock;

        @Override
        public int decodeAFP(byte[] sfData, int offset, int length) throws AFPParserException {
            StructuredField.checkDataLength(sfData, offset, length, 6);
            this.controlFlags = ParametersData.ControlFlag.valueOf(UtilBinaryDecoding.parseInt(sfData, offset, 1));
            this.numberOfDataSymbolCharactersPerRow = sfData[offset + 1];
            this.desiredNumberOfRows = sfData[offset + 2];
            this.securityLevel = sfData[offset + 3];
            this.lengthOfMacroPDF417ControlBlock = UtilBinaryDecoding.parseShort(sfData, offset + 4, 2);
            this.macroPDF417ControlBlock = new byte[this.lengthOfMacroPDF417ControlBlock];
            System.arraycopy(sfData, offset, this.macroPDF417ControlBlock, 0, this.lengthOfMacroPDF417ControlBlock);
            return 6 + this.lengthOfMacroPDF417ControlBlock;
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(ParametersData.ControlFlag.toByte(this.controlFlags));
            os.write(this.numberOfDataSymbolCharactersPerRow);
            os.write(this.desiredNumberOfRows);
            os.write(this.securityLevel);
            os.write(UtilBinaryDecoding.shortToByteArray(this.lengthOfMacroPDF417ControlBlock, 2));
            os.write(this.macroPDF417ControlBlock);
        }
    }

    public static class ParametersDataMaxiCode_2D
    extends ParametersData {
        SymbolMode symbolMode = SymbolMode.Mode2;
        SpecialFunctionFlag specialFunctionFlag = SpecialFunctionFlag.NoZipperPattern;

        @Override
        public int decodeAFP(byte[] sfData, int offset, int length) throws AFPParserException {
            BDA_BarCodeData.checkDataLength(sfData, offset, length, 5);
            this.controlFlags = ParametersData.ControlFlag.valueOf(UtilBinaryDecoding.parseInt(sfData, offset, 1));
            this.symbolMode = SymbolMode.valueOf(sfData[offset + 1]);
            this.sequenceIndicator = sfData[offset + 2];
            this.totalNumberOfSymbols = sfData[offset + 3];
            this.specialFunctionFlag = SpecialFunctionFlag.valueOf(sfData[offset + 4]);
            return 5;
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(ParametersData.ControlFlag.toByte(this.controlFlags));
            os.write(this.symbolMode.toByte());
            os.write(this.sequenceIndicator);
            os.write(this.totalNumberOfSymbols);
            os.write(this.specialFunctionFlag.toByte());
        }

        public static enum SpecialFunctionFlag {
            NoZipperPattern,
            VerticalZipperPatternOnRight;


            public static SpecialFunctionFlag valueOf(byte code) {
                if (code == 0) {
                    return NoZipperPattern;
                }
                return VerticalZipperPatternOnRight;
            }

            public int toByte() {
                if (this == NoZipperPattern) {
                    return 0;
                }
                return 128;
            }
        }

        public static enum SymbolMode {
            Mode2,
            Mode3,
            Mode4,
            Mode5,
            Mode6;


            public static SymbolMode valueOf(byte symbolModeCode) {
                if (symbolModeCode == 2) {
                    return Mode2;
                }
                if (symbolModeCode == 3) {
                    return Mode3;
                }
                if (symbolModeCode == 4) {
                    return Mode4;
                }
                if (symbolModeCode == 5) {
                    return Mode5;
                }
                if (symbolModeCode == 6) {
                    return Mode6;
                }
                return null;
            }

            public int toByte() {
                if (this == Mode2) {
                    return 2;
                }
                if (this == Mode3) {
                    return 3;
                }
                if (this == Mode4) {
                    return 4;
                }
                if (this == Mode5) {
                    return 5;
                }
                if (this == Mode6) {
                    return 6;
                }
                return 0;
            }
        }
    }

    public static class ParametersDataMatrixBarcode
    extends ParametersData {
        int desiredRowSize;
        int desiredNumberOfRows;
        short fileIDFirstByte;
        short fileIDSecondByte;
        EnumSet<SpecialFunctionFlag> specialFunctionFlags;

        @Override
        public int decodeAFP(byte[] sfData, int offset, int length) throws AFPParserException {
            BDA_BarCodeData.checkDataLength(sfData, offset, length, 10);
            this.controlFlags = ParametersData.ControlFlag.valueOf(UtilBinaryDecoding.parseInt(sfData, offset, 1));
            this.desiredRowSize = UtilBinaryDecoding.parseInt(sfData, offset + 1, 2);
            this.desiredNumberOfRows = UtilBinaryDecoding.parseInt(sfData, offset + 3, 2);
            this.sequenceIndicator = sfData[offset + 5];
            this.totalNumberOfSymbols = sfData[offset + 6];
            this.fileIDFirstByte = UtilBinaryDecoding.parseShort(sfData, offset + 7, 1);
            this.fileIDSecondByte = UtilBinaryDecoding.parseShort(sfData, offset + 8, 1);
            this.specialFunctionFlags = SpecialFunctionFlag.valueOf(UtilBinaryDecoding.parseInt(sfData, offset + 9, 1));
            return 10;
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(ParametersData.ControlFlag.toByte(this.controlFlags));
            os.write(UtilBinaryDecoding.intToByteArray(this.desiredRowSize, 2));
            os.write(UtilBinaryDecoding.intToByteArray(this.desiredNumberOfRows, 2));
            os.write(this.sequenceIndicator);
            os.write(this.totalNumberOfSymbols);
            os.write(this.fileIDFirstByte);
            os.write(this.fileIDSecondByte);
            os.write(SpecialFunctionFlag.toByte(this.specialFunctionFlags));
        }

        public int getDesiredRowSize() {
            return this.desiredRowSize;
        }

        public void setDesiredRowSize(int desiredRowSize) {
            this.desiredRowSize = desiredRowSize;
        }

        public int getDesiredNumberOfRows() {
            return this.desiredNumberOfRows;
        }

        public void setDesiredNumberOfRows(int desiredNumberOfRows) {
            this.desiredNumberOfRows = desiredNumberOfRows;
        }

        public short getFileIDFirstByte() {
            return this.fileIDFirstByte;
        }

        public void setFileIDFirstByte(short fileIDFirstByte) {
            this.fileIDFirstByte = fileIDFirstByte;
        }

        public short getFileIDSecondByte() {
            return this.fileIDSecondByte;
        }

        public void setFileIDSecondByte(short fileIDSecondByte) {
            this.fileIDSecondByte = fileIDSecondByte;
        }

        public EnumSet<SpecialFunctionFlag> getSpecialFunctionFlags() {
            return this.specialFunctionFlags;
        }

        public void setSpecialFunctionFlags(EnumSet<SpecialFunctionFlag> specialFunctionFlags) {
            this.specialFunctionFlags = specialFunctionFlags;
        }

        public void addSpecialFunctionFlag(SpecialFunctionFlag specialFunctionFlag) {
            if (this.specialFunctionFlags == null) {
                this.specialFunctionFlags = EnumSet.noneOf(SpecialFunctionFlag.class);
            }
            if (specialFunctionFlag == SpecialFunctionFlag.UseMacro06HeaderTrailer) {
                this.specialFunctionFlags.remove((Object)SpecialFunctionFlag.UseMacro05HeaderTrailer);
            } else if (specialFunctionFlag == SpecialFunctionFlag.UseMacro05HeaderTrailer) {
                this.specialFunctionFlags.remove((Object)SpecialFunctionFlag.UseMacro06HeaderTrailer);
            }
            if (specialFunctionFlag == SpecialFunctionFlag.EncodationSchemeAutoEncoding || specialFunctionFlag == SpecialFunctionFlag.EncodationSchemeBase256 || specialFunctionFlag == SpecialFunctionFlag.EncodationSchemeEDIFACT || specialFunctionFlag == SpecialFunctionFlag.EncodationSchemeX12 || specialFunctionFlag == SpecialFunctionFlag.EncodationSchemeText || specialFunctionFlag == SpecialFunctionFlag.EncodationSchemeC40 || specialFunctionFlag == SpecialFunctionFlag.EncodationSchemeASCII) {
                this.specialFunctionFlags.remove((Object)SpecialFunctionFlag.EncodationSchemeAutoEncoding);
                this.specialFunctionFlags.remove((Object)SpecialFunctionFlag.EncodationSchemeBase256);
                this.specialFunctionFlags.remove((Object)SpecialFunctionFlag.EncodationSchemeEDIFACT);
                this.specialFunctionFlags.remove((Object)SpecialFunctionFlag.EncodationSchemeX12);
                this.specialFunctionFlags.remove((Object)SpecialFunctionFlag.EncodationSchemeText);
                this.specialFunctionFlags.remove((Object)SpecialFunctionFlag.EncodationSchemeC40);
                this.specialFunctionFlags.remove((Object)SpecialFunctionFlag.EncodationSchemeASCII);
            }
            this.specialFunctionFlags.add(specialFunctionFlag);
        }

        public void removeSpecialFunctionFlag(SpecialFunctionFlag specialFunctionFlag) {
            if (this.specialFunctionFlags == null) {
                return;
            }
            this.specialFunctionFlags.remove((Object)specialFunctionFlag);
        }

        public static enum SpecialFunctionFlag {
            SymbolConfirmsToGS1Standard,
            SymbolConfirmsToIndustryStandard,
            SymbolEncodesAMessage,
            UseMacro05HeaderTrailer,
            UseMacro06HeaderTrailer,
            EncodationSchemeASCII,
            EncodationSchemeC40,
            EncodationSchemeText,
            EncodationSchemeX12,
            EncodationSchemeEDIFACT,
            EncodationSchemeBase256,
            EncodationSchemeAutoEncoding;


            public static EnumSet<SpecialFunctionFlag> valueOf(int flagByte) {
                EnumSet<SpecialFunctionFlag> result = EnumSet.noneOf(SpecialFunctionFlag.class);
                if ((flagByte & 0x80) != 0) {
                    result.add(SymbolConfirmsToGS1Standard);
                }
                if ((flagByte & 0x40) != 0) {
                    result.add(SymbolConfirmsToIndustryStandard);
                }
                if ((flagByte & 0x20) != 0) {
                    result.add(SymbolEncodesAMessage);
                }
                if ((flagByte & 0x10) != 0) {
                    result.add(UseMacro06HeaderTrailer);
                }
                if ((flagByte & 8) != 0) {
                    result.add(UseMacro05HeaderTrailer);
                }
                if ((flagByte & 7) != 0) {
                    result.add(EncodationSchemeAutoEncoding);
                }
                if ((flagByte & 6) != 0) {
                    result.add(EncodationSchemeBase256);
                }
                if ((flagByte & 5) != 0) {
                    result.add(EncodationSchemeEDIFACT);
                }
                if ((flagByte & 4) != 0) {
                    result.add(EncodationSchemeX12);
                }
                if ((flagByte & 3) != 0) {
                    result.add(EncodationSchemeText);
                }
                if ((flagByte & 2) != 0) {
                    result.add(EncodationSchemeC40);
                }
                if ((flagByte & 1) != 0) {
                    result.add(EncodationSchemeASCII);
                }
                return result;
            }

            public static int toByte(EnumSet<SpecialFunctionFlag> specialFunctionFlags) {
                int result = 0;
                if (specialFunctionFlags.contains((Object)SymbolConfirmsToGS1Standard)) {
                    result |= 0x80;
                }
                if (specialFunctionFlags.contains((Object)SymbolConfirmsToIndustryStandard)) {
                    result |= 0x40;
                }
                if (specialFunctionFlags.contains((Object)SymbolEncodesAMessage)) {
                    result |= 0x20;
                }
                if (specialFunctionFlags.contains((Object)UseMacro06HeaderTrailer)) {
                    result |= 0x10;
                } else if (specialFunctionFlags.contains((Object)UseMacro05HeaderTrailer)) {
                    result |= 8;
                }
                if (specialFunctionFlags.contains((Object)EncodationSchemeAutoEncoding)) {
                    result |= 7;
                } else if (specialFunctionFlags.contains((Object)EncodationSchemeBase256)) {
                    result |= 6;
                } else if (specialFunctionFlags.contains((Object)EncodationSchemeEDIFACT)) {
                    result |= 5;
                } else if (specialFunctionFlags.contains((Object)EncodationSchemeX12)) {
                    result |= 4;
                } else if (specialFunctionFlags.contains((Object)EncodationSchemeText)) {
                    result |= 3;
                } else if (specialFunctionFlags.contains((Object)EncodationSchemeC40)) {
                    result |= 2;
                } else if (specialFunctionFlags.contains((Object)EncodationSchemeASCII)) {
                    result |= 1;
                }
                return result;
            }
        }
    }

    public static abstract class ParametersData {
        EnumSet<ControlFlag> controlFlags;
        byte sequenceIndicator;
        byte totalNumberOfSymbols;

        public abstract int decodeAFP(byte[] var1, int var2, int var3) throws AFPParserException;

        public abstract void writeAFP(OutputStream var1, AFPParserConfiguration var2) throws IOException;

        public byte getSequenceIndicator() {
            return this.sequenceIndicator;
        }

        public void setSequenceIndicator(byte sequenceIndicator) {
            this.sequenceIndicator = sequenceIndicator;
        }

        public byte getTotalNumberOfSymbols() {
            return this.totalNumberOfSymbols;
        }

        public void setTotalNumberOfSymbols(byte totalNumberOfSymbols) {
            this.totalNumberOfSymbols = totalNumberOfSymbols;
        }

        public EnumSet<ControlFlag> getControlFlags() {
            return this.controlFlags;
        }

        public void setControlFlags(EnumSet<ControlFlag> controlFlags) {
            this.controlFlags = controlFlags;
        }

        public void addControlFlag(ControlFlag controlFlag) {
            if (this.controlFlags == null) {
                this.controlFlags = EnumSet.noneOf(ControlFlag.class);
            }
            this.controlFlags.add(controlFlag);
        }

        public void removeControlFlag(ControlFlag controlFlag) {
            if (this.controlFlags == null) {
                return;
            }
            this.controlFlags.remove((Object)controlFlag);
        }

        public static enum ControlFlag {
            ConvertEBCDICToASCII,
            IgnoreAllEscapeSequences;


            public static EnumSet<ControlFlag> valueOf(int flagByte) {
                EnumSet<ControlFlag> result = EnumSet.noneOf(ControlFlag.class);
                if ((flagByte & 0x80) != 0) {
                    result.add(ConvertEBCDICToASCII);
                }
                if ((flagByte & 0x40) != 0) {
                    result.add(IgnoreAllEscapeSequences);
                }
                return result;
            }

            public static int toByte(EnumSet<ControlFlag> controlFlags) {
                int result = 0;
                if (controlFlags.contains((Object)ConvertEBCDICToASCII)) {
                    result += 128;
                }
                if (controlFlags.contains((Object)IgnoreAllEscapeSequences)) {
                    result += 64;
                }
                return result;
            }
        }
    }

    public static enum BarCodeFlag {
        HRINotPresent,
        PositionHRIBelow,
        PositionHRIAbove,
        SSCASTAsteriskIsPresent,
        SuppressBarCodeSymbol,
        SuppressAndAdjustBlanks;


        public static EnumSet<BarCodeFlag> valueOf(int flagByte) {
            EnumSet<BarCodeFlag> result = EnumSet.noneOf(BarCodeFlag.class);
            if ((flagByte & 0x80) != 0) {
                result.add(HRINotPresent);
            }
            if ((flagByte & 0x40) != 0) {
                result.add(PositionHRIBelow);
            } else if ((flagByte & 0x20) != 0) {
                result.add(PositionHRIAbove);
            }
            if ((flagByte & 8) != 0) {
                result.add(SSCASTAsteriskIsPresent);
            }
            if ((flagByte & 4) != 0) {
                result.add(SuppressBarCodeSymbol);
            }
            if ((flagByte & 2) != 0) {
                result.add(SuppressAndAdjustBlanks);
            }
            return result;
        }

        public static int toByte(EnumSet<BarCodeFlag> flags) {
            int result = 0;
            if (flags.contains((Object)HRINotPresent)) {
                result += 128;
            }
            if (flags.contains((Object)PositionHRIBelow)) {
                result += 64;
            } else if (flags.contains((Object)PositionHRIAbove)) {
                result += 32;
            }
            if (flags.contains((Object)SSCASTAsteriskIsPresent)) {
                result += 8;
            }
            if (flags.contains((Object)SuppressBarCodeSymbol)) {
                result += 4;
            }
            if (flags.contains((Object)SuppressAndAdjustBlanks)) {
                result += 2;
            }
            return result;
        }
    }
}

