/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.foca;

import com.mgz.afp.base.StructuredField;
import com.mgz.afp.base.annotations.AFPField;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.util.Constants;
import com.mgz.util.UtilBinaryDecoding;
import com.mgz.util.UtilCharacterEncoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.EnumSet;

public class CPC_CodePageControl
extends StructuredField {
    private static final Charset cpIBM500 = Constants.cpIBM500;
    @AFPField
    String defaultGraphicCharacterGlobalID;
    @AFPField
    EnumSet<DefaultCharacterUseFlag> defaultCharacterUseFlags;
    @AFPField
    CPIRepeatingGroupLength cpiRepeatingGroupLength;
    @AFPField
    short spaceCharacterSectionNumber;
    @AFPField
    short spaceCharacterCodePoint;
    @AFPField
    EnumSet<CodePageUseFlag> codePageUseFlags;
    @AFPField
    long unicodeScalarValue;

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        CPC_CodePageControl.checkDataLength(sfData, offset, length, 13);
        this.defaultGraphicCharacterGlobalID = new String(sfData, 0, 8, cpIBM500);
        this.defaultCharacterUseFlags = DefaultCharacterUseFlag.valueOf(sfData[8] & 0xFF);
        this.cpiRepeatingGroupLength = CPIRepeatingGroupLength.valueOf(sfData[9] & 0xFF);
        this.spaceCharacterSectionNumber = UtilBinaryDecoding.parseShort(sfData, offset + 10, 1);
        this.spaceCharacterCodePoint = UtilBinaryDecoding.parseShort(sfData, offset + 11, 1);
        this.codePageUseFlags = CodePageUseFlag.valueOf(sfData[12] & 0xFF);
        if (this.cpiRepeatingGroupLength == CPIRepeatingGroupLength.SingleByteCodePageUnicodeScalarValues || this.cpiRepeatingGroupLength == CPIRepeatingGroupLength.DoubleByteCodePageUnicodeScalarValues) {
            this.unicodeScalarValue = UtilBinaryDecoding.parseLong(sfData, 13, 4);
        }
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(UtilCharacterEncoding.stringToByteArray(this.defaultGraphicCharacterGlobalID, cpIBM500, 8, (byte)64));
        baos.write(DefaultCharacterUseFlag.toByte(this.defaultCharacterUseFlags));
        baos.write(this.cpiRepeatingGroupLength.val);
        baos.write(UtilBinaryDecoding.shortToByteArray(this.spaceCharacterSectionNumber, 1));
        baos.write(UtilBinaryDecoding.shortToByteArray(this.spaceCharacterCodePoint, 1));
        baos.write(CodePageUseFlag.toByte(this.codePageUseFlags));
        if (this.cpiRepeatingGroupLength == CPIRepeatingGroupLength.SingleByteCodePageUnicodeScalarValues || this.cpiRepeatingGroupLength == CPIRepeatingGroupLength.DoubleByteCodePageUnicodeScalarValues) {
            baos.write(UtilBinaryDecoding.longToByteArray(this.unicodeScalarValue, 4));
        }
        this.writeFullStructuredField(os, baos.toByteArray());
    }

    public String getDefaultGraphicCharacterGlobalID() {
        return this.defaultGraphicCharacterGlobalID;
    }

    public void setDefaultGraphicCharacterGlobalID(String defaultGraphicCharacterGlobalID) {
        this.defaultGraphicCharacterGlobalID = defaultGraphicCharacterGlobalID;
    }

    public EnumSet<DefaultCharacterUseFlag> getDefaultCharacterUseFlags() {
        return this.defaultCharacterUseFlags;
    }

    public void setDefaultCharacterUseFlags(EnumSet<DefaultCharacterUseFlag> defaultCharacterUseFlags) {
        this.defaultCharacterUseFlags = defaultCharacterUseFlags;
    }

    public CPIRepeatingGroupLength getCpiRepeatingGroupLength() {
        return this.cpiRepeatingGroupLength;
    }

    public void setCpiRepeatingGroupLength(CPIRepeatingGroupLength cpiRepeatingGroupLength) {
        this.cpiRepeatingGroupLength = cpiRepeatingGroupLength;
    }

    public short getSpaceCharacterSectionNumber() {
        return this.spaceCharacterSectionNumber;
    }

    public void setSpaceCharacterSectionNumber(short spaceCharacterSectionNumber) {
        this.spaceCharacterSectionNumber = spaceCharacterSectionNumber;
    }

    public short getSpaceCharacterCodePoint() {
        return this.spaceCharacterCodePoint;
    }

    public void setSpaceCharacterCodePoint(short spaceCharacterCodePoint) {
        this.spaceCharacterCodePoint = spaceCharacterCodePoint;
    }

    public EnumSet<CodePageUseFlag> getCodePageUseFlags() {
        return this.codePageUseFlags;
    }

    public void setCodePageUseFlags(EnumSet<CodePageUseFlag> codePageUseFlags) {
        this.codePageUseFlags = codePageUseFlags;
    }

    public long getUnicodeScalarValue() {
        return this.unicodeScalarValue;
    }

    public void setUnicodeScalarValue(long unicodeScalarValue) {
        this.unicodeScalarValue = unicodeScalarValue;
    }

    public static enum CodePageUseFlag {
        SortOrder,
        VariableSpaceEnable;


        public static EnumSet<CodePageUseFlag> valueOf(int flagByte) {
            EnumSet<CodePageUseFlag> result = EnumSet.noneOf(CodePageUseFlag.class);
            if ((flagByte & 0x80) != 0) {
                result.add(SortOrder);
            }
            if ((flagByte & 8) != 0) {
                result.add(VariableSpaceEnable);
            }
            return result;
        }

        public static int toByte(EnumSet<CodePageUseFlag> flags) {
            int result = 0;
            if (flags.contains((Object)SortOrder)) {
                result += 128;
            }
            if (flags.contains((Object)VariableSpaceEnable)) {
                result += 8;
            }
            return result;
        }
    }

    public static enum CPIRepeatingGroupLength {
        SingleByteCodePage(10),
        DoubleByteCodePage(11),
        SingleByteCodePageUnicodeScalarValues(254),
        DoubleByteCodePageUnicodeScalarValues(255);

        int val;

        private CPIRepeatingGroupLength(int val) {
            this.val = val;
        }

        public static CPIRepeatingGroupLength valueOf(int cpiRepeatingGroupLengthByte) {
            for (CPIRepeatingGroupLength cpiRGL : CPIRepeatingGroupLength.values()) {
                if (cpiRGL.val != cpiRepeatingGroupLengthByte) continue;
                return cpiRGL;
            }
            return null;
        }

        public int toByte() {
            return this.val;
        }

        public short nrOfBytes() {
            if (this == DoubleByteCodePage || this == DoubleByteCodePageUnicodeScalarValues) {
                return 2;
            }
            return 1;
        }

        public boolean isUnicodeScalarValues() {
            return this == SingleByteCodePageUnicodeScalarValues || this == DoubleByteCodePageUnicodeScalarValues;
        }
    }

    public static enum DefaultCharacterUseFlag {
        InvalidCodedCharacter,
        NoPresentation,
        NoIncrement;


        public static EnumSet<DefaultCharacterUseFlag> valueOf(int flagByte) {
            EnumSet<DefaultCharacterUseFlag> result = EnumSet.noneOf(DefaultCharacterUseFlag.class);
            if ((flagByte & 0x80) != 0) {
                result.add(InvalidCodedCharacter);
            }
            if ((flagByte & 0x40) != 0) {
                result.add(NoPresentation);
            }
            if ((flagByte & 0x20) != 0) {
                result.add(NoIncrement);
            }
            return result;
        }

        public static int toByte(EnumSet<DefaultCharacterUseFlag> flags) {
            int result = 0;
            if (flags.contains((Object)InvalidCodedCharacter)) {
                result += 128;
            }
            if (flags.contains((Object)NoPresentation)) {
                result += 64;
            }
            if (flags.contains((Object)NoIncrement)) {
                result += 32;
            }
            return result;
        }
    }
}

