/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.foca;

import com.mgz.afp.base.StructuredField;
import com.mgz.afp.base.annotations.AFPField;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.exceptions.IAFPDecodeableWriteable;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.util.Constants;
import com.mgz.util.UtilBinaryDecoding;
import com.mgz.util.UtilCharacterEncoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class FNI_FontIndex
extends StructuredField {
    @AFPField
    List<FNI_RepeatingGroup> repeatingGroups;

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        if (config.getCurrentFontControl() == null) {
            throw new AFPParserException(AFPParserConfiguration.class.getSimpleName() + ": current font control is not set.");
        }
        short repeatingGroupLength = config.getCurrentFontControl().fniRepeatingGroupLength;
        int actualLength = FNI_FontIndex.getActualLength(sfData, offset, length);
        this.repeatingGroups = new ArrayList<FNI_RepeatingGroup>(actualLength / repeatingGroupLength);
        for (int pos = 0; pos < actualLength; pos += repeatingGroupLength) {
            FNI_RepeatingGroup repeatingGroup = new FNI_RepeatingGroup();
            repeatingGroup.decodeAFP(sfData, offset + pos, repeatingGroupLength, config);
            this.repeatingGroups.add(repeatingGroup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (this.repeatingGroups != null) {
            if (this.repeatingGroups.size() > 1) {
                List<FNI_RepeatingGroup> list = this.repeatingGroups;
                synchronized (list) {
                    Collections.sort(this.repeatingGroups, new FNI_RepeatingGroup.ComparatorForFNIRepeatinGroups());
                }
            }
            for (FNI_RepeatingGroup rg : this.repeatingGroups) {
                rg.writeAFP(baos, config);
            }
        }
        this.writeFullStructuredField(os, baos.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FNI_RepeatingGroup> getRepeatingGroups() {
        if (this.repeatingGroups != null && this.repeatingGroups.size() > 1) {
            List<FNI_RepeatingGroup> list = this.repeatingGroups;
            synchronized (list) {
                Collections.sort(this.repeatingGroups, new FNI_RepeatingGroup.ComparatorForFNIRepeatinGroups());
            }
        }
        return this.repeatingGroups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRepeatingGroups(List<FNI_RepeatingGroup> repeatingGroups) {
        this.repeatingGroups = repeatingGroups;
        List<FNI_RepeatingGroup> list = repeatingGroups;
        synchronized (list) {
            Collections.sort(repeatingGroups, new FNI_RepeatingGroup.ComparatorForFNIRepeatinGroups());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRepeatingGroup(FNI_RepeatingGroup repeatinGroup) {
        if (this.repeatingGroups == null) {
            this.repeatingGroups = new ArrayList<FNI_RepeatingGroup>();
            this.repeatingGroups.add(repeatinGroup);
        } else {
            this.repeatingGroups.add(repeatinGroup);
            List<FNI_RepeatingGroup> list = this.repeatingGroups;
            synchronized (list) {
                Collections.sort(this.repeatingGroups, new FNI_RepeatingGroup.ComparatorForFNIRepeatinGroups());
            }
        }
    }

    public static class FNI_RepeatingGroup
    implements IAFPDecodeableWriteable {
        @AFPField
        volatile short repeatingGroupLength;
        @AFPField
        String graphicCharacterGlobalID_GCGID;
        @AFPField
        short characterIncrement;
        @AFPField
        short ascenderHeight;
        @AFPField
        short descenderDepth;
        @AFPField(size=2)
        byte[] reserved14_15 = new byte[]{0, 0};
        @AFPField
        int fnmIndex;
        @AFPField
        short ASpace;
        @AFPField
        short BSpace;
        @AFPField
        short CSpace;
        @AFPField(size=2)
        byte[] reserved24_25 = new byte[]{0, 0};
        @AFPField
        short baselineOffset;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.repeatingGroupLength = (short)(length != -1 ? length : sfData.length - offset);
            this.graphicCharacterGlobalID_GCGID = new String(sfData, offset, 8, Constants.cpIBM500);
            this.characterIncrement = UtilBinaryDecoding.parseShort(sfData, offset + 8, 2);
            if (this.repeatingGroupLength > 10) {
                this.ascenderHeight = UtilBinaryDecoding.parseShort(sfData, offset + 10, 2);
                this.descenderDepth = UtilBinaryDecoding.parseShort(sfData, offset + 12, 2);
                this.reserved14_15 = Constants.EMPTYBYTES_2;
                this.fnmIndex = UtilBinaryDecoding.parseInt(sfData, offset + 16, 2);
                this.ASpace = UtilBinaryDecoding.parseShort(sfData, offset + 18, 2);
                this.BSpace = UtilBinaryDecoding.parseShort(sfData, offset + 20, 2);
                this.CSpace = UtilBinaryDecoding.parseShort(sfData, offset + 22, 2);
                this.reserved24_25 = Constants.EMPTYBYTES_2;
                this.baselineOffset = UtilBinaryDecoding.parseShort(sfData, offset + 26, 2);
            } else {
                this.ascenderHeight = (short)-1;
                this.descenderDepth = (short)-1;
                this.reserved14_15 = null;
                this.fnmIndex = -1;
                this.ASpace = (short)-1;
                this.BSpace = (short)-1;
                this.CSpace = (short)-1;
                this.reserved24_25 = null;
                this.baselineOffset = (short)-1;
            }
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(UtilCharacterEncoding.stringToByteArray(this.graphicCharacterGlobalID_GCGID, Constants.cpIBM500, 8, (byte)64));
            os.write(UtilBinaryDecoding.shortToByteArray(this.characterIncrement, 2));
            if (this.repeatingGroupLength > 10) {
                os.write(UtilBinaryDecoding.shortToByteArray(this.ascenderHeight, 2));
                os.write(UtilBinaryDecoding.shortToByteArray(this.descenderDepth, 2));
                os.write(this.reserved14_15);
                os.write(UtilBinaryDecoding.intToByteArray(this.fnmIndex, 2));
                os.write(UtilBinaryDecoding.shortToByteArray(this.ASpace, 2));
                os.write(UtilBinaryDecoding.shortToByteArray(this.BSpace, 2));
                os.write(UtilBinaryDecoding.shortToByteArray(this.CSpace, 2));
                os.write(this.reserved24_25);
                os.write(UtilBinaryDecoding.shortToByteArray(this.baselineOffset, 2));
            }
        }

        public short getRepeatingGroupLength() {
            return this.repeatingGroupLength;
        }

        public void setRepeatingGroupLength(short repeatingGroupLength) {
            this.repeatingGroupLength = repeatingGroupLength;
        }

        public String getGraphicCharacterGlobalID_GCGID() {
            return this.graphicCharacterGlobalID_GCGID;
        }

        public void setGraphicCharacterGlobalID_GCGID(String graphicCharacterGlobalID_GCGID) {
            this.graphicCharacterGlobalID_GCGID = graphicCharacterGlobalID_GCGID;
        }

        public short getCharacterIncrement() {
            return this.characterIncrement;
        }

        public void setCharacterIncrement(short characterIncrement) {
            this.characterIncrement = characterIncrement;
        }

        public short getAscenderHeight() {
            return this.ascenderHeight;
        }

        public void setAscenderHeight(short ascenderHeight) {
            this.ascenderHeight = ascenderHeight;
        }

        public short getDescenderDepth() {
            return this.descenderDepth;
        }

        public void setDescenderDepth(short descenderDepth) {
            this.descenderDepth = descenderDepth;
        }

        public byte[] getReserved14_15() {
            return this.reserved14_15;
        }

        public void setReserved14_15(byte[] reserved14_15) {
            this.reserved14_15 = reserved14_15;
        }

        public int getFnmIndex() {
            return this.fnmIndex;
        }

        public void setFnmIndex(int fnmIndex) {
            this.fnmIndex = fnmIndex;
        }

        public short getASpace() {
            return this.ASpace;
        }

        public void setASpace(short aSpace) {
            this.ASpace = aSpace;
        }

        public short getBSpace() {
            return this.BSpace;
        }

        public void setBSpace(short bSpace) {
            this.BSpace = bSpace;
        }

        public short getCSpace() {
            return this.CSpace;
        }

        public void setCSpace(short cSpace) {
            this.CSpace = cSpace;
        }

        public byte[] getReserved24_25() {
            return this.reserved24_25;
        }

        public void setReserved24_25(byte[] reserved24_25) {
            this.reserved24_25 = reserved24_25;
        }

        public short getBaselineOffset() {
            return this.baselineOffset;
        }

        public void setBaselineOffset(short baselineOffset) {
            this.baselineOffset = baselineOffset;
        }

        public static class ComparatorForFNIRepeatinGroups
        implements Comparator<FNI_RepeatingGroup> {
            @Override
            public int compare(FNI_RepeatingGroup o1, FNI_RepeatingGroup o2) {
                return o1.graphicCharacterGlobalID_GCGID.compareTo(o2.graphicCharacterGlobalID_GCGID);
            }
        }
    }
}

