/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.foca;

import com.mgz.afp.base.StructuredField;
import com.mgz.afp.base.annotations.AFPField;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.exceptions.IAFPDecodeableWriteable;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.util.UtilBinaryDecoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class FNP_FontPosition
extends StructuredField {
    @AFPField
    List<FNP_RepeatingGroup> repeatingGroups;

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        int actualLength = length != -1 ? length : sfData.length - offset;
        this.repeatingGroups = new ArrayList<FNP_RepeatingGroup>();
        for (int pos = 0; pos < actualLength; pos += 22) {
            FNP_RepeatingGroup rg = new FNP_RepeatingGroup();
            rg.decodeAFP(sfData, offset + pos, 22, config);
            this.repeatingGroups.add(rg);
        }
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(this.repeatingGroups.size() * 22);
        for (FNP_RepeatingGroup rg : this.repeatingGroups) {
            rg.writeAFP(baos, config);
        }
        this.writeFullStructuredField(os, baos.toByteArray());
    }

    public List<FNP_RepeatingGroup> getRepeatingGroups() {
        return this.repeatingGroups;
    }

    public void setRepeatingGroups(List<FNP_RepeatingGroup> repeatingGroups) {
        this.repeatingGroups = repeatingGroups;
    }

    public void addFNPRepeatingGroup(FNP_RepeatingGroup rg) {
        if (rg == null) {
            return;
        }
        if (this.repeatingGroups == null) {
            this.repeatingGroups = new ArrayList<FNP_RepeatingGroup>();
        }
        this.repeatingGroups.add(rg);
    }

    public void removeRepeatingGroup(FNP_RepeatingGroup rg) {
        if (this.repeatingGroups == null) {
            return;
        }
        this.repeatingGroups.remove(rg);
    }

    public static class FNP_RepeatingGroup
    implements IAFPDecodeableWriteable {
        @AFPField(size=2)
        byte[] reserved0_1 = new byte[]{0, 0};
        @AFPField
        short lowercaseHeight;
        @AFPField
        short capMHeight;
        @AFPField
        short maxAscenderHeight;
        @AFPField
        short maxDescenderDepth;
        @AFPField(size=5)
        byte[] reserved10_14 = new byte[]{0, 0, 0, 0, 0};
        @AFPField
        short retired15 = 1;
        @AFPField
        short reserved16 = 0;
        @AFPField
        short underscoreWidth_Units;
        @AFPField
        short underscoreWidthFraction = 0;
        @AFPField
        short underscorePosition;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            StructuredField.checkDataLength(sfData, offset, length, 22);
            this.reserved0_1 = new byte[2];
            System.arraycopy(sfData, offset, this.reserved0_1, 0, this.reserved0_1.length);
            this.lowercaseHeight = UtilBinaryDecoding.parseShort(sfData, offset + 2, 2);
            this.capMHeight = UtilBinaryDecoding.parseShort(sfData, offset + 4, 2);
            this.maxAscenderHeight = UtilBinaryDecoding.parseShort(sfData, offset + 6, 2);
            this.maxDescenderDepth = UtilBinaryDecoding.parseShort(sfData, offset + 8, 2);
            this.reserved10_14 = new byte[5];
            System.arraycopy(sfData, offset + 10, this.reserved10_14, 0, this.reserved10_14.length);
            this.retired15 = UtilBinaryDecoding.parseShort(sfData, offset + 15, 1);
            this.reserved16 = UtilBinaryDecoding.parseShort(sfData, offset + 16, 1);
            this.underscoreWidth_Units = UtilBinaryDecoding.parseShort(sfData, offset + 17, 2);
            this.underscoreWidthFraction = UtilBinaryDecoding.parseShort(sfData, offset + 19, 1);
            this.underscorePosition = UtilBinaryDecoding.parseShort(sfData, offset + 20, 2);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.reserved0_1);
            os.write(UtilBinaryDecoding.shortToByteArray(this.lowercaseHeight, 2));
            os.write(UtilBinaryDecoding.shortToByteArray(this.capMHeight, 2));
            os.write(UtilBinaryDecoding.shortToByteArray(this.maxAscenderHeight, 2));
            os.write(UtilBinaryDecoding.shortToByteArray(this.maxDescenderDepth, 2));
            os.write(this.reserved10_14);
            os.write(this.retired15);
            os.write(this.reserved16);
            os.write(UtilBinaryDecoding.shortToByteArray(this.underscoreWidth_Units, 2));
            os.write(this.underscoreWidthFraction);
            os.write(UtilBinaryDecoding.shortToByteArray(this.underscorePosition, 2));
        }

        public byte[] getReserved0_1() {
            return this.reserved0_1;
        }

        public void setReserved0_1(byte[] reserved0_1) {
            this.reserved0_1 = reserved0_1;
        }

        public short getLowercaseHeight() {
            return this.lowercaseHeight;
        }

        public void setLowercaseHeight(short lowercaseHeight) {
            this.lowercaseHeight = lowercaseHeight;
        }

        public short getCapMHeight() {
            return this.capMHeight;
        }

        public void setCapMHeight(short capMHeight) {
            this.capMHeight = capMHeight;
        }

        public short getMaxAscenderHeight() {
            return this.maxAscenderHeight;
        }

        public void setMaxAscenderHeight(short maxAscenderHeight) {
            this.maxAscenderHeight = maxAscenderHeight;
        }

        public short getMaxDescenderDepth() {
            return this.maxDescenderDepth;
        }

        public void setMaxDescenderDepth(short maxDescenderDepth) {
            this.maxDescenderDepth = maxDescenderDepth;
        }

        public byte[] getReserved10_14() {
            return this.reserved10_14;
        }

        public void setReserved10_14(byte[] reserved10_14) {
            this.reserved10_14 = reserved10_14;
        }

        public short getRetired15() {
            return this.retired15;
        }

        public void setRetired15(short retired15) {
            this.retired15 = retired15;
        }

        public short getReserved16() {
            return this.reserved16;
        }

        public void setReserved16(short reserved16) {
            this.reserved16 = reserved16;
        }

        public short getUnderscoreWidth_Units() {
            return this.underscoreWidth_Units;
        }

        public void setUnderscoreWidth_Units(short underscoreWidth_Units) {
            this.underscoreWidth_Units = underscoreWidth_Units;
        }

        public short getUnderscoreWidthFraction() {
            return this.underscoreWidthFraction;
        }

        public void setUnderscoreWidthFraction(short underscoreWidthFraction) {
            this.underscoreWidthFraction = underscoreWidthFraction;
        }

        public short getUnderscorePosition() {
            return this.underscorePosition;
        }

        public void setUnderscorePosition(short underscorePosition) {
            this.underscorePosition = underscorePosition;
        }
    }
}

