/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.ioca;

import com.mgz.afp.base.StructuredField;
import com.mgz.afp.enums.AFPColorSpace;
import com.mgz.afp.enums.AFPColorValue;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.exceptions.IAFPDecodeableWriteable;
import com.mgz.afp.ioca.IDD_ImageDataDescriptor;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.util.UtilBinaryDecoding;
import java.io.IOException;
import java.io.OutputStream;

public abstract class IDD_SelfDefiningField
implements IAFPDecodeableWriteable {
    SelfDefiningFieldType fieldType;
    short lengthOfFollowingData;

    public SelfDefiningFieldType getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(SelfDefiningFieldType fieldType) {
        this.fieldType = fieldType;
    }

    public short getLengthOfFollowingData() {
        return this.lengthOfFollowingData;
    }

    public void setLengthOfFollowingData(short lengthOfFollowingData) {
        this.lengthOfFollowingData = lengthOfFollowingData;
    }

    public static class UnknownSelfDefiningField
    extends IDD_SelfDefiningField {
        short unknownFieldType;
        byte[] data;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.unknownFieldType = UtilBinaryDecoding.parseShort(sfData, offset, 1);
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
            if (this.lengthOfFollowingData > 0) {
                this.data = new byte[this.lengthOfFollowingData];
                System.arraycopy(sfData, offset + 2, this.data, 0, this.data.length);
            } else {
                this.data = null;
            }
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            this.lengthOfFollowingData = this.data == null ? (short)0 : (short)this.data.length;
            os.write(this.unknownFieldType);
            os.write(this.lengthOfFollowingData);
            if (this.data != null) {
                os.write(this.data);
            }
        }
    }

    public static class IOCAFunctionSetIdentification
    extends IDD_SelfDefiningField {
        short functionSetCategory;
        FunctionSetIdentifier functionSetIdentifier;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            StructuredField.checkDataLength(sfData, offset, length, 4);
            this.fieldType = SelfDefiningFieldType.valueOf(UtilBinaryDecoding.parseShort(sfData, offset, 1));
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
            this.functionSetCategory = UtilBinaryDecoding.parseShort(sfData, offset + 2, 1);
            this.functionSetIdentifier = FunctionSetIdentifier.valueOf(sfData[offset + 3]);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.fieldType.toByte());
            os.write(this.lengthOfFollowingData);
            os.write(this.functionSetCategory);
            os.write(this.functionSetIdentifier.toByte());
        }

        public short getFunctionSetCategory() {
            return this.functionSetCategory;
        }

        public void setFunctionSetCategory(short functionSetCategory) {
            this.functionSetCategory = functionSetCategory;
        }

        public FunctionSetIdentifier getFunctionSetIdentifier() {
            return this.functionSetIdentifier;
        }

        public void setFunctionSetIdentifier(FunctionSetIdentifier functionSetIdentifier) {
            this.functionSetIdentifier = functionSetIdentifier;
        }

        public static enum FunctionSetIdentifier {
            FS10(10),
            FS11(11),
            FS40(40),
            FS42(42),
            FS45(45);

            int code;

            private FunctionSetIdentifier(int fsCodeByte) {
                this.code = fsCodeByte;
            }

            public static FunctionSetIdentifier valueOf(byte fsCodeByte) {
                for (FunctionSetIdentifier fsi : FunctionSetIdentifier.values()) {
                    if (fsi.code != fsCodeByte) continue;
                    return fsi;
                }
                return null;
            }

            public int toByte() {
                return this.code;
            }
        }
    }

    public static class SetExtendedBilevelImageColor
    extends IDD_SelfDefiningField {
        short reserved2 = 0;
        AFPColorSpace colorSpace;
        byte[] reserved4_7 = new byte[]{0, 0};
        byte nrOfBitsComponent1;
        byte nrOfBitsComponent2;
        byte nrOfBitsComponent3;
        byte nrOfBitsComponent4;
        byte[] colorValue;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            IDD_ImageDataDescriptor.checkDataLength(sfData, offset, length, 6);
            this.fieldType = SelfDefiningFieldType.valueOf(UtilBinaryDecoding.parseShort(sfData, offset, 1));
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
            this.reserved2 = UtilBinaryDecoding.parseShort(sfData, offset + 2, 1);
            this.colorSpace = AFPColorSpace.valueOf(sfData[offset + 3]);
            this.reserved4_7 = new byte[4];
            System.arraycopy(sfData, offset + 5, this.reserved4_7, 0, 4);
            this.nrOfBitsComponent1 = sfData[offset + 8];
            this.nrOfBitsComponent2 = sfData[offset + 9];
            this.nrOfBitsComponent3 = sfData[offset + 10];
            this.nrOfBitsComponent4 = sfData[offset + 11];
            this.colorValue = new byte[this.lengthOfFollowingData - 10];
            System.arraycopy(sfData, offset + 12, this.colorValue, 0, this.colorValue.length);
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.fieldType.toByte());
            os.write(this.lengthOfFollowingData);
            os.write(this.reserved2);
            os.write(this.colorSpace.toByte());
            os.write(this.reserved4_7);
            os.write(this.nrOfBitsComponent1);
            os.write(this.nrOfBitsComponent2);
            os.write(this.nrOfBitsComponent3);
            os.write(this.nrOfBitsComponent4);
            os.write(this.colorValue);
        }

        public short getReserved2() {
            return this.reserved2;
        }

        public void setReserved2(short reserved2) {
            this.reserved2 = reserved2;
        }

        public AFPColorSpace getColorSpace() {
            return this.colorSpace;
        }

        public void setColorSpace(AFPColorSpace colorSpace) {
            this.colorSpace = colorSpace;
        }

        public byte[] getReserved4_7() {
            return this.reserved4_7;
        }

        public void setReserved4_7(byte[] reserved4_7) {
            this.reserved4_7 = reserved4_7;
        }

        public byte getNrOfBitsComponent1() {
            return this.nrOfBitsComponent1;
        }

        public void setNrOfBitsComponent1(byte nrOfBitsComponent1) {
            this.nrOfBitsComponent1 = nrOfBitsComponent1;
        }

        public byte getNrOfBitsComponent2() {
            return this.nrOfBitsComponent2;
        }

        public void setNrOfBitsComponent2(byte nrOfBitsComponent2) {
            this.nrOfBitsComponent2 = nrOfBitsComponent2;
        }

        public byte getNrOfBitsComponent3() {
            return this.nrOfBitsComponent3;
        }

        public void setNrOfBitsComponent3(byte nrOfBitsComponent3) {
            this.nrOfBitsComponent3 = nrOfBitsComponent3;
        }

        public byte getNrOfBitsComponent4() {
            return this.nrOfBitsComponent4;
        }

        public void setNrOfBitsComponent4(byte nrOfBitsComponent4) {
            this.nrOfBitsComponent4 = nrOfBitsComponent4;
        }

        public byte[] getColorValue() {
            return this.colorValue;
        }

        public void setColorValue(byte[] colorValue) {
            this.colorValue = colorValue;
        }
    }

    public static class SetBilevelImageColor
    extends IDD_SelfDefiningField {
        short applicabilityArea;
        short reserved3 = 0;
        AFPColorValue color;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            IDD_ImageDataDescriptor.checkDataLength(sfData, offset, length, 6);
            this.fieldType = SelfDefiningFieldType.valueOf(UtilBinaryDecoding.parseShort(sfData, offset, 1));
            this.lengthOfFollowingData = UtilBinaryDecoding.parseShort(sfData, offset + 1, 1);
            this.applicabilityArea = UtilBinaryDecoding.parseShort(sfData, offset + 2, 1);
            this.reserved3 = UtilBinaryDecoding.parseShort(sfData, offset + 3, 1);
            this.color = AFPColorValue.valueOf(UtilBinaryDecoding.parseInt(sfData, offset + 4, 2));
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            os.write(this.fieldType.toByte());
            os.write(this.lengthOfFollowingData);
            os.write(this.applicabilityArea);
            os.write(this.reserved3);
            os.write(this.color.toByte2());
        }

        public short getApplicabilityArea() {
            return this.applicabilityArea;
        }

        public void setApplicabilityArea(short applicabilityArea) {
            this.applicabilityArea = applicabilityArea;
        }

        public short getReserved3() {
            return this.reserved3;
        }

        public void setReserved3(short reserved3) {
            this.reserved3 = reserved3;
        }

        public AFPColorValue getColor() {
            return this.color;
        }

        public void setColor(AFPColorValue color) {
            this.color = color;
        }
    }

    public static enum SelfDefiningFieldType {
        Unknown(0),
        SetBilevelImageColor(246),
        SetExtendedBilevelImageColor(244),
        IOCAFunctionSetIdentification(247);

        int fieldType;

        private SelfDefiningFieldType(int fieldTypeByte) {
            this.fieldType = fieldTypeByte;
        }

        public static SelfDefiningFieldType valueOf(short fieldTypeByte) {
            for (SelfDefiningFieldType t : SelfDefiningFieldType.values()) {
                if (t.fieldType != fieldTypeByte) continue;
                return t;
            }
            return Unknown;
        }

        public int toByte() {
            return this.fieldType;
        }
    }
}

