/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.lineData;

import com.mgz.afp.base.IHasName;
import com.mgz.afp.base.StructuredFieldBaseTriplets;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.afp.triplets.Triplet;
import com.mgz.util.UtilCharacterEncoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BDM_BeginDataMap
extends StructuredFieldBaseTriplets
implements IHasName {
    String name;
    BDM_DataFormat dataFormat;

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        int actualLength = BDM_BeginDataMap.getActualLength(sfData, offset, length);
        this.name = new String(sfData, offset, 8, config.getAfpCharSet());
        if (actualLength > 8) {
            this.dataFormat = BDM_DataFormat.valueOf(sfData[offset + 8]);
            if (actualLength > 9) {
                super.decodeAFP(sfData, offset + 9, actualLength - 9, config);
            } else {
                this.triplets = null;
            }
        } else {
            this.dataFormat = null;
            this.triplets = null;
        }
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(UtilCharacterEncoding.stringToByteArray(this.name, config.getAfpCharSet(), 8, (byte)64));
        if (this.dataFormat != null) {
            baos.write(this.dataFormat.toByte());
            if (this.triplets != null) {
                for (Triplet t : this.triplets) {
                    t.writeAFP(baos, config);
                }
            }
        }
        this.writeFullStructuredField(os, baos.toByteArray());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String dataMapName) {
        this.name = dataMapName;
    }

    public BDM_DataFormat getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(BDM_DataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    public static enum BDM_DataFormat {
        UsingLND,
        UsingRCD,
        UsingXMD;


        public static BDM_DataFormat valueOf(byte dataFormtCode) {
            for (BDM_DataFormat df : BDM_DataFormat.values()) {
                if (df.ordinal() != dataFormtCode) continue;
                return df;
            }
            return null;
        }

        public int toByte() {
            return this.ordinal();
        }
    }
}

