/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.lineData;

import com.mgz.afp.base.StructuredFieldBaseTriplets;
import com.mgz.afp.enums.AFPColorValue;
import com.mgz.afp.enums.AFPOrientation;
import com.mgz.afp.enums.IMutualExclusiveGroupedFlag;
import com.mgz.afp.enums.MutualExclusiveGroupedFlagHandler;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.afp.triplets.Triplet;
import com.mgz.util.UtilBinaryDecoding;
import com.mgz.util.UtilCharacterEncoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.EnumSet;

public class LND_LineDescriptor
extends StructuredFieldBaseTriplets {
    EnumSet<LND_Flag> flags;
    int inlinePosition;
    int baselinePosition;
    AFPOrientation inlineOrientation;
    AFPOrientation baselineOrientation;
    short primaryFontLocalId;
    byte channelCode;
    int nextLNDIfSkipping;
    int nextLNDIfSpacing;
    int nextLNDIfReusingData;
    String suppressionTokenName;
    byte shiftOutLocalFontID;
    int dataStartPosition;
    int dataLength;
    AFPColorValue textColor;
    int nextLNDIfConditionalProcessing;
    short subpageID;
    int ccpIdentifier;

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        this.flags = LND_Flag.valueOf(UtilBinaryDecoding.parseInt(sfData, offset, 2));
        this.inlinePosition = UtilBinaryDecoding.parseInt(sfData, offset + 2, 2);
        this.baselinePosition = this.flags.contains(LND_Flag.RelativeBaselinePosition_AbsolutePosition) ? UtilBinaryDecoding.parseInt(sfData, offset + 4, 2) : (int)UtilBinaryDecoding.parseShort(sfData, offset + 4, 2);
        this.inlineOrientation = AFPOrientation.valueOf(UtilBinaryDecoding.parseInt(sfData, offset + 6, 2));
        this.baselineOrientation = AFPOrientation.valueOf(UtilBinaryDecoding.parseInt(sfData, offset + 8, 2));
        this.primaryFontLocalId = UtilBinaryDecoding.parseShort(sfData, offset + 10, 1);
        this.channelCode = sfData[offset + 11];
        this.nextLNDIfSkipping = UtilBinaryDecoding.parseInt(sfData, offset + 12, 2);
        this.nextLNDIfSpacing = UtilBinaryDecoding.parseInt(sfData, offset + 14, 2);
        this.nextLNDIfReusingData = UtilBinaryDecoding.parseInt(sfData, offset + 16, 2);
        this.suppressionTokenName = new String(sfData, offset + 18, 8, config.getAfpCharSet());
        this.shiftOutLocalFontID = sfData[offset + 26];
        this.dataStartPosition = UtilBinaryDecoding.parseInt(sfData, offset + 27, 4);
        this.dataLength = UtilBinaryDecoding.parseInt(sfData, offset + 31, 2);
        this.textColor = AFPColorValue.valueOf(UtilBinaryDecoding.parseInt(sfData, offset + 33, 2));
        this.nextLNDIfConditionalProcessing = UtilBinaryDecoding.parseInt(sfData, offset + 35, 2);
        this.subpageID = UtilBinaryDecoding.parseShort(sfData, offset + 37, 1);
        this.ccpIdentifier = UtilBinaryDecoding.parseInt(sfData, offset + 38, 2);
        if (LND_LineDescriptor.getActualLength(sfData, offset, length) > 40) {
            super.decodeAFP(sfData, offset + 40, -1, config);
        } else {
            this.triplets = null;
        }
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(LND_Flag.toBytes(this.flags));
        baos.write(UtilBinaryDecoding.intToByteArray(this.inlinePosition, 2));
        baos.write(UtilBinaryDecoding.intToByteArray(this.baselinePosition, 2));
        baos.write(this.inlineOrientation.toBytes());
        baos.write(this.baselineOrientation.toBytes());
        baos.write(this.primaryFontLocalId);
        baos.write(this.channelCode);
        baos.write(UtilBinaryDecoding.intToByteArray(this.nextLNDIfSkipping, 2));
        baos.write(UtilBinaryDecoding.intToByteArray(this.nextLNDIfSpacing, 2));
        baos.write(UtilBinaryDecoding.intToByteArray(this.nextLNDIfReusingData, 2));
        baos.write(UtilCharacterEncoding.stringToByteArray(this.suppressionTokenName, config.getAfpCharSet(), 8, (byte)64));
        baos.write(this.shiftOutLocalFontID);
        baos.write(UtilBinaryDecoding.intToByteArray(this.dataStartPosition, 4));
        baos.write(UtilBinaryDecoding.intToByteArray(this.dataLength, 2));
        baos.write(this.textColor.toByte());
        baos.write(UtilBinaryDecoding.intToByteArray(this.nextLNDIfConditionalProcessing, 2));
        baos.write(this.subpageID);
        baos.write(UtilBinaryDecoding.intToByteArray(this.ccpIdentifier, 2));
        if (this.triplets != null) {
            for (Triplet t : this.triplets) {
                t.writeAFP(baos, config);
            }
        }
        this.writeFullStructuredField(os, baos.toByteArray());
    }

    public EnumSet<LND_Flag> getFlags() {
        return this.flags;
    }

    public void setFlags(EnumSet<LND_Flag> flags) {
        this.flags = flags;
    }

    public int getInlinePosition() {
        return this.inlinePosition;
    }

    public void setInlinePosition(int inlinePosition) {
        this.inlinePosition = inlinePosition;
    }

    public int getBaselinePosition() {
        return this.baselinePosition;
    }

    public void setBaselinePosition(int baselinePosition) {
        this.baselinePosition = baselinePosition;
    }

    public short getPrimaryFontLocalId() {
        return this.primaryFontLocalId;
    }

    public void setPrimaryFontLocalId(short primaryFontLocalId) {
        this.primaryFontLocalId = primaryFontLocalId;
    }

    public byte getChannelCode() {
        return this.channelCode;
    }

    public void setChannelCode(byte channelCode) {
        this.channelCode = channelCode;
    }

    public int getNextLNDIfSkipping() {
        return this.nextLNDIfSkipping;
    }

    public void setNextLNDIfSkipping(int nextLNDIfSkipping) {
        this.nextLNDIfSkipping = nextLNDIfSkipping;
    }

    public int getNextLNDIfSpacing() {
        return this.nextLNDIfSpacing;
    }

    public void setNextLNDIfSpacing(int nextLNDIfSpacing) {
        this.nextLNDIfSpacing = nextLNDIfSpacing;
    }

    public int getNextLNDIfReusingData() {
        return this.nextLNDIfReusingData;
    }

    public void setNextLNDIfReusingData(int nextLNDIfReusingData) {
        this.nextLNDIfReusingData = nextLNDIfReusingData;
    }

    public String getSuppressionTokenName() {
        return this.suppressionTokenName;
    }

    public void setSuppressionTokenName(String suppressionTokenName) {
        this.suppressionTokenName = suppressionTokenName;
    }

    public byte getShiftOutLocalFontID() {
        return this.shiftOutLocalFontID;
    }

    public void setShiftOutLocalFontID(byte shiftOutLocalFontID) {
        this.shiftOutLocalFontID = shiftOutLocalFontID;
    }

    public int getDataStartPosition() {
        return this.dataStartPosition;
    }

    public void setDataStartPosition(int dataStartPosition) {
        this.dataStartPosition = dataStartPosition;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public void setDataLength(int dataLength) {
        this.dataLength = dataLength;
    }

    public AFPColorValue getTextColor() {
        return this.textColor;
    }

    public void setTextColor(AFPColorValue textColor) {
        this.textColor = textColor;
    }

    public int getNextLNDIfConditionalProcessing() {
        return this.nextLNDIfConditionalProcessing;
    }

    public void setNextLNDIfConditionalProcessing(int nextLNDIfConditionalProcessing) {
        this.nextLNDIfConditionalProcessing = nextLNDIfConditionalProcessing;
    }

    public short getSubpageID() {
        return this.subpageID;
    }

    public void setSubpageID(short subpageID) {
        this.subpageID = subpageID;
    }

    public int getCcpIdentifier() {
        return this.ccpIdentifier;
    }

    public void setCcpIdentifier(int ccpIdentifier) {
        this.ccpIdentifier = ccpIdentifier;
    }

    public AFPOrientation getInlineOrientation() {
        return this.inlineOrientation;
    }

    public void setInlineOrientation(AFPOrientation inlineOrientation) {
        this.inlineOrientation = inlineOrientation;
    }

    public AFPOrientation getBaselineOrientation() {
        return this.baselineOrientation;
    }

    public void setBaselineOrientation(AFPOrientation baselineOrientation) {
        this.baselineOrientation = baselineOrientation;
    }

    public static enum LND_Flag implements IMutualExclusiveGroupedFlag
    {
        Skipping_CurrentPageDoesNotEnd(0),
        Skipping_CurrentPagesEnds(0),
        Spacing_CurrentPageDoesNotEnd(1),
        Spacing_CurrentPagesEnds(1),
        GenerateInlinePosition_CurrentPosition(2),
        GenerateInlinePosition_NewPosition(2),
        GenerateBaselinePosition_CurrentPosition(3),
        GenerateBaselinePosition_NewPosition(3),
        GenerateFontChange_TRC_MRC_Default(4),
        GenerateFontChange_AsSpecified(4),
        GenerateSuppression_TextIsNotSuppressible(5),
        GenerateSuppression_TextIsSuppressible(5),
        ReuseRecord_DoNotReuse(6),
        ReuseRecord_DoReuse(6),
        UseFixedData_DoNotPresent(7),
        UseFixedData_DoPresent(7),
        UseCompatibilityTRC_DoNotUse(8),
        UseCompatibilityTRC_DoUse(8),
        SetTextColor_DefaultColor(9),
        SetTextColor_AsSpecified(9),
        ConditionalProcessing_DoNotPerformCP(10),
        ConditionalProcessing_DoPerformCP(10),
        ResourceObjectInclude_DoNotIncludeResource(12),
        ResourceObjectInclude_DoIncludeResource(12),
        RelativeBaselinePosition_AbsolutePosition(13),
        RelativeBaselinePosition_RelativePosition(13);

        private static MutualExclusiveGroupedFlagHandler<LND_Flag> handler;
        int group;

        private LND_Flag(int group) {
            this.group = group;
        }

        public static EnumSet<LND_Flag> valueOf(int flagBytes) {
            EnumSet<LND_Flag> result = EnumSet.noneOf(LND_Flag.class);
            if ((flagBytes & 0x8000) != 0) {
                result.add(Skipping_CurrentPagesEnds);
            } else {
                result.add(Skipping_CurrentPageDoesNotEnd);
            }
            if ((flagBytes & 0x4000) != 0) {
                result.add(Spacing_CurrentPagesEnds);
            } else {
                result.add(Spacing_CurrentPageDoesNotEnd);
            }
            if ((flagBytes & 0x2000) != 0) {
                result.add(GenerateInlinePosition_NewPosition);
            } else {
                result.add(GenerateInlinePosition_CurrentPosition);
            }
            if ((flagBytes & 0x1000) != 0) {
                result.add(GenerateBaselinePosition_NewPosition);
            } else {
                result.add(GenerateBaselinePosition_CurrentPosition);
            }
            if ((flagBytes & 0x800) != 0) {
                result.add(GenerateFontChange_AsSpecified);
            } else {
                result.add(GenerateFontChange_TRC_MRC_Default);
            }
            if ((flagBytes & 0x400) != 0) {
                result.add(GenerateSuppression_TextIsSuppressible);
            } else {
                result.add(GenerateSuppression_TextIsNotSuppressible);
            }
            if ((flagBytes & 0x200) != 0) {
                result.add(ReuseRecord_DoReuse);
            } else {
                result.add(ReuseRecord_DoNotReuse);
            }
            if ((flagBytes & 0x100) != 0) {
                result.add(UseFixedData_DoPresent);
            } else {
                result.add(UseFixedData_DoNotPresent);
            }
            if ((flagBytes & 0x40) != 0) {
                result.add(UseCompatibilityTRC_DoUse);
            } else {
                result.add(UseCompatibilityTRC_DoNotUse);
            }
            if ((flagBytes & 0x20) != 0) {
                result.add(SetTextColor_AsSpecified);
            } else {
                result.add(SetTextColor_DefaultColor);
            }
            if ((flagBytes & 0x10) != 0) {
                result.add(ConditionalProcessing_DoPerformCP);
            } else {
                result.add(ConditionalProcessing_DoNotPerformCP);
            }
            if ((flagBytes & 8) != 0) {
                result.add(ResourceObjectInclude_DoIncludeResource);
            } else {
                result.add(ResourceObjectInclude_DoNotIncludeResource);
            }
            if ((flagBytes & 4) != 0) {
                result.add(RelativeBaselinePosition_RelativePosition);
            } else {
                result.add(RelativeBaselinePosition_AbsolutePosition);
            }
            return result;
        }

        public static byte[] toBytes(EnumSet<LND_Flag> flags) {
            int result = 0;
            if (flags.contains(Skipping_CurrentPagesEnds)) {
                result |= 0x8000;
            }
            if (flags.contains(Spacing_CurrentPagesEnds)) {
                result |= 0x4000;
            }
            if (flags.contains(GenerateInlinePosition_NewPosition)) {
                result |= 0x2000;
            }
            if (flags.contains(GenerateBaselinePosition_NewPosition)) {
                result |= 0x1000;
            }
            if (flags.contains(GenerateFontChange_AsSpecified)) {
                result |= 0x800;
            }
            if (flags.contains(GenerateSuppression_TextIsSuppressible)) {
                result |= 0x400;
            }
            if (flags.contains(ReuseRecord_DoReuse)) {
                result |= 0x200;
            }
            if (flags.contains(UseFixedData_DoPresent)) {
                result |= 0x100;
            }
            if (flags.contains(UseCompatibilityTRC_DoUse)) {
                result |= 0x40;
            }
            if (flags.contains(SetTextColor_AsSpecified)) {
                result |= 0x20;
            }
            if (flags.contains(ConditionalProcessing_DoPerformCP)) {
                result |= 0x10;
            }
            if (flags.contains(ResourceObjectInclude_DoIncludeResource)) {
                result |= 8;
            }
            if (flags.contains(RelativeBaselinePosition_RelativePosition)) {
                result |= 4;
            }
            return UtilBinaryDecoding.intToByteArray(result, 2);
        }

        public static void setFlag(EnumSet<LND_Flag> flags, LND_Flag flag) {
            handler.setFlag(flags, flag);
        }

        @Override
        public int getGroup() {
            return this.group;
        }

        static {
            handler = new MutualExclusiveGroupedFlagHandler();
        }
    }
}

