/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.modca;

import com.mgz.afp.base.StructuredField;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.util.UtilBinaryDecoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ICP_IMImageCellPosition
extends StructuredField {
    short xOffset;
    short yOffset;
    int xSize;
    int ySize;
    int xSizeOfFillRectangle;
    int ySizeOfFillRectangle;

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        ICP_IMImageCellPosition.checkDataLength(sfData, offset, length, 12);
        this.xOffset = UtilBinaryDecoding.parseShort(sfData, offset, 2);
        this.yOffset = UtilBinaryDecoding.parseShort(sfData, offset + 2, 2);
        this.xSize = UtilBinaryDecoding.parseInt(sfData, offset + 4, 2);
        this.ySize = UtilBinaryDecoding.parseInt(sfData, offset + 6, 2);
        this.xSizeOfFillRectangle = UtilBinaryDecoding.parseInt(sfData, offset + 8, 2);
        this.ySizeOfFillRectangle = UtilBinaryDecoding.parseInt(sfData, offset + 10, 2);
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(12);
        baos.write(UtilBinaryDecoding.shortToByteArray(this.xOffset, 2));
        baos.write(UtilBinaryDecoding.shortToByteArray(this.yOffset, 2));
        baos.write(UtilBinaryDecoding.intToByteArray(this.xSize, 2));
        baos.write(UtilBinaryDecoding.intToByteArray(this.ySize, 2));
        baos.write(UtilBinaryDecoding.intToByteArray(this.xSizeOfFillRectangle, 2));
        baos.write(UtilBinaryDecoding.intToByteArray(this.ySizeOfFillRectangle, 2));
        this.writeFullStructuredField(os, baos.toByteArray());
    }
}

