/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.modca;

import com.mgz.afp.base.StructuredField;
import com.mgz.afp.enums.AFPOrientation;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.util.UtilBinaryDecoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class IOC_IMImageOutputControl
extends StructuredField {
    int xOrigin;
    int yOrigin;
    AFPOrientation xRotation;
    AFPOrientation yRotation;
    byte[] constantData10_17;
    ImageMapping xImageMapping;
    ImageMapping yImageMapping;
    byte[] constantData22_23;

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        this.xOrigin = UtilBinaryDecoding.parseInt(sfData, offset, 3);
        this.yOrigin = UtilBinaryDecoding.parseInt(sfData, offset + 3, 3);
        this.xRotation = AFPOrientation.valueOf(UtilBinaryDecoding.parseShort(sfData, offset + 6, 2));
        this.yRotation = AFPOrientation.valueOf(UtilBinaryDecoding.parseShort(sfData, offset + 8, 2));
        this.constantData10_17 = new byte[8];
        System.arraycopy(sfData, offset + 10, this.constantData10_17, 0, this.constantData10_17.length);
        this.xImageMapping = ImageMapping.valueOf(UtilBinaryDecoding.parseShort(sfData, offset + 18, 2));
        this.yImageMapping = ImageMapping.valueOf(UtilBinaryDecoding.parseShort(sfData, offset + 20, 2));
        int actualLength = IOC_IMImageOutputControl.getActualLength(sfData, offset, length);
        if (actualLength > 22) {
            this.constantData22_23 = new byte[2];
            System.arraycopy(sfData, offset + 22, this.constantData22_23, 0, this.constantData22_23.length);
        } else {
            this.constantData22_23 = null;
        }
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(24);
        baos.write(UtilBinaryDecoding.intToByteArray(this.xOrigin, 3));
        baos.write(UtilBinaryDecoding.intToByteArray(this.yOrigin, 3));
        baos.write(this.xRotation.toBytes());
        baos.write(this.yRotation.toBytes());
        baos.write(this.constantData10_17);
        baos.write(this.xImageMapping.toBytes());
        baos.write(this.yImageMapping.toBytes());
        if (this.constantData22_23 != null) {
            baos.write(this.constantData22_23);
        }
        this.writeFullStructuredField(os, baos.toByteArray());
    }

    public int getxOrigin() {
        return this.xOrigin;
    }

    public void setxOrigin(int xOrigin) {
        this.xOrigin = xOrigin;
    }

    public int getyOrigin() {
        return this.yOrigin;
    }

    public void setyOrigin(int yOrigin) {
        this.yOrigin = yOrigin;
    }

    public AFPOrientation getxRotation() {
        return this.xRotation;
    }

    public void setxRotation(AFPOrientation xRotation) {
        this.xRotation = xRotation;
    }

    public AFPOrientation getyRotation() {
        return this.yRotation;
    }

    public void setyRotation(AFPOrientation yRotation) {
        this.yRotation = yRotation;
    }

    public byte[] getConstantData10_17() {
        return this.constantData10_17;
    }

    public void setConstantData10_17(byte[] constantData10_17) {
        this.constantData10_17 = constantData10_17;
    }

    public ImageMapping getxImageMapping() {
        return this.xImageMapping;
    }

    public void setxImageMapping(ImageMapping xImageMapping) {
        this.xImageMapping = xImageMapping;
    }

    public ImageMapping getyImageMapping() {
        return this.yImageMapping;
    }

    public void setyImageMapping(ImageMapping yImageMapping) {
        this.yImageMapping = yImageMapping;
    }

    public byte[] getConstantData22_23() {
        return this.constantData22_23;
    }

    public void setConstantData22_23(byte[] constantData22_23) {
        this.constantData22_23 = constantData22_23;
    }

    public static enum ImageMapping {
        ImagePointToOnePel(1000),
        ImagePointToTwoPel(2000);

        int code;

        private ImageMapping(int code) {
            this.code = code;
        }

        public static ImageMapping valueOf(short code) {
            for (ImageMapping im : ImageMapping.values()) {
                if (im.code != code) continue;
                return im;
            }
            return null;
        }

        public byte[] toBytes() {
            return UtilBinaryDecoding.intToByteArray(this.code, 2);
        }
    }
}

