/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.modca;

import com.mgz.afp.base.StructuredFieldBaseTriplets;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.afp.triplets.Triplet;
import com.mgz.util.UtilBinaryDecoding;
import com.mgz.util.UtilCharacterEncoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class IPS_IncludePageSegment
extends StructuredFieldBaseTriplets {
    String pageSegmentName;
    int xOrigin;
    int yOrigin;

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        this.pageSegmentName = new String(sfData, offset, 8, config.getAfpCharSet());
        this.xOrigin = UtilBinaryDecoding.parseInt(sfData, offset + 8, 3);
        this.yOrigin = UtilBinaryDecoding.parseInt(sfData, offset + 11, 3);
        int actualLength = IPS_IncludePageSegment.getActualLength(sfData, offset, length);
        if (actualLength > 14) {
            super.decodeAFP(sfData, offset + 16, actualLength - 16, config);
        } else {
            this.triplets = null;
        }
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(UtilCharacterEncoding.stringToByteArray(this.pageSegmentName, config.getAfpCharSet(), 8, (byte)64));
        baos.write(UtilBinaryDecoding.intToByteArray(this.xOrigin, 3));
        baos.write(UtilBinaryDecoding.intToByteArray(this.yOrigin, 3));
        if (this.triplets != null) {
            for (Triplet t : this.triplets) {
                t.writeAFP(baos, config);
            }
        }
        this.writeFullStructuredField(os, baos.toByteArray());
    }

    public String getPageSegmentName() {
        return this.pageSegmentName;
    }

    public void setPageSegmentName(String pageSegmentName) {
        this.pageSegmentName = pageSegmentName;
    }

    public int getxOrigin() {
        return this.xOrigin;
    }

    public void setxOrigin(int xOrigin) {
        this.xOrigin = xOrigin;
    }

    public int getyOrigin() {
        return this.yOrigin;
    }

    public void setyOrigin(int yOrigin) {
        this.yOrigin = yOrigin;
    }
}

