/*
 * Decompiled with CFR 0.152.
 */
package com.mgz.afp.modca;

import com.mgz.afp.base.IHasTriplets;
import com.mgz.afp.base.StructuredField;
import com.mgz.afp.exceptions.AFPParserException;
import com.mgz.afp.exceptions.IAFPDecodeableWriteable;
import com.mgz.afp.parser.AFPParserConfiguration;
import com.mgz.afp.parser.TripletParser;
import com.mgz.afp.triplets.Triplet;
import com.mgz.util.UtilBinaryDecoding;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class LLE_LinkLogicalElement
extends StructuredField {
    LLE_LinkType linkType;
    byte reserved1 = 0;
    List<LLE_RepeatingGroup> repeatingGroups;

    @Override
    public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
        LLE_RepeatingGroup rg;
        this.linkType = LLE_LinkType.valueOf(sfData[offset]);
        this.reserved1 = sfData[offset + 1];
        this.repeatingGroups = new ArrayList<LLE_RepeatingGroup>();
        int actualLength = LLE_LinkLogicalElement.getActualLength(sfData, offset, length);
        for (int pos = 2; pos < actualLength; pos += rg.lengthOfRepeatingGroup) {
            rg = new LLE_RepeatingGroup();
            rg.decodeAFP(sfData, offset + pos, actualLength - pos, config);
            this.repeatingGroups.add(rg);
        }
    }

    @Override
    public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(this.linkType.toByte());
        baos.write(this.reserved1);
        for (LLE_RepeatingGroup rg : this.repeatingGroups) {
            rg.writeAFP(baos, config);
        }
        this.writeFullStructuredField(os, baos.toByteArray());
    }

    public LLE_LinkType getLinkType() {
        return this.linkType;
    }

    public void setLinkType(LLE_LinkType linkType) {
        this.linkType = linkType;
    }

    public byte getReserved1() {
        return this.reserved1;
    }

    public void setReserved1(byte reserved1) {
        this.reserved1 = reserved1;
    }

    public List<LLE_RepeatingGroup> getRepeatingGroups() {
        return this.repeatingGroups;
    }

    public void setRepeatingGroups(List<LLE_RepeatingGroup> repeatingGroups) {
        this.repeatingGroups = repeatingGroups;
    }

    public void addRepeatingGroup(LLE_RepeatingGroup repeatingGroup) {
        if (repeatingGroup == null) {
            return;
        }
        if (this.repeatingGroups == null) {
            this.repeatingGroups = new ArrayList<LLE_RepeatingGroup>();
        }
        this.repeatingGroups.add(repeatingGroup);
    }

    public void removeRepeatingGroup(LLE_RepeatingGroup repeatingGroup) {
        if (this.repeatingGroups == null) {
            return;
        }
        this.repeatingGroups.remove(repeatingGroup);
    }

    public static class LLE_RepeatingGroup
    implements IAFPDecodeableWriteable,
    IHasTriplets {
        int lengthOfRepeatingGroup;
        LLE_RepeatingGroupFunction repeatingGroupFunction;
        List<Triplet> triplets;

        @Override
        public void decodeAFP(byte[] sfData, int offset, int length, AFPParserConfiguration config) throws AFPParserException {
            this.lengthOfRepeatingGroup = UtilBinaryDecoding.parseInt(sfData, offset, 2);
            this.repeatingGroupFunction = LLE_RepeatingGroupFunction.valueOf(sfData[offset + 2]);
            int actualLength = StructuredField.getActualLength(sfData, offset, length);
            this.triplets = actualLength > 3 ? TripletParser.parseTriplets(sfData, offset + 3, actualLength - 3, config) : null;
        }

        @Override
        public void writeAFP(OutputStream os, AFPParserConfiguration config) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this.repeatingGroupFunction.toByte());
            if (this.triplets != null) {
                for (Triplet t : this.triplets) {
                    t.writeAFP(baos, config);
                }
            }
            this.lengthOfRepeatingGroup = baos.size() + 2;
            os.write(UtilBinaryDecoding.intToByteArray(this.lengthOfRepeatingGroup, 2));
            os.write(baos.toByteArray());
        }

        @Override
        public List<Triplet> getTriplets() {
            return this.triplets;
        }

        @Override
        public void setTriplets(List<Triplet> triplets) {
            this.triplets = triplets;
        }

        @Override
        public void addTriplet(Triplet triplet) {
            if (triplet == null) {
                return;
            }
            if (this.triplets == null) {
                this.triplets = new ArrayList<Triplet>();
            }
            this.triplets.add(triplet);
        }

        @Override
        public void removeTriplet(Triplet triplet) {
            if (this.triplets == null) {
                return;
            }
            this.triplets.remove(triplet);
        }

        public int getLengthOfRepeatingGroup() {
            return this.lengthOfRepeatingGroup;
        }

        public void setLengthOfRepeatingGroup(int lengthOfRepeatingGroup) {
            this.lengthOfRepeatingGroup = lengthOfRepeatingGroup;
        }

        public LLE_RepeatingGroupFunction getRepeatingGroupFunction() {
            return this.repeatingGroupFunction;
        }

        public void setRepeatingGroupFunction(LLE_RepeatingGroupFunction repeatingGroupFunction) {
            this.repeatingGroupFunction = repeatingGroupFunction;
        }

        public static enum LLE_RepeatingGroupFunction {
            LinkAttributeSpecification,
            LinkSourceSpecification,
            LinkTargetSpecification;


            public static LLE_RepeatingGroupFunction valueOf(byte linkTypeByte) {
                for (LLE_RepeatingGroupFunction lt : LLE_RepeatingGroupFunction.values()) {
                    if (lt.ordinal() != linkTypeByte - 1) continue;
                    return lt;
                }
                return null;
            }

            public int toByte() {
                return this.ordinal() + 1;
            }
        }
    }

    public static enum LLE_LinkType {
        NavigationLink,
        AnnotationLink,
        AppendLink;


        public static LLE_LinkType valueOf(byte linkTypeByte) {
            for (LLE_LinkType lt : LLE_LinkType.values()) {
                if (lt.ordinal() != linkTypeByte - 1) continue;
                return lt;
            }
            return null;
        }

        public int toByte() {
            return this.ordinal() + 1;
        }
    }
}

